/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.io;

import com.ibm.jvm.io.LocalizedInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import sun.io.ByteToCharConverter;
import sun.io.CharToByteConverter;
import sun.security.action.GetPropertyAction;

public final class ConsoleInputStream
extends FilterInputStream {
    private static final String encoding;
    private static final ByteToCharConverter btc;
    private static final CharToByteConverter ctb;
    private static boolean conversionRequired;

    private ConsoleInputStream(InputStream inputStream) {
        super(inputStream);
    }

    public static void setConversionRequired(boolean bl) {
        conversionRequired = bl;
    }

    public static InputStream localize(InputStream inputStream) {
        if (btc == null || ctb == null) {
            return inputStream;
        }
        return new ConsoleInputStream(inputStream);
    }

    public static String getEncoding(InputStream inputStream) {
        if (inputStream instanceof ConsoleInputStream) {
            ConsoleInputStream cfr_ignored_0 = (ConsoleInputStream)inputStream;
            return encoding;
        }
        return null;
    }

    static InputStream getInputStream(InputStream inputStream) {
        if (inputStream instanceof ConsoleInputStream) {
            return ((ConsoleInputStream)inputStream).in;
        }
        return inputStream;
    }

    @Override
    public int read() throws IOException {
        byte[] byArray = new byte[1];
        if (this.read(byArray) != -1) {
            return byArray[0] & 0xFF;
        }
        return -1;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        char[] cArray = new char[n2];
        int n3 = this.in.read(byArray, n, n2);
        if (conversionRequired && n3 > 0) {
            n3 = btc.convert(byArray, n, n + n3, cArray, 0, n2);
            n3 = ctb.convert(cArray, 0, n3, byArray, n, n + n2);
        }
        return n3;
    }

    static {
        String string = AccessController.doPrivileged(new GetPropertyAction("file.encoding"));
        String string2 = AccessController.doPrivileged(new GetPropertyAction("console.encoding"));
        if (string2 == null && LocalizedInputStream.nonASCIIPlatform) {
            string2 = AccessController.doPrivileged(new GetPropertyAction("ibm.system.encoding"));
        }
        if (string2 == null) {
            string2 = string;
        }
        ByteToCharConverter byteToCharConverter = null;
        CharToByteConverter charToByteConverter = null;
        conversionRequired = false;
        if (!string2.equals(string)) {
            try {
                byteToCharConverter = ByteToCharConverter.getConverter(string2);
                charToByteConverter = CharToByteConverter.getConverter(string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
            conversionRequired = true;
        }
        encoding = string2;
        btc = byteToCharConverter;
        ctb = charToByteConverter;
    }
}

