/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.packed;

import com.ibm.jvm.packed.PackedSerialContext;
import java.security.AccessController;
import java.util.HashMap;
import sun.security.action.GetBooleanAction;

class DefaultPackedSerialContext
implements PackedSerialContext {
    private static final boolean debug = AccessController.doPrivileged(new GetBooleanAction("com.ibm.jvm.packed.DebugInfo"));
    private HashMap<Object, Integer> writeMap;
    private HashMap<Integer, Object> readMap;
    private HashMap<String, Long> hashMap;
    private int lastOffset = -1;

    public DefaultPackedSerialContext(boolean bl) {
        if (bl) {
            this.readMap = new HashMap();
            this.hashMap = new HashMap();
        } else {
            this.writeMap = new HashMap();
        }
    }

    @Override
    public int getLastOffset() {
        return this.lastOffset;
    }

    @Override
    public int getLastWrittenOffset(Object object) {
        Object object2 = object;
        Integer n = this.writeMap.get(object2);
        if (n != null) {
            return n;
        }
        return -1;
    }

    @Override
    public void hashWrite(String string, long l) {
        this.hashMap.put(string, l);
    }

    @Override
    public long hashRead(String string) {
        Long l = this.hashMap.get(string);
        if (l == null) {
            return -1L;
        }
        return l;
    }

    @Override
    public int objectWrite(Object object) {
        ++this.lastOffset;
        this.writeMap.put(object, this.lastOffset);
        return this.lastOffset;
    }

    @Override
    public Object getPreviouslyReadObject(int n) {
        Object object = this.readMap.get(n);
        if (object != null) {
            return object;
        }
        return null;
    }

    @Override
    public void objectRead(Object object, int n) {
        this.readMap.put(n, object);
    }

    @Override
    public void log(String string) {
        System.out.println(string);
    }

    @Override
    public boolean debugEnabled() {
        return debug;
    }

    @Override
    public void clearWriteEntries() {
        this.writeMap.clear();
    }

    @Override
    public void clearReadEntries() {
        this.readMap.clear();
        this.hashMap.clear();
    }
}

