/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.misc;

import com.ibm.jvm.MemorySafetyService;
import com.ibm.tenant.TenantGlobals;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Properties;
import sun.misc.VM;

public class SystemIntialization {
    private static boolean firstChanceHookCalled = false;
    private static boolean lastChanceHookCalled = false;
    private static boolean initialisationComplete = false;

    public static boolean initialisationComplete() {
        return initialisationComplete;
    }

    public static void firstChanceHook() {
        if (!firstChanceHookCalled) {
            long l = VM.maxDirectMemory();
            VM.booted();
            firstChanceHookCalled = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void lastChanceHook() {
        Object object;
        if (lastChanceHookCalled) {
            return;
        }
        lastChanceHookCalled = true;
        boolean bl = false;
        Properties properties = System.getProperties();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            if (!((String)object).startsWith("com.sun.management")) continue;
            bl = true;
        }
        if (bl) {
            object = Thread.currentThread().getThreadGroup();
            long l = -1L;
            try {
                l = MemorySafetyService.enterSafeMemoryArea();
                SystemIntialization.startJMXThread((ThreadGroup)object);
            }
            finally {
                MemorySafetyService.exitLastMemoryArea((long)l);
            }
        }
        initialisationComplete = true;
        SystemIntialization.setInitialisationComplete();
    }

    private static void startJMXThread(ThreadGroup threadGroup) {
        Thread thread = new Thread(threadGroup, "jlmAgent"){

            @Override
            public void run() {
                try {
                    Class<?> clazz = Class.forName("sun.management.Agent");
                    Method method = clazz.getMethod("startAgent", null);
                    Object object = method.invoke(clazz.newInstance(), null);
                }
                catch (Exception exception) {
                    throw new Error("snmp agent failed to launch", exception);
                }
            }
        };
        thread.setDaemon(true);
        thread.start();
        if (!TenantGlobals.isTenantEnabled() && !MemorySafetyService.isSafeMode()) {
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                throw new Error("snmp agent failed", interruptedException);
            }
        }
    }

    private static native String getJCLVersion();

    private static native void setInitialisationComplete();
}

