/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.auth;

import com.ibm.security.auth.NumericCredential;
import com.ibm.security.auth.ThreadSubject;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.Set;
import javax.security.auth.Subject;

public final class NTThreadSubject
extends ThreadSubject {
    private static boolean alreadyLoaded = false;
    Subject currentSubject;

    private native void set0(NumericCredential var1) throws UnsupportedOperationException;

    private native void restore0() throws UnsupportedOperationException;

    private static native void whoaminow0();

    @Override
    protected void set(Subject subject) throws UnsupportedOperationException, SecurityException {
        if (!alreadyLoaded) {
            NTThreadSubject.ensureLoaded();
        }
        try {
            Set<Principal> set = subject.getPrincipals();
            Set<?> set2 = subject.getPublicCredentials(Class.forName("com.ibm.security.auth.NumericCredential"));
            if (set2.isEmpty()) {
                throw new UnsupportedOperationException("No NT public credentials exist for this Subject");
            }
            this.set0((NumericCredential)set2.iterator().next());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new UnsupportedOperationException("Configuration error, cannot find com.ibm.security.auth.NumericCredential");
        }
    }

    @Override
    protected void restore() throws UnsupportedOperationException, SecurityException {
        if (!alreadyLoaded) {
            NTThreadSubject.ensureLoaded();
        }
        this.restore0();
    }

    public static void whoaminow() {
        if (!alreadyLoaded) {
            NTThreadSubject.ensureLoaded();
        }
        NTThreadSubject.whoaminow0();
    }

    private static void ensureLoaded() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                System.loadLibrary("NTThreadSubject");
                return null;
            }
        });
        alreadyLoaded = true;
    }
}

