/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.auth.module;

import com.ibm.security.auth.DomainIDPrincipal;
import com.ibm.security.auth.DomainPrincipal;
import com.ibm.security.auth.GroupIDPrincipal;
import com.ibm.security.auth.NumericCredential;
import com.ibm.security.auth.PrimaryGroupIDPrincipal;
import com.ibm.security.auth.UserIDPrincipal;
import com.ibm.security.auth.UsernamePrincipal;
import com.ibm.security.auth.module.Win64System;
import java.security.Principal;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class Win64LoginModule
implements LoginModule {
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map sharedState;
    private Map options;
    private boolean debug = false;
    private boolean succeeded = false;
    private boolean commitSucceeded = false;
    private UsernamePrincipal usernamePrincipal;
    private UserIDPrincipal userIDPrincipal;
    private DomainPrincipal domainPrincipal;
    private DomainIDPrincipal domainIDPrincipal;
    private PrimaryGroupIDPrincipal primaryGroupIDPrincipal;
    private LinkedList supplementaryGroups = new LinkedList();
    private NumericCredential numericCredential;
    private Win64System system;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> map, Map<String, ?> map2) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = map;
        this.options = map2;
        this.debug = "true".equalsIgnoreCase((String)map2.get("debug"));
    }

    @Override
    public boolean login() throws LoginException {
        String[] stringArray = null;
        this.succeeded = false;
        this.system = new Win64System();
        if (this.system == null) {
            if (this.debug) {
                System.out.println("\t\t[Win64LoginModule] Failed in Win64 login");
            }
            throw new FailedLoginException("Failed in attempt to import the underlying Win64 system identity information");
        }
        if (this.system.getUsername() == null) {
            throw new FailedLoginException("Failed in attempt to import the underlying Win64 system identity information");
        }
        this.usernamePrincipal = new UsernamePrincipal(this.system.getUsername());
        if (this.debug) {
            System.out.println("\t\t[Win64LoginModule] succeeded importing info: ");
            System.out.println("\t\t\tuser name = " + this.usernamePrincipal.getName());
        }
        if (this.system.getUserSID() != null) {
            this.userIDPrincipal = new UserIDPrincipal(this.system.getUserSID());
            if (this.debug) {
                System.out.println("\t\t\tuser SID = " + this.userIDPrincipal.getName());
            }
        }
        if (this.system.getDomain() != null) {
            this.domainPrincipal = new DomainPrincipal(this.system.getDomain());
            if (this.debug) {
                System.out.println("\t\t\tuser domain = " + this.domainPrincipal.getName());
            }
        }
        if (this.system.getDomainSID() != null) {
            this.domainIDPrincipal = new DomainIDPrincipal(this.system.getDomainSID());
            if (this.debug) {
                System.out.println("\t\t\tuser domain SID = " + this.domainIDPrincipal.getName());
            }
        }
        if (this.system.getPrimaryGroupID() != null) {
            this.primaryGroupIDPrincipal = new PrimaryGroupIDPrincipal(this.system.getPrimaryGroupID());
            if (this.debug) {
                System.out.println("\t\t\tuser primary group = " + this.primaryGroupIDPrincipal.getName());
            }
        }
        if (this.system.getGroupIDs() != null && this.system.getGroupIDs().length > 0) {
            stringArray = this.system.getGroupIDs();
        }
        for (int i = 0; i < stringArray.length; ++i) {
            GroupIDPrincipal groupIDPrincipal = new GroupIDPrincipal(stringArray[i]);
            if (!groupIDPrincipal.getName().equals(this.primaryGroupIDPrincipal.getName())) {
                this.supplementaryGroups.add(groupIDPrincipal);
            }
            if (!this.debug) continue;
            System.out.println("\t\t\tuser group = " + groupIDPrincipal.getName());
        }
        if (this.system.getImpersonationToken() != 0L) {
            this.numericCredential = new NumericCredential(this.system.getImpersonationToken(), this.system);
            if (this.debug) {
                System.out.println("\t\t\tnumeric credential = " + this.numericCredential.getToken());
            }
        }
        this.succeeded = true;
        return this.succeeded;
    }

    @Override
    public boolean commit() throws LoginException {
        if (!this.succeeded) {
            if (this.debug) {
                System.out.println("\t\t[Win64LoginModule]: did not add any Principals to Subject because own authentication failed.");
            }
            return false;
        }
        if (this.subject.isReadOnly()) {
            throw new LoginException("Subject is ReadOnly");
        }
        Set<Principal> set = this.subject.getPrincipals();
        if (!set.contains(this.usernamePrincipal)) {
            set.add(this.usernamePrincipal);
        }
        if (this.userIDPrincipal != null && !set.contains(this.userIDPrincipal)) {
            set.add(this.userIDPrincipal);
        }
        if (this.domainPrincipal != null && !set.contains(this.domainPrincipal)) {
            set.add(this.domainPrincipal);
        }
        if (this.domainIDPrincipal != null && !set.contains(this.domainIDPrincipal)) {
            set.add(this.domainIDPrincipal);
        }
        if (this.primaryGroupIDPrincipal != null && !set.contains(this.primaryGroupIDPrincipal)) {
            set.add(this.primaryGroupIDPrincipal);
        }
        for (int i = 0; i < this.supplementaryGroups.size(); ++i) {
            if (set.contains(this.supplementaryGroups.get(i))) continue;
            set.add((Principal)this.supplementaryGroups.get(i));
        }
        if (this.numericCredential != null && !this.subject.getPublicCredentials().contains(this.numericCredential)) {
            this.subject.getPublicCredentials().add(this.numericCredential);
        }
        this.commitSucceeded = true;
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        if (this.debug) {
            System.out.println("\t\t[Win64LoginModule]: aborted authentication attempt");
        }
        if (!this.succeeded) {
            return false;
        }
        if (this.succeeded && !this.commitSucceeded) {
            this.usernamePrincipal = null;
            this.userIDPrincipal = null;
            this.domainPrincipal = null;
            this.domainIDPrincipal = null;
            this.supplementaryGroups = new LinkedList();
            this.primaryGroupIDPrincipal = null;
            this.numericCredential = null;
            this.system = null;
            this.succeeded = false;
        } else {
            this.logout();
        }
        return this.succeeded;
    }

    @Override
    public boolean logout() throws LoginException {
        if (this.subject.isReadOnly()) {
            throw new LoginException("Subject is ReadOnly");
        }
        Set<Principal> set = this.subject.getPrincipals();
        if (set.contains(this.usernamePrincipal)) {
            set.remove(this.usernamePrincipal);
        }
        if (set.contains(this.userIDPrincipal)) {
            set.remove(this.userIDPrincipal);
        }
        if (set.contains(this.domainPrincipal)) {
            set.remove(this.domainPrincipal);
        }
        if (set.contains(this.domainIDPrincipal)) {
            set.remove(this.domainIDPrincipal);
        }
        if (set.contains(this.primaryGroupIDPrincipal)) {
            set.remove(this.primaryGroupIDPrincipal);
        }
        for (int i = 0; i < this.supplementaryGroups.size(); ++i) {
            if (!set.contains(this.supplementaryGroups.get(i))) continue;
            set.remove(this.supplementaryGroups.get(i));
        }
        Set<Object> set2 = this.subject.getPublicCredentials();
        if (set2.contains(this.numericCredential)) {
            set2.remove(this.numericCredential);
        }
        this.succeeded = false;
        this.commitSucceeded = false;
        this.system.logoff();
        this.usernamePrincipal = null;
        this.domainPrincipal = null;
        this.userIDPrincipal = null;
        this.domainIDPrincipal = null;
        this.supplementaryGroups = new LinkedList();
        this.primaryGroupIDPrincipal = null;
        this.numericCredential = null;
        this.system = null;
        if (this.debug) {
            System.out.println("\t\t[Win64LoginModule] completed logout processing");
        }
        return true;
    }
}

