/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.encoding;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.ws.encoding.ContentType;

public final class ContentTypeImpl
implements com.sun.xml.internal.ws.api.pipe.ContentType {
    @NotNull
    private final String contentType;
    @NotNull
    private final String soapAction;
    @Nullable
    private final String accept;
    @Nullable
    private final String charset;

    public ContentTypeImpl(String contentType) {
        this(contentType, null, null);
    }

    public ContentTypeImpl(String contentType, @Nullable String soapAction) {
        this(contentType, soapAction, null);
    }

    public ContentTypeImpl(String contentType, @Nullable String soapAction, @Nullable String accept) {
        this.contentType = contentType;
        this.accept = accept;
        this.soapAction = this.getQuotedSOAPAction(soapAction);
        String tmpCharset = null;
        try {
            tmpCharset = new ContentType(contentType).getParameter("charset");
        }
        catch (Exception e) {
            // empty catch block
        }
        this.charset = tmpCharset;
    }

    @Nullable
    public String getCharSet() {
        return this.charset;
    }

    private String getQuotedSOAPAction(String soapAction) {
        if (soapAction == null || soapAction.length() == 0) {
            return "\"\"";
        }
        if (soapAction.charAt(0) != '\"' && soapAction.charAt(soapAction.length() - 1) != '\"') {
            return "\"" + soapAction + "\"";
        }
        return soapAction;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public String getSOAPActionHeader() {
        return this.soapAction;
    }

    @Override
    public String getAcceptHeader() {
        return this.accept;
    }
}

