/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.SyncFailedException;
import java.util.concurrent.atomic.AtomicInteger;
import sun.misc.JavaIOFileDescriptorAccess;
import sun.misc.SharedSecrets;

public final class FileDescriptor {
    private int fd = -1;
    private int fd2 = -1;
    private int boundfd = -1;
    private int fdinuse = -1;
    private long handle = -1L;
    private AtomicInteger useCount = new AtomicInteger();
    public static final FileDescriptor in;
    public static final FileDescriptor out;
    public static final FileDescriptor err;

    int read() throws IOException {
        return this.read(this.handle);
    }

    private native int read(long var1) throws IOException;

    public boolean valid() {
        return this.handle != -1L || this.fd != -1 || this.fd2 != -1;
    }

    public native void sync() throws SyncFailedException;

    private static native void initIDs();

    private static native long set(int var0);

    private static FileDescriptor standardStream(int n) {
        FileDescriptor fileDescriptor = new FileDescriptor();
        fileDescriptor.handle = FileDescriptor.set(n);
        return fileDescriptor;
    }

    int incrementAndGetUseCount() {
        return this.useCount.incrementAndGet();
    }

    int decrementAndGetUseCount() {
        return this.useCount.decrementAndGet();
    }

    static {
        FileDescriptor.initIDs();
        SharedSecrets.setJavaIOFileDescriptorAccess(new JavaIOFileDescriptorAccess(){

            @Override
            public void set(FileDescriptor fileDescriptor, int n) {
                fileDescriptor.fd = n;
            }

            @Override
            public int get(FileDescriptor fileDescriptor) {
                return fileDescriptor.fd;
            }

            @Override
            public void setHandle(FileDescriptor fileDescriptor, long l) {
                fileDescriptor.handle = l;
            }

            @Override
            public long getHandle(FileDescriptor fileDescriptor) {
                return fileDescriptor.handle;
            }
        });
        in = FileDescriptor.standardStream(0);
        out = FileDescriptor.standardStream(1);
        err = FileDescriptor.standardStream(2);
    }
}

