/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import java.security.AccessController;
import sun.misc.IoTrace;
import sun.nio.ch.FileChannelImpl;
import sun.security.action.GetPropertyAction;

public class FileInputStream
extends InputStream {
    private final FileDescriptor fd;
    private final String path;
    private FileChannel channel = null;
    private final Object closeLock = new Object();
    private volatile boolean closed = false;
    private static final ThreadLocal<Boolean> runningFinalize = new ThreadLocal();
    private static boolean CloseFDWithStream = true;

    private static boolean isRunningFinalize() {
        Boolean bl = runningFinalize.get();
        if (bl != null) {
            return bl;
        }
        return false;
    }

    public FileInputStream(String string) throws FileNotFoundException {
        this(string != null ? new File(string) : null);
    }

    public FileInputStream(File file) throws FileNotFoundException {
        String string = file != null ? file.getPath() : null;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(string);
        }
        if (string == null) {
            throw new NullPointerException();
        }
        if (file.isInvalid()) {
            throw new FileNotFoundException("Invalid file path");
        }
        this.fd = new FileDescriptor();
        this.fd.incrementAndGetUseCount();
        this.path = string;
        this.open(string);
    }

    public FileInputStream(FileDescriptor fileDescriptor) {
        SecurityManager securityManager = System.getSecurityManager();
        if (fileDescriptor == null) {
            throw new NullPointerException();
        }
        if (securityManager != null) {
            securityManager.checkRead(fileDescriptor);
        }
        this.fd = fileDescriptor;
        this.path = null;
        this.fd.incrementAndGetUseCount();
    }

    private native void open(String var1) throws FileNotFoundException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        Object object = IoTrace.fileReadBegin(this.path);
        int n = 0;
        try {
            n = this.read0();
            IoTrace.fileReadEnd(object, n == -1 ? 0L : 1L);
        }
        catch (Throwable throwable) {
            IoTrace.fileReadEnd(object, n == -1 ? 0L : 1L);
            throw throwable;
        }
        return n;
    }

    private int read0() throws IOException {
        return this.fd.read();
    }

    private native int readBytes(byte[] var1, int var2, int var3) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] byArray) throws IOException {
        long l;
        Object object = IoTrace.fileReadBegin(this.path);
        int n = 0;
        try {
            n = this.readBytes(byArray, 0, byArray.length);
            l = n == -1 ? 0L : (long)n;
        }
        catch (Throwable throwable) {
            IoTrace.fileReadEnd(object, n == -1 ? 0L : (long)n);
            throw throwable;
        }
        IoTrace.fileReadEnd(object, l);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        long l;
        Object object = IoTrace.fileReadBegin(this.path);
        int n3 = 0;
        try {
            n3 = this.readBytes(byArray, n, n2);
            l = n3 == -1 ? 0L : (long)n3;
        }
        catch (Throwable throwable) {
            IoTrace.fileReadEnd(object, n3 == -1 ? 0L : (long)n3);
            throw throwable;
        }
        IoTrace.fileReadEnd(object, l);
        return n3;
    }

    @Override
    public native long skip(long var1) throws IOException;

    @Override
    public native int available() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        int n;
        Object object = this.closeLock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        if (this.channel != null) {
            this.fd.decrementAndGetUseCount();
            this.channel.close();
        }
        if ((n = this.fd.decrementAndGetUseCount()) <= 0 || !FileInputStream.isRunningFinalize() && CloseFDWithStream) {
            this.close0();
        }
    }

    public final FileDescriptor getFD() throws IOException {
        if (this.fd != null) {
            return this.fd;
        }
        throw new IOException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileChannel getChannel() {
        FileInputStream fileInputStream = this;
        synchronized (fileInputStream) {
            if (this.channel == null) {
                this.channel = FileChannelImpl.open(this.fd, this.path, true, false, this);
                this.fd.incrementAndGetUseCount();
            }
            return this.channel;
        }
    }

    private static native void initIDs();

    private native void close0() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws IOException {
        if (this.fd != null && this.fd != FileDescriptor.in) {
            runningFinalize.set(Boolean.TRUE);
            try {
                this.close();
            }
            finally {
                runningFinalize.set(Boolean.FALSE);
            }
        }
    }

    static {
        FileInputStream.initIDs();
        CloseFDWithStream = !AccessController.doPrivileged(new GetPropertyAction("com.ibm.streams.CloseFDWithStream", "true")).equalsIgnoreCase("false");
    }
}

