/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import com.ibm.tenant.TenantGlobals;
import java.lang.ref.WeakReference;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class ClassValue<T> {
    private static final Entry<?>[] EMPTY_CACHE = new Entry[]{null};
    final int hashCodeForCache = nextHashCode.getAndAdd(1640531527) & 0x3FFFFFFF;
    private static final AtomicInteger nextHashCode = new AtomicInteger();
    private static final int HASH_INCREMENT = 1640531527;
    static final int HASH_MASK = 0x3FFFFFFF;
    final Identity identity = new Identity();
    private volatile Version<T> version = new Version(this);
    private static final Object CRITICAL_SECTION = new Object();
    static WeakHashMap<Class<?>, ClassValueMap> typeHashMap = new WeakHashMap();

    protected ClassValue() {
    }

    protected abstract T computeValue(Class<?> var1);

    public T get(Class<?> clazz) {
        Entry<?>[] entryArray = ClassValue.getCacheCarefully(clazz);
        Entry entry = ClassValueMap.probeHomeLocation(entryArray, this);
        if (this.match(entry)) {
            return entry.value();
        }
        return this.getFromBackup(entryArray, clazz);
    }

    public void remove(Class<?> clazz) {
        ClassValueMap classValueMap = ClassValue.getMap(clazz);
        classValueMap.removeEntry(this);
    }

    void put(Class<?> clazz, T t) {
        ClassValueMap classValueMap = ClassValue.getMap(clazz);
        classValueMap.changeEntry(this, t);
    }

    private static Entry<?>[] getCacheCarefully(Class<?> clazz) {
        ClassValueMap classValueMap;
        if (TenantGlobals.isTenantEnabled()) {
            if (clazz == null) {
                throw new NullPointerException();
            }
            classValueMap = typeHashMap.get(clazz);
        } else {
            classValueMap = clazz.classValueMap;
        }
        if (classValueMap == null) {
            return EMPTY_CACHE;
        }
        Entry<?>[] entryArray = classValueMap.getCache();
        return entryArray;
    }

    private T getFromBackup(Entry<?>[] entryArray, Class<?> clazz) {
        Entry entry = ClassValueMap.probeBackupLocations(entryArray, this);
        if (entry != null) {
            return entry.value();
        }
        return this.getFromHashMap(clazz);
    }

    Entry<T> castEntry(Entry<?> entry) {
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T getFromHashMap(Class<?> clazz) {
        Entry entry;
        ClassValueMap classValueMap = ClassValue.getMap(clazz);
        do {
            if (!(entry = classValueMap.startEntry(this)).isPromise()) {
                return entry.value();
            }
            try {
                entry = ClassValue.makeEntry(entry.version(), this.computeValue(clazz));
            }
            finally {
                entry = classValueMap.finishEntry(this, entry);
            }
        } while (entry == null);
        return entry.value();
    }

    boolean match(Entry<?> entry) {
        return entry != null && entry.get() == this.version;
    }

    Version<T> version() {
        return this.version;
    }

    void bumpVersion() {
        this.version = new Version(this);
    }

    private static ClassValueMap getMap(Class<?> clazz) {
        ClassValueMap classValueMap = null;
        if (TenantGlobals.isTenantEnabled()) {
            if (clazz == null) {
                throw new NullPointerException();
            }
            classValueMap = typeHashMap.get(clazz);
        } else {
            classValueMap = clazz.classValueMap;
        }
        if (classValueMap != null) {
            return classValueMap;
        }
        return ClassValue.initializeMap(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ClassValueMap initializeMap(Class<?> clazz) {
        ClassValueMap classValueMap = null;
        Object object = CRITICAL_SECTION;
        synchronized (object) {
            if (TenantGlobals.isTenantEnabled()) {
                if (clazz == null) {
                    throw new NullPointerException();
                }
                classValueMap = typeHashMap.get(clazz);
                if (classValueMap == null) {
                    classValueMap = new ClassValueMap(clazz);
                    typeHashMap.put(clazz, classValueMap);
                }
            } else {
                classValueMap = clazz.classValueMap;
                if (classValueMap == null) {
                    clazz.classValueMap = classValueMap = new ClassValueMap(clazz);
                }
            }
        }
        return classValueMap;
    }

    static <T> Entry<T> makeEntry(Version<T> version, T t) {
        return new Entry<T>(version, t);
    }

    static class ClassValueMap
    extends WeakHashMap<Identity, Entry<?>> {
        private final Class<?> type;
        private Entry<?>[] cacheArray;
        private int cacheLoad;
        private int cacheLoadLimit;
        private static final int INITIAL_ENTRIES = 32;
        private static final int CACHE_LOAD_LIMIT = 67;
        private static final int PROBE_LIMIT = 6;

        ClassValueMap(Class<?> clazz) {
            this.type = clazz;
            this.sizeCache(32);
        }

        Entry<?>[] getCache() {
            return this.cacheArray;
        }

        synchronized <T> Entry<T> startEntry(ClassValue<T> classValue) {
            Entry<T> entry = (Entry<T>)this.get(classValue.identity);
            Version<T> version = classValue.version();
            if (entry == null) {
                entry = version.promise();
                this.put(classValue.identity, entry);
                return entry;
            }
            if (entry.isPromise()) {
                if (entry.version() != version) {
                    entry = version.promise();
                    this.put(classValue.identity, entry);
                }
                return entry;
            }
            if (entry.version() != version) {
                entry = entry.refreshVersion(version);
                this.put(classValue.identity, entry);
            }
            this.checkCacheLoad();
            this.addToCache(classValue, entry);
            return entry;
        }

        synchronized <T> Entry<T> finishEntry(ClassValue<T> classValue, Entry<T> entry) {
            Entry entry2 = (Entry)this.get(classValue.identity);
            if (entry == entry2) {
                assert (entry.isPromise());
                this.remove(classValue.identity);
                return null;
            }
            if (entry2 != null && entry2.isPromise() && entry2.version() == entry.version()) {
                Version<T> version = classValue.version();
                if (entry.version() != version) {
                    entry = entry.refreshVersion(version);
                }
                this.put(classValue.identity, entry);
                this.checkCacheLoad();
                this.addToCache(classValue, entry);
                return entry;
            }
            return null;
        }

        synchronized void removeEntry(ClassValue<?> classValue) {
            if (this.remove(classValue.identity) != null) {
                classValue.bumpVersion();
                this.removeStaleEntries(classValue);
            }
        }

        synchronized <T> void changeEntry(ClassValue<T> classValue, T t) {
            Entry entry = (Entry)this.get(classValue.identity);
            Version<T> version = classValue.version();
            if (entry != null) {
                if (entry.version() == version && entry.value() == t) {
                    return;
                }
                classValue.bumpVersion();
                this.removeStaleEntries(classValue);
            }
            Entry<T> entry2 = ClassValue.makeEntry(version, t);
            this.put(classValue.identity, entry2);
            this.checkCacheLoad();
            this.addToCache(classValue, entry2);
        }

        static Entry<?> loadFromCache(Entry<?>[] entryArray, int n) {
            return entryArray[n & entryArray.length - 1];
        }

        static <T> Entry<T> probeHomeLocation(Entry<?>[] entryArray, ClassValue<T> classValue) {
            return classValue.castEntry(ClassValueMap.loadFromCache(entryArray, classValue.hashCodeForCache));
        }

        static <T> Entry<T> probeBackupLocations(Entry<?>[] entryArray, ClassValue<T> classValue) {
            Entry<?> entry;
            int n = entryArray.length - 1;
            int n2 = classValue.hashCodeForCache & n;
            Entry<?> entry2 = entryArray[n2];
            if (entry2 == null) {
                return null;
            }
            int n3 = -1;
            for (int i = n2 + 1; i < n2 + 6 && (entry = entryArray[i & n]) != null; ++i) {
                if (classValue.match(entry)) {
                    entryArray[n2] = entry;
                    if (n3 >= 0) {
                        entryArray[i & n] = Entry.DEAD_ENTRY;
                    } else {
                        n3 = i;
                    }
                    entryArray[n3 & n] = ClassValueMap.entryDislocation(entryArray, n3, entry2) < 6 ? entry2 : Entry.DEAD_ENTRY;
                    return classValue.castEntry(entry);
                }
                if (entry.isLive() || n3 >= 0) continue;
                n3 = i;
            }
            return null;
        }

        private static int entryDislocation(Entry<?>[] entryArray, int n, Entry<?> entry) {
            ClassValue<?> classValue = entry.classValueOrNull();
            if (classValue == null) {
                return 0;
            }
            int n2 = entryArray.length - 1;
            return n - classValue.hashCodeForCache & n2;
        }

        private void sizeCache(int n) {
            assert ((n & n - 1) == 0);
            this.cacheLoad = 0;
            this.cacheLoadLimit = (int)((double)n * 67.0 / 100.0);
            this.cacheArray = new Entry[n];
        }

        private void checkCacheLoad() {
            if (this.cacheLoad >= this.cacheLoadLimit) {
                this.reduceCacheLoad();
            }
        }

        private void reduceCacheLoad() {
            this.removeStaleEntries();
            if (this.cacheLoad < this.cacheLoadLimit) {
                return;
            }
            Entry<?>[] entryArray = this.getCache();
            if (entryArray.length > 0x3FFFFFFF) {
                return;
            }
            this.sizeCache(entryArray.length * 2);
            for (Entry<?> entry : entryArray) {
                if (entry == null || !entry.isLive()) continue;
                this.addToCache(entry);
            }
        }

        private void removeStaleEntries(Entry<?>[] entryArray, int n, int n2) {
            int n3 = entryArray.length - 1;
            int n4 = 0;
            for (int i = n; i < n + n2; ++i) {
                Entry<?> entry = entryArray[i & n3];
                if (entry == null || entry.isLive()) continue;
                Entry<?> entry2 = null;
                entry2 = this.findReplacement(entryArray, i);
                entryArray[i & n3] = entry2;
                if (entry2 != null) continue;
                ++n4;
            }
            this.cacheLoad = Math.max(0, this.cacheLoad - n4);
        }

        private Entry<?> findReplacement(Entry<?>[] entryArray, int n) {
            Entry<?> entry;
            Entry<?> entry2 = null;
            int n2 = -1;
            int n3 = 0;
            int n4 = entryArray.length - 1;
            for (int i = n + 1; i < n + 6 && (entry = entryArray[i & n4]) != null; ++i) {
                int n5;
                int n6;
                if (!entry.isLive() || (n6 = ClassValueMap.entryDislocation(entryArray, i, entry)) == 0 || (n5 = i - n6) > n) continue;
                if (n5 == n) {
                    n2 = 1;
                    n3 = i;
                    entry2 = entry;
                    continue;
                }
                if (n2 > 0) continue;
                n2 = 0;
                n3 = i;
                entry2 = entry;
            }
            if (n2 >= 0) {
                if (entryArray[n3 + 1 & n4] != null) {
                    entryArray[n3 & n4] = Entry.DEAD_ENTRY;
                } else {
                    entryArray[n3 & n4] = null;
                    --this.cacheLoad;
                }
            }
            return entry2;
        }

        private void removeStaleEntries(ClassValue<?> classValue) {
            this.removeStaleEntries(this.getCache(), classValue.hashCodeForCache, 6);
        }

        private void removeStaleEntries() {
            Entry<?>[] entryArray = this.getCache();
            this.removeStaleEntries(entryArray, 0, entryArray.length + 6 - 1);
        }

        private <T> void addToCache(Entry<T> entry) {
            ClassValue<T> classValue = entry.classValueOrNull();
            if (classValue != null) {
                this.addToCache(classValue, entry);
            }
        }

        private <T> void addToCache(ClassValue<T> classValue, Entry<T> entry) {
            int n;
            int n2;
            int n3;
            Entry<?>[] entryArray = this.getCache();
            Entry<?> entry2 = this.placeInCache(entryArray, n3 = classValue.hashCodeForCache & (n2 = entryArray.length - 1), entry, false);
            if (entry2 == null) {
                return;
            }
            int n4 = ClassValueMap.entryDislocation(entryArray, n3, entry2);
            for (int i = n = n3 - n4; i < n + 6; ++i) {
                if (this.placeInCache(entryArray, i & n2, entry2, true) != null) continue;
                return;
            }
        }

        private Entry<?> placeInCache(Entry<?>[] entryArray, int n, Entry<?> entry, boolean bl) {
            Entry<?> entry2 = this.overwrittenEntry(entryArray[n]);
            if (bl && entry2 != null) {
                return entry;
            }
            entryArray[n] = entry;
            return entry2;
        }

        private <T> Entry<T> overwrittenEntry(Entry<T> entry) {
            if (entry == null) {
                ++this.cacheLoad;
            } else if (entry.isLive()) {
                return entry;
            }
            return null;
        }
    }

    static class Entry<T>
    extends WeakReference<Version<T>> {
        final Object value;
        static final Entry<?> DEAD_ENTRY = new Entry<Object>(null, null);

        Entry(Version<T> version, T t) {
            super(version);
            this.value = t;
        }

        private void assertNotPromise() {
            assert (!this.isPromise());
        }

        Entry(Version<T> version) {
            super(version);
            this.value = this;
        }

        T value() {
            this.assertNotPromise();
            return (T)this.value;
        }

        boolean isPromise() {
            return this.value == this;
        }

        Version<T> version() {
            return (Version)this.get();
        }

        ClassValue<T> classValueOrNull() {
            Version<T> version = this.version();
            return version == null ? null : version.classValue();
        }

        boolean isLive() {
            Version<T> version = this.version();
            if (version == null) {
                return false;
            }
            if (version.isLive()) {
                return true;
            }
            this.clear();
            return false;
        }

        Entry<T> refreshVersion(Version<T> version) {
            this.assertNotPromise();
            Entry<Object> entry = new Entry<Object>(version, this.value);
            this.clear();
            return entry;
        }
    }

    static class Version<T> {
        private final ClassValue<T> classValue;
        private final Entry<T> promise = new Entry(this);

        Version(ClassValue<T> classValue) {
            this.classValue = classValue;
        }

        ClassValue<T> classValue() {
            return this.classValue;
        }

        Entry<T> promise() {
            return this.promise;
        }

        boolean isLive() {
            return this.classValue.version() == this;
        }
    }

    static class Identity {
        Identity() {
        }
    }
}

