/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import com.ibm.jvm.MemorySafetyService;
import java.lang.annotation.Annotation;
import java.lang.annotation.AnnotationFormatError;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.nio.ByteBuffer;
import java.util.Map;
import sun.misc.SharedSecrets;
import sun.reflect.CallerSensitive;
import sun.reflect.MethodAccessor;
import sun.reflect.Reflection;
import sun.reflect.annotation.AnnotationParser;
import sun.reflect.annotation.AnnotationType;
import sun.reflect.annotation.ExceptionProxy;
import sun.reflect.generics.factory.CoreReflectionFactory;
import sun.reflect.generics.factory.GenericsFactory;
import sun.reflect.generics.repository.MethodRepository;
import sun.reflect.generics.scope.MethodScope;

public final class Method
extends AccessibleObject
implements GenericDeclaration,
Member {
    private Class<?> clazz;
    private int slot;
    private String name;
    private Class<?> returnType;
    private Class<?>[] parameterTypes;
    private Class<?>[] exceptionTypes;
    private int modifiers;
    private transient String signature;
    private transient MethodRepository genericInfo;
    private byte[] annotations;
    private byte[] parameterAnnotations;
    private byte[] annotationDefault;
    private volatile MethodAccessor methodAccessor;
    private Method root;
    private transient Map<Class<? extends Annotation>, Annotation> declaredAnnotations;

    private String getGenericSignature() {
        return this.signature;
    }

    private GenericsFactory getFactory() {
        return CoreReflectionFactory.make(this, MethodScope.make(this));
    }

    private MethodRepository getGenericInfo() {
        if (this.genericInfo == null) {
            this.genericInfo = MethodRepository.make(this.getGenericSignature(), this.getFactory());
        }
        return this.genericInfo;
    }

    Method(Class<?> clazz, String string, Class<?>[] classArray, Class<?> clazz2, Class<?>[] classArray2, int n, int n2, String string2, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        this.clazz = clazz;
        this.name = string;
        this.parameterTypes = classArray;
        this.returnType = clazz2;
        this.exceptionTypes = classArray2;
        this.modifiers = n;
        this.slot = n2;
        this.signature = string2;
        this.annotations = byArray;
        this.parameterAnnotations = byArray2;
        this.annotationDefault = byArray3;
    }

    Method copy() {
        Method method = new Method(this.clazz, this.name, this.parameterTypes, this.returnType, this.exceptionTypes, this.modifiers, this.slot, this.signature, this.annotations, this.parameterAnnotations, this.annotationDefault);
        method.root = this;
        method.methodAccessor = this.methodAccessor;
        return method;
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this.clazz;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getModifiers() {
        return this.modifiers;
    }

    public TypeVariable<Method>[] getTypeParameters() {
        if (this.getGenericSignature() != null) {
            return this.getGenericInfo().getTypeParameters();
        }
        return new TypeVariable[0];
    }

    public Class<?> getReturnType() {
        return this.returnType;
    }

    public Type getGenericReturnType() {
        if (this.getGenericSignature() != null) {
            return this.getGenericInfo().getReturnType();
        }
        return this.getReturnType();
    }

    public Class<?>[] getParameterTypes() {
        return (Class[])this.parameterTypes.clone();
    }

    public Type[] getGenericParameterTypes() {
        if (this.getGenericSignature() != null) {
            return this.getGenericInfo().getParameterTypes();
        }
        return this.getParameterTypes();
    }

    public Class<?>[] getExceptionTypes() {
        return (Class[])this.exceptionTypes.clone();
    }

    public Type[] getGenericExceptionTypes() {
        Type[] typeArray;
        if (this.getGenericSignature() != null && (typeArray = this.getGenericInfo().getExceptionTypes()).length > 0) {
            return typeArray;
        }
        return this.getExceptionTypes();
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Method) {
            Method method = (Method)object;
            if (this.getDeclaringClass() == method.getDeclaringClass() && this.getName() == method.getName()) {
                if (!this.returnType.equals(method.getReturnType())) {
                    return false;
                }
                Class<?>[] classArray = this.parameterTypes;
                Class<?>[] classArray2 = method.parameterTypes;
                if (classArray.length == classArray2.length) {
                    for (int i = 0; i < classArray.length; ++i) {
                        if (classArray[i] == classArray2[i]) continue;
                        return false;
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public int hashCode() {
        return this.getDeclaringClass().getName().hashCode() ^ this.getName().hashCode();
    }

    public String toString() {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            int n = this.getModifiers() & Modifier.methodModifiers();
            if (n != 0) {
                stringBuilder.append(Modifier.toString(n)).append(' ');
            }
            stringBuilder.append(Field.getTypeName(this.getReturnType())).append(' ');
            stringBuilder.append(Field.getTypeName(this.getDeclaringClass())).append('.');
            stringBuilder.append(this.getName()).append('(');
            Class<?>[] classArray = this.parameterTypes;
            for (int i = 0; i < classArray.length; ++i) {
                stringBuilder.append(Field.getTypeName(classArray[i]));
                if (i >= classArray.length - 1) continue;
                stringBuilder.append(',');
            }
            stringBuilder.append(')');
            Class<?>[] classArray2 = this.exceptionTypes;
            if (classArray2.length > 0) {
                stringBuilder.append(" throws ");
                for (int i = 0; i < classArray2.length; ++i) {
                    stringBuilder.append(classArray2[i].getName());
                    if (i >= classArray2.length - 1) continue;
                    stringBuilder.append(',');
                }
            }
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            return "<" + exception + ">";
        }
    }

    public String toGenericString() {
        try {
            Type type;
            TypeVariable<Method>[] typeVariableArray;
            StringBuilder stringBuilder = new StringBuilder();
            int n = this.getModifiers() & Modifier.methodModifiers();
            if (n != 0) {
                stringBuilder.append(Modifier.toString(n)).append(' ');
            }
            if ((typeVariableArray = this.getTypeParameters()).length > 0) {
                boolean bl = true;
                stringBuilder.append('<');
                for (TypeVariable<Method> typeVariable : typeVariableArray) {
                    if (!bl) {
                        stringBuilder.append(',');
                    }
                    stringBuilder.append(typeVariable.toString());
                    bl = false;
                }
                stringBuilder.append("> ");
            }
            stringBuilder.append((type = this.getGenericReturnType()) instanceof Class ? Field.getTypeName((Class)type) : type.toString()).append(' ');
            stringBuilder.append(Field.getTypeName(this.getDeclaringClass())).append('.');
            stringBuilder.append(this.getName()).append('(');
            Type[] typeArray = this.getGenericParameterTypes();
            for (int i = 0; i < typeArray.length; ++i) {
                String string;
                String string2 = string = typeArray[i] instanceof Class ? Field.getTypeName((Class)typeArray[i]) : typeArray[i].toString();
                if (this.isVarArgs() && i == typeArray.length - 1) {
                    string = string.replaceFirst("\\[\\]$", "...");
                }
                stringBuilder.append(string);
                if (i >= typeArray.length - 1) continue;
                stringBuilder.append(',');
            }
            stringBuilder.append(')');
            Type[] typeArray2 = this.getGenericExceptionTypes();
            if (typeArray2.length > 0) {
                stringBuilder.append(" throws ");
                for (int i = 0; i < typeArray2.length; ++i) {
                    stringBuilder.append(typeArray2[i] instanceof Class ? ((Class)typeArray2[i]).getName() : typeArray2[i].toString());
                    if (i >= typeArray2.length - 1) continue;
                    stringBuilder.append(',');
                }
            }
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            return "<" + exception + ">";
        }
    }

    @CallerSensitive
    public Object invoke(Object object, Object ... objectArray) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Object object2;
        if (!this.override && !Reflection.quickCheckMemberAccess(this.clazz, this.modifiers)) {
            object2 = this.getCallerClass();
            this.checkAccess((Class<?>)object2, this.clazz, object, this.modifiers);
        }
        if ((object2 = this.methodAccessor) == null) {
            object2 = this.acquireMethodAccessor();
        }
        return object2.invoke(object, objectArray);
    }

    @CallerSensitive
    private Class<?> getCallerClass() {
        return Reflection.getCallerClass();
    }

    public boolean isBridge() {
        return (this.getModifiers() & 0x40) != 0;
    }

    public boolean isVarArgs() {
        return (this.getModifiers() & 0x80) != 0;
    }

    @Override
    public boolean isSynthetic() {
        return Modifier.isSynthetic(this.getModifiers());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MethodAccessor acquireMethodAccessor() {
        MethodAccessor methodAccessor = null;
        if (this.root != null) {
            methodAccessor = this.root.getMethodAccessor();
        }
        if (methodAccessor != null) {
            this.methodAccessor = methodAccessor;
        } else {
            long l = -1L;
            try {
                l = MemorySafetyService.enterObjectsMemoryArea((Object)this);
                methodAccessor = reflectionFactory.newMethodAccessor(this);
            }
            finally {
                MemorySafetyService.exitLastMemoryArea((long)l);
            }
            this.setMethodAccessor(methodAccessor);
        }
        return methodAccessor;
    }

    MethodAccessor getMethodAccessor() {
        return this.methodAccessor;
    }

    void setMethodAccessor(MethodAccessor methodAccessor) {
        this.methodAccessor = methodAccessor;
        if (this.root != null) {
            this.root.setMethodAccessor(methodAccessor);
        }
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> clazz) {
        if (clazz == null) {
            throw new NullPointerException();
        }
        return (T)this.declaredAnnotations().get(clazz);
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return AnnotationParser.toArray(this.declaredAnnotations());
    }

    private synchronized Map<Class<? extends Annotation>, Annotation> declaredAnnotations() {
        if (this.declaredAnnotations == null) {
            this.declaredAnnotations = this.getAnnotationsFromCache(this.getDeclaringClass(), this.annotations);
        }
        return this.declaredAnnotations;
    }

    public Object getDefaultValue() {
        if (this.annotationDefault == null) {
            return null;
        }
        Class<?> clazz = AnnotationType.invocationHandlerReturnType(this.getReturnType());
        Object object = AnnotationParser.parseMemberValue(clazz, ByteBuffer.wrap(this.annotationDefault), SharedSecrets.getJavaLangAccess().getConstantPool(this.getDeclaringClass()), this.getDeclaringClass());
        if (object instanceof ExceptionProxy) {
            throw new AnnotationFormatError("Invalid default: " + this);
        }
        return object;
    }

    public Annotation[][] getParameterAnnotations() {
        int n = this.parameterTypes.length;
        if (this.parameterAnnotations == null) {
            return new Annotation[n][0];
        }
        Annotation[][] annotationArray = AnnotationParser.parseParameterAnnotations(this.parameterAnnotations, SharedSecrets.getJavaLangAccess().getConstantPool(this.getDeclaringClass()), this.getDeclaringClass());
        if (annotationArray.length != n) {
            throw new AnnotationFormatError("Parameter annotations don't match number of parameters");
        }
        return annotationArray;
    }
}

