/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DirectByteBuffer;
import java.security.AccessController;
import java.util.concurrent.atomic.AtomicLong;
import sun.misc.JavaNioAccess;
import sun.misc.SharedSecrets;
import sun.misc.Unsafe;
import sun.misc.VM;
import sun.security.action.GetPropertyAction;

class Bits {
    private static final Unsafe unsafe;
    private static final ByteOrder byteOrder;
    private static int pageSize;
    private static boolean unaligned;
    private static boolean unalignedKnown;
    private static final AtomicLong maxCapacity;
    private static final AtomicLong currentCapacity;
    private static final AtomicLong reservedMemory;
    private static final AtomicLong activeReservations;
    private static boolean isMaxCapacityGrowable;
    private static final Object initCapacityLock;
    private static boolean isMaxCapacityInit;
    private static final long DEFAULT_MAX_CAPACITY = 0x4000000L;
    private static final long MIN_MAX_CAPACITY_INCREMENT = 0x2000000L;
    private static final long INITIAL_SLEEP_MILLIS = 100L;
    private static final long SLEEP_MILLIS_INCREMENT = 50L;
    private static final int SLEEP_RETRIES = 5;
    private static final long RESERVATION_SUCCESSFUL = -1L;
    static final int JNI_COPY_TO_ARRAY_THRESHOLD = 6;
    static final int JNI_COPY_FROM_ARRAY_THRESHOLD = 6;
    static final long UNSAFE_COPY_THRESHOLD = 0x100000L;
    static final /* synthetic */ boolean $assertionsDisabled;

    private Bits() {
    }

    static short swap(short s) {
        return Short.reverseBytes(s);
    }

    static char swap(char c) {
        return Character.reverseBytes(c);
    }

    static int swap(int n) {
        return Integer.reverseBytes(n);
    }

    static long swap(long l) {
        return Long.reverseBytes(l);
    }

    private static char makeChar(byte by, byte by2) {
        return (char)(by << 8 | by2 & 0xFF);
    }

    static char getCharL(ByteBuffer byteBuffer, int n) {
        return Bits.makeChar(byteBuffer._get(n + 1), byteBuffer._get(n));
    }

    static char getCharL(long l) {
        return Bits.makeChar(Bits._get(l + 1L), Bits._get(l));
    }

    static char rcmGetCharL(long l) {
        return Bits.makeChar(Bits._rcmGet(l + 1L), Bits._rcmGet(l));
    }

    static char getCharB(ByteBuffer byteBuffer, int n) {
        return Bits.makeChar(byteBuffer._get(n), byteBuffer._get(n + 1));
    }

    static char getCharB(long l) {
        return Bits.makeChar(Bits._get(l), Bits._get(l + 1L));
    }

    static char rcmGetCharB(long l) {
        return Bits.makeChar(Bits._rcmGet(l), Bits._rcmGet(l + 1L));
    }

    static char getChar(ByteBuffer byteBuffer, int n, boolean bl) {
        return bl ? Bits.getCharB(byteBuffer, n) : Bits.getCharL(byteBuffer, n);
    }

    static char getChar(long l, boolean bl) {
        return bl ? Bits.getCharB(l) : Bits.getCharL(l);
    }

    static char rcmGetChar(long l, boolean bl) {
        return bl ? Bits.rcmGetCharB(l) : Bits.rcmGetCharL(l);
    }

    private static byte char1(char c) {
        return (byte)(c >> 8);
    }

    private static byte char0(char c) {
        return (byte)c;
    }

    static void putCharL(ByteBuffer byteBuffer, int n, char c) {
        byteBuffer._put(n, Bits.char0(c));
        byteBuffer._put(n + 1, Bits.char1(c));
    }

    static void putCharL(long l, char c) {
        Bits._put(l, Bits.char0(c));
        Bits._put(l + 1L, Bits.char1(c));
    }

    static void rcmPutCharL(long l, char c) {
        Bits._rcmPut(l, Bits.char0(c));
        Bits._rcmPut(l + 1L, Bits.char1(c));
    }

    static void putCharB(ByteBuffer byteBuffer, int n, char c) {
        byteBuffer._put(n, Bits.char1(c));
        byteBuffer._put(n + 1, Bits.char0(c));
    }

    static void putCharB(long l, char c) {
        Bits._put(l, Bits.char1(c));
        Bits._put(l + 1L, Bits.char0(c));
    }

    static void rcmPutCharB(long l, char c) {
        Bits._rcmPut(l, Bits.char1(c));
        Bits._rcmPut(l + 1L, Bits.char0(c));
    }

    static void putChar(ByteBuffer byteBuffer, int n, char c, boolean bl) {
        if (bl) {
            Bits.putCharB(byteBuffer, n, c);
        } else {
            Bits.putCharL(byteBuffer, n, c);
        }
    }

    static void putChar(long l, char c, boolean bl) {
        if (bl) {
            Bits.putCharB(l, c);
        } else {
            Bits.putCharL(l, c);
        }
    }

    static void rcmPutChar(long l, char c, boolean bl) {
        if (bl) {
            Bits.rcmPutCharB(l, c);
        } else {
            Bits.rcmPutCharL(l, c);
        }
    }

    private static short makeShort(byte by, byte by2) {
        return (short)(by << 8 | by2 & 0xFF);
    }

    static short getShortL(ByteBuffer byteBuffer, int n) {
        return Bits.makeShort(byteBuffer._get(n + 1), byteBuffer._get(n));
    }

    static short getShortL(long l) {
        return Bits.makeShort(Bits._get(l + 1L), Bits._get(l));
    }

    static short rcmGetShortL(long l) {
        return Bits.makeShort(Bits._rcmGet(l + 1L), Bits._rcmGet(l));
    }

    static short getShortB(ByteBuffer byteBuffer, int n) {
        return Bits.makeShort(byteBuffer._get(n), byteBuffer._get(n + 1));
    }

    static short getShortB(long l) {
        return Bits.makeShort(Bits._get(l), Bits._get(l + 1L));
    }

    static short rcmGetShortB(long l) {
        return Bits.makeShort(Bits._rcmGet(l), Bits._rcmGet(l + 1L));
    }

    static short getShort(ByteBuffer byteBuffer, int n, boolean bl) {
        return bl ? Bits.getShortB(byteBuffer, n) : Bits.getShortL(byteBuffer, n);
    }

    static short getShort(long l, boolean bl) {
        return bl ? Bits.getShortB(l) : Bits.getShortL(l);
    }

    static short rcmGetShort(long l, boolean bl) {
        return bl ? Bits.rcmGetShortB(l) : Bits.rcmGetShortL(l);
    }

    private static byte short1(short s) {
        return (byte)(s >> 8);
    }

    private static byte short0(short s) {
        return (byte)s;
    }

    static void putShortL(ByteBuffer byteBuffer, int n, short s) {
        byteBuffer._put(n, Bits.short0(s));
        byteBuffer._put(n + 1, Bits.short1(s));
    }

    static void putShortL(long l, short s) {
        Bits._put(l, Bits.short0(s));
        Bits._put(l + 1L, Bits.short1(s));
    }

    static void rcmPutShortL(long l, short s) {
        Bits._rcmPut(l, Bits.short0(s));
        Bits._rcmPut(l + 1L, Bits.short1(s));
    }

    static void putShortB(ByteBuffer byteBuffer, int n, short s) {
        byteBuffer._put(n, Bits.short1(s));
        byteBuffer._put(n + 1, Bits.short0(s));
    }

    static void putShortB(long l, short s) {
        Bits._put(l, Bits.short1(s));
        Bits._put(l + 1L, Bits.short0(s));
    }

    static void rcmPutShortB(long l, short s) {
        Bits._rcmPut(l, Bits.short1(s));
        Bits._rcmPut(l + 1L, Bits.short0(s));
    }

    static void putShort(ByteBuffer byteBuffer, int n, short s, boolean bl) {
        if (bl) {
            Bits.putShortB(byteBuffer, n, s);
        } else {
            Bits.putShortL(byteBuffer, n, s);
        }
    }

    static void putShort(long l, short s, boolean bl) {
        if (bl) {
            Bits.putShortB(l, s);
        } else {
            Bits.putShortL(l, s);
        }
    }

    static void rcmPutShort(long l, short s, boolean bl) {
        if (bl) {
            Bits.rcmPutShortB(l, s);
        } else {
            Bits.rcmPutShortL(l, s);
        }
    }

    private static int makeInt(byte by, byte by2, byte by3, byte by4) {
        return by << 24 | (by2 & 0xFF) << 16 | (by3 & 0xFF) << 8 | by4 & 0xFF;
    }

    static int getIntL(ByteBuffer byteBuffer, int n) {
        return Bits.makeInt(byteBuffer._get(n + 3), byteBuffer._get(n + 2), byteBuffer._get(n + 1), byteBuffer._get(n));
    }

    static int getIntL(long l) {
        return Bits.makeInt(Bits._get(l + 3L), Bits._get(l + 2L), Bits._get(l + 1L), Bits._get(l));
    }

    static int rcmGetIntL(long l) {
        return Bits.makeInt(Bits._rcmGet(l + 3L), Bits._rcmGet(l + 2L), Bits._rcmGet(l + 1L), Bits._rcmGet(l));
    }

    static int getIntB(ByteBuffer byteBuffer, int n) {
        return Bits.makeInt(byteBuffer._get(n), byteBuffer._get(n + 1), byteBuffer._get(n + 2), byteBuffer._get(n + 3));
    }

    static int getIntB(long l) {
        return Bits.makeInt(Bits._get(l), Bits._get(l + 1L), Bits._get(l + 2L), Bits._get(l + 3L));
    }

    static int rcmGetIntB(long l) {
        return Bits.makeInt(Bits._rcmGet(l), Bits._rcmGet(l + 1L), Bits._rcmGet(l + 2L), Bits._rcmGet(l + 3L));
    }

    static int getInt(ByteBuffer byteBuffer, int n, boolean bl) {
        return bl ? Bits.getIntB(byteBuffer, n) : Bits.getIntL(byteBuffer, n);
    }

    static int getInt(long l, boolean bl) {
        return bl ? Bits.getIntB(l) : Bits.getIntL(l);
    }

    static int rcmGetInt(long l, boolean bl) {
        return bl ? Bits.rcmGetIntB(l) : Bits.rcmGetIntL(l);
    }

    private static byte int3(int n) {
        return (byte)(n >> 24);
    }

    private static byte int2(int n) {
        return (byte)(n >> 16);
    }

    private static byte int1(int n) {
        return (byte)(n >> 8);
    }

    private static byte int0(int n) {
        return (byte)n;
    }

    static void putIntL(ByteBuffer byteBuffer, int n, int n2) {
        byteBuffer._put(n + 3, Bits.int3(n2));
        byteBuffer._put(n + 2, Bits.int2(n2));
        byteBuffer._put(n + 1, Bits.int1(n2));
        byteBuffer._put(n, Bits.int0(n2));
    }

    static void putIntL(long l, int n) {
        Bits._put(l + 3L, Bits.int3(n));
        Bits._put(l + 2L, Bits.int2(n));
        Bits._put(l + 1L, Bits.int1(n));
        Bits._put(l, Bits.int0(n));
    }

    static void rcmPutIntL(long l, int n) {
        Bits._rcmPut(l + 3L, Bits.int3(n));
        Bits._rcmPut(l + 2L, Bits.int2(n));
        Bits._rcmPut(l + 1L, Bits.int1(n));
        Bits._rcmPut(l, Bits.int0(n));
    }

    static void putIntB(ByteBuffer byteBuffer, int n, int n2) {
        byteBuffer._put(n, Bits.int3(n2));
        byteBuffer._put(n + 1, Bits.int2(n2));
        byteBuffer._put(n + 2, Bits.int1(n2));
        byteBuffer._put(n + 3, Bits.int0(n2));
    }

    static void putIntB(long l, int n) {
        Bits._put(l, Bits.int3(n));
        Bits._put(l + 1L, Bits.int2(n));
        Bits._put(l + 2L, Bits.int1(n));
        Bits._put(l + 3L, Bits.int0(n));
    }

    static void rcmPutIntB(long l, int n) {
        Bits._rcmPut(l, Bits.int3(n));
        Bits._rcmPut(l + 1L, Bits.int2(n));
        Bits._rcmPut(l + 2L, Bits.int1(n));
        Bits._rcmPut(l + 3L, Bits.int0(n));
    }

    static void putInt(ByteBuffer byteBuffer, int n, int n2, boolean bl) {
        if (bl) {
            Bits.putIntB(byteBuffer, n, n2);
        } else {
            Bits.putIntL(byteBuffer, n, n2);
        }
    }

    static void putInt(long l, int n, boolean bl) {
        if (bl) {
            Bits.putIntB(l, n);
        } else {
            Bits.putIntL(l, n);
        }
    }

    static void rcmPutInt(long l, int n, boolean bl) {
        if (bl) {
            Bits.rcmPutIntB(l, n);
        } else {
            Bits.rcmPutIntL(l, n);
        }
    }

    private static long makeLong(byte by, byte by2, byte by3, byte by4, byte by5, byte by6, byte by7, byte by8) {
        return (long)by << 56 | ((long)by2 & 0xFFL) << 48 | ((long)by3 & 0xFFL) << 40 | ((long)by4 & 0xFFL) << 32 | ((long)by5 & 0xFFL) << 24 | ((long)by6 & 0xFFL) << 16 | ((long)by7 & 0xFFL) << 8 | (long)by8 & 0xFFL;
    }

    static long getLongL(ByteBuffer byteBuffer, int n) {
        return Bits.makeLong(byteBuffer._get(n + 7), byteBuffer._get(n + 6), byteBuffer._get(n + 5), byteBuffer._get(n + 4), byteBuffer._get(n + 3), byteBuffer._get(n + 2), byteBuffer._get(n + 1), byteBuffer._get(n));
    }

    static long getLongL(long l) {
        return Bits.makeLong(Bits._get(l + 7L), Bits._get(l + 6L), Bits._get(l + 5L), Bits._get(l + 4L), Bits._get(l + 3L), Bits._get(l + 2L), Bits._get(l + 1L), Bits._get(l));
    }

    static long rcmGetLongL(long l) {
        return Bits.makeLong(Bits._rcmGet(l + 7L), Bits._rcmGet(l + 6L), Bits._rcmGet(l + 5L), Bits._rcmGet(l + 4L), Bits._rcmGet(l + 3L), Bits._rcmGet(l + 2L), Bits._rcmGet(l + 1L), Bits._rcmGet(l));
    }

    static long getLongB(ByteBuffer byteBuffer, int n) {
        return Bits.makeLong(byteBuffer._get(n), byteBuffer._get(n + 1), byteBuffer._get(n + 2), byteBuffer._get(n + 3), byteBuffer._get(n + 4), byteBuffer._get(n + 5), byteBuffer._get(n + 6), byteBuffer._get(n + 7));
    }

    static long getLongB(long l) {
        return Bits.makeLong(Bits._get(l), Bits._get(l + 1L), Bits._get(l + 2L), Bits._get(l + 3L), Bits._get(l + 4L), Bits._get(l + 5L), Bits._get(l + 6L), Bits._get(l + 7L));
    }

    static long rcmGetLongB(long l) {
        return Bits.makeLong(Bits._rcmGet(l), Bits._rcmGet(l + 1L), Bits._rcmGet(l + 2L), Bits._rcmGet(l + 3L), Bits._rcmGet(l + 4L), Bits._rcmGet(l + 5L), Bits._rcmGet(l + 6L), Bits._rcmGet(l + 7L));
    }

    static long getLong(ByteBuffer byteBuffer, int n, boolean bl) {
        return bl ? Bits.getLongB(byteBuffer, n) : Bits.getLongL(byteBuffer, n);
    }

    static long getLong(long l, boolean bl) {
        return bl ? Bits.getLongB(l) : Bits.getLongL(l);
    }

    static long rcmGetLong(long l, boolean bl) {
        return bl ? Bits.rcmGetLongB(l) : Bits.rcmGetLongL(l);
    }

    private static byte long7(long l) {
        return (byte)(l >> 56);
    }

    private static byte long6(long l) {
        return (byte)(l >> 48);
    }

    private static byte long5(long l) {
        return (byte)(l >> 40);
    }

    private static byte long4(long l) {
        return (byte)(l >> 32);
    }

    private static byte long3(long l) {
        return (byte)(l >> 24);
    }

    private static byte long2(long l) {
        return (byte)(l >> 16);
    }

    private static byte long1(long l) {
        return (byte)(l >> 8);
    }

    private static byte long0(long l) {
        return (byte)l;
    }

    static void putLongL(ByteBuffer byteBuffer, int n, long l) {
        byteBuffer._put(n + 7, Bits.long7(l));
        byteBuffer._put(n + 6, Bits.long6(l));
        byteBuffer._put(n + 5, Bits.long5(l));
        byteBuffer._put(n + 4, Bits.long4(l));
        byteBuffer._put(n + 3, Bits.long3(l));
        byteBuffer._put(n + 2, Bits.long2(l));
        byteBuffer._put(n + 1, Bits.long1(l));
        byteBuffer._put(n, Bits.long0(l));
    }

    static void putLongL(long l, long l2) {
        Bits._put(l + 7L, Bits.long7(l2));
        Bits._put(l + 6L, Bits.long6(l2));
        Bits._put(l + 5L, Bits.long5(l2));
        Bits._put(l + 4L, Bits.long4(l2));
        Bits._put(l + 3L, Bits.long3(l2));
        Bits._put(l + 2L, Bits.long2(l2));
        Bits._put(l + 1L, Bits.long1(l2));
        Bits._put(l, Bits.long0(l2));
    }

    static void rcmPutLongL(long l, long l2) {
        Bits._rcmPut(l + 7L, Bits.long7(l2));
        Bits._rcmPut(l + 6L, Bits.long6(l2));
        Bits._rcmPut(l + 5L, Bits.long5(l2));
        Bits._rcmPut(l + 4L, Bits.long4(l2));
        Bits._rcmPut(l + 3L, Bits.long3(l2));
        Bits._rcmPut(l + 2L, Bits.long2(l2));
        Bits._rcmPut(l + 1L, Bits.long1(l2));
        Bits._rcmPut(l, Bits.long0(l2));
    }

    static void putLongB(ByteBuffer byteBuffer, int n, long l) {
        byteBuffer._put(n, Bits.long7(l));
        byteBuffer._put(n + 1, Bits.long6(l));
        byteBuffer._put(n + 2, Bits.long5(l));
        byteBuffer._put(n + 3, Bits.long4(l));
        byteBuffer._put(n + 4, Bits.long3(l));
        byteBuffer._put(n + 5, Bits.long2(l));
        byteBuffer._put(n + 6, Bits.long1(l));
        byteBuffer._put(n + 7, Bits.long0(l));
    }

    static void putLongB(long l, long l2) {
        Bits._put(l, Bits.long7(l2));
        Bits._put(l + 1L, Bits.long6(l2));
        Bits._put(l + 2L, Bits.long5(l2));
        Bits._put(l + 3L, Bits.long4(l2));
        Bits._put(l + 4L, Bits.long3(l2));
        Bits._put(l + 5L, Bits.long2(l2));
        Bits._put(l + 6L, Bits.long1(l2));
        Bits._put(l + 7L, Bits.long0(l2));
    }

    static void rcmPutLongB(long l, long l2) {
        Bits._rcmPut(l, Bits.long7(l2));
        Bits._rcmPut(l + 1L, Bits.long6(l2));
        Bits._rcmPut(l + 2L, Bits.long5(l2));
        Bits._rcmPut(l + 3L, Bits.long4(l2));
        Bits._rcmPut(l + 4L, Bits.long3(l2));
        Bits._rcmPut(l + 5L, Bits.long2(l2));
        Bits._rcmPut(l + 6L, Bits.long1(l2));
        Bits._rcmPut(l + 7L, Bits.long0(l2));
    }

    static void putLong(ByteBuffer byteBuffer, int n, long l, boolean bl) {
        if (bl) {
            Bits.putLongB(byteBuffer, n, l);
        } else {
            Bits.putLongL(byteBuffer, n, l);
        }
    }

    static void putLong(long l, long l2, boolean bl) {
        if (bl) {
            Bits.putLongB(l, l2);
        } else {
            Bits.putLongL(l, l2);
        }
    }

    static void rcmPutLong(long l, long l2, boolean bl) {
        if (bl) {
            Bits.rcmPutLongB(l, l2);
        } else {
            Bits.rcmPutLongL(l, l2);
        }
    }

    static float getFloatL(ByteBuffer byteBuffer, int n) {
        return Float.intBitsToFloat(Bits.getIntL(byteBuffer, n));
    }

    static float getFloatL(long l) {
        return Float.intBitsToFloat(Bits.getIntL(l));
    }

    static float rcmGetFloatL(long l) {
        return Float.intBitsToFloat(Bits.rcmGetIntL(l));
    }

    static float getFloatB(ByteBuffer byteBuffer, int n) {
        return Float.intBitsToFloat(Bits.getIntB(byteBuffer, n));
    }

    static float getFloatB(long l) {
        return Float.intBitsToFloat(Bits.getIntB(l));
    }

    static float rcmGetFloatB(long l) {
        return Float.intBitsToFloat(Bits.rcmGetIntB(l));
    }

    static float getFloat(ByteBuffer byteBuffer, int n, boolean bl) {
        return bl ? Bits.getFloatB(byteBuffer, n) : Bits.getFloatL(byteBuffer, n);
    }

    static float getFloat(long l, boolean bl) {
        return bl ? Bits.getFloatB(l) : Bits.getFloatL(l);
    }

    static float rcmGetFloat(long l, boolean bl) {
        return bl ? Bits.rcmGetFloatB(l) : Bits.rcmGetFloatL(l);
    }

    static void putFloatL(ByteBuffer byteBuffer, int n, float f) {
        Bits.putIntL(byteBuffer, n, Float.floatToRawIntBits(f));
    }

    static void putFloatL(long l, float f) {
        Bits.putIntL(l, Float.floatToRawIntBits(f));
    }

    static void rcmPutFloatL(long l, float f) {
        Bits.rcmPutIntL(l, Float.floatToRawIntBits(f));
    }

    static void putFloatB(ByteBuffer byteBuffer, int n, float f) {
        Bits.putIntB(byteBuffer, n, Float.floatToRawIntBits(f));
    }

    static void putFloatB(long l, float f) {
        Bits.putIntB(l, Float.floatToRawIntBits(f));
    }

    static void rcmPutFloatB(long l, float f) {
        Bits.rcmPutIntB(l, Float.floatToRawIntBits(f));
    }

    static void putFloat(ByteBuffer byteBuffer, int n, float f, boolean bl) {
        if (bl) {
            Bits.putFloatB(byteBuffer, n, f);
        } else {
            Bits.putFloatL(byteBuffer, n, f);
        }
    }

    static void putFloat(long l, float f, boolean bl) {
        if (bl) {
            Bits.putFloatB(l, f);
        } else {
            Bits.putFloatL(l, f);
        }
    }

    static void rcmPutFloat(long l, float f, boolean bl) {
        if (bl) {
            Bits.rcmPutFloatB(l, f);
        } else {
            Bits.rcmPutFloatL(l, f);
        }
    }

    static double getDoubleL(ByteBuffer byteBuffer, int n) {
        return Double.longBitsToDouble(Bits.getLongL(byteBuffer, n));
    }

    static double getDoubleL(long l) {
        return Double.longBitsToDouble(Bits.getLongL(l));
    }

    static double rcmGetDoubleL(long l) {
        return Double.longBitsToDouble(Bits.rcmGetLongL(l));
    }

    static double getDoubleB(ByteBuffer byteBuffer, int n) {
        return Double.longBitsToDouble(Bits.getLongB(byteBuffer, n));
    }

    static double getDoubleB(long l) {
        return Double.longBitsToDouble(Bits.getLongB(l));
    }

    static double rmcGetDoubleB(long l) {
        return Double.longBitsToDouble(Bits.rcmGetLongB(l));
    }

    static double getDouble(ByteBuffer byteBuffer, int n, boolean bl) {
        return bl ? Bits.getDoubleB(byteBuffer, n) : Bits.getDoubleL(byteBuffer, n);
    }

    static double getDouble(long l, boolean bl) {
        return bl ? Bits.getDoubleB(l) : Bits.getDoubleL(l);
    }

    static double rcmGetDouble(long l, boolean bl) {
        return bl ? Bits.rmcGetDoubleB(l) : Bits.rcmGetDoubleL(l);
    }

    static void putDoubleL(ByteBuffer byteBuffer, int n, double d) {
        Bits.putLongL(byteBuffer, n, Double.doubleToRawLongBits(d));
    }

    static void putDoubleL(long l, double d) {
        Bits.putLongL(l, Double.doubleToRawLongBits(d));
    }

    static void rcmPutDoubleL(long l, double d) {
        Bits.rcmPutLongL(l, Double.doubleToRawLongBits(d));
    }

    static void putDoubleB(ByteBuffer byteBuffer, int n, double d) {
        Bits.putLongB(byteBuffer, n, Double.doubleToRawLongBits(d));
    }

    static void putDoubleB(long l, double d) {
        Bits.putLongB(l, Double.doubleToRawLongBits(d));
    }

    static void rcmPutDoubleB(long l, double d) {
        Bits.rcmPutLongB(l, Double.doubleToRawLongBits(d));
    }

    static void putDouble(ByteBuffer byteBuffer, int n, double d, boolean bl) {
        if (bl) {
            Bits.putDoubleB(byteBuffer, n, d);
        } else {
            Bits.putDoubleL(byteBuffer, n, d);
        }
    }

    static void putDouble(long l, double d, boolean bl) {
        if (bl) {
            Bits.putDoubleB(l, d);
        } else {
            Bits.putDoubleL(l, d);
        }
    }

    static void rcmPutDouble(long l, double d, boolean bl) {
        if (bl) {
            Bits.rcmPutDoubleB(l, d);
        } else {
            Bits.rcmPutDoubleL(l, d);
        }
    }

    private static byte _get(long l) {
        return unsafe.getByte(l);
    }

    private static byte _rcmGet(long l) {
        return unsafe.rcmGetByte(l);
    }

    private static void _put(long l, byte by) {
        unsafe.putByte(l, by);
    }

    private static void _rcmPut(long l, byte by) {
        unsafe.rcmPutByte(l, by);
    }

    static Unsafe unsafe() {
        return unsafe;
    }

    static ByteOrder byteOrder() {
        if (byteOrder == null) {
            throw new Error("Unknown byte order");
        }
        return byteOrder;
    }

    static int pageSize() {
        if (pageSize == -1) {
            pageSize = Bits.unsafe().pageSize();
        }
        return pageSize;
    }

    static int pageCount(long l) {
        return (int)(l + (long)Bits.pageSize() - 1L) / Bits.pageSize();
    }

    static void keepAlive(Object object) {
    }

    static boolean unaligned() {
        if (unalignedKnown) {
            return unaligned;
        }
        if (VM.isBooted()) {
            GetPropertyAction getPropertyAction = new GetPropertyAction("os.arch");
            String string = AccessController.doPrivileged(getPropertyAction);
            unaligned = string.equals("i386") || string.equals("x86") || string.equals("amd64");
            unalignedKnown = true;
        } else {
            unaligned = false;
        }
        return unaligned;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void initMaxCapacity() {
        Object object = initCapacityLock;
        synchronized (object) {
            if (isMaxCapacityInit || !VM.isBooted()) return;
            long l = VM.maxDirectMemory();
            Class<Bits> clazz = Bits.class;
            synchronized (Bits.class) {
                isMaxCapacityGrowable = l == 0x4000000L;
                // ** MonitorExit[var3_2] (shouldn't be in output)
                maxCapacity.set(l);
                isMaxCapacityInit = true;
                return;
            }
        }
    }

    private static long tryReserveMemory(long l, long l2) {
        long l3;
        block1: {
            l3 = 0L;
            long l4 = 0L;
            do {
                l3 = currentCapacity.get();
                l4 = l3 + l2;
                if (maxCapacity.get() <= l4) break block1;
            } while (!currentCapacity.compareAndSet(l3, l4));
            reservedMemory.addAndGet(l);
            activeReservations.incrementAndGet();
            return -1L;
        }
        return l3;
    }

    private static synchronized void syncReserveMemory(long l, long l2) {
        long l3 = Bits.tryReserveMemory(l, l2);
        if (l3 == -1L) {
            return;
        }
        System.gc();
        long l4 = 100L;
        for (int i = 5; i > 0; --i) {
            try {
                Thread.sleep(l4);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (currentCapacity.get() < l3) break;
            l4 += 50L;
        }
        if ((l3 = Bits.tryReserveMemory(l, l2)) == -1L) {
            return;
        }
        if (isMaxCapacityGrowable) {
            currentCapacity.addAndGet(l2);
            maxCapacity.addAndGet(Math.max(0x2000000L, l2));
            reservedMemory.addAndGet(l);
            activeReservations.incrementAndGet();
            return;
        }
        throw new OutOfMemoryError("Direct buffer memory::Please use appropriate '<size>' via -XX:MaxDirectMemorySize=<size>");
    }

    static void reserveMemory(long l, int n) {
        Bits.initMaxCapacity();
        long l2 = Bits.tryReserveMemory(l, n);
        if (l2 == -1L) {
            return;
        }
        Bits.syncReserveMemory(l, n);
    }

    static void unreserveMemory(long l, int n) {
        long l2 = currentCapacity.addAndGet(-n);
        long l3 = reservedMemory.addAndGet(-l);
        activeReservations.decrementAndGet();
        if (!$assertionsDisabled && l2 <= -1L) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && l3 <= -1L) {
            throw new AssertionError();
        }
    }

    static void copyFromArray(Object object, long l, long l2, long l3, long l4) {
        long l5 = l + l2;
        while (l4 > 0L) {
            long l6 = l4 > 0x100000L ? 0x100000L : l4;
            unsafe.copyMemory(object, l5, null, l3, l6);
            l4 -= l6;
            l5 += l6;
            l3 += l6;
        }
    }

    static void copyToArray(long l, Object object, long l2, long l3, long l4) {
        long l5 = l2 + l3;
        while (l4 > 0L) {
            long l6 = l4 > 0x100000L ? 0x100000L : l4;
            unsafe.copyMemory(null, l, object, l5, l6);
            l4 -= l6;
            l += l6;
            l5 += l6;
        }
    }

    static void copyFromCharArray(Object object, long l, long l2, long l3) {
        Bits.copyFromShortArray(object, l, l2, l3);
    }

    static void copyToCharArray(long l, Object object, long l2, long l3) {
        Bits.copyToShortArray(l, object, l2, l3);
    }

    static native void copyFromShortArray(Object var0, long var1, long var3, long var5);

    static native void copyToShortArray(long var0, Object var2, long var3, long var5);

    static native void copyFromIntArray(Object var0, long var1, long var3, long var5);

    static native void copyToIntArray(long var0, Object var2, long var3, long var5);

    static native void copyFromLongArray(Object var0, long var1, long var3, long var5);

    static native void copyToLongArray(long var0, Object var2, long var3, long var5);

    static void rcmCopyFromArray(Object object, long l, long l2, long l3, long l4) {
        long l5 = l + l2;
        while (l4 > 0L) {
            long l6 = l4 > 0x100000L ? 0x100000L : l4;
            unsafe.rcmCopyMemory(object, l5, null, l3, l6);
            l4 -= l6;
            l5 += l6;
            l3 += l6;
        }
    }

    static void rcmCopyToArray(long l, Object object, long l2, long l3, long l4) {
        long l5 = l2 + l3;
        while (l4 > 0L) {
            long l6 = l4 > 0x100000L ? 0x100000L : l4;
            unsafe.rcmCopyMemory(null, l, object, l5, l6);
            l4 -= l6;
            l += l6;
            l5 += l6;
        }
    }

    static void rcmCopyFromCharArray(Object object, long l, long l2, long l3) {
        Bits.rcmCopyFromShortArray(object, l, l2, l3);
    }

    static void rcmCopyToCharArray(long l, Object object, long l2, long l3) {
        Bits.rcmCopyToShortArray(l, object, l2, l3);
    }

    static native void rcmCopyFromShortArray(Object var0, long var1, long var3, long var5);

    static native void rcmCopyToShortArray(long var0, Object var2, long var3, long var5);

    static native void rcmCopyFromIntArray(Object var0, long var1, long var3, long var5);

    static native void rcmCopyToIntArray(long var0, Object var2, long var3, long var5);

    static native void rcmCopyFromLongArray(Object var0, long var1, long var3, long var5);

    static native void rcmCopyToLongArray(long var0, Object var2, long var3, long var5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    static {
        Bits.$assertionsDisabled = Bits.class.desiredAssertionStatus() == false;
        Bits.unsafe = Unsafe.getUnsafe();
        var0 = Bits.unsafe.allocateMemory(8L);
        try {
            Bits.unsafe.putLong(var0, 72623859790382856L);
            var2_1 = Bits.unsafe.getByte(var0);
            switch (var2_1) {
                case 1: {
                    Bits.byteOrder = ByteOrder.BIG_ENDIAN;
                    ** break;
lbl11:
                    // 1 sources

                    break;
                }
                case 8: {
                    Bits.byteOrder = ByteOrder.LITTLE_ENDIAN;
                    ** break;
lbl15:
                    // 1 sources

                    break;
                }
                default: {
                    if (!Bits.$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    Bits.byteOrder = null;
                    break;
                }
            }
        }
        finally {
            Bits.unsafe.freeMemory(var0);
        }
        Bits.pageSize = -1;
        Bits.unalignedKnown = false;
        Bits.maxCapacity = new AtomicLong(VM.maxDirectMemory());
        Bits.currentCapacity = new AtomicLong();
        Bits.reservedMemory = new AtomicLong();
        Bits.activeReservations = new AtomicLong();
        Bits.isMaxCapacityGrowable = true;
        Bits.initCapacityLock = Bits.class.getName() + ".initCapacityLock";
        Bits.isMaxCapacityInit = false;
        SharedSecrets.setJavaNioAccess(new JavaNioAccess(){

            @Override
            public JavaNioAccess.BufferPool getDirectBufferPool() {
                return new JavaNioAccess.BufferPool(){

                    @Override
                    public String getName() {
                        return "direct";
                    }

                    @Override
                    public long getCount() {
                        return activeReservations.get();
                    }

                    @Override
                    public long getTotalCapacity() {
                        return currentCapacity.get();
                    }

                    @Override
                    public long getMemoryUsed() {
                        return reservedMemory.get();
                    }
                };
            }

            @Override
            public ByteBuffer newDirectByteBuffer(long l, int n, Object object) {
                return new DirectByteBuffer(l, n, object);
            }

            @Override
            public void truncate(Buffer buffer) {
                buffer.truncate();
            }
        });
    }
}

