/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import sun.security.jca.GetInstance;
import sun.security.jca.ServiceId;
import sun.security.util.Debug;

public abstract class Signature
extends SignatureSpi {
    private static final Debug debug = Debug.getInstance("jca", "Signature");
    private final String algorithm;
    Provider provider;
    protected static final int UNINITIALIZED = 0;
    protected static final int SIGN = 2;
    protected static final int VERIFY = 3;
    protected int state = 0;
    private static final String RSA_SIGNATURE = "NONEwithRSA";
    private static final String RSA_CIPHER = "RSA/ECB/PKCS1Padding";
    private static final List<ServiceId> rsaIds = Arrays.asList(new ServiceId("Signature", "NONEwithRSA"), new ServiceId("Cipher", "RSA/ECB/PKCS1Padding"), new ServiceId("Cipher", "RSA/ECB"), new ServiceId("Cipher", "RSA//PKCS1Padding"), new ServiceId("Cipher", "RSA"));
    private static final Map<String, Boolean> signatureInfo = new ConcurrentHashMap<String, Boolean>();

    protected Signature(String string) {
        this.algorithm = string;
    }

    public static Signature getInstance(String string) throws NoSuchAlgorithmException {
        List<Provider.Service> list = string.equalsIgnoreCase(RSA_SIGNATURE) ? GetInstance.getServices(rsaIds) : GetInstance.getServices("Signature", string);
        NoSuchAlgorithmException noSuchAlgorithmException = null;
        for (Provider.Service service : list) {
            if (Signature.isSpi(service)) {
                return new Delegate(service, list, string);
            }
            try {
                GetInstance.Instance instance = GetInstance.getInstance(service, SignatureSpi.class);
                return Signature.getInstance(instance, string);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException2) {
                noSuchAlgorithmException = noSuchAlgorithmException2;
            }
        }
        throw new NoSuchAlgorithmException("Algorithm " + string + " not available", noSuchAlgorithmException);
    }

    private static Signature getInstance(GetInstance.Instance instance, String string) {
        Signature signature;
        if (instance.impl instanceof Signature) {
            signature = (Signature)instance.impl;
        } else {
            SignatureSpi signatureSpi = (SignatureSpi)instance.impl;
            signature = new Delegate(signatureSpi, string);
        }
        signature.provider = instance.provider;
        return signature;
    }

    private static boolean isSpi(Provider.Service service) {
        if (service.getType().equals("Cipher")) {
            return true;
        }
        String string = service.getClassName();
        Boolean bl = signatureInfo.get(string);
        if (bl == null) {
            try {
                boolean bl2;
                Object object = service.newInstance(null);
                boolean bl3 = bl2 = object instanceof SignatureSpi && !(object instanceof Signature);
                if (debug != null && !bl2) {
                    debug.println("Not a SignatureSpi " + string);
                    debug.println("Delayed provider selection may not be available for algorithm " + service.getAlgorithm());
                }
                bl = bl2;
                signatureInfo.put(string, bl);
            }
            catch (Exception exception) {
                return false;
            }
        }
        return bl;
    }

    public static Signature getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (string.equalsIgnoreCase(RSA_SIGNATURE)) {
            if (string2 == null || string2.length() == 0) {
                throw new IllegalArgumentException("missing provider");
            }
            Provider provider = Security.getProvider(string2);
            if (provider == null) {
                throw new NoSuchProviderException("no such provider: " + string2);
            }
            return Signature.getInstanceRSA(provider);
        }
        GetInstance.Instance instance = GetInstance.getInstance("Signature", SignatureSpi.class, string, string2);
        return Signature.getInstance(instance, string);
    }

    public static Signature getInstance(String string, Provider provider) throws NoSuchAlgorithmException {
        if (string.equalsIgnoreCase(RSA_SIGNATURE)) {
            if (provider == null) {
                throw new IllegalArgumentException("missing provider");
            }
            return Signature.getInstanceRSA(provider);
        }
        GetInstance.Instance instance = GetInstance.getInstance("Signature", SignatureSpi.class, string, provider);
        return Signature.getInstance(instance, string);
    }

    private static Signature getInstanceRSA(Provider provider) throws NoSuchAlgorithmException {
        Provider.Service service = provider.getService("Signature", RSA_SIGNATURE);
        if (service != null) {
            GetInstance.Instance instance = GetInstance.getInstance(service, SignatureSpi.class);
            return Signature.getInstance(instance, RSA_SIGNATURE);
        }
        try {
            Cipher cipher = Cipher.getInstance(RSA_CIPHER, provider);
            return new Delegate(new CipherAdapter(cipher), RSA_SIGNATURE);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new NoSuchAlgorithmException("no such algorithm: NONEwithRSA for provider " + provider.getName(), generalSecurityException);
        }
    }

    public final Provider getProvider() {
        this.chooseFirstProvider();
        return this.provider;
    }

    void chooseFirstProvider() {
    }

    public final void initVerify(PublicKey publicKey) throws InvalidKeyException {
        this.engineInitVerify(publicKey);
        this.state = 3;
    }

    public final void initVerify(Certificate certificate) throws InvalidKeyException {
        boolean[] blArray;
        Serializable serializable;
        Set<String> set;
        if (certificate instanceof X509Certificate && (set = (serializable = (X509Certificate)certificate).getCriticalExtensionOIDs()) != null && !set.isEmpty() && set.contains("2.5.29.15") && (blArray = ((X509Certificate)serializable).getKeyUsage()) != null && !blArray[0]) {
            throw new InvalidKeyException("Wrong key usage");
        }
        serializable = certificate.getPublicKey();
        this.engineInitVerify((PublicKey)serializable);
        this.state = 3;
    }

    public final void initSign(PrivateKey privateKey) throws InvalidKeyException {
        this.engineInitSign(privateKey);
        this.state = 2;
    }

    public final void initSign(PrivateKey privateKey, SecureRandom secureRandom) throws InvalidKeyException {
        this.engineInitSign(privateKey, secureRandom);
        this.state = 2;
    }

    public final byte[] sign() throws SignatureException {
        if (this.state == 2) {
            return this.engineSign();
        }
        throw new SignatureException("object not initialized for signing");
    }

    public final int sign(byte[] byArray, int n, int n2) throws SignatureException {
        if (byArray == null) {
            throw new IllegalArgumentException("No output buffer given");
        }
        if (byArray.length - n < n2) {
            throw new IllegalArgumentException("Output buffer too small for specified offset and length");
        }
        if (this.state != 2) {
            throw new SignatureException("object not initialized for signing");
        }
        return this.engineSign(byArray, n, n2);
    }

    public final boolean verify(byte[] byArray) throws SignatureException {
        if (this.state == 3) {
            return this.engineVerify(byArray);
        }
        throw new SignatureException("object not initialized for verification");
    }

    public final boolean verify(byte[] byArray, int n, int n2) throws SignatureException {
        if (this.state == 3) {
            if (byArray == null || n < 0 || n2 < 0 || n2 > byArray.length - n) {
                throw new IllegalArgumentException("Bad arguments");
            }
            return this.engineVerify(byArray, n, n2);
        }
        throw new SignatureException("object not initialized for verification");
    }

    public final void update(byte by) throws SignatureException {
        if (this.state != 3 && this.state != 2) {
            throw new SignatureException("object not initialized for signature or verification");
        }
        this.engineUpdate(by);
    }

    public final void update(byte[] byArray) throws SignatureException {
        this.update(byArray, 0, byArray.length);
    }

    public final void update(byte[] byArray, int n, int n2) throws SignatureException {
        if (this.state != 2 && this.state != 3) {
            throw new SignatureException("object not initialized for signature or verification");
        }
        this.engineUpdate(byArray, n, n2);
    }

    public final void update(ByteBuffer byteBuffer) throws SignatureException {
        if (this.state != 2 && this.state != 3) {
            throw new SignatureException("object not initialized for signature or verification");
        }
        if (byteBuffer == null) {
            throw new NullPointerException();
        }
        this.engineUpdate(byteBuffer);
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public String toString() {
        String string = "";
        switch (this.state) {
            case 0: {
                string = "<not initialized>";
                break;
            }
            case 3: {
                string = "<initialized for verifying>";
                break;
            }
            case 2: {
                string = "<initialized for signing>";
            }
        }
        return "Signature object: " + this.getAlgorithm() + string;
    }

    @Deprecated
    public final void setParameter(String string, Object object) throws InvalidParameterException {
        this.engineSetParameter(string, object);
    }

    public final void setParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        this.engineSetParameter(algorithmParameterSpec);
    }

    public final AlgorithmParameters getParameters() {
        return this.engineGetParameters();
    }

    @Deprecated
    public final Object getParameter(String string) throws InvalidParameterException {
        return this.engineGetParameter(string);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        if (this instanceof Cloneable) {
            return super.clone();
        }
        throw new CloneNotSupportedException();
    }

    static {
        Boolean bl = Boolean.TRUE;
        signatureInfo.put("sun.security.provider.DSA$RawDSA", bl);
        signatureInfo.put("sun.security.provider.DSA$SHA1withDSA", bl);
        signatureInfo.put("sun.security.rsa.RSASignature$MD2withRSA", bl);
        signatureInfo.put("sun.security.rsa.RSASignature$MD5withRSA", bl);
        signatureInfo.put("sun.security.rsa.RSASignature$SHA1withRSA", bl);
        signatureInfo.put("sun.security.rsa.RSASignature$SHA256withRSA", bl);
        signatureInfo.put("sun.security.rsa.RSASignature$SHA384withRSA", bl);
        signatureInfo.put("sun.security.rsa.RSASignature$SHA512withRSA", bl);
        signatureInfo.put("com.sun.net.ssl.internal.ssl.RSASignature", bl);
        signatureInfo.put("sun.security.pkcs11.P11Signature", bl);
    }

    private static class CipherAdapter
    extends SignatureSpi {
        private final Cipher cipher;
        private ByteArrayOutputStream data;

        CipherAdapter(Cipher cipher) {
            this.cipher = cipher;
        }

        @Override
        protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
            this.cipher.init(2, publicKey);
            if (this.data == null) {
                this.data = new ByteArrayOutputStream(128);
            } else {
                this.data.reset();
            }
        }

        @Override
        protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
            this.cipher.init(1, privateKey);
            this.data = null;
        }

        @Override
        protected void engineInitSign(PrivateKey privateKey, SecureRandom secureRandom) throws InvalidKeyException {
            this.cipher.init(1, (Key)privateKey, secureRandom);
            this.data = null;
        }

        @Override
        protected void engineUpdate(byte by) throws SignatureException {
            this.engineUpdate(new byte[]{by}, 0, 1);
        }

        @Override
        protected void engineUpdate(byte[] byArray, int n, int n2) throws SignatureException {
            if (this.data != null) {
                this.data.write(byArray, n, n2);
                return;
            }
            byte[] byArray2 = this.cipher.update(byArray, n, n2);
            if (byArray2 != null && byArray2.length != 0) {
                throw new SignatureException("Cipher unexpectedly returned data");
            }
        }

        @Override
        protected byte[] engineSign() throws SignatureException {
            try {
                return this.cipher.doFinal();
            }
            catch (IllegalBlockSizeException illegalBlockSizeException) {
                throw new SignatureException("doFinal() failed", illegalBlockSizeException);
            }
            catch (BadPaddingException badPaddingException) {
                throw new SignatureException("doFinal() failed", badPaddingException);
            }
        }

        @Override
        protected boolean engineVerify(byte[] byArray) throws SignatureException {
            try {
                byte[] byArray2 = this.cipher.doFinal(byArray);
                byte[] byArray3 = this.data.toByteArray();
                this.data.reset();
                return Arrays.equals(byArray2, byArray3);
            }
            catch (BadPaddingException badPaddingException) {
                return false;
            }
            catch (IllegalBlockSizeException illegalBlockSizeException) {
                throw new SignatureException("doFinal() failed", illegalBlockSizeException);
            }
        }

        @Override
        protected void engineSetParameter(String string, Object object) throws InvalidParameterException {
            throw new InvalidParameterException("Parameters not supported");
        }

        @Override
        protected Object engineGetParameter(String string) throws InvalidParameterException {
            throw new InvalidParameterException("Parameters not supported");
        }
    }

    private static class Delegate
    extends Signature {
        private SignatureSpi sigSpi;
        private Provider.Service service;
        private final Object lock;
        private final Provider.Service firstService;
        private final Iterable<Provider.Service> services;
        private static int warnCount = 10;
        private static final int I_PUB = 1;
        private static final int I_PRIV = 2;
        private static final int I_PRIV_SR = 3;

        Delegate(SignatureSpi signatureSpi, String string) {
            super(string);
            this.sigSpi = signatureSpi;
            this.firstService = null;
            this.services = null;
            this.lock = null;
        }

        Delegate(Provider.Service service, Iterable<Provider.Service> iterable, String string) {
            super(string);
            this.firstService = service;
            this.services = iterable;
            this.lock = new Object();
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            this.chooseFirstProvider();
            if (this.sigSpi instanceof Cloneable) {
                SignatureSpi signatureSpi = (SignatureSpi)this.sigSpi.clone();
                Delegate delegate = new Delegate(signatureSpi, ((Signature)this).algorithm);
                delegate.provider = this.provider;
                return delegate;
            }
            throw new CloneNotSupportedException();
        }

        private static SignatureSpi newInstance(Provider.Service service) throws NoSuchAlgorithmException {
            if (service.getType().equals("Cipher")) {
                try {
                    Cipher cipher = Cipher.getInstance(Signature.RSA_CIPHER, service.getProvider());
                    return new CipherAdapter(cipher);
                }
                catch (NoSuchPaddingException noSuchPaddingException) {
                    throw new NoSuchAlgorithmException(noSuchPaddingException);
                }
            }
            Object object = service.newInstance(null);
            if (!(object instanceof SignatureSpi)) {
                throw new NoSuchAlgorithmException("Not a SignatureSpi: " + object.getClass().getName());
            }
            return (SignatureSpi)object;
        }

        @Override
        void chooseFirstProvider() {
            if (this.sigSpi != null || this.services == null) {
                return;
            }
            Object object = this.lock;
            synchronized (object) {
                int n;
                if (this.sigSpi != null) {
                    return;
                }
                if (debug != null && (n = --warnCount) >= 0) {
                    debug.println("Signature.init() not first method called, disabling delayed provider selection");
                    if (n == 0) {
                        debug.println("Further warnings of this type will be suppressed");
                    }
                    new Exception("Call trace").printStackTrace();
                }
                NoSuchAlgorithmException noSuchAlgorithmException = null;
                boolean bl = this.firstService != null;
                for (Provider.Service service : this.services) {
                    if (bl) {
                        if (service != this.firstService) continue;
                        bl = false;
                    }
                    if (!Signature.isSpi(service)) continue;
                    try {
                        SignatureSpi signatureSpi = Delegate.newInstance(service);
                        this.provider = service.getProvider();
                        this.sigSpi = signatureSpi;
                        this.service = service;
                        return;
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException2) {
                        noSuchAlgorithmException = noSuchAlgorithmException2;
                    }
                }
                ProviderException providerException = new ProviderException("Could not construct SignatureSpi instance");
                if (noSuchAlgorithmException != null) {
                    providerException.initCause(noSuchAlgorithmException);
                }
                throw providerException;
            }
        }

        private void chooseProvider(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
            Object object = this.lock;
            synchronized (object) {
                if (this.sigSpi != null && (this.service == null || this.service.supportsParameter(key))) {
                    this.init(this.sigSpi, n, key, secureRandom);
                    return;
                }
                Exception exception = null;
                boolean bl = this.firstService != null;
                for (Provider.Service service : this.services) {
                    if (bl) {
                        if (service != this.firstService) continue;
                        bl = false;
                    }
                    if (!service.supportsParameter(key) || !Signature.isSpi(service)) continue;
                    try {
                        SignatureSpi signatureSpi = Delegate.newInstance(service);
                        this.init(signatureSpi, n, key, secureRandom);
                        this.provider = service.getProvider();
                        this.service = this.service;
                        this.sigSpi = signatureSpi;
                        return;
                    }
                    catch (Exception exception2) {
                        if (exception != null) continue;
                        exception = exception2;
                    }
                }
                if (exception instanceof InvalidKeyException) {
                    throw (InvalidKeyException)exception;
                }
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                String string = key != null ? key.getClass().getName() : "(null)";
                throw new InvalidKeyException("No installed provider supports this key: " + (String)string, exception);
            }
        }

        private void init(SignatureSpi signatureSpi, int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
            switch (n) {
                case 1: {
                    signatureSpi.engineInitVerify((PublicKey)key);
                    break;
                }
                case 2: {
                    signatureSpi.engineInitSign((PrivateKey)key);
                    break;
                }
                case 3: {
                    signatureSpi.engineInitSign((PrivateKey)key, secureRandom);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Internal error: " + n));
                }
            }
        }

        @Override
        protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
            if (this.sigSpi != null && (this.service == null || this.service.supportsParameter(publicKey))) {
                this.sigSpi.engineInitVerify(publicKey);
            } else {
                this.chooseProvider(1, publicKey, null);
            }
        }

        @Override
        protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
            if (this.sigSpi != null && (this.service == null || this.service.supportsParameter(privateKey))) {
                this.sigSpi.engineInitSign(privateKey);
            } else {
                this.chooseProvider(2, privateKey, null);
            }
        }

        @Override
        protected void engineInitSign(PrivateKey privateKey, SecureRandom secureRandom) throws InvalidKeyException {
            if (this.sigSpi != null && (this.service == null || this.service.supportsParameter(privateKey))) {
                this.sigSpi.engineInitSign(privateKey, secureRandom);
            } else {
                this.chooseProvider(3, privateKey, secureRandom);
            }
        }

        @Override
        protected void engineUpdate(byte by) throws SignatureException {
            this.chooseFirstProvider();
            this.sigSpi.engineUpdate(by);
        }

        @Override
        protected void engineUpdate(byte[] byArray, int n, int n2) throws SignatureException {
            this.chooseFirstProvider();
            this.sigSpi.engineUpdate(byArray, n, n2);
        }

        @Override
        protected void engineUpdate(ByteBuffer byteBuffer) {
            this.chooseFirstProvider();
            this.sigSpi.engineUpdate(byteBuffer);
        }

        @Override
        protected byte[] engineSign() throws SignatureException {
            this.chooseFirstProvider();
            return this.sigSpi.engineSign();
        }

        @Override
        protected int engineSign(byte[] byArray, int n, int n2) throws SignatureException {
            this.chooseFirstProvider();
            return this.sigSpi.engineSign(byArray, n, n2);
        }

        @Override
        protected boolean engineVerify(byte[] byArray) throws SignatureException {
            this.chooseFirstProvider();
            return this.sigSpi.engineVerify(byArray);
        }

        @Override
        protected boolean engineVerify(byte[] byArray, int n, int n2) throws SignatureException {
            this.chooseFirstProvider();
            return this.sigSpi.engineVerify(byArray, n, n2);
        }

        @Override
        protected void engineSetParameter(String string, Object object) throws InvalidParameterException {
            this.chooseFirstProvider();
            this.sigSpi.engineSetParameter(string, object);
        }

        @Override
        protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
            this.chooseFirstProvider();
            this.sigSpi.engineSetParameter(algorithmParameterSpec);
        }

        @Override
        protected Object engineGetParameter(String string) throws InvalidParameterException {
            this.chooseFirstProvider();
            return this.sigSpi.engineGetParameter(string);
        }

        @Override
        protected AlgorithmParameters engineGetParameters() {
            this.chooseFirstProvider();
            return this.sigSpi.engineGetParameters();
        }
    }
}

