/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.util.BitSet;

public class VariableGridLayout
extends GridLayout {
    BitSet rowsSet = new BitSet();
    double[] rowFractions = null;
    BitSet colsSet = new BitSet();
    double[] colFractions = null;
    int rows;
    int cols;
    int hgap;
    int vgap;

    public VariableGridLayout(int n, int n2) {
        this(n, n2, 0, 0);
        if (n != 0) {
            this.rowsSet = new BitSet(n);
            this.stdRowFractions(n);
        }
        if (n2 != 0) {
            this.colsSet = new BitSet(n2);
            this.stdColFractions(n2);
        }
    }

    public VariableGridLayout(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
        this.rows = n;
        this.cols = n2;
        this.hgap = n3;
        this.vgap = n4;
        if (n != 0) {
            this.rowsSet = new BitSet(n);
            this.stdRowFractions(n);
        }
        if (n2 != 0) {
            this.colsSet = new BitSet(n2);
            this.stdColFractions(n2);
        }
    }

    void stdRowFractions(int n) {
        this.rowFractions = new double[n];
        for (int i = 0; i < n; ++i) {
            this.rowFractions[i] = 1.0 / (double)n;
        }
    }

    void stdColFractions(int n) {
        this.colFractions = new double[n];
        for (int i = 0; i < n; ++i) {
            this.colFractions[i] = 1.0 / (double)n;
        }
    }

    public void setRowFraction(int n, double d) {
        this.rowsSet.set(n);
        this.rowFractions[n] = d;
    }

    public void setColFraction(int n, double d) {
        this.colsSet.set(n);
        this.colFractions[n] = d;
    }

    public double getRowFraction(int n) {
        return this.rowFractions[n];
    }

    public double getColFraction(int n) {
        return this.colFractions[n];
    }

    void allocateExtraSpace(double[] dArray, BitSet bitSet) {
        int n;
        double d = 0.0;
        int n2 = 0;
        for (n = 0; n < dArray.length; ++n) {
            if (bitSet.get(n)) {
                d += dArray[n];
                continue;
            }
            ++n2;
        }
        if (n2 != 0) {
            double d2 = (1.0 - d) / (double)n2;
            for (n = 0; n < dArray.length; ++n) {
                if (bitSet.get(n)) continue;
                dArray[n] = d2;
                bitSet.set(n);
            }
        }
    }

    void allocateExtraSpace() {
        this.allocateExtraSpace(this.rowFractions, this.rowsSet);
        this.allocateExtraSpace(this.colFractions, this.colsSet);
    }

    @Override
    public void layoutContainer(Container container) {
        Insets insets = container.insets();
        int n = container.countComponents();
        int n2 = this.rows;
        int n3 = this.cols;
        if (n2 > 0) {
            n3 = (n + n2 - 1) / n2;
        } else {
            n2 = (n + n3 - 1) / n3;
        }
        if (this.rows == 0) {
            this.stdRowFractions(n2);
        }
        if (this.cols == 0) {
            this.stdColFractions(n3);
        }
        Dimension dimension = container.size();
        int n4 = dimension.width - (insets.left + insets.right);
        int n5 = dimension.height - (insets.top + insets.bottom);
        n4 -= (n3 - 1) * this.hgap;
        n5 -= (n2 - 1) * this.vgap;
        this.allocateExtraSpace();
        int n6 = insets.left;
        for (int i = 0; i < n3; ++i) {
            int n7 = (int)(this.getColFraction(i) * (double)n4);
            int n8 = insets.top;
            for (int j = 0; j < n2; ++j) {
                int n9 = j * n3 + i;
                int n10 = (int)(this.getRowFraction(j) * (double)n5);
                if (n9 < n) {
                    container.getComponent(n9).reshape(n6, n8, n7, n10);
                }
                n8 += n10 + this.vgap;
            }
            n6 += n7 + this.hgap;
        }
    }

    static String fracsToString(double[] dArray) {
        String string = "[" + dArray.length + "]";
        for (int i = 0; i < dArray.length; ++i) {
            string = string + "<" + dArray[i] + ">";
        }
        return string;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "[hgap=" + this.hgap + ",vgap=" + this.vgap + ",rows=" + this.rows + ",cols=" + this.cols + ",rowFracs=" + VariableGridLayout.fracsToString(this.rowFractions) + ",colFracs=" + VariableGridLayout.fracsToString(this.colFractions) + "]";
    }
}

