/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import com.ibm.net.SocketKeepAliveParameters;
import com.ibm.nio.ch.IBMSocketOptions;
import java.io.FileDescriptor;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.ProtocolFamily;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketOption;
import java.net.StandardProtocolFamily;
import java.net.StandardSocketOptions;
import java.net.UnknownHostException;
import java.nio.channels.AlreadyBoundException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NotYetBoundException;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.UnresolvedAddressException;
import java.nio.channels.UnsupportedAddressTypeException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import sun.nio.ch.IOUtil;
import sun.nio.ch.OptionKey;
import sun.nio.ch.SocketOptionRegistry;
import sun.nio.ch.Util;

class Net {
    static final ProtocolFamily UNSPEC;
    private static boolean revealLocalAddress;
    private static volatile boolean propRevealLocalAddress;
    private static final boolean exclusiveBind;
    private static volatile boolean checkedIPv6;
    private static volatile boolean isIPv6Available;
    private static boolean isSecondSocketRequired;
    public static final int SHUT_RD = 0;
    public static final int SHUT_WR = 1;
    public static final int SHUT_RDWR = 2;

    private Net() {
    }

    static boolean isIPv6Available() {
        if (!checkedIPv6) {
            isIPv6Available = Net.isIPv6Available0();
            checkedIPv6 = true;
        }
        return isIPv6Available;
    }

    static boolean useExclusiveBind() {
        return exclusiveBind;
    }

    static boolean isIPv6Available(boolean bl) {
        if (!checkedIPv6) {
            isIPv6Available = Net.isIPv6Available0();
            checkedIPv6 = true;
        }
        if (bl) {
            return isIPv6Available && !Net.isTwoSocketsRequired();
        }
        return isIPv6Available;
    }

    static boolean canIPv6SocketJoinIPv4Group() {
        return Net.canIPv6SocketJoinIPv4Group0();
    }

    static boolean canJoin6WithIPv4Group() {
        return Net.canJoin6WithIPv4Group0();
    }

    static InetSocketAddress checkAddress(SocketAddress socketAddress) {
        if (socketAddress == null) {
            throw new NullPointerException();
        }
        if (!(socketAddress instanceof InetSocketAddress)) {
            throw new UnsupportedAddressTypeException();
        }
        InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
        if (inetSocketAddress.isUnresolved()) {
            throw new UnresolvedAddressException();
        }
        InetAddress inetAddress = inetSocketAddress.getAddress();
        if (!(inetAddress instanceof Inet4Address) && !(inetAddress instanceof Inet6Address)) {
            throw new IllegalArgumentException("Invalid address type");
        }
        return inetSocketAddress;
    }

    static InetSocketAddress asInetSocketAddress(SocketAddress socketAddress) {
        if (!(socketAddress instanceof InetSocketAddress)) {
            throw new UnsupportedAddressTypeException();
        }
        return (InetSocketAddress)socketAddress;
    }

    static void translateToSocketException(Exception exception) throws SocketException {
        if (exception instanceof SocketException) {
            throw (SocketException)exception;
        }
        Exception exception2 = exception;
        if (exception instanceof ClosedChannelException) {
            exception2 = new SocketException("Socket is closed");
        } else if (exception instanceof NotYetConnectedException) {
            exception2 = new SocketException("Socket is not connected");
        } else if (exception instanceof AlreadyBoundException) {
            exception2 = new SocketException("Already bound");
        } else if (exception instanceof NotYetBoundException) {
            exception2 = new SocketException("Socket is not bound yet");
        } else if (exception instanceof UnsupportedAddressTypeException) {
            exception2 = new SocketException("Unsupported address type");
        } else if (exception instanceof UnresolvedAddressException) {
            exception2 = new SocketException("Unresolved address");
        }
        if (exception2 != exception) {
            exception2.initCause(exception);
        }
        if (exception2 instanceof SocketException) {
            throw (SocketException)exception2;
        }
        if (exception2 instanceof RuntimeException) {
            throw (RuntimeException)exception2;
        }
        throw new Error("Untranslated exception", exception2);
    }

    static void translateException(Exception exception, boolean bl) throws IOException {
        if (exception instanceof IOException) {
            throw (IOException)exception;
        }
        if (bl && exception instanceof UnresolvedAddressException) {
            throw new UnknownHostException();
        }
        Net.translateToSocketException(exception);
    }

    static void translateException(Exception exception) throws IOException {
        Net.translateException(exception, false);
    }

    static InetSocketAddress getRevealedLocalAddress(InetSocketAddress inetSocketAddress) {
        SecurityManager securityManager = System.getSecurityManager();
        if (inetSocketAddress == null || securityManager == null) {
            return inetSocketAddress;
        }
        if (!Net.getRevealLocalAddress()) {
            try {
                securityManager.checkConnect(inetSocketAddress.getAddress().getHostAddress(), -1);
            }
            catch (SecurityException securityException) {
                inetSocketAddress = Net.getLoopbackAddress(inetSocketAddress.getPort());
            }
        }
        return inetSocketAddress;
    }

    static String getRevealedLocalAddressAsString(InetSocketAddress inetSocketAddress) {
        if (!Net.getRevealLocalAddress() && System.getSecurityManager() != null) {
            inetSocketAddress = Net.getLoopbackAddress(inetSocketAddress.getPort());
        }
        return inetSocketAddress.toString();
    }

    private static boolean getRevealLocalAddress() {
        if (!propRevealLocalAddress) {
            try {
                revealLocalAddress = Boolean.parseBoolean(AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                    @Override
                    public String run() {
                        return System.getProperty("jdk.net.revealLocalAddress");
                    }
                }));
            }
            catch (Exception exception) {
                // empty catch block
            }
            propRevealLocalAddress = true;
        }
        return revealLocalAddress;
    }

    private static InetSocketAddress getLoopbackAddress(int n) {
        return new InetSocketAddress(InetAddress.getLoopbackAddress(), n);
    }

    static Inet4Address anyInet4Address(final NetworkInterface networkInterface) {
        return AccessController.doPrivileged(new PrivilegedAction<Inet4Address>(){

            @Override
            public Inet4Address run() {
                Enumeration<InetAddress> enumeration = networkInterface.getInetAddresses();
                while (enumeration.hasMoreElements()) {
                    InetAddress inetAddress = enumeration.nextElement();
                    if (!(inetAddress instanceof Inet4Address)) continue;
                    return (Inet4Address)inetAddress;
                }
                return null;
            }
        });
    }

    static int inet4AsInt(InetAddress inetAddress) {
        if (inetAddress instanceof Inet4Address) {
            byte[] byArray = inetAddress.getAddress();
            int n = byArray[3] & 0xFF;
            n |= byArray[2] << 8 & 0xFF00;
            n |= byArray[1] << 16 & 0xFF0000;
            return n |= byArray[0] << 24 & 0xFF000000;
        }
        throw new AssertionError((Object)"Should not reach here");
    }

    static InetAddress inet4FromInt(int n) {
        byte[] byArray = new byte[]{(byte)(n >>> 24 & 0xFF), (byte)(n >>> 16 & 0xFF), (byte)(n >>> 8 & 0xFF), (byte)(n & 0xFF)};
        try {
            return InetAddress.getByAddress(byArray);
        }
        catch (UnknownHostException unknownHostException) {
            throw new AssertionError((Object)"Should not reach here");
        }
    }

    static byte[] inet6AsByteArray(InetAddress inetAddress) {
        if (inetAddress instanceof Inet6Address) {
            return inetAddress.getAddress();
        }
        if (inetAddress instanceof Inet4Address) {
            byte[] byArray = inetAddress.getAddress();
            byte[] byArray2 = new byte[16];
            byArray2[10] = -1;
            byArray2[11] = -1;
            byArray2[12] = byArray[0];
            byArray2[13] = byArray[1];
            byArray2[14] = byArray[2];
            byArray2[15] = byArray[3];
            return byArray2;
        }
        throw new AssertionError((Object)"Should not reach here");
    }

    static void setSocketOption(FileDescriptor fileDescriptor, ProtocolFamily protocolFamily, SocketOption<?> socketOption, Object object) throws IOException {
        boolean bl;
        int n;
        if (object == null) {
            throw new IllegalArgumentException("Invalid option value");
        }
        Class<?> clazz = socketOption.type();
        if (clazz != Integer.class && clazz != Boolean.class && clazz != SocketKeepAliveParameters.class) {
            throw new AssertionError((Object)"Should not reach here");
        }
        if ((socketOption == StandardSocketOptions.SO_RCVBUF || socketOption == StandardSocketOptions.SO_SNDBUF) && (n = ((Integer)object).intValue()) < 0) {
            throw new IllegalArgumentException("Invalid send/receive buffer size");
        }
        if (socketOption == StandardSocketOptions.SO_LINGER) {
            n = (Integer)object;
            if (n < 0) {
                object = -1;
            }
            if (n > 65535) {
                object = 65535;
            }
        }
        if (socketOption == StandardSocketOptions.IP_TOS && ((n = ((Integer)object).intValue()) < 0 || n > 255)) {
            throw new IllegalArgumentException("Invalid IP_TOS value");
        }
        if (socketOption == StandardSocketOptions.IP_MULTICAST_TTL && ((n = ((Integer)object).intValue()) < 0 || n > 255)) {
            throw new IllegalArgumentException("Invalid TTL/hop value");
        }
        if (socketOption == IBMSocketOptions.TCP_KEEPALIVE_VALS) {
            SocketKeepAliveParameters socketKeepAliveParameters = (SocketKeepAliveParameters)object;
            Net.configureKeepAlive(fileDescriptor, socketKeepAliveParameters.getIdleTime(), socketKeepAliveParameters.getProbeCount(), socketKeepAliveParameters.getIntervalTime());
            return;
        }
        OptionKey optionKey = SocketOptionRegistry.findOption(socketOption, protocolFamily);
        if (optionKey == null) {
            throw new AssertionError((Object)"Option not found");
        }
        int n2 = clazz == Integer.class ? (Integer)object : ((bl = ((Boolean)object).booleanValue()) ? 1 : 0);
        bl = protocolFamily == UNSPEC;
        Net.setIntOption0(fileDescriptor, bl, optionKey.level(), optionKey.name(), n2);
    }

    static Object getSocketOption(FileDescriptor fileDescriptor, ProtocolFamily protocolFamily, SocketOption<?> socketOption) throws IOException {
        Class<?> clazz = socketOption.type();
        if (clazz != Integer.class && clazz != Boolean.class) {
            throw new AssertionError((Object)"Should not reach here");
        }
        OptionKey optionKey = SocketOptionRegistry.findOption(socketOption, protocolFamily);
        if (optionKey == null) {
            throw new AssertionError((Object)"Option not found");
        }
        boolean bl = protocolFamily == UNSPEC;
        int n = Net.getIntOption0(fileDescriptor, bl, optionKey.level(), optionKey.name());
        if (clazz == Integer.class) {
            return n;
        }
        return n == 0 ? Boolean.FALSE : Boolean.TRUE;
    }

    private static native boolean isSecondSocketRequired0();

    static boolean isTwoSocketsRequired() {
        return isSecondSocketRequired;
    }

    private static native boolean isIPv6Available0();

    private static native int isExclusiveBindAvailable();

    private static native boolean canIPv6SocketJoinIPv4Group0();

    private static native boolean canJoin6WithIPv4Group0();

    static FileDescriptor socket(boolean bl) throws IOException {
        return Net.socket(UNSPEC, bl);
    }

    static FileDescriptor socket(boolean bl, boolean bl2) throws IOException {
        return Net.socket(UNSPEC, bl, bl2);
    }

    static FileDescriptor socket(ProtocolFamily protocolFamily, boolean bl) throws IOException {
        if (protocolFamily == UNSPEC && Net.isTwoSocketsRequired()) {
            FileDescriptor fileDescriptor = IOUtil.newFD(Net.socket0(false, bl, false));
            IOUtil.setfd2Val(fileDescriptor, Net.socket0(true, bl, false));
            return fileDescriptor;
        }
        boolean bl2 = Net.isIPv6Available() && protocolFamily != StandardProtocolFamily.INET;
        return IOUtil.newFD(Net.socket0(bl2, bl, false));
    }

    static FileDescriptor socket(ProtocolFamily protocolFamily, boolean bl, boolean bl2) throws IOException {
        if (protocolFamily == UNSPEC && !bl2 && Net.isTwoSocketsRequired()) {
            FileDescriptor fileDescriptor = IOUtil.newFD(Net.socket0(false, bl, false));
            IOUtil.setfd2Val(fileDescriptor, Net.socket0(true, bl, false));
            return fileDescriptor;
        }
        boolean bl3 = Net.isIPv6Available(bl2) && protocolFamily != StandardProtocolFamily.INET;
        return IOUtil.newFD(Net.socket0(bl3, bl, false));
    }

    static FileDescriptor serverSocket(boolean bl) {
        if (Net.isTwoSocketsRequired()) {
            FileDescriptor fileDescriptor = IOUtil.newFD(Net.socket0(false, bl, true));
            IOUtil.setfd2Val(fileDescriptor, Net.socket0(true, bl, true));
            return fileDescriptor;
        }
        return IOUtil.newFD(Net.socket0(Net.isIPv6Available(), bl, true));
    }

    static FileDescriptor serverSocket(boolean bl, boolean bl2) {
        if (!bl2 && Net.isTwoSocketsRequired()) {
            FileDescriptor fileDescriptor = IOUtil.newFD(Net.socket0(false, bl, true));
            IOUtil.setfd2Val(fileDescriptor, Net.socket0(true, bl, true));
            return fileDescriptor;
        }
        return IOUtil.newFD(Net.socket0(Net.isIPv6Available(bl2), bl, true));
    }

    private static native int socket0(boolean var0, boolean var1, boolean var2);

    static native void closeUnboundSocket(FileDescriptor var0);

    static native void closeUnconnectedSocket(FileDescriptor var0);

    static void bind(FileDescriptor fileDescriptor, InetAddress inetAddress, int n) throws IOException {
        Net.bind(UNSPEC, fileDescriptor, inetAddress, n, false);
    }

    static void bind(FileDescriptor fileDescriptor, InetAddress inetAddress, int n, boolean bl) throws IOException {
        Net.bind(UNSPEC, fileDescriptor, inetAddress, n, bl);
    }

    static void bind(ProtocolFamily protocolFamily, FileDescriptor fileDescriptor, InetAddress inetAddress, int n) throws IOException {
        Net.bind(protocolFamily, fileDescriptor, inetAddress, n, false);
    }

    static void bind(ProtocolFamily protocolFamily, FileDescriptor fileDescriptor, InetAddress inetAddress, int n, boolean bl) throws IOException {
        boolean bl2 = Net.isIPv6Available(bl) && protocolFamily != StandardProtocolFamily.INET;
        Net.bind0(fileDescriptor, bl2, exclusiveBind, inetAddress, n);
    }

    private static native void bind0(FileDescriptor var0, boolean var1, boolean var2, InetAddress var3, int var4) throws IOException;

    static native void listen(FileDescriptor var0, int var1) throws IOException;

    static int connect(FileDescriptor fileDescriptor, InetAddress inetAddress, int n) throws IOException {
        return Net.connect(UNSPEC, fileDescriptor, inetAddress, n);
    }

    static int connect(ProtocolFamily protocolFamily, FileDescriptor fileDescriptor, InetAddress inetAddress, int n) throws IOException {
        boolean bl = Net.isIPv6Available() && protocolFamily != StandardProtocolFamily.INET;
        return Net.connect0(bl, fileDescriptor, inetAddress, n);
    }

    private static native int connect0(boolean var0, FileDescriptor var1, InetAddress var2, int var3) throws IOException;

    static native void shutdown(FileDescriptor var0, int var1) throws IOException;

    private static native int localPort(FileDescriptor var0) throws IOException;

    private static native InetAddress localInetAddress(FileDescriptor var0) throws IOException;

    static InetSocketAddress localAddress(FileDescriptor fileDescriptor) throws IOException {
        return new InetSocketAddress(Net.localInetAddress(fileDescriptor), Net.localPort(fileDescriptor));
    }

    private static native int remotePort(FileDescriptor var0) throws IOException;

    private static native InetAddress remoteInetAddress(FileDescriptor var0) throws IOException;

    static InetSocketAddress remoteAddress(FileDescriptor fileDescriptor) throws IOException {
        return new InetSocketAddress(Net.remoteInetAddress(fileDescriptor), Net.remotePort(fileDescriptor));
    }

    private static native int getIntOption0(FileDescriptor var0, boolean var1, int var2, int var3) throws IOException;

    private static native void setIntOption0(FileDescriptor var0, boolean var1, int var2, int var3, int var4) throws IOException;

    static int join4(FileDescriptor fileDescriptor, int n, int n2, int n3) throws IOException {
        return Net.joinOrDrop4(true, fileDescriptor, n, n2, n3);
    }

    static void drop4(FileDescriptor fileDescriptor, int n, int n2, int n3) throws IOException {
        Net.joinOrDrop4(false, fileDescriptor, n, n2, n3);
    }

    private static native int joinOrDrop4(boolean var0, FileDescriptor var1, int var2, int var3, int var4) throws IOException;

    static int block4(FileDescriptor fileDescriptor, int n, int n2, int n3) throws IOException {
        return Net.blockOrUnblock4(true, fileDescriptor, n, n2, n3);
    }

    static void unblock4(FileDescriptor fileDescriptor, int n, int n2, int n3) throws IOException {
        Net.blockOrUnblock4(false, fileDescriptor, n, n2, n3);
    }

    private static native int blockOrUnblock4(boolean var0, FileDescriptor var1, int var2, int var3, int var4) throws IOException;

    static int join6(FileDescriptor fileDescriptor, byte[] byArray, int n, byte[] byArray2) throws IOException {
        return Net.joinOrDrop6(true, fileDescriptor, byArray, n, byArray2);
    }

    static void drop6(FileDescriptor fileDescriptor, byte[] byArray, int n, byte[] byArray2) throws IOException {
        Net.joinOrDrop6(false, fileDescriptor, byArray, n, byArray2);
    }

    private static native int joinOrDrop6(boolean var0, FileDescriptor var1, byte[] var2, int var3, byte[] var4) throws IOException;

    static int block6(FileDescriptor fileDescriptor, byte[] byArray, int n, byte[] byArray2) throws IOException {
        return Net.blockOrUnblock6(true, fileDescriptor, byArray, n, byArray2);
    }

    static void unblock6(FileDescriptor fileDescriptor, byte[] byArray, int n, byte[] byArray2) throws IOException {
        Net.blockOrUnblock6(false, fileDescriptor, byArray, n, byArray2);
    }

    static native int blockOrUnblock6(boolean var0, FileDescriptor var1, byte[] var2, int var3, byte[] var4) throws IOException;

    static native void setInterface4(FileDescriptor var0, int var1) throws IOException;

    static native int getInterface4(FileDescriptor var0) throws IOException;

    static native void setInterface6(FileDescriptor var0, int var1) throws IOException;

    static native int getInterface6(FileDescriptor var0) throws IOException;

    static native void configureKeepAlive(FileDescriptor var0, int var1, int var2, int var3) throws SocketException;

    private static native void initIDs();

    static {
        String string;
        Util.load();
        Net.initIDs();
        UNSPEC = new ProtocolFamily(){

            @Override
            public String name() {
                return "UNSPEC";
            }
        };
        int n = Net.isExclusiveBindAvailable();
        exclusiveBind = n >= 0 ? ((string = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("sun.net.useExclusiveBind");
            }
        })) != null ? (string.length() == 0 ? true : Boolean.parseBoolean(string)) : n == 1) : false;
        checkedIPv6 = false;
        isSecondSocketRequired = false;
        isSecondSocketRequired = Net.isSecondSocketRequired0();
    }
}

