/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import com.ibm.net.NetworkRecycledException;
import java.io.FileDescriptor;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.AlreadyBoundException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NotYetBoundException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.security.AccessController;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import sun.net.NetHooks;
import sun.nio.ch.IOStatus;
import sun.nio.ch.IOUtil;
import sun.nio.ch.NativeDispatcher;
import sun.nio.ch.NativeThread;
import sun.nio.ch.Net;
import sun.nio.ch.NetworkProvider;
import sun.nio.ch.NetworkSelector;
import sun.nio.ch.ProviderNet;
import sun.nio.ch.SelChImpl;
import sun.nio.ch.SelectionKeyImpl;
import sun.nio.ch.ServerSocketAdaptor;
import sun.nio.ch.SocketAction;
import sun.nio.ch.SocketChannelImpl;
import sun.nio.ch.SocketDispatcher;
import sun.nio.ch.Util;
import sun.security.action.GetPropertyAction;

class ServerSocketChannelImpl
extends ServerSocketChannel
implements SelChImpl {
    private static NativeDispatcher nd;
    private NetworkProvider netProvider = null;
    private boolean providerSwitchDone = false;
    private ProviderNet providerNet = null;
    private NativeDispatcher providerDispatcher = null;
    private final FileDescriptor fd;
    private int fdVal;
    private volatile long thread = 0L;
    private final Object lock = new Object();
    private final Object stateLock = new Object();
    private static final int ST_UNINITIALIZED = -1;
    private static final int ST_INUSE = 0;
    private static final int ST_KILLED = 1;
    private int state = -1;
    private InetSocketAddress localAddress;
    private boolean isReuseAddress;
    private int backlogQ = 50;
    private int sport = 0;
    private SocketAddress saddr = null;
    private static boolean zOS;
    ServerSocket socket;

    ServerSocketChannelImpl(SelectorProvider selectorProvider) throws IOException {
        super(selectorProvider);
        this.fd = Net.serverSocket(true);
        this.fdVal = IOUtil.fdVal(this.fd);
        this.state = 0;
    }

    ServerSocketChannelImpl(SelectorProvider selectorProvider, FileDescriptor fileDescriptor, boolean bl) throws IOException {
        super(selectorProvider);
        this.fd = fileDescriptor;
        this.fdVal = IOUtil.fdVal(fileDescriptor);
        this.state = 0;
        if (bl) {
            this.localAddress = Net.localAddress(fileDescriptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServerSocket socket() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.socket == null) {
                this.socket = ServerSocketAdaptor.create(this);
            }
            return this.socket;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SocketAddress getLocalAddress() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            return this.localAddress == null ? this.localAddress : Net.getRevealedLocalAddress(Net.asInetSocketAddress(this.localAddress));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> ServerSocketChannel setOption(SocketOption<T> socketOption, T t) throws IOException {
        if (socketOption == null) {
            throw new NullPointerException();
        }
        if (!this.supportedOptions().contains(socketOption)) {
            throw new UnsupportedOperationException("'" + socketOption + "' not supported");
        }
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            if (socketOption == StandardSocketOptions.SO_REUSEADDR && Net.useExclusiveBind()) {
                this.isReuseAddress = (Boolean)t;
            } else if (!this.providerSwitchDone) {
                Net.setSocketOption(this.fd, Net.UNSPEC, socketOption, t);
            } else {
                this.providerNet.setSocketOption(this.fd, Net.UNSPEC, socketOption, t);
            }
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T getOption(SocketOption<T> socketOption) throws IOException {
        if (socketOption == null) {
            throw new NullPointerException();
        }
        if (!this.supportedOptions().contains(socketOption)) {
            throw new UnsupportedOperationException("'" + socketOption + "' not supported");
        }
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            if (socketOption == StandardSocketOptions.SO_REUSEADDR && Net.useExclusiveBind()) {
                return (T)Boolean.valueOf(this.isReuseAddress);
            }
            if (!this.providerSwitchDone) {
                return (T)Net.getSocketOption(this.fd, Net.UNSPEC, socketOption);
            }
            return (T)this.providerNet.getSocketOption(this.fd, Net.UNSPEC, socketOption);
        }
    }

    @Override
    public final Set<SocketOption<?>> supportedOptions() {
        return DefaultOptionsHolder.defaultOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBound() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.localAddress != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InetSocketAddress localAddress() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.localAddress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServerSocketChannel bind(SocketAddress socketAddress, int n) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            Object object2;
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            if (this.isBound()) {
                throw new AlreadyBoundException();
            }
            InetSocketAddress inetSocketAddress = socketAddress == null ? new InetSocketAddress(0) : Net.checkAddress(socketAddress);
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkListen(inetSocketAddress.getPort());
            }
            if (zOS) {
                object2 = new Boolean(true);
                int n2 = 5;
                this.setIBMSockOption(this.fd, n2, object2);
            }
            this.initializeProvider(SocketAction.BIND, inetSocketAddress.getAddress(), inetSocketAddress.getPort());
            if (!this.providerSwitchDone) {
                NetHooks.beforeTcpBind(this.fd, inetSocketAddress.getAddress(), inetSocketAddress.getPort());
                Net.bind(this.fd, inetSocketAddress.getAddress(), inetSocketAddress.getPort());
                Net.listen(this.fd, n < 1 ? 50 : n);
            } else {
                if (this.netProvider.getPreferredAddress() != null && (((InetAddress)(object2 = inetSocketAddress.getAddress())).isAnyLocalAddress() || ((InetAddress)object2).isLoopbackAddress())) {
                    inetSocketAddress = new InetSocketAddress(this.netProvider.getPreferredAddress(), inetSocketAddress.getPort());
                }
                Net.bind(this.fd, inetSocketAddress.getAddress(), inetSocketAddress.getPort());
                Net.listen(this.fd, n < 1 ? 50 : n);
                this.providerNet.bind(this.fd, inetSocketAddress.getAddress(), inetSocketAddress.getPort());
                this.providerNet.listen(this.fd, n < 1 ? 50 : n);
            }
            object2 = this.stateLock;
            synchronized (object2) {
                this.localAddress = Net.localAddress(this.fd);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SocketChannel accept() throws IOException {
        var1_1 = this.lock;
        synchronized (var1_1) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            if (!this.isBound()) {
                throw new NotYetBoundException();
            }
            var2_2 = null;
            var3_3 = 0;
            var4_4 = new FileDescriptor();
            var5_5 = new InetSocketAddress[1];
            var6_6 = null;
            var7_7 = 50;
            do {
                var8_8 = false;
                try {
                    this.begin();
                    if (this.isOpen()) ** GOTO lbl-1000
                    var9_10 = null;
                    this.thread = 0L;
                    v0 = var3_3 > 0;
                    ** GOTO lbl52
                }
                catch (NetworkRecycledException var9_9) {
                    try {
                        var8_8 = Boolean.getBoolean("ibm.serversocket.recover");
                        if (!var8_8) {
                            throw var9_9;
                        }
                        try {
                            this.processNRException(this.fd);
                            var6_6 = this.localAddress();
                            var7_7 = this.backlogQ;
                            this.localAddress = null;
                            this.bind(var6_6, var7_7);
                        }
                        catch (SecurityException var10_12) {
                            throw var10_12;
                        }
                        catch (IOException var10_13) {
                            throw var10_13;
                        }
                        var8_8 = true;
                        this.thread = 0L;
                        if (var3_3 > 0) {
                            v1 = true;
                        }
                        v1 = false;
                    }
                    catch (Throwable var11_15) {
                        this.thread = 0L;
                        this.end(var3_3 > 0);
                        if (!ServerSocketChannelImpl.$assertionsDisabled && !IOStatus.check(var3_3)) {
                            throw new AssertionError();
                        }
                        throw var11_15;
                    }
lbl52:
                    // 1 sources

                    this.end(v0);
                    if (!ServerSocketChannelImpl.$assertionsDisabled && !IOStatus.check(var3_3)) {
                        throw new AssertionError();
                    }
                    return var9_10;
lbl-1000:
                    // 1 sources

                    {
                        this.thread = NativeThread.current();
                        while ((var3_3 = this.accept0(this.fd, var4_4, var5_5)) == -3 && this.isOpen()) {
                        }
                        this.thread = 0L;
                        this.end(var3_3 > 0);
                    }
                    if (!ServerSocketChannelImpl.$assertionsDisabled && !IOStatus.check(var3_3)) {
                        throw new AssertionError();
                    }
                    continue;
                    this.end(v1);
                    if (!ServerSocketChannelImpl.$assertionsDisabled && !IOStatus.check(var3_3)) {
                        throw new AssertionError();
                    }
                }
            } while (var8_8);
            if (var3_3 < 1) {
                return null;
            }
            IOUtil.configureBlocking(var4_4, true);
            var9_11 = var5_5[0];
            var2_2 = new SocketChannelImpl(this.provider(), var4_4, var9_11);
            var10_14 = System.getSecurityManager();
            if (var10_14 != null) {
                try {
                    var10_14.checkAccept(var9_11.getAddress().getHostAddress(), var9_11.getPort());
                }
                catch (SecurityException var11_16) {
                    var2_2.close();
                    throw var11_16;
                }
            }
            this.initializeProvider(SocketAction.ACCEPT, var9_11.getAddress(), var9_11.getPort());
            if (this.providerSwitchDone) {
                this.netProvider.postAccept(this.fd, var2_2);
            }
            return var2_2;
        }
    }

    @Override
    protected void implConfigureBlocking(boolean bl) throws IOException {
        IOUtil.configureBlocking(this.fd, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void implCloseSelectableChannel() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            long l = this.thread;
            if (l != 0L) {
                NativeThread.signal(l);
            }
            if (this.state != 1) {
                nd.preClose(this.fd);
            }
            if (!this.isRegistered()) {
                this.kill();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void kill() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == 1) {
                return;
            }
            if (this.state == -1) {
                this.state = 1;
                return;
            }
            assert (!this.isOpen() && !this.isRegistered());
            if (this.providerSwitchDone) {
                this.providerDispatcher.close(this.fd);
            }
            nd.close(this.fd);
            this.state = 1;
        }
    }

    public boolean translateReadyOps(int n, int n2, SelectionKeyImpl selectionKeyImpl) {
        int n3 = selectionKeyImpl.nioInterestOps();
        int n4 = selectionKeyImpl.nioReadyOps();
        int n5 = n2;
        if ((n & 0x20) != 0) {
            return false;
        }
        if ((n & 0x18) != 0) {
            n5 = n3;
            selectionKeyImpl.nioReadyOps(n5);
            return (n5 & ~n4) != 0;
        }
        if ((n & 1) != 0 && (n3 & 0x10) != 0) {
            n5 |= 0x10;
        }
        selectionKeyImpl.nioReadyOps(n5);
        return (n5 & ~n4) != 0;
    }

    @Override
    public boolean translateAndUpdateReadyOps(int n, SelectionKeyImpl selectionKeyImpl) {
        return this.translateReadyOps(n, selectionKeyImpl.nioReadyOps(), selectionKeyImpl);
    }

    @Override
    public boolean translateAndSetReadyOps(int n, SelectionKeyImpl selectionKeyImpl) {
        return this.translateReadyOps(n, 0, selectionKeyImpl);
    }

    @Override
    public void translateAndSetInterestOps(int n, SelectionKeyImpl selectionKeyImpl) {
        int n2 = 0;
        if ((n & 0x10) != 0) {
            n2 |= 1;
        }
        selectionKeyImpl.selector.putEventOps(selectionKeyImpl, n2);
    }

    @Override
    public FileDescriptor getFD() {
        return this.fd;
    }

    @Override
    public int getFDVal() {
        return this.fdVal;
    }

    private void initializeProvider(SocketAction socketAction, InetAddress inetAddress, int n) {
        if (this.providerSwitchDone) {
            return;
        }
        this.netProvider = NetworkSelector.getNetworkProvider(socketAction, inetAddress, n, null);
        try {
            if (this.netProvider != null) {
                this.providerNet = this.netProvider.getProviderNet();
                this.providerDispatcher = this.netProvider.getProviderDispatcher();
                if (this.providerNet == null || this.providerDispatcher == null) {
                    return;
                }
                this.netProvider.createSocket(this.fd, 1);
                this.providerSwitchDone = true;
                this.configureBlocking(true);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean isProviderSwitchDone() {
        return this.providerSwitchDone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append('[');
        if (!this.isOpen()) {
            stringBuffer.append("closed");
        } else {
            Object object = this.stateLock;
            synchronized (object) {
                InetSocketAddress inetSocketAddress = this.localAddress();
                if (inetSocketAddress == null) {
                    stringBuffer.append("unbound");
                } else {
                    stringBuffer.append(Net.getRevealedLocalAddressAsString(inetSocketAddress));
                }
            }
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    private native void processNRException(FileDescriptor var1) throws IOException;

    private native void setIBMSockOption(FileDescriptor var1, int var2, Object var3) throws IOException;

    private native int accept0(FileDescriptor var1, FileDescriptor var2, InetSocketAddress[] var3) throws IOException;

    private static native void initIDs();

    static {
        zOS = false;
        Util.load();
        ServerSocketChannelImpl.initIDs();
        nd = new SocketDispatcher();
        GetPropertyAction getPropertyAction = new GetPropertyAction("os.name");
        String string = AccessController.doPrivileged(getPropertyAction);
        if (string.equals("z/OS")) {
            zOS = true;
        }
    }

    private static class DefaultOptionsHolder {
        static final Set<SocketOption<?>> defaultOptions = DefaultOptionsHolder.defaultOptions();

        private DefaultOptionsHolder() {
        }

        private static Set<SocketOption<?>> defaultOptions() {
            HashSet<SocketOption<Comparable<Integer>>> hashSet = new HashSet<SocketOption<Comparable<Integer>>>(2);
            hashSet.add(StandardSocketOptions.SO_RCVBUF);
            hashSet.add(StandardSocketOptions.SO_REUSEADDR);
            return Collections.unmodifiableSet(hashSet);
        }
    }
}

