/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs;

import com.ibm.bidiTools.bdlayout.BidiConvert;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.security.AccessController;
import sun.misc.VM;
import sun.nio.cs.Surrogate;
import sun.security.action.GetPropertyAction;

class UTF8_Decoder
extends CharsetDecoder {
    private final int flags;
    private String bidiParms;
    private boolean bidiEnabled = false;
    private static String bidiInit;
    private final Surrogate.Generator sgg = new Surrogate.Generator();

    private boolean validSecond(int n, int n2, int n3) {
        if (n3 < 128 || n3 > 191) {
            return false;
        }
        if ((this.flags & 2) != 0) {
            return true;
        }
        switch (n) {
            case 2: {
                if (n2 >= 194 && n2 <= 223) break;
                return false;
            }
            case 3: {
                if (n2 != 224 || n3 >= 160) break;
                return false;
            }
            case 4: {
                if (n2 > 244) {
                    return true;
                }
                if ((this.flags & 4) != 0) {
                    return false;
                }
                if (n2 == 240 && n3 < 144) {
                    return false;
                }
                if (n2 != 244 || n3 <= 143) break;
                return false;
            }
        }
        return true;
    }

    protected UTF8_Decoder(Charset charset, int n) {
        super(charset, 1.0f, 1.0f);
        this.flags = n;
        this.bidiParms = bidiInit;
        if (null == this.bidiParms) {
            if (VM.isBooted()) {
                this.bidiParms = System.getSecurityManager() == null ? new GetPropertyAction("JAVABIDI").run() : AccessController.doPrivileged(new GetPropertyAction("JAVABIDI"));
                if (null == this.bidiParms) {
                    this.bidiParms = "NO";
                }
                bidiInit = this.bidiParms;
            } else {
                this.bidiParms = "NO";
            }
        }
        this.bidiEnabled = !"NO".equals(this.bidiParms);
    }

    private boolean isContinuation(int n) {
        return (n & 0xC0) == 128;
    }

    static final void updatePositions(Buffer buffer, int n, Buffer buffer2, int n2) {
        buffer.position(n - buffer.arrayOffset());
        buffer2.position(n2 - buffer2.arrayOffset());
    }

    private static boolean isNotContinuation(int n) {
        return (n & 0xC0) != 128;
    }

    private static final boolean isMalformed2(int n, int n2) {
        return (n & 0x1E) == 0 || (n2 & 0xC0) != 128;
    }

    private static boolean isMalformed3(int n, int n2, int n3) {
        return n == -32 && (n2 & 0xE0) == 128 || (n2 & 0xC0) != 128 || (n3 & 0xC0) != 128;
    }

    private static final boolean isMalformed4(int n, int n2, int n3) {
        return (n & 0xC0) != 128 || (n2 & 0xC0) != 128 || (n3 & 0xC0) != 128;
    }

    private static CoderResult lookupN(ByteBuffer byteBuffer, int n) {
        for (int i = 1; i < n; ++i) {
            if (!UTF8_Decoder.isNotContinuation(byteBuffer.get())) continue;
            return CoderResult.malformedForLength(i);
        }
        return CoderResult.malformedForLength(n);
    }

    private static CoderResult malformedN(ByteBuffer byteBuffer, int n) {
        switch (n) {
            case 1: {
                byte by = byteBuffer.get();
                if (by >> 2 == -2) {
                    if (byteBuffer.remaining() < 4) {
                        return CoderResult.UNDERFLOW;
                    }
                    return UTF8_Decoder.lookupN(byteBuffer, 5);
                }
                if (by >> 1 == -2) {
                    if (byteBuffer.remaining() < 5) {
                        return CoderResult.UNDERFLOW;
                    }
                    return UTF8_Decoder.lookupN(byteBuffer, 6);
                }
                return CoderResult.malformedForLength(1);
            }
            case 2: {
                return CoderResult.malformedForLength(1);
            }
            case 3: {
                byte by = byteBuffer.get();
                byte by2 = byteBuffer.get();
                return CoderResult.malformedForLength(by == -32 && (by2 & 0xE0) == 128 || UTF8_Decoder.isNotContinuation(by2) ? 1 : 2);
            }
            case 4: {
                int n2 = byteBuffer.get() & 0xFF;
                int n3 = byteBuffer.get() & 0xFF;
                if (n2 > 244 || n2 == 240 && (n3 < 144 || n3 > 191) || n2 == 244 && (n3 & 0xF0) != 128 || UTF8_Decoder.isNotContinuation(n3)) {
                    return CoderResult.malformedForLength(1);
                }
                if (UTF8_Decoder.isNotContinuation(byteBuffer.get())) {
                    return CoderResult.malformedForLength(2);
                }
                return CoderResult.malformedForLength(3);
            }
        }
        assert (false);
        return null;
    }

    private static CoderResult malformed(ByteBuffer byteBuffer, int n, CharBuffer charBuffer, int n2, int n3) {
        byteBuffer.position(n - byteBuffer.arrayOffset());
        CoderResult coderResult = UTF8_Decoder.malformedN(byteBuffer, n3);
        UTF8_Decoder.updatePositions(byteBuffer, n, charBuffer, n2);
        return coderResult;
    }

    private static CoderResult malformed(ByteBuffer byteBuffer, int n, int n2) {
        byteBuffer.position(n);
        CoderResult coderResult = UTF8_Decoder.malformedN(byteBuffer, n2);
        byteBuffer.position(n);
        return coderResult;
    }

    private static CoderResult xflow(Buffer buffer, int n, int n2, Buffer buffer2, int n3, int n4) {
        UTF8_Decoder.updatePositions(buffer, n, buffer2, n3);
        return n4 == 0 || n2 - n < n4 ? CoderResult.UNDERFLOW : CoderResult.OVERFLOW;
    }

    private static CoderResult xflow(Buffer buffer, int n, int n2) {
        CoderResult coderResult = n2 == 0 || buffer.remaining() < n2 - 1 ? CoderResult.UNDERFLOW : CoderResult.OVERFLOW;
        buffer.position(n);
        return coderResult;
    }

    private CoderResult decodeArrayLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        byte[] byArray = byteBuffer.array();
        int n = byteBuffer.arrayOffset() + byteBuffer.position();
        int n2 = byteBuffer.arrayOffset() + byteBuffer.limit();
        char[] cArray = charBuffer.array();
        int n3 = charBuffer.arrayOffset() + charBuffer.position();
        int n4 = charBuffer.arrayOffset() + charBuffer.limit();
        int n5 = n3 + Math.min(n2 - n, n4 - n3);
        while (n3 < n5 && byArray[n] >= 0) {
            cArray[n3++] = (char)byArray[n++];
        }
        while (n < n2) {
            byte by;
            byte by2;
            byte by3 = byArray[n];
            byteBuffer.position(n - byteBuffer.arrayOffset());
            charBuffer.position(n3 - charBuffer.arrayOffset());
            if (by3 >= 0) {
                if (n3 >= n4) {
                    return UTF8_Decoder.xflow(byteBuffer, n, n2, charBuffer, n3, 1);
                }
                cArray[n3++] = (char)by3;
                ++n;
                continue;
            }
            if (by3 >> 5 == -2) {
                if (n2 - n < 2 || n3 >= n4) {
                    return UTF8_Decoder.xflow(byteBuffer, n, n2, charBuffer, n3, 2);
                }
                by2 = byArray[n + 1];
                if (UTF8_Decoder.isMalformed2(by3, by2)) {
                    return UTF8_Decoder.malformed(byteBuffer, n, charBuffer, n3, 2);
                }
                cArray[n3++] = (char)(by3 << 6 ^ by2 ^ 0xF80);
                n += 2;
                continue;
            }
            if (by3 >> 4 == -2) {
                if (n2 - n < 3 || n3 >= n4) {
                    return UTF8_Decoder.xflow(byteBuffer, n, n2, charBuffer, n3, 3);
                }
                by2 = byArray[n + 1];
                by = byArray[n + 2];
                if (UTF8_Decoder.isMalformed3(by3, by2, by)) {
                    return UTF8_Decoder.malformed(byteBuffer, n, charBuffer, n3, 3);
                }
                cArray[n3++] = (char)(by3 << 12 ^ by2 << 6 ^ by ^ 0x1F80);
                n += 3;
                continue;
            }
            if (by3 >> 3 == -2) {
                if (n2 - n < 4 || n4 - n3 < 2) {
                    return UTF8_Decoder.xflow(byteBuffer, n, n2, charBuffer, n3, 4);
                }
                by2 = byArray[n + 1];
                by = byArray[n + 2];
                byte by4 = byArray[n + 3];
                int n6 = (by3 & 7) << 18 | (by2 & 0x3F) << 12 | (by & 0x3F) << 6 | by4 & 0x3F;
                if (UTF8_Decoder.isMalformed4(by2, by, by4) || !Surrogate.neededFor(n6)) {
                    return UTF8_Decoder.malformed(byteBuffer, n, charBuffer, n3, 4);
                }
                cArray[n3++] = Surrogate.high(n6);
                cArray[n3++] = Surrogate.low(n6);
                n += 4;
                continue;
            }
            return UTF8_Decoder.malformed(byteBuffer, n, charBuffer, n3, 1);
        }
        return UTF8_Decoder.xflow(byteBuffer, n, n2, charBuffer, n3, 0);
    }

    private CoderResult decodeBufferLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        int n = byteBuffer.position();
        int n2 = byteBuffer.limit();
        while (n < n2) {
            byte by;
            byte by2;
            byte by3 = byteBuffer.get();
            if (by3 >= 0) {
                if (charBuffer.remaining() < 1) {
                    return UTF8_Decoder.xflow(byteBuffer, n, 1);
                }
                charBuffer.put((char)by3);
                ++n;
                continue;
            }
            if (by3 >> 5 == -2) {
                if (n2 - n < 2 || charBuffer.remaining() < 1) {
                    return UTF8_Decoder.xflow(byteBuffer, n, 2);
                }
                by2 = byteBuffer.get();
                if (UTF8_Decoder.isMalformed2(by3, by2)) {
                    return UTF8_Decoder.malformed(byteBuffer, n, 2);
                }
                charBuffer.put((char)(by3 << 6 ^ by2 ^ 0xF80));
                n += 2;
                continue;
            }
            if (by3 >> 4 == -2) {
                if (n2 - n < 3 || charBuffer.remaining() < 1) {
                    return UTF8_Decoder.xflow(byteBuffer, n, 3);
                }
                by2 = byteBuffer.get();
                if (UTF8_Decoder.isMalformed3(by3, by2, by = byteBuffer.get())) {
                    return UTF8_Decoder.malformed(byteBuffer, n, 3);
                }
                charBuffer.put((char)(by3 << 12 ^ by2 << 6 ^ by ^ 0x1F80));
                n += 3;
                continue;
            }
            if (by3 >> 3 == -2) {
                if (n2 - n < 4 || charBuffer.remaining() < 2) {
                    return UTF8_Decoder.xflow(byteBuffer, n, 4);
                }
                by2 = byteBuffer.get();
                by = byteBuffer.get();
                byte by4 = byteBuffer.get();
                int n3 = (by3 & 7) << 18 | (by2 & 0x3F) << 12 | (by & 0x3F) << 6 | by4 & 0x3F;
                if (UTF8_Decoder.isMalformed4(by2, by, by4) || !Surrogate.neededFor(n3)) {
                    return UTF8_Decoder.malformed(byteBuffer, n, 4);
                }
                charBuffer.put(Surrogate.high(n3));
                charBuffer.put(Surrogate.low(n3));
                n += 4;
                continue;
            }
            return UTF8_Decoder.malformed(byteBuffer, n, 1);
        }
        return UTF8_Decoder.xflow(byteBuffer, n, 0);
    }

    @Override
    protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        CoderResult coderResult = null;
        Boolean bl = false;
        int n = charBuffer.position();
        if (byteBuffer.hasArray() && charBuffer.hasArray()) {
            bl = true;
            coderResult = this.decodeArrayLoop(byteBuffer, charBuffer);
        } else {
            bl = false;
            coderResult = this.decodeBufferLoop(byteBuffer, charBuffer);
        }
        if (this.bidiEnabled) {
            int n2;
            int n3;
            char[] cArray;
            int n4 = charBuffer.position();
            if (bl.booleanValue()) {
                cArray = charBuffer.array();
                n3 = charBuffer.arrayOffset() + n;
                n2 = charBuffer.arrayOffset() + n4;
            } else {
                n3 = 0;
                n2 = n4 - n;
                cArray = new char[n2];
                charBuffer.position(n);
                charBuffer.get(cArray);
                charBuffer.position(n4);
            }
            BidiConvert bidiConvert = new BidiConvert();
            if (bidiConvert.isBidiData(cArray, n3, n2, this.bidiParms, this.toString())) {
                cArray = bidiConvert.toUnicode(cArray, n3, n2, this.bidiParms, this.toString());
                if (bl.booleanValue()) {
                    System.arraycopy(cArray, 0, charBuffer.array(), charBuffer.arrayOffset() + n, cArray.length);
                } else {
                    charBuffer.position(n);
                    charBuffer.put(cArray);
                }
            }
        }
        return coderResult;
    }
}

