/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xml.xdm.dom;

import com.ibm.xtq.common.utils.SystemIDResolver;
import com.ibm.xtq.xml.xdm.XDMClassCache;
import com.ibm.xtq.xml.xdm.XDMCursor;
import com.ibm.xtq.xml.xdm.XDMCursor_SAXBuildable;
import com.ibm.xtq.xml.xdm.XDMManager;
import com.ibm.xtq.xml.xdm.XDMManagerFactory;
import com.ibm.xtq.xml.xdm.XDMWSFilter;
import com.ibm.xtq.xml.xdm.dom.XDMNodeAdapterEmpty;
import com.ibm.xtq.xml.xdm.dom.XDMNodeAdapterSingle;
import com.ibm.xtq.xml.xdm.ref.XDMCursorProxyCursor;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;

public class XDMManagerDOM
implements XDMManager {
    private XDMCursor _main = null;
    private XDMManagerFactory _managerFactory = null;

    public XDMManagerDOM() {
    }

    public XDMManagerDOM(XDMManagerFactory xDMManagerFactory) {
        this._managerFactory = xDMManagerFactory;
        this.init();
    }

    @Override
    public void init() {
        XDMCursorProxyCursor.EMPTY = this.createEmptyCursor();
    }

    @Override
    public XDMCursor getXDM(Source source, boolean bl, XDMWSFilter xDMWSFilter, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, XDMManagerFactory xDMManagerFactory, XDMClassCache xDMClassCache) {
        if (source instanceof DOMSource) {
            Node node = ((DOMSource)source).getNode();
            if (node == null) {
                try {
                    node = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    return null;
                }
            }
            XDMNodeAdapterSingle xDMNodeAdapterSingle = new XDMNodeAdapterSingle(xDMManagerFactory, node, xDMWSFilter, XDMManagerFactory.uniqueDocNumber());
            String string = source.getSystemId();
            try {
                if (string == null) {
                    string = "";
                }
                string = SystemIDResolver.getAbsoluteURI(string);
            }
            catch (Exception exception) {
                System.err.println("Can not absolutize URL: " + string);
            }
            xDMNodeAdapterSingle.setDocumentBaseURI(string);
            if (this._managerFactory == null) {
                this._managerFactory = xDMManagerFactory;
            }
            if (this._main == null) {
                this._main = xDMNodeAdapterSingle;
                this._managerFactory.addDocumentCursor(xDMNodeAdapterSingle);
            }
            return xDMNodeAdapterSingle;
        }
        return null;
    }

    @Override
    public XDMCursor getXDMCursorFromNode(Node node) {
        if (node.equals(this._main.getNode())) {
            return this._main;
        }
        boolean bl = false;
        XDMCursor xDMCursor = this._main.getAxisCursor(4);
        if (!xDMCursor.isEmpty()) {
            do {
                if (!xDMCursor.getNode().equals(node)) continue;
                bl = true;
                break;
            } while (xDMCursor.nextNode());
            if (bl) {
                return new XDMNodeAdapterSingle(this._managerFactory, node, null, XDMManagerFactory.uniqueDocNumber());
            }
        }
        return null;
    }

    @Override
    public XDMCursor createTextFragment(String string) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            DocumentFragment documentFragment = document.createDocumentFragment();
            documentFragment.appendChild(document.createTextNode(string));
            return this._managerFactory.getXDM(new DOMSource(documentFragment), true, null, false, false, false, false);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public XDMCursor createEmptyCursor() {
        return new XDMNodeAdapterEmpty(this._managerFactory);
    }

    @Override
    public boolean release(XDMCursor xDMCursor, boolean bl) {
        return false;
    }

    @Override
    public XDMCursor_SAXBuildable getGlobalRTFXDMCursor() {
        return null;
    }

    @Override
    public void popRTFContext() {
    }

    @Override
    public void pushRTFContext() {
    }

    @Override
    public XDMCursor_SAXBuildable getRTFXDMCursor() {
        return null;
    }

    @Override
    public void setManagerFactory(XDMManagerFactory xDMManagerFactory) {
        this._managerFactory = xDMManagerFactory;
    }
}

