/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem;

import com.ibm.xylem.AbstractTypeStore;
import com.ibm.xylem.Binding;
import com.ibm.xylem.Function;
import com.ibm.xylem.FunctionSignature;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.Module;
import com.ibm.xylem.Optimizer;
import com.ibm.xylem.Type;
import com.ibm.xylem.TypeCheckException;
import com.ibm.xylem.instructions.LambdaInstruction;
import com.ibm.xylem.instructions.LetInstruction;
import com.ibm.xylem.types.AbstractDataType;
import com.ibm.xylem.types.AbstractDataTypeLambda;
import com.ibm.xylem.types.ConstructorDataType;
import com.ibm.xylem.types.NamedType;
import com.ibm.xylem.utils.XylemError;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;

public class BaseDesugarer
extends Optimizer {
    protected Module m_prog;

    public BaseDesugarer(Module module) {
        this.m_prog = module;
    }

    protected void convertADTs() {
        boolean bl;
        HashSet<AbstractDataType> hashSet = new HashSet<AbstractDataType>();
        do {
            Iterator iterator = new ArrayList(this.m_prog.getAbstractDataTypes()).iterator();
            bl = false;
            while (iterator.hasNext()) {
                AbstractDataType abstractDataType = (AbstractDataType)iterator.next();
                if (hashSet.contains(abstractDataType)) continue;
                for (int i = 0; i < abstractDataType.m_constructors.length; ++i) {
                    AbstractDataType.Constructor constructor = abstractDataType.m_constructors[i];
                    for (int j = 0; j < constructor.m_parameters.length; ++j) {
                        Binding binding = constructor.m_parameters[j];
                        binding.setType(this.convertType(binding.getBindingType()));
                    }
                }
                hashSet.add(abstractDataType);
                bl = true;
            }
        } while (bl);
    }

    protected void convertFunctionSignatures() {
        Iterator iterator = this.m_prog.m_functions.values().iterator();
        while (iterator.hasNext()) {
            Function function;
            this.m_currentFunction = function = (Function)iterator.next();
            FunctionSignature functionSignature = this.m_prog.getFunctionSignature(this.m_currentFunction.getName());
            for (int i = 0; i < function.m_parameters.length; ++i) {
                Binding binding = function.m_parameters[i];
                Type type = this.convertType(binding.getBindingType());
                binding.setType(type);
                if (functionSignature == null) continue;
                functionSignature.setParameterType(i, type);
            }
            function.setReturnType(this.convertType(function.getReturnType()));
            if (functionSignature != null) {
                functionSignature.m_returnType = function.getReturnType();
            }
            this.m_currentFunction = null;
        }
    }

    public void desugar() {
        this.convertADTs();
        this.convertFunctionSignatures();
        this.m_prog.optimize(this);
        this.m_prog.clearTypeInformation(true);
        try {
            this.m_prog.typeCheckReduced();
        }
        catch (TypeCheckException typeCheckException) {
            typeCheckException.printStackTrace();
        }
    }

    public static String generateTypeName(Type[] typeArray, String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = 0; i < typeArray.length; ++i) {
            stringBuffer.append("_");
            stringBuffer.append(typeArray[i].toString());
        }
        return stringBuffer.toString().replace('[', 'Z').replace(']', 'Z').replace('.', '_').replace(' ', '_').replace('-', '_').replace('>', '_').replace('(', 'Z').replace(')', 'Z').replace(',', '_').replace('/', '_');
    }

    public static Type generateType(Module module, Type[] typeArray, String string) {
        String string2 = BaseDesugarer.generateTypeName(typeArray, string);
        AbstractDataType abstractDataType = (AbstractDataType)module.lookupCompoundType(string2);
        if (abstractDataType == null) {
            Binding[] bindingArray = new Binding[typeArray.length];
            for (int i = 0; i < typeArray.length; ++i) {
                bindingArray[i] = new Binding((Object)("x" + i), typeArray[i]);
            }
            AbstractDataType.Constructor constructor = new AbstractDataType.Constructor(string2, bindingArray);
            abstractDataType = new ConstructorDataType(string2, new AbstractDataType.Constructor[]{constructor});
            module.addAbstractDataType(abstractDataType);
        }
        return new NamedType(abstractDataType.getName());
    }

    public static Type generateUnionType(Module module, Type[] typeArray, String string) {
        String string2 = BaseDesugarer.generateTypeName(typeArray, string);
        AbstractDataType abstractDataType = (AbstractDataType)module.lookupCompoundType(string2);
        if (abstractDataType != null) {
            return new NamedType(abstractDataType.getName());
        }
        AbstractDataType.Constructor[] constructorArray = new AbstractDataType.Constructor[typeArray.length];
        for (int i = 0; i < typeArray.length; ++i) {
            Binding binding = new Binding((Object)("x" + i), typeArray[i]);
            constructorArray[i] = new AbstractDataType.Constructor(string2 + "_" + i, new Binding[]{binding});
        }
        abstractDataType = new ConstructorDataType(string2, constructorArray);
        module.addAbstractDataType(abstractDataType);
        return new NamedType(abstractDataType.getName());
    }

    public Type[] convertTypes(Type[] typeArray) {
        Type[] typeArray2 = new Type[typeArray.length];
        for (int i = 0; i < typeArray.length; ++i) {
            typeArray2[i] = this.convertType(typeArray[i]);
        }
        return typeArray2;
    }

    public Type convertType(Type type) {
        Type type2;
        if (type == null) {
            throw new RuntimeException();
        }
        Type type3 = type2 = this.getCurrentFunction() == null ? type : type.resolveType(this.getCurrentFunction().getTypeEnvironment());
        if (type2 instanceof NamedType) {
            Module module;
            AbstractDataTypeLambda abstractDataTypeLambda;
            NamedType namedType = (NamedType)type2;
            if (namedType.getTypeParameters() != null && (abstractDataTypeLambda = ((AbstractTypeStore)(module = this.m_prog)).getGenericADT(namedType.getName())) != null) {
                return abstractDataTypeLambda.applyADT(module, this.convertTypes(namedType.getTypeParameters())).getNamedType();
            }
            return type2;
        }
        if (type2 == null) {
            int n = 0;
            ++n;
            String string = "Couldn't figure out a type in function " + this.m_currentFunction.getName();
            throw new XylemError("ERR_SYSTEM", string);
        }
        int n = type2.getChildTypeCount();
        for (int i = 0; i < n; ++i) {
            type2.setChildType(i, this.convertType(type2.getChildType(i)));
        }
        return type2;
    }

    @Override
    public Instruction optimize(Instruction instruction) {
        Instruction instruction2;
        if (!(instruction instanceof LetInstruction)) {
            this.optimizeChildren(instruction);
        }
        if ((instruction2 = this.optimizeStep(instruction, null, -1)) == null) {
            return instruction;
        }
        return instruction2;
    }

    @Override
    protected void optimizeChildren(Instruction instruction) {
        if (instruction instanceof LetInstruction) {
            this.optimizeStep(instruction, null, -1);
        } else {
            int n = instruction.getChildInstructionCount();
            for (int i = 0; i < n; ++i) {
                Instruction instruction2;
                Instruction instruction3 = instruction.getChildInstruction(i);
                this.optimizeChildren(instruction3);
                if (instruction3 instanceof LetInstruction || (instruction2 = this.optimizeStep(instruction3, instruction, i)) == null || instruction2 == instruction3) continue;
                instruction.setChildInstruction(i, instruction2);
                instruction3.m_bindingEnvironment = null;
            }
        }
    }

    @Override
    protected Instruction optimizeStep(Instruction instruction, Instruction instruction2, int n) {
        Instruction instruction3;
        if (!(instruction instanceof LetInstruction)) {
            return this.optimizeStep2(instruction);
        }
        Instruction instruction4 = null;
        LetInstruction letInstruction = (LetInstruction)instruction;
        while (true) {
            Instruction instruction5 = letInstruction.getValue();
            this.optimizeChildren(instruction5);
            Instruction instruction6 = this.optimizeStep2(instruction5);
            letInstruction.setValue(instruction6);
            instruction3 = letInstruction.getBody();
            if (!(instruction3 instanceof LetInstruction)) break;
            instruction2 = letInstruction;
            n = 1;
            letInstruction = (LetInstruction)instruction3;
        }
        this.optimizeChildren(instruction3);
        letInstruction.setBody(this.optimizeStep2(instruction3));
        return instruction4;
    }

    public Instruction optimizeStep2(Instruction instruction) {
        if (instruction instanceof LambdaInstruction) {
            LambdaInstruction lambdaInstruction = (LambdaInstruction)instruction;
            Binding[] bindingArray = (Binding[])lambdaInstruction.getChildInstructionBindings(0);
            int n = bindingArray.length;
            for (int i = 0; i < n; ++i) {
                bindingArray[i].setType(this.convertType(bindingArray[i].getBindingType()));
            }
        } else {
            int n = instruction.getTypeParameterCount();
            for (int i = 0; i < n; ++i) {
                if (instruction.getTypeParameter(i) == null) {
                    System.out.println("Instruction " + instruction + " parameter " + i + " (" + instruction.getChildInstruction(i) + ") is null");
                    throw new RuntimeException();
                }
                instruction.setTypeParameter(i, this.convertType(instruction.getTypeParameter(i)));
            }
        }
        return instruction;
    }

    public static void main(String[] stringArray) {
        Module module = new Module(stringArray[0], null);
        BaseDesugarer baseDesugarer = new BaseDesugarer(module);
        baseDesugarer.desugar();
    }
}

