/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.annot;

import com.ibm.xylem.BindingEnvironment;
import com.ibm.xylem.Function;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.Logger;
import com.ibm.xylem.NavigationUtilities;
import com.ibm.xylem.TypeEnvironment;
import com.ibm.xylem.annot.AnnotationTable;
import com.ibm.xylem.annot.IAnnotation;
import com.ibm.xylem.annot.IFunctionAnnotationInfo;
import com.ibm.xylem.annot.NullAnnotation;
import com.ibm.xylem.instructions.IdentifierInstruction;
import com.ibm.xylem.instructions.LiteralInstruction;
import com.ibm.xylem.utils.XylemError;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class AnnotationEnvironment {
    public static final Logger s_logger = Logger.getInstance(AnnotationEnvironment.class);
    private AnnotationTable m_table;
    private HashMap m_env = new HashMap();
    private HashMap m_literals = new HashMap();
    private HashMap m_infos = new HashMap();
    private boolean m_hasAnnotations = false;
    private IFunctionAnnotationInfo m_functionInfo;

    public AnnotationEnvironment(AnnotationTable annotationTable) {
        this.m_table = annotationTable;
    }

    public Function getEnclosingFunction() {
        return this.m_functionInfo.getEnclosingFunction();
    }

    public TypeEnvironment getTypeEnvironment() {
        return this.getEnclosingFunction().getTypeEnvironment();
    }

    public BindingEnvironment getBindingEnvironment() {
        return this.getEnclosingFunction().getBindingEnvironment();
    }

    public AnnotationTable getTable() {
        return this.m_table;
    }

    public boolean hasAnnotations() {
        return this.m_hasAnnotations;
    }

    public IAnnotation get(Object object) {
        return (IAnnotation)this.m_env.get(object);
    }

    public IAnnotation[] get(Instruction[] instructionArray) {
        IAnnotation[] iAnnotationArray = new IAnnotation[instructionArray.length];
        for (int i = 0; i < instructionArray.length; ++i) {
            iAnnotationArray[i] = this.get(instructionArray[i]);
        }
        return iAnnotationArray;
    }

    public IAnnotation[] get(Object[] objectArray) {
        IAnnotation[] iAnnotationArray = new IAnnotation[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            iAnnotationArray[i] = this.get(objectArray[i]);
        }
        return iAnnotationArray;
    }

    public IAnnotation get(Instruction instruction) {
        if (instruction instanceof LiteralInstruction) {
            return this.m_table.getAnnotator().analyzeExpression(this, instruction, null);
        }
        if (!(instruction instanceof IdentifierInstruction)) {
            throw new XylemError("ERR_SYSTEM", "Annnotations may only be bound to reduced code");
        }
        return this.get(((IdentifierInstruction)instruction).getVariable());
    }

    public void setAlias(Object object, IdentifierInstruction identifierInstruction) {
        this.setAlias(object, identifierInstruction.getVariable());
    }

    public void setAlias(Object object, Object object2) {
        if (this.m_env.containsKey(object)) {
            throw new XylemError("ERR_SYSTEM", "Can't alias '" + object + "' to '" + object2 + "' " + "because '" + object + "' is already bound (to " + this.m_env.get(object) + ").");
        }
        if (!this.m_env.containsKey(object2)) {
            throw new XylemError("ERR_SYSTEM", "Can't alias '" + object + "' to '" + object2 + "' because '" + object2 + "' is not bound.");
        }
        IAnnotation iAnnotation = this.get(object2);
        this.m_env.put(object, iAnnotation);
        s_logger.debug("alias(" + object + ")=>" + object2);
    }

    public void set(Object object, IAnnotation iAnnotation) {
        IAnnotation iAnnotation2;
        if (iAnnotation != null && !(iAnnotation instanceof NullAnnotation)) {
            this.m_hasAnnotations = true;
            iAnnotation.setVariable(object);
        }
        if ((iAnnotation2 = this.m_env.put(object, iAnnotation)) != null) {
            this.m_env.put(object, iAnnotation2);
            throw new XylemError("ERR_SYSTEM", "Annotation for '" + object + "' is already bound to '" + iAnnotation2 + "'");
        }
        s_logger.debug("annot(" + object + ")=>" + iAnnotation);
    }

    public void setComputedLiteral(Instruction instruction, Object object) {
        HashSet<Object> hashSet;
        if (instruction instanceof IdentifierInstruction) {
            instruction = NavigationUtilities.resolveReducedIdentifier(instruction, this.getBindingEnvironment());
        }
        if ((hashSet = (HashSet<Object>)this.m_literals.get(instruction)) == null) {
            hashSet = new HashSet<Object>();
            this.m_literals.put(instruction, hashSet);
        }
        hashSet.add(object);
    }

    public Set getComputedLiteral(Instruction instruction) {
        if (instruction instanceof LiteralInstruction) {
            return Collections.singleton(((LiteralInstruction)instruction).getValue());
        }
        if (!(instruction instanceof IdentifierInstruction)) {
            throw new XylemError("ERR_SYSTEM", "Literals may only be resolved against reduced code");
        }
        instruction = NavigationUtilities.resolveReducedIdentifier(instruction, this.getBindingEnvironment());
        return (Set)this.m_literals.get(instruction);
    }

    public void setFunctionInfo(IFunctionAnnotationInfo iFunctionAnnotationInfo) {
        this.m_functionInfo = iFunctionAnnotationInfo;
    }

    public IFunctionAnnotationInfo getFunctionInfo() {
        return this.m_functionInfo;
    }

    public void addInfo(Object object, Object object2, Object object3) {
        Object object4;
        HashMap<Object, Object> hashMap = (HashMap<Object, Object>)this.m_infos.get(object);
        if (hashMap == null) {
            hashMap = new HashMap<Object, Object>();
            this.m_infos.put(object, hashMap);
        }
        if ((object4 = hashMap.put(object2, object3)) != null) {
            // empty if block
        }
    }

    public Object getInfo(Object object, Object object2) {
        Map map = (Map)this.m_infos.get(object);
        if (map == null) {
            return null;
        }
        return map.get(object2);
    }

    public void debug() {
        if (!s_logger.isDebugEnabled()) {
            return;
        }
        s_logger.debug("ENVIRONMENT:");
        for (Object k : this.m_env.keySet()) {
            s_logger.debug("  " + k + " => " + this.m_env.get(k));
        }
    }
}

