/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.annot;

import com.ibm.xylem.Logger;
import com.ibm.xylem.annot.IAnnotation;
import com.ibm.xylem.annot.ICallSpec;
import com.ibm.xylem.annot.IFunctionAnnotationInfo;
import com.ibm.xylem.utils.XylemError;
import java.util.List;

public class FunctionCallStackItem {
    static final Logger s_logger = Logger.getInstance(FunctionCallStackItem.class);
    private ICallSpec m_fcs;
    private IFunctionAnnotationInfo m_fai;

    public FunctionCallStackItem(ICallSpec iCallSpec, IFunctionAnnotationInfo iFunctionAnnotationInfo) {
        this.m_fai = iFunctionAnnotationInfo;
        this.m_fcs = iCallSpec;
    }

    public String toString() {
        return "FCSI:" + this.m_fai;
    }

    public ICallSpec getCallSpec() {
        return this.m_fcs;
    }

    public IFunctionAnnotationInfo getFunctionInfo() {
        return this.m_fai;
    }

    public static boolean backpatchFunctionCalls(List list) {
        FunctionCallStackItem functionCallStackItem;
        int n;
        boolean bl = false;
        FunctionCallStackItem functionCallStackItem2 = (FunctionCallStackItem)list.get(list.size() - 1);
        if (list.size() == 1) {
            functionCallStackItem2.m_fai.setComplete();
            s_logger.debug("backpatched call " + functionCallStackItem2.m_fai.getFunctionName() + " (non-recursive)");
            return bl |= functionCallStackItem2.backpatchFunctionCall();
        }
        if (!functionCallStackItem2.m_fai.equals(((FunctionCallStackItem)list.get((int)0)).m_fai)) {
            throw new XylemError("ERR_SYSTEM", "FCSI looks corrupt (or not ready), top and bottom don't match!\ntop:   " + functionCallStackItem2.m_fai + "\n" + "bottom:" + functionCallStackItem2.m_fai + "\n");
        }
        int n2 = list.size() * 2 + 2;
        int n3 = 0;
        boolean bl2 = false;
        do {
            bl2 = false;
            if (n3++ > n2) {
                throw new Error("recursion won't resolve (" + functionCallStackItem2 + ") limit = " + n2);
            }
            for (n = list.size() - 1; n >= 0; --n) {
                functionCallStackItem = (FunctionCallStackItem)list.get(n);
                if (!functionCallStackItem.backpatchFunctionCall()) continue;
                s_logger.debug("recursive backpatch caused changes.");
                bl2 = true;
                bl = true;
            }
            s_logger.debug("backpatched call stack " + functionCallStackItem2.m_fai.getFunctionName() + " depth=" + list.size() + " (trial " + n3 + ")");
        } while (bl2);
        for (n = list.size() - 1; n >= 0; --n) {
            functionCallStackItem = (FunctionCallStackItem)list.get(n);
            functionCallStackItem.m_fai.setComplete();
        }
        return bl;
    }

    private boolean backpatchFunctionCall() {
        int n = this.m_fcs.getParamAnnotations().length;
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            if (this.m_fai.getParamAnnotations()[i] != null) {
                IAnnotation iAnnotation = this.m_fcs.getParamAnnotations()[i];
                IAnnotation iAnnotation2 = this.m_fai.getParamAnnotations()[i];
                if (iAnnotation2 != null) {
                    s_logger.debug(" backpatching '" + iAnnotation.getVariable() + "' calls '" + iAnnotation2.getVariable() + "' " + "in " + this.m_fai.getFunctionName() + " call=" + iAnnotation + " param=" + iAnnotation2);
                    if (!iAnnotation.propagateDependancies(iAnnotation2)) continue;
                    bl = true;
                    s_logger.debug(" there were changes");
                    if (!iAnnotation.propagateDependancies(iAnnotation2)) continue;
                    throw new Error("non-stabilizing propagation " + iAnnotation2);
                }
                s_logger.error(" no annotations to backpatch for param " + i + "'.");
                continue;
            }
            s_logger.debug(" not backpatching '" + this.m_fcs.getParamBindings()[i].getName() + "'" + "in " + this.m_fai.getFunctionName());
        }
        return bl;
    }
}

