/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.instructions;

import com.ibm.xtq.bcel.generic.InstructionHandle;
import com.ibm.xylem.BindingEnvironment;
import com.ibm.xylem.Function;
import com.ibm.xylem.IDebuggerInterceptor;
import com.ibm.xylem.IMatchDestructable;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.PrettyPrinter;
import com.ibm.xylem.ReadObjectFileHelper;
import com.ibm.xylem.ReductionHelper;
import com.ibm.xylem.Type;
import com.ibm.xylem.TypeCheckException;
import com.ibm.xylem.TypeEnvironment;
import com.ibm.xylem.WriteObjectFileHelper;
import com.ibm.xylem.codegen.CodeGenerationTracker;
import com.ibm.xylem.codegen.DataFlowCodeGenerationHelper;
import com.ibm.xylem.codegen.bcel.BCELCodeGenerationHelper;
import com.ibm.xylem.codegen.bcel.InstructionListBuilder;
import com.ibm.xylem.instructions.ChooseInstruction;
import com.ibm.xylem.instructions.IdentifierInstruction;
import com.ibm.xylem.instructions.LetInstruction;
import com.ibm.xylem.instructions.PrimitiveEqualityInstruction;
import com.ibm.xylem.interpreter.Debugger;
import com.ibm.xylem.interpreter.Environment;
import com.ibm.xylem.types.BooleanType;
import com.ibm.xylem.types.CharType;
import com.ibm.xylem.types.DecimalType;
import com.ibm.xylem.types.DoubleType;
import com.ibm.xylem.types.FloatType;
import com.ibm.xylem.types.INumericalType;
import com.ibm.xylem.types.IntType;
import com.ibm.xylem.types.LongType;
import com.ibm.xylem.types.NullableType;
import com.ibm.xylem.types.ShortType;
import com.ibm.xylem.types.UnitType;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.LinkedList;

public final class LiteralInstruction
extends Instruction
implements IMatchDestructable {
    protected Object m_value;
    protected Type m_type;

    public LiteralInstruction() {
    }

    @Override
    public int hashCode() {
        return this.m_value == null ? 0 : this.m_value.hashCode();
    }

    public LiteralInstruction(Type type, Object object) {
        this.setCachedType(type);
        this.m_value = object;
        this.m_type = type;
    }

    public Object getValue() {
        return this.m_value;
    }

    public Type getType() {
        return this.m_type;
    }

    @Override
    public Type getType(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        return this.m_type;
    }

    @Override
    public Type typeCheck(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) throws TypeCheckException {
        this.m_bindingEnvironment = null;
        this.m_hasBeenTypechecked = true;
        return this.m_type;
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        LiteralInstruction literalInstruction = (LiteralInstruction)object;
        if (!literalInstruction.m_type.equals(this.m_type)) {
            return false;
        }
        if (this.m_value == null) {
            return literalInstruction.m_value == null;
        }
        return this.m_value.equals(literalInstruction.m_value);
    }

    @Override
    public Type getTypeParameter(int n) {
        if (n == 0) {
            return this.m_type;
        }
        return null;
    }

    @Override
    public int getTypeParameterCount() {
        return 1;
    }

    @Override
    public void setTypeParameter(int n, Type type) {
        if (n == 0) {
            this.m_type = type;
        }
    }

    public static final LiteralInstruction numberLiteral(String string) {
        return string.endsWith("f") ? LiteralInstruction.floatLiteral(Float.parseFloat(string.substring(0, string.length() - 1))) : (string.endsWith("d") ? LiteralInstruction.doubleLiteral(Double.parseDouble(string.substring(0, string.length() - 1))) : (string.endsWith("l") ? LiteralInstruction.longLiteral(Long.parseLong(string.substring(0, string.length() - 1))) : (string.indexOf(46) == -1 ? LiteralInstruction.integerLiteral(Integer.parseInt(string)) : LiteralInstruction.doubleLiteral(Double.parseDouble(string)))));
    }

    public static final LiteralInstruction integerLiteral(int n) {
        return new LiteralInstruction(IntType.s_intType, new Integer(n));
    }

    public static final LiteralInstruction longLiteral(long l) {
        return new LiteralInstruction(LongType.s_longType, new Long(l));
    }

    public static final LiteralInstruction shortLiteral(long l) {
        return new LiteralInstruction(ShortType.s_shortType, new Long(l));
    }

    public static final LiteralInstruction doubleLiteral(double d) {
        return new LiteralInstruction(DoubleType.s_doubleType, new Double(d));
    }

    public static final LiteralInstruction floatLiteral(float f) {
        return new LiteralInstruction(FloatType.s_floatType, new Float(f));
    }

    public static final LiteralInstruction charLiteral(char c) {
        return new LiteralInstruction(CharType.s_charType, new Character(c));
    }

    public static final LiteralInstruction booleanTrueLiteral() {
        return new LiteralInstruction(BooleanType.s_booleanType, Boolean.TRUE);
    }

    public static final LiteralInstruction unitLiteral() {
        return new LiteralInstruction(UnitType.s_unitType, new Integer(0));
    }

    public static final LiteralInstruction booleanLiteral(boolean bl) {
        return bl ? LiteralInstruction.booleanTrueLiteral() : LiteralInstruction.booleanFalseLiteral();
    }

    public static final LiteralInstruction booleanFalseLiteral() {
        return new LiteralInstruction(BooleanType.s_booleanType, Boolean.FALSE);
    }

    public static final LiteralInstruction decimalLiteral(BigDecimal bigDecimal) {
        return new LiteralInstruction(DecimalType.s_decimalType, bigDecimal);
    }

    public static final LiteralInstruction nullLiteral(Type type) {
        if (type == null || !type.isFullySpecified()) {
            throw new Error("Dead literal must be fully typed, but got " + type);
        }
        return new LiteralInstruction(type, null);
    }

    public static final LiteralInstruction nullableLiteral(Type type) {
        if (type == null || !type.isFullySpecified()) {
            throw new Error("Dead literal must be fully typed, but got " + type);
        }
        return new LiteralInstruction(new NullableType(type), null);
    }

    public static final String generateValueForArray(Type type, LiteralInstruction[] literalInstructionArray, DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper) {
        String string = "new " + type + "[] {";
        for (int i = 0; i < literalInstructionArray.length; ++i) {
            if (0 != i) {
                string = string + ", ";
            }
            string = string + literalInstructionArray[i].generateValue(dataFlowCodeGenerationHelper);
        }
        string = string + "}";
        return string;
    }

    @Override
    public void generateCode(BCELCodeGenerationHelper bCELCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, String string, InstructionHandle instructionHandle, InstructionListBuilder instructionListBuilder) {
        instructionListBuilder.appendConstant(this.m_value);
    }

    public String generateValue(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper) {
        if (this.m_value == null) {
            if (this.m_type instanceof INumericalType) {
                return "((" + this.m_type + ") 0)";
            }
            if (this.m_type instanceof BooleanType) {
                return "(false)";
            }
            if (this.m_type instanceof UnitType) {
                return "0";
            }
            if (dataFlowCodeGenerationHelper.isTargetCPP()) {
                return "((" + (dataFlowCodeGenerationHelper == null ? this.m_type.toString() : this.m_type.getImplementationName(dataFlowCodeGenerationHelper)) + ") NULL)";
            }
            return "((" + (dataFlowCodeGenerationHelper == null ? this.m_type.toString() : this.m_type.getImplementationName(dataFlowCodeGenerationHelper)) + ") null)";
        }
        if (this.m_value.equals(new Double(Double.NaN))) {
            return "Double.NaN";
        }
        if (this.m_value.equals(new Float(Float.NaN))) {
            return "Float.NaN";
        }
        if (this.m_value.equals(new Float(Float.NEGATIVE_INFINITY))) {
            return "Float.NEGATIVE_INFINITY";
        }
        if (this.m_value.equals(new Float(Float.POSITIVE_INFINITY))) {
            return "Float.POSITIVE_INFINITY";
        }
        if (this.m_value.equals(new Double(Double.NEGATIVE_INFINITY))) {
            return "Double.NEGATIVE_INFINITY";
        }
        if (this.m_value.equals(new Double(Double.POSITIVE_INFINITY))) {
            return "Double.POSITIVE_INFINITY";
        }
        if (this.m_value instanceof Character) {
            return "'" + LiteralInstruction.escape(this.m_value.toString()) + "'";
        }
        if (this.m_type.equals(DecimalType.s_decimalType)) {
            return "new java.math.BigDecimal(\"" + this.m_value.toString() + "\")";
        }
        if (this.m_type.equals(LongType.s_longType)) {
            long l = (Long)this.m_value;
            if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
                return "0x" + Long.toHexString(l) + "L";
            }
            return this.m_value.toString();
        }
        if (this.m_type.equals(ShortType.s_shortType)) {
            return "((short)" + this.m_value.toString() + ")";
        }
        return this.m_value.toString();
    }

    public static final Integer getInteger(Instruction instruction) {
        if (!(instruction instanceof LiteralInstruction)) {
            return null;
        }
        Object object = ((LiteralInstruction)instruction).getValue();
        if (!(object instanceof Integer)) {
            return null;
        }
        return (Integer)object;
    }

    @Override
    public boolean isStatic(BindingEnvironment bindingEnvironment) {
        return true;
    }

    public static String escape(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        block8: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\n': {
                    stringBuffer.append("\\n");
                    continue block8;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    continue block8;
                }
                case '\\': {
                    stringBuffer.append("\\\\");
                    continue block8;
                }
                case '\'': {
                    stringBuffer.append("\\'");
                    continue block8;
                }
                case '\"': {
                    stringBuffer.append("\\\"");
                    continue block8;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    continue block8;
                }
                default: {
                    if (c >= '\u0080') {
                        stringBuffer.append("\\u");
                        String string2 = Integer.toHexString(c);
                        stringBuffer.append("000".substring(string2.length() - 1));
                        stringBuffer.append(string2);
                        continue block8;
                    }
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    @Override
    public String generateCodeBasedOnDataFlow(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, String string, boolean bl) {
        return this.generateValue(dataFlowCodeGenerationHelper);
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        return this;
    }

    @Override
    public Instruction cloneShallow() {
        return this;
    }

    public boolean isReducedExpression() {
        return true;
    }

    @Override
    public void generateReducedForm(ReductionHelper reductionHelper, Instruction[] instructionArray, BindingEnvironment bindingEnvironment) {
        instructionArray[0] = this;
    }

    @Override
    public void toString(PrettyPrinter prettyPrinter, int n) {
        String string = this.m_value == null ? (this.m_type instanceof INumericalType ? "((" + this.m_type + ") 0)" : (this.m_type instanceof BooleanType ? "(false)" : "(java-null " + this.m_type.prettyPrint() + ")")) : (this.m_value.equals(new Double(Double.NaN)) ? "Double.NaN" : (this.m_value.equals(new Float(Float.NaN)) ? "Float.NaN" : (this.m_value.equals(new Float(Float.NEGATIVE_INFINITY)) ? "Float.NEGATIVE_INFINITY" : (this.m_value.equals(new Float(Float.POSITIVE_INFINITY)) ? "Float.POSITIVE_INFINITY" : (this.m_value.equals(new Double(Double.NEGATIVE_INFINITY)) ? "Double.NEGATIVE_INFINITY" : (this.m_value.equals(new Double(Double.POSITIVE_INFINITY)) ? "Double.POSITIVE_INFINITY" : (this.m_type instanceof UnitType ? "unit" : (this.m_value instanceof Character ? "'" + LiteralInstruction.escape(this.m_value.toString()) + "'" : (this.m_type.equals(DecimalType.s_decimalType) ? "new java.math.BigDecimal(\"" + this.m_value.toString() + "\")" : this.m_value.toString())))))))));
        prettyPrinter.printToken(string, n);
    }

    @Override
    public Object evaluate(Environment environment, Function function, IDebuggerInterceptor iDebuggerInterceptor, boolean bl) {
        if (null != iDebuggerInterceptor && iDebuggerInterceptor.getVerbosityLevel() == 0) {
            iDebuggerInterceptor.enter(this, environment, function);
        }
        Object object = this.m_value;
        if (null != iDebuggerInterceptor && iDebuggerInterceptor.getVerbosityLevel() == 0) {
            return Debugger.leave(iDebuggerInterceptor, this, environment, function, object);
        }
        return object;
    }

    @Override
    public void read(ReadObjectFileHelper readObjectFileHelper, BindingEnvironment bindingEnvironment) throws Exception {
        super.read(readObjectFileHelper, bindingEnvironment);
        this.m_type = readObjectFileHelper.readType();
        this.m_value = readObjectFileHelper.readObject();
        this.setCachedType(this.m_type);
    }

    @Override
    public void write(WriteObjectFileHelper writeObjectFileHelper) throws IOException {
        super.write(writeObjectFileHelper);
        writeObjectFileHelper.writeType(this.m_type);
        writeObjectFileHelper.writeObject(this.m_value);
    }

    @Override
    public Type typeCheckDestruction(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) throws TypeCheckException {
        return this.m_type;
    }

    @Override
    public Instruction desugarDestruction(Instruction instruction, ReductionHelper reductionHelper, IMatchDestructable.Generator generator, IMatchDestructable.Generator generator2, BindingEnvironment bindingEnvironment) {
        Object object = reductionHelper.generateReducedIdentifier("");
        LetInstruction letInstruction = new LetInstruction(object, new PrimitiveEqualityInstruction(instruction, this), new ChooseInstruction(new IdentifierInstruction(object), generator.generate(), generator2.generate()));
        return letInstruction;
    }

    @Override
    public Instruction cloneReduced() {
        return this;
    }

    @Override
    public void typeCheckReduced(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) {
    }

    public static class KnownValue {
        Object m_literalValue = null;
        Object[] m_literalArray = null;

        public KnownValue(Object object) {
            this.m_literalValue = object;
        }

        public KnownValue(LiteralInstruction literalInstruction) {
            this.m_literalValue = literalInstruction.getValue();
        }

        public KnownValue(Object[] objectArray) {
            this.m_literalArray = objectArray;
        }

        public KnownValue(LiteralInstruction[] literalInstructionArray) {
            this.m_literalArray = new Object[literalInstructionArray.length];
            for (int i = 0; i < literalInstructionArray.length; ++i) {
                this.m_literalArray[i] = literalInstructionArray[i].getValue();
            }
        }

        public boolean equals(Object object) {
            if (!(object instanceof KnownValue)) {
                return false;
            }
            KnownValue knownValue = (KnownValue)object;
            if (null == this.m_literalValue) {
                if (null != knownValue.m_literalValue) {
                    return false;
                }
                if (this.m_literalArray.length != knownValue.m_literalArray.length) {
                    return false;
                }
                for (int i = 0; i < this.m_literalArray.length; ++i) {
                    if (this.m_literalArray[i].equals(knownValue.m_literalArray[i])) continue;
                    return false;
                }
                return true;
            }
            if (null == knownValue.m_literalValue) {
                return false;
            }
            return this.m_literalValue.equals(knownValue.m_literalValue);
        }

        public String getStringValue() {
            if (this.m_literalArray != null) {
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < this.m_literalArray.length; ++i) {
                    Object object = this.m_literalArray[i];
                    if (!(object instanceof Character)) {
                        return null;
                    }
                    stringBuffer.append(((Character)object).charValue());
                }
                return stringBuffer.toString();
            }
            return null;
        }
    }
}

