/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.jaxp.datatype;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConstants;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.xerces.jaxp.datatype.AbstractDurationImpl;
import org.apache.xerces.jaxp.datatype.DurationImpl;
import org.apache.xerces.jaxp.datatype.LightweightDurationImpl;
import org.apache.xerces.jaxp.datatype.XMLGregorianCalendarImpl;

public class DatatypeFactoryImpl
extends DatatypeFactory {
    private static final int SECOND = 1000;
    private static final int MINUTE = 60000;
    private static final int HOUR = 3600000;
    private static final long DAY = 86400000L;
    private static final int YEAR_100 = 36524;
    private static final int YEAR_400 = 146097;
    private static final int[] MONTHS = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334};
    private static final int[] MONTHS_LEAP = new int[]{0, MONTHS[1], MONTHS[2] + 1, MONTHS[3] + 1, MONTHS[4] + 1, MONTHS[5] + 1, MONTHS[6] + 1, MONTHS[7] + 1, MONTHS[8] + 1, MONTHS[9] + 1, MONTHS[10] + 1, MONTHS[11] + 1};
    private static final int[] MONTHS_N = new int[]{0, 31, 61, 92, 122, 153, 184, 214, 245, 275, 306, 334};
    private static final int[] MONTHS_N_LEAP = new int[]{0, MONTHS_N[1], MONTHS_N[2], MONTHS_N[3], MONTHS_N[4], MONTHS_N[5], MONTHS_N[6], MONTHS_N[7], MONTHS_N[8], MONTHS_N[9], MONTHS_N[10], MONTHS_N[11] + 1};

    public Duration newDuration(String string) {
        return AbstractDurationImpl.newDuration(string, DatatypeConstants.DURATION);
    }

    public Duration newDuration(long l) {
        return this.newDurationInternal(l, true);
    }

    public Duration newDuration(boolean bl, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigDecimal bigDecimal) {
        return new DurationImpl(bl, bigInteger, bigInteger2, bigInteger3, bigInteger4, bigInteger5, bigDecimal);
    }

    public Duration newDuration(boolean bl, int n, int n2, int n3, int n4, int n5, int n6) {
        return new LightweightDurationImpl(bl, n, n2, n3, n4, n5, n6);
    }

    public Duration newDurationDayTime(long l) {
        boolean bl;
        if (l == 0L) {
            return this.newDuration(true, Integer.MIN_VALUE, Integer.MIN_VALUE, 0, 0, 0, 0);
        }
        boolean bl2 = false;
        if (l < 0L) {
            bl = false;
            if (l == Long.MIN_VALUE) {
                ++l;
                bl2 = true;
            }
            l *= -1L;
        } else {
            bl = true;
        }
        long l2 = l;
        int n = (int)(l2 % 60000L);
        if (bl2) {
            ++n;
        }
        if (n % 1000 == 0) {
            int n2 = n / 1000;
            int n3 = (int)((l2 /= 60000L) % 60L);
            int n4 = (int)((l2 /= 60L) % 24L);
            long l3 = l2 / 24L;
            if (l3 <= Integer.MAX_VALUE) {
                return this.newDuration(bl, Integer.MIN_VALUE, Integer.MIN_VALUE, (int)l3, n4, n3, n2);
            }
            return this.newDuration(bl, null, null, BigInteger.valueOf(l3), BigInteger.valueOf(n4), BigInteger.valueOf(n3), BigDecimal.valueOf(n, 3));
        }
        BigDecimal bigDecimal = BigDecimal.valueOf(n, 3);
        BigInteger bigInteger = BigInteger.valueOf((l2 /= 60000L) % 60L);
        BigInteger bigInteger2 = BigInteger.valueOf((l2 /= 60L) % 24L);
        BigInteger bigInteger3 = BigInteger.valueOf(l2 /= 24L);
        return this.newDuration(bl, null, null, bigInteger3, bigInteger2, bigInteger, bigDecimal);
    }

    public Duration newDurationDayTime(String string) {
        return AbstractDurationImpl.newDuration(string, DatatypeConstants.DURATION_DAYTIME);
    }

    public Duration newDurationYearMonth(long l) {
        return this.newDurationInternal(l, false);
    }

    public Duration newDurationYearMonth(String string) {
        return AbstractDurationImpl.newDuration(string, DatatypeConstants.DURATION_YEARMONTH);
    }

    private Duration newDurationInternal(long l, boolean bl) {
        boolean bl2;
        int n;
        int[] nArray;
        if (l < 2678400000L && l > -2678400000L) {
            if (bl) {
                return this.newDurationDayTime(l);
            }
            return this.newDurationYearMonth(true, 0, 0);
        }
        long l2 = l / 86400000L;
        int n2 = (int)(l2 / 146097L) * 400;
        int n3 = ((l2 %= 146097L) >= 0L ? 1970 : 1969) + (int)(l2 / 36524L) * 100;
        l2 %= 36524L;
        if (n3 > 1970) {
            if (l2 == 0L) {
                --n3;
                l2 = 364L;
            } else {
                --l2;
            }
        }
        int n4 = 365;
        while (l2 >= (long)n4) {
            l2 -= (long)n4;
            int n5 = n4 = DatatypeFactoryImpl.isLeapYear(++n3) ? 366 : 365;
        }
        n4 = -365;
        while (l2 <= (long)n4) {
            l2 -= (long)n4;
            int n6 = n4 = DatatypeFactoryImpl.isLeapYear(++n3) ? -366 : -365;
        }
        if (l2 >= 0L) {
            nArray = DatatypeFactoryImpl.isLeapYear(n3) ? MONTHS_LEAP : MONTHS;
            n = 11;
            while (l2 < (long)nArray[n]) {
                --n;
            }
            l2 -= (long)nArray[n];
        } else {
            l2 = -l2;
            nArray = DatatypeFactoryImpl.isLeapYear(n3) ? MONTHS_N_LEAP : MONTHS_N;
            n = 11;
            while (l2 < (long)nArray[n]) {
                --n;
            }
            l2 -= (long)nArray[n];
        }
        boolean bl3 = bl2 = l >= 0L;
        n2 = n3 >= 1970 ? (n2 += n3 - 1970) : 1969 - n2 - n3;
        if (bl) {
            if ((l %= 86400000L) == 0L) {
                return this.newDuration(bl2, n2, n, (int)l2, 0, 0, 0);
            }
            if (l < 0L) {
                l = -l;
            }
            int n7 = (int)l / 3600000;
            int n8 = (int)(l %= 3600000L) / 60000;
            if ((l %= 60000L) % 1000L == 0L) {
                return this.newDuration(bl2, n2, n, (int)l2, n7, n8, (int)l / 1000);
            }
            return this.newDuration(bl2, BigInteger.valueOf(n2), BigInteger.valueOf(n), BigInteger.valueOf(l2), BigInteger.valueOf(n7), BigInteger.valueOf(n8), BigDecimal.valueOf(l, 3));
        }
        return this.newDurationYearMonth(bl2, n2, n);
    }

    private static boolean isLeapYear(int n) {
        if ((n & 3) != 0) {
            return false;
        }
        if (n % 100 != 0) {
            return true;
        }
        return (n /= 100) % 400 == 0;
    }

    public XMLGregorianCalendar newXMLGregorianCalendar() {
        return new XMLGregorianCalendarImpl();
    }

    public XMLGregorianCalendar newXMLGregorianCalendar(String string) {
        return new XMLGregorianCalendarImpl(string);
    }

    public XMLGregorianCalendar newXMLGregorianCalendar(GregorianCalendar gregorianCalendar) {
        return new XMLGregorianCalendarImpl(gregorianCalendar);
    }

    public XMLGregorianCalendar newXMLGregorianCalendar(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        return new XMLGregorianCalendarImpl(n, n2, n3, n4, n5, n6, n7, n8);
    }

    public XMLGregorianCalendar newXMLGregorianCalendar(BigInteger bigInteger, int n, int n2, int n3, int n4, int n5, BigDecimal bigDecimal, int n6) {
        return new XMLGregorianCalendarImpl(bigInteger, n, n2, n3, n4, n5, bigDecimal, n6);
    }
}

