/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.spatial;

import com.ibm.spatial.ErrorHandler;
import com.ibm.spatial.EventLocation;
import com.ibm.spatial.SpatialException;
import com.ibm.spatial.util.CodeLocation;
import com.ibm.spatial.util.ErrorReporter;
import com.ibm.spatial.util.HandlerImpl;
import com.ibm.spatial.util.ImplementationMessages;
import com.ibm.spatial.util.LogHandler;
import com.ibm.spatial.util.Logger;
import com.ibm.spatial.util.MessageProvider;
import com.ibm.spatial.util.Messages;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Locale;

public class SpatialManager {
    private static boolean f_needReset = false;
    private static boolean f_continueAfterFatalError = false;
    private static MessageProvider f_messages = new Messages();
    private static MessageProvider f_implementationMessages = new ImplementationMessages();
    private static LogHandler f_logHandler = new HandlerImpl();
    private static Logger f_logger = null;
    private static ErrorReporter f_errorReporter = new ErrorReporter((ErrorHandler)((Object)f_logHandler), f_messages, f_implementationMessages);
    private static final String PROPRIETARY_STATEMENT = "Licensed Materials - Property of IBM IBM Informix Spatial DataBlade(c) Copyright IBM Corp. 2002 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    private static void init() {
        f_continueAfterFatalError = false;
        f_needReset = false;
        f_messages = new Messages();
        f_implementationMessages = new ImplementationMessages();
        f_logHandler = new HandlerImpl();
        f_errorReporter = new ErrorReporter((ErrorHandler)((Object)f_logHandler), f_messages, f_implementationMessages);
    }

    public static void setLocale(Locale locale) throws SpatialException {
        f_messages.setLocale(locale);
        f_implementationMessages.setLocale(locale);
    }

    public static Locale getLocale() {
        return f_messages.getLocale();
    }

    public static synchronized void setErrorHandler(ErrorHandler errorHandler) {
        f_errorReporter.setHandler(errorHandler);
    }

    public static ErrorHandler getErrorHandler() {
        return f_errorReporter.getHandler();
    }

    public static MessageProvider getMessageProvider() {
        return f_messages;
    }

    public static void setLogger(Logger logger) {
        f_logger = logger;
    }

    public static Logger getLogger() {
        return f_logger;
    }

    public static void setLogLevel(int n) {
        Logger.getInstance().setLevel(n);
    }

    public static int getLogLevel() {
        return Logger.getInstance().getLevel();
    }

    public static LogHandler getLogHandler() {
        return f_logHandler;
    }

    public static synchronized void setLogWriter(String string) throws IOException {
        if (string != null) {
            ((HandlerImpl)f_logHandler).setWriter(new FileWriter(string));
        } else {
            SpatialManager.setLogWriter((Writer)null);
        }
    }

    public static synchronized void setLogWriter(Writer writer) {
        ((HandlerImpl)f_logHandler).setWriter(writer);
    }

    public static Writer getLogWriter() {
        return ((HandlerImpl)f_logHandler).getWriter();
    }

    public static ErrorReporter getErrorReporter() {
        return f_errorReporter;
    }

    public static void reportError(Exception exception, String string, String string2) throws SpatialException {
        Logger.getInstance().log(1000, string, string2, 15, null, exception);
        Object[] objectArray = new Object[]{exception};
        f_errorReporter.reportError(4, 15, objectArray, SpatialManager.getEventLocation(string, string2));
    }

    public static void reportError(int n) throws SpatialException {
        Logger.getInstance().log(1000, n);
        f_errorReporter.reportError(0, n, null, null);
    }

    public static void reportError(int n, Object[] objectArray) throws SpatialException {
        Logger.getInstance().log(1000, n, objectArray);
        f_errorReporter.reportError(0, n, objectArray, null);
    }

    public static void reportError(int n, String string, String string2) throws SpatialException {
        Logger.getInstance().log(1000, string, string2, n);
        f_errorReporter.reportError(0, n, null, SpatialManager.getEventLocation(string, string2));
    }

    public static void reportError(int n, Object[] objectArray, String string, String string2) throws SpatialException {
        Logger.getInstance().log(1000, string, string2, n, objectArray);
        f_errorReporter.reportError(0, n, objectArray, SpatialManager.getEventLocation(string, string2));
    }

    public static void reportError(int n, Object[] objectArray, EventLocation eventLocation) throws SpatialException {
        Logger.getInstance().log(1000, eventLocation.getEntityId(), eventLocation.getSubEntityId(), n);
        f_errorReporter.reportError(0, n, objectArray, eventLocation);
    }

    public static void reportError(int n, int n2, Object[] objectArray, EventLocation eventLocation) throws SpatialException {
        Logger.getInstance().log(1000, eventLocation.getEntityId(), eventLocation.getSubEntityId(), n, objectArray);
        f_errorReporter.reportError(n2, n, objectArray, eventLocation);
    }

    public static void assertSM(boolean bl, String string, String string2, int n) {
    }

    public static void assertSM(boolean bl, String string, String string2) {
    }

    public static void indexOutOfRange(String string, int n, int n2, int n3, String string2, String string3) {
        Object[] objectArray = new Object[]{string, new Integer(n), new Integer(n2), new Integer(n3)};
        Logger.getInstance().log(1000, string2, string3, 17, objectArray);
        f_errorReporter.reportRuntimeError(0, 17, objectArray, SpatialManager.getEventLocation(string2, string3));
    }

    public static void invalidArg(String string, String string2, String string3, String string4) {
        Object[] objectArray = new Object[]{string, string2};
        Logger.getInstance().log(1000, string3, string4, 16, objectArray);
        f_errorReporter.reportRuntimeError(0, 16, objectArray, SpatialManager.getEventLocation(string3, string4));
    }

    public static void invalidArg(String string, int n, String string2, String string3) {
        Object[] objectArray = new Object[]{string, new Integer(n)};
        Logger.getInstance().log(1000, string2, string3, 16, objectArray);
        f_errorReporter.reportRuntimeError(0, 16, objectArray, SpatialManager.getEventLocation(string2, string3));
    }

    public static void unsupported() {
        Logger.getInstance().log(1000, "", "", 18);
        f_errorReporter.reportRuntimeError(0, 18, null, null);
    }

    public static EventLocation getEventLocation(String string, String string2) {
        return new CodeLocation(string, string2);
    }

    public static String releaseVersion() {
        return "1.10.JC1";
    }

    public static String buildVersion() {
        return "1.10.JC1";
    }

    public static String buildNumber() {
        return "12320";
    }

    public static String buildTime() {
        return "Thu Nov 15 13:47:24 CST 2012";
    }
}

