/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.spatial.geom;

import com.ibm.spatial.geom.Point;
import java.io.Serializable;

public abstract class CoordPoint
implements Cloneable,
Serializable {
    protected CoordPoint() {
    }

    public double getCoordAt(int n) {
        double d;
        switch (n) {
            case 0: {
                d = this.getX();
                break;
            }
            case 1: {
                d = this.getY();
                break;
            }
            case 2: {
                d = this.getZ();
                break;
            }
            case 3: {
                d = this.getM();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
        return d;
    }

    public abstract double getX();

    public abstract double getY();

    public abstract double getZ();

    public abstract double getM();

    public abstract void setCoordAt(int var1, double var2);

    public void setCoord(CoordPoint coordPoint) {
        this.setCoord(coordPoint.getX(), coordPoint.getY());
        this.setZ(coordPoint.getZ());
        this.setM(coordPoint.getM());
    }

    public abstract void setCoord(double var1, double var3);

    public void setZ(double d) {
    }

    public void setM(double d) {
    }

    public abstract void setEmpty();

    public abstract boolean isEmpty();

    public boolean hasZ() {
        return false;
    }

    public boolean hasM() {
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append("[x=").append(this.getX()).append(",y=").append(this.getY());
        if (this.hasZ()) {
            stringBuffer.append(",z=").append(this.getZ());
        }
        if (this.hasM()) {
            stringBuffer.append(",m=").append(this.getM());
        }
        stringBuffer.append("]");
        return new String(stringBuffer);
    }

    public int hashCode() {
        long l = java.lang.Double.doubleToLongBits(this.getX());
        l += java.lang.Double.doubleToLongBits(this.getY()) * 37L;
        l += java.lang.Double.doubleToLongBits(this.getZ()) * 23L;
        return (int)(l += java.lang.Double.doubleToLongBits(this.getM()) * 23L) ^ (int)(l >> 32);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof CoordPoint) {
            CoordPoint coordPoint = (CoordPoint)object;
            return this.getX() == coordPoint.getX() && this.getY() == coordPoint.getY() && this.getZ() == coordPoint.getZ() && this.getM() == coordPoint.getM();
        }
        return false;
    }

    public boolean equals(Object object, double d, double d2, double d3) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CoordPoint)) {
            return false;
        }
        CoordPoint coordPoint = (CoordPoint)object;
        if (Math.abs(this.getX() - coordPoint.getX()) >= d || Math.abs(this.getY() - coordPoint.getY()) >= d) {
            return false;
        }
        if (!java.lang.Double.isNaN(this.getZ()) && java.lang.Double.isNaN(coordPoint.getZ()) || java.lang.Double.isNaN(this.getZ()) && !java.lang.Double.isNaN(coordPoint.getZ()) || !java.lang.Double.isNaN(this.getZ()) && !java.lang.Double.isNaN(coordPoint.getZ()) && Math.abs(this.getZ() - coordPoint.getZ()) >= d2) {
            return false;
        }
        return !(!java.lang.Double.isNaN(this.getM()) && java.lang.Double.isNaN(coordPoint.getM()) || java.lang.Double.isNaN(this.getM()) && !java.lang.Double.isNaN(coordPoint.getM())) && (java.lang.Double.isNaN(this.getM()) || java.lang.Double.isNaN(coordPoint.getM()) || !(Math.abs(this.getM() - coordPoint.getM()) >= d3));
    }

    public Object clone() {
        Object object = null;
        try {
            object = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return object;
    }

    public static class DoubleZM
    extends Double {
        public double z;
        public double m;

        public DoubleZM() {
            this.m = java.lang.Double.NaN;
            this.z = java.lang.Double.NaN;
        }

        public DoubleZM(double d, double d2) {
            super(d, d2);
            this.z = java.lang.Double.NaN;
            this.m = java.lang.Double.NaN;
        }

        public DoubleZM(double d, double d2, double d3, double d4) {
            super(d, d2);
            this.z = d3;
            this.m = d4;
        }

        public DoubleZM(CoordPoint coordPoint) {
            super(coordPoint);
            if (coordPoint != null) {
                this.z = coordPoint.getZ();
                this.m = coordPoint.getM();
            }
        }

        public DoubleZM(Point point) {
            super(point);
            if (point != null) {
                this.z = point.ordAt(2);
                this.m = point.ordAt(3);
            }
        }

        @Override
        public double getZ() {
            return this.z;
        }

        @Override
        public double getM() {
            return this.m;
        }

        @Override
        public void setCoordAt(int n, double d) throws IndexOutOfBoundsException {
            switch (n) {
                case 0: {
                    this.x = d;
                    break;
                }
                case 1: {
                    this.y = d;
                    break;
                }
                case 2: {
                    this.z = d;
                    break;
                }
                case 3: {
                    this.m = d;
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException();
                }
            }
        }

        @Override
        public void setZ(double d) {
            this.z = d;
        }

        @Override
        public void setM(double d) {
            this.m = d;
        }

        @Override
        public void setEmpty() {
            this.m = java.lang.Double.NaN;
            this.z = java.lang.Double.NaN;
            this.y = java.lang.Double.NaN;
            this.x = java.lang.Double.NaN;
        }

        @Override
        public boolean isEmpty() {
            return java.lang.Double.isNaN(this.x) && java.lang.Double.isNaN(this.y) && java.lang.Double.isNaN(this.z) && java.lang.Double.isNaN(this.m);
        }

        @Override
        public boolean hasZ() {
            return !java.lang.Double.isNaN(this.z);
        }

        @Override
        public boolean hasM() {
            return !java.lang.Double.isNaN(this.m);
        }
    }

    public static class Double
    extends CoordPoint {
        public double x;
        public double y;

        public Double() {
            this.y = java.lang.Double.NaN;
            this.x = java.lang.Double.NaN;
        }

        public Double(double d, double d2) {
            this.x = d;
            this.y = d2;
        }

        public Double(CoordPoint coordPoint) {
            if (coordPoint != null) {
                this.x = coordPoint.getX();
                this.y = coordPoint.getY();
            }
        }

        public Double(Point point) {
            if (point != null) {
                this.x = point.X();
                this.y = point.Y();
            }
        }

        @Override
        public double getX() {
            return this.x;
        }

        @Override
        public double getY() {
            return this.y;
        }

        @Override
        public double getZ() {
            return java.lang.Double.NaN;
        }

        @Override
        public double getM() {
            return java.lang.Double.NaN;
        }

        @Override
        public void setCoordAt(int n, double d) {
            switch (n) {
                case 0: {
                    this.x = d;
                    break;
                }
                case 1: {
                    this.y = d;
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException();
                }
            }
        }

        @Override
        public void setCoord(double d, double d2) {
            this.x = d;
            this.y = d2;
        }

        @Override
        public void setEmpty() {
            this.y = java.lang.Double.NaN;
            this.x = java.lang.Double.NaN;
        }

        @Override
        public boolean isEmpty() {
            return java.lang.Double.isNaN(this.x) && java.lang.Double.isNaN(this.y);
        }
    }

    public static class LongZM
    extends Long {
        public long z;
        public long m;

        public LongZM() {
            this.m = java.lang.Long.MIN_VALUE;
            this.z = java.lang.Long.MIN_VALUE;
        }

        public LongZM(long l, long l2) {
            super(l, l2);
            this.z = java.lang.Long.MIN_VALUE;
            this.m = java.lang.Long.MIN_VALUE;
        }

        public LongZM(long l, long l2, long l3, long l4) {
            super(l, l2);
            this.z = l3;
            this.m = l4;
        }

        public LongZM(CoordPoint coordPoint) {
            super(coordPoint);
            if (coordPoint != null) {
                this.z = java.lang.Double.isNaN(coordPoint.getZ()) ? java.lang.Long.MIN_VALUE : (long)coordPoint.getZ();
                this.m = java.lang.Double.isNaN(coordPoint.getM()) ? java.lang.Long.MIN_VALUE : (long)coordPoint.getM();
            }
        }

        public LongZM(Point point) {
            super(point);
            if (point != null) {
                double d = point.ordAt(2);
                double d2 = point.ordAt(3);
                this.z = java.lang.Double.isNaN(d) ? java.lang.Long.MIN_VALUE : (long)d;
                this.m = java.lang.Double.isNaN(d2) ? java.lang.Long.MIN_VALUE : (long)d2;
            }
        }

        @Override
        public double getZ() {
            return this.z;
        }

        @Override
        public double getM() {
            return this.m;
        }

        @Override
        public void setCoordAt(int n, double d) throws IndexOutOfBoundsException {
            long l = java.lang.Double.isNaN(d) ? java.lang.Long.MIN_VALUE : (long)d;
            switch (n) {
                case 0: {
                    this.x = l;
                    break;
                }
                case 1: {
                    this.y = l;
                    break;
                }
                case 2: {
                    this.z = l;
                    break;
                }
                case 3: {
                    this.m = l;
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException();
                }
            }
        }

        @Override
        public void setZ(double d) {
            this.z = (long)d;
        }

        @Override
        public void setM(double d) {
            this.m = (long)d;
        }

        @Override
        public void setEmpty() {
            this.m = java.lang.Long.MIN_VALUE;
            this.z = java.lang.Long.MIN_VALUE;
            this.y = java.lang.Long.MIN_VALUE;
            this.x = java.lang.Long.MIN_VALUE;
        }

        @Override
        public boolean isEmpty() {
            return this.x == java.lang.Long.MIN_VALUE && this.y == java.lang.Long.MIN_VALUE && this.z == java.lang.Long.MIN_VALUE && this.m == java.lang.Long.MIN_VALUE;
        }

        @Override
        public boolean hasZ() {
            return this.z != java.lang.Long.MIN_VALUE;
        }

        @Override
        public boolean hasM() {
            return this.m != java.lang.Long.MIN_VALUE;
        }

        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(64);
            stringBuffer.append(this.getClass().getName());
            stringBuffer.append("[x=").append(this.x).append(",y=").append(this.y);
            if (this.hasZ()) {
                stringBuffer.append(",z=").append(this.z);
            }
            if (this.hasM()) {
                stringBuffer.append(",m=").append(this.m);
            }
            stringBuffer.append("]");
            return new String(stringBuffer);
        }
    }

    public static class Long
    extends CoordPoint {
        public long x;
        public long y;

        public Long() {
            this.y = java.lang.Long.MIN_VALUE;
            this.x = java.lang.Long.MIN_VALUE;
        }

        public Long(long l, long l2) {
            this.x = l;
            this.y = l2;
        }

        public Long(CoordPoint coordPoint) {
            if (coordPoint != null) {
                this.x = (long)coordPoint.getX();
                this.y = (long)coordPoint.getY();
            }
        }

        public Long(Point point) {
            if (point != null) {
                this.x = (long)point.X();
                this.y = (long)point.Y();
            }
        }

        @Override
        public double getX() {
            return this.x;
        }

        @Override
        public double getY() {
            return this.y;
        }

        @Override
        public double getZ() {
            return java.lang.Double.NaN;
        }

        @Override
        public double getM() {
            return java.lang.Double.NaN;
        }

        @Override
        public void setCoordAt(int n, double d) throws IndexOutOfBoundsException {
            long l = java.lang.Double.isNaN(d) ? java.lang.Long.MIN_VALUE : (long)d;
            switch (n) {
                case 0: {
                    this.x = l;
                    break;
                }
                case 1: {
                    this.y = l;
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException();
                }
            }
        }

        @Override
        public void setCoord(double d, double d2) {
            this.x = (long)d;
            this.y = (long)d2;
        }

        @Override
        public void setEmpty() {
            this.y = java.lang.Long.MIN_VALUE;
            this.x = java.lang.Long.MIN_VALUE;
        }

        @Override
        public boolean isEmpty() {
            return this.x == java.lang.Long.MIN_VALUE && this.y == java.lang.Long.MIN_VALUE;
        }

        @Override
        public String toString() {
            return this.getClass().getName() + "[x=" + this.x + ",y=" + this.y + "]";
        }
    }
}

