/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.spatial.geom;

import com.ibm.spatial.geom.CoordPoint;
import java.io.Serializable;

public abstract class Envelope
implements Cloneable,
Serializable {
    protected Envelope() {
    }

    public abstract double getMinX();

    public abstract double getMaxX();

    public abstract double getMinY();

    public abstract double getMaxY();

    public abstract double getMinZ();

    public abstract double getMaxZ();

    public abstract double getMinM();

    public abstract double getMaxM();

    public double getMin(int n) {
        switch (n) {
            case 0: {
                return this.getMinX();
            }
            case 1: {
                return this.getMinY();
            }
            case 2: {
                return this.getMinZ();
            }
            case 3: {
                return this.getMinM();
            }
        }
        return java.lang.Double.NaN;
    }

    public double getMax(int n) {
        switch (n) {
            case 0: {
                return this.getMaxX();
            }
            case 1: {
                return this.getMaxY();
            }
            case 2: {
                return this.getMaxZ();
            }
            case 3: {
                return this.getMaxM();
            }
        }
        return java.lang.Double.NaN;
    }

    public void getCenter(CoordPoint coordPoint) {
        coordPoint.setEmpty();
        coordPoint.setCoord((this.getMinX() + this.getMaxX()) / 2.0, (this.getMinY() + this.getMaxY()) / 2.0);
        if (coordPoint.hasZ() && this.hasZ()) {
            coordPoint.setZ((this.getMinZ() + this.getMaxZ()) / 2.0);
        }
        if (coordPoint.hasM() && this.hasM()) {
            coordPoint.setM((this.getMinM() + this.getMaxM()) / 2.0);
        }
    }

    public CoordPoint getCenter() {
        CoordPoint.Double double_ = this.hasZ() || this.hasM() ? new CoordPoint.DoubleZM() : new CoordPoint.Double();
        this.getCenter(double_);
        return double_;
    }

    public abstract boolean isEmpty();

    public abstract void setEmpty();

    public abstract boolean hasZ();

    public abstract boolean hasM();

    public abstract void setExtent(double var1, double var3, double var5, double var7);

    public abstract void setExtentZ(double var1, double var3);

    public abstract void setExtentM(double var1, double var3);

    public void setExtent(Envelope envelope) {
        this.setExtent(envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY());
    }

    public abstract Envelope createIntersection(Envelope var1);

    public static void intersect(Envelope envelope, Envelope envelope2, Envelope envelope3) {
        double d = Math.max(envelope.getMinX(), envelope2.getMinX());
        double d2 = Math.max(envelope.getMinY(), envelope2.getMinY());
        double d3 = Math.min(envelope.getMaxX(), envelope2.getMaxX());
        double d4 = Math.min(envelope.getMaxY(), envelope2.getMaxY());
        envelope3.setExtent(d, d2, d3, d4);
    }

    public boolean intersects(Envelope envelope) {
        boolean bl;
        double d = envelope.getMin(2);
        double d2 = envelope.getMax(2);
        double d3 = envelope.getMin(3);
        double d4 = envelope.getMax(3);
        boolean bl2 = bl = this.getMinX() <= envelope.getMaxX() && envelope.getMinX() <= this.getMaxX() && this.getMinY() <= envelope.getMaxY() && envelope.getMinY() <= this.getMaxY();
        if (java.lang.Double.isNaN(d3) || java.lang.Double.isNaN(d4) || java.lang.Double.isNaN(this.getMinM()) || java.lang.Double.isNaN(this.getMaxM())) {
            if (java.lang.Double.isNaN(d) || java.lang.Double.isNaN(d2) || java.lang.Double.isNaN(this.getMinZ()) || java.lang.Double.isNaN(this.getMaxZ())) {
                return bl;
            }
            return bl && this.getMinZ() <= d2 && d <= this.getMaxZ();
        }
        if (java.lang.Double.isNaN(d) || java.lang.Double.isNaN(d2) || java.lang.Double.isNaN(this.getMinZ()) || java.lang.Double.isNaN(this.getMaxZ())) {
            return bl && this.getMinM() <= d4 && d3 <= this.getMaxM();
        }
        return bl && this.getMinZ() <= d2 && d <= this.getMaxZ() && this.getMinM() <= d4 && d3 <= this.getMaxM();
    }

    public abstract Envelope createUnion(Envelope var1);

    public static void union(Envelope envelope, Envelope envelope2, Envelope envelope3) {
        double d = Math.min(envelope.getMinX(), envelope2.getMinX());
        double d2 = Math.min(envelope.getMinY(), envelope2.getMinY());
        double d3 = Math.max(envelope.getMaxX(), envelope2.getMaxX());
        double d4 = Math.max(envelope.getMaxY(), envelope2.getMaxY());
        envelope3.setExtent(d, d2, d3, d4);
    }

    public void add(double d, double d2) {
        double d3 = Math.min(this.getMinX(), d);
        double d4 = Math.max(this.getMaxX(), d);
        double d5 = Math.min(this.getMinY(), d2);
        double d6 = Math.max(this.getMaxY(), d2);
        this.setExtent(d3, d5, d4, d6);
    }

    public void add(double[] dArray, int n, int n2) {
        double d = this.getMinX();
        double d2 = this.getMaxX();
        double d3 = this.getMinY();
        double d4 = this.getMaxY();
        int n3 = (n + n2) * 2;
        for (int i = n * 2; i < n3; ++i) {
            if (d > dArray[i]) {
                d = dArray[i];
            }
            if (d2 < dArray[i]) {
                d2 = dArray[i];
            }
            if (d3 > dArray[++i]) {
                d3 = dArray[i];
            }
            if (!(d4 < dArray[i])) continue;
            d4 = dArray[i];
        }
        this.setExtent(d, d3, d2, d4);
    }

    public void addZ(double d) {
        double d2 = Math.min(this.getMinZ(), d);
        double d3 = Math.max(this.getMaxZ(), d);
        this.setExtentZ(d2, d3);
    }

    public void addZ(double[] dArray, int n, int n2) {
        double d = this.getMinZ();
        double d2 = this.getMaxZ();
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            if (d > dArray[i]) {
                d = dArray[i];
            }
            if (!(d2 < dArray[i])) continue;
            d2 = dArray[i];
        }
        this.setExtentZ(d, d2);
    }

    public void addM(double d) {
        double d2 = Math.min(this.getMinM(), d);
        double d3 = Math.max(this.getMaxM(), d);
        this.setExtentM(d2, d3);
    }

    public void addM(double[] dArray, int n, int n2) {
        double d = this.getMinM();
        double d2 = this.getMaxM();
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            if (d > dArray[i]) {
                d = dArray[i];
            }
            if (!(d2 < dArray[i])) continue;
            d2 = dArray[i];
        }
        this.setExtentM(d, d2);
    }

    public void add(CoordPoint coordPoint) {
        this.add(coordPoint.getX(), coordPoint.getY());
        if (coordPoint.hasZ()) {
            this.addZ(coordPoint.getZ());
        }
        if (coordPoint.hasM()) {
            this.addM(coordPoint.getM());
        }
    }

    public void add(Envelope envelope) {
        this.add(envelope.getMinX(), envelope.getMinY());
        this.addZ(envelope.getMinZ());
        this.addM(envelope.getMinM());
        this.add(envelope.getMaxX(), envelope.getMaxY());
        this.addZ(envelope.getMaxZ());
        this.addM(envelope.getMaxM());
    }

    public int hashCode() {
        long l = java.lang.Double.doubleToLongBits(this.getMinX());
        l += java.lang.Double.doubleToLongBits(this.getMinY()) * 37L;
        l += java.lang.Double.doubleToLongBits(this.getMaxX()) * 43L;
        l += java.lang.Double.doubleToLongBits(this.getMaxY()) * 47L;
        l += java.lang.Double.doubleToLongBits(this.getMinZ()) * 23L;
        l += java.lang.Double.doubleToLongBits(this.getMaxZ()) * 19L;
        l += java.lang.Double.doubleToLongBits(this.getMinM()) * 23L;
        return (int)(l += java.lang.Double.doubleToLongBits(this.getMaxM()) * 19L) ^ (int)(l >> 32);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Envelope) {
            Envelope envelope = (Envelope)object;
            return this.getMinX() == envelope.getMinX() && this.getMaxX() == envelope.getMaxX() && this.getMinY() == envelope.getMinY() && this.getMaxY() == envelope.getMaxY() && this.getMinZ() == envelope.getMinZ() && this.getMaxZ() == envelope.getMaxZ() && this.getMinM() == envelope.getMinM() && this.getMaxM() == envelope.getMaxM();
        }
        return false;
    }

    public Object clone() {
        Object object = null;
        try {
            object = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return object;
    }

    public static class Double
    extends Envelope {
        public double minX;
        public double minY;
        public double maxX;
        public double maxY;
        public double minZ;
        public double maxZ;
        public double minM;
        public double maxM;

        public Double() {
            this.setEmpty();
        }

        public Double(double d, double d2, double d3, double d4) {
            this.minX = d;
            this.maxX = d3;
            this.minY = d2;
            this.maxY = d4;
            this.minZ = java.lang.Double.POSITIVE_INFINITY;
            this.maxZ = java.lang.Double.NEGATIVE_INFINITY;
            this.minM = java.lang.Double.POSITIVE_INFINITY;
            this.maxM = java.lang.Double.NEGATIVE_INFINITY;
        }

        @Override
        public double getMinX() {
            return this.minX;
        }

        @Override
        public double getMaxX() {
            return this.maxX;
        }

        @Override
        public double getMinY() {
            return this.minY;
        }

        @Override
        public double getMaxY() {
            return this.maxY;
        }

        @Override
        public double getMinZ() {
            return this.minZ;
        }

        @Override
        public double getMaxZ() {
            return this.maxZ;
        }

        @Override
        public double getMinM() {
            return this.minM;
        }

        @Override
        public double getMaxM() {
            return this.maxM;
        }

        @Override
        public void setExtent(double d, double d2, double d3, double d4) {
            this.minX = d;
            this.maxX = d3;
            this.minY = d2;
            this.maxY = d4;
        }

        @Override
        public void setExtentZ(double d, double d2) {
            this.minZ = d;
            this.maxZ = d2;
        }

        @Override
        public void setExtentM(double d, double d2) {
            this.minM = d;
            this.maxM = d2;
        }

        @Override
        public void setExtent(Envelope envelope) {
            this.minX = envelope.getMinX();
            this.maxX = envelope.getMaxX();
            this.minY = envelope.getMinY();
            this.maxY = envelope.getMaxY();
            this.minZ = envelope.getMinZ();
            this.maxZ = envelope.getMaxZ();
            this.minM = envelope.getMinM();
            this.maxM = envelope.getMaxM();
        }

        @Override
        public boolean hasZ() {
            return this.minZ > this.maxZ;
        }

        @Override
        public boolean hasM() {
            return this.minM > this.maxM;
        }

        @Override
        public boolean isEmpty() {
            return this.maxX <= this.minX || this.maxY <= this.minY;
        }

        @Override
        public void setEmpty() {
            this.minM = java.lang.Double.POSITIVE_INFINITY;
            this.minZ = java.lang.Double.POSITIVE_INFINITY;
            this.minY = java.lang.Double.POSITIVE_INFINITY;
            this.minX = java.lang.Double.POSITIVE_INFINITY;
            this.maxM = java.lang.Double.NEGATIVE_INFINITY;
            this.maxZ = java.lang.Double.NEGATIVE_INFINITY;
            this.maxY = java.lang.Double.NEGATIVE_INFINITY;
            this.maxX = java.lang.Double.NEGATIVE_INFINITY;
        }

        @Override
        public Envelope createIntersection(Envelope envelope) {
            Double double_ = new Double();
            Envelope.intersect(this, envelope, double_);
            return double_;
        }

        @Override
        public Envelope createUnion(Envelope envelope) {
            Double double_ = new Double();
            Envelope.union(this, envelope, double_);
            return double_;
        }

        public String toString() {
            return this.getClass().getName() + "[minX=" + this.minX + ",maxX=" + this.maxX + ",minY=" + this.minY + ",maxY=" + this.maxY + ",minZ=" + this.minZ + ",maxZ=" + this.maxZ + ",minM=" + this.minM + ",maxM=" + this.maxM + "]";
        }
    }

    public static class Long
    extends Envelope {
        public long minX;
        public long minY;
        public long maxX;
        public long maxY;
        public long minZ = java.lang.Long.MAX_VALUE;
        public long maxZ = java.lang.Long.MIN_VALUE;
        public long minM = java.lang.Long.MAX_VALUE;
        public long maxM = java.lang.Long.MIN_VALUE;

        public Long() {
            this.setEmpty();
        }

        public Long(long l, long l2, long l3, long l4) {
            this.minX = l;
            this.maxX = l3;
            this.minY = l2;
            this.maxY = l4;
            this.minZ = java.lang.Long.MAX_VALUE;
            this.maxZ = java.lang.Long.MIN_VALUE;
            this.minM = java.lang.Long.MAX_VALUE;
            this.maxM = java.lang.Long.MIN_VALUE;
        }

        @Override
        public double getMinX() {
            return this.minX;
        }

        @Override
        public double getMaxX() {
            return this.maxX;
        }

        @Override
        public double getMinY() {
            return this.minY;
        }

        @Override
        public double getMaxY() {
            return this.maxY;
        }

        @Override
        public double getMinZ() {
            return this.minZ;
        }

        @Override
        public double getMaxZ() {
            return this.maxZ;
        }

        @Override
        public double getMinM() {
            return this.minM;
        }

        @Override
        public double getMaxM() {
            return this.maxM;
        }

        @Override
        public void setExtent(double d, double d2, double d3, double d4) {
            this.minX = (long)d;
            this.maxX = (long)d3;
            this.minY = (long)d2;
            this.maxY = (long)d4;
        }

        @Override
        public void setExtentZ(double d, double d2) {
            this.minZ = (long)d;
            this.maxZ = (long)d2;
        }

        @Override
        public void setExtentM(double d, double d2) {
            this.minM = (long)d;
            this.maxM = (long)d2;
        }

        public void setExtent(long l, long l2, long l3, long l4) {
            this.minX = l;
            this.maxX = l3;
            this.minY = l2;
            this.maxY = l4;
        }

        public void setExtentZ(long l, long l2) {
            this.minZ = l;
            this.maxZ = l2;
        }

        public void setExtentM(long l, long l2) {
            this.minM = l;
            this.maxM = l2;
        }

        @Override
        public void setExtent(Envelope envelope) {
            if (envelope instanceof Long) {
                Long longVal = (Long)envelope;
                this.minX = longVal.minX;
                this.maxX = longVal.maxX;
                this.minY = longVal.minY;
                this.maxY = longVal.maxY;
                this.minZ = longVal.minZ;
                this.maxZ = longVal.maxZ;
                this.minM = longVal.minM;
                this.maxM = longVal.maxM;
            } else {
                this.minX = (long)envelope.getMinX();
                this.maxX = (long)envelope.getMaxX();
                this.minY = (long)envelope.getMinY();
                this.maxY = (long)envelope.getMaxY();
                this.minZ = (long)envelope.getMinZ();
                this.maxZ = (long)envelope.getMaxZ();
                this.minM = (long)envelope.getMinM();
                this.maxM = (long)envelope.getMaxM();
            }
        }

        @Override
        public boolean hasZ() {
            return this.minZ > this.maxZ;
        }

        @Override
        public boolean hasM() {
            return this.minM > this.maxM;
        }

        @Override
        public boolean isEmpty() {
            return this.maxX <= this.minX || this.maxY <= this.minY;
        }

        @Override
        public void setEmpty() {
            this.minM = java.lang.Long.MAX_VALUE;
            this.minZ = java.lang.Long.MAX_VALUE;
            this.minY = java.lang.Long.MAX_VALUE;
            this.minX = java.lang.Long.MAX_VALUE;
            this.maxM = java.lang.Long.MIN_VALUE;
            this.maxZ = java.lang.Long.MIN_VALUE;
            this.maxY = java.lang.Long.MIN_VALUE;
            this.maxX = java.lang.Long.MIN_VALUE;
        }

        @Override
        public Envelope createIntersection(Envelope envelope) {
            Envelope envelope2 = envelope instanceof Long ? new Long() : new Double();
            Envelope.intersect(this, envelope, envelope2);
            return envelope2;
        }

        @Override
        public Envelope createUnion(Envelope envelope) {
            Envelope envelope2 = (Envelope)envelope.clone();
            Envelope.union(this, envelope, envelope2);
            return envelope2;
        }

        public void add(long l, long l2) {
            this.minX = Math.min(this.minX, l);
            this.maxX = Math.max(this.maxX, l);
            this.minY = Math.min(this.minY, l2);
            this.maxY = Math.max(this.maxY, l2);
        }

        public String toString() {
            return this.getClass().getName() + "[minX=" + this.minX + ",maxX=" + this.maxX + ",minY=" + this.minY + ",maxY=" + this.maxY + ",minZ=" + this.minZ + ",maxZ=" + this.maxZ + ",minM=" + this.minM + ",maxM=" + this.maxM + "]";
        }
    }
}

