/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.spatial.geom;

import com.ibm.spatial.SpatialException;
import com.ibm.spatial.SpatialManager;
import com.ibm.spatial.geom.CoordPoint;
import com.ibm.spatial.geom.Envelope;
import com.ibm.spatial.geom.Geometry;
import com.ibm.spatial.geom.GeometryCollection;
import com.ibm.spatial.geom.IfxGeometry;
import com.ibm.spatial.geom.IfxGeometryCollection;
import com.ibm.spatial.geom.IfxPoint;
import com.ibm.spatial.geom.IfxPolygon;
import com.ibm.spatial.geom.IfxSQLGeometryFactory;
import com.ibm.spatial.geom.Point;
import com.ibm.spatial.geom.Polygon;
import com.ibm.spatial.srs.CoordRef;
import com.ibm.spatial.util.Logger;

public class GeometryFactory {
    protected CoordRef f_srs = null;
    private final String f_createPointMethodName = "createPoint";
    protected final String f_classNamePrefix = "com.ibm.spatial.geom.Ifx";

    protected GeometryFactory() {
    }

    protected GeometryFactory(CoordRef coordRef) {
        this.f_srs = coordRef;
    }

    public static GeometryFactory getInstance(String string, CoordRef coordRef) {
        if (string != null && string.equals("IfxSQL")) {
            if (coordRef == null) {
                SpatialManager.invalidArg("CoordRef", "null", "GeometryFactory", "getInstance");
            }
            return new IfxSQLGeometryFactory(coordRef);
        }
        return GeometryFactory.getInstance(coordRef);
    }

    public static GeometryFactory getInstance(CoordRef coordRef) {
        if (coordRef == null) {
            SpatialManager.invalidArg("CoordRef", "null", "GeometryFactory", "getInstance");
        }
        return new GeometryFactory(coordRef);
    }

    public CoordRef getSpatialReference() {
        return this.f_srs;
    }

    public Point createPoint(CoordPoint coordPoint) throws SpatialException {
        Cloneable cloneable;
        if (coordPoint != null) {
            if (!coordPoint.isEmpty()) {
                double d;
                double d2;
                double d3;
                double d4;
                if (coordPoint instanceof CoordPoint.Long) {
                    cloneable = (CoordPoint.Long)coordPoint;
                    d4 = this.f_srs.convertXValueToWorld(((CoordPoint.Long)cloneable).x);
                    d3 = this.f_srs.convertYValueToWorld(((CoordPoint.Long)cloneable).y);
                    d2 = ((CoordPoint)cloneable).hasZ() ? this.f_srs.convertZValueToWorld((int)((CoordPoint.Long)cloneable).getZ()) : Double.NaN;
                    d = ((CoordPoint)cloneable).hasM() ? this.f_srs.convertMValueToWorld((int)((CoordPoint.Long)cloneable).getM()) : Double.NaN;
                } else {
                    cloneable = (CoordPoint.Double)coordPoint;
                    d4 = ((CoordPoint.Double)cloneable).x;
                    d3 = ((CoordPoint.Double)cloneable).y;
                    d2 = ((CoordPoint.Double)cloneable).getZ();
                    d = ((CoordPoint.Double)cloneable).getM();
                }
                coordPoint = !Double.isNaN(d2) || !Double.isNaN(d) ? new CoordPoint.DoubleZM(d4, d3, d2, d) : new CoordPoint.Double(d4, d3);
            } else {
                coordPoint = null;
            }
        }
        cloneable = new IfxPoint(this.f_srs, coordPoint);
        ((IfxPoint)cloneable).checkValid(this.getClass().getName(), "createPoint");
        return cloneable;
    }

    public Point createPoint(double d, double d2) throws SpatialException {
        IfxPoint ifxPoint = new IfxPoint(this.f_srs, d, d2);
        ifxPoint.checkValid(this.getClass().getName(), "createPoint");
        return ifxPoint;
    }

    public Point createPoint(double d, double d2, double d3, double d4) throws SpatialException {
        CoordPoint.Double double_ = !Double.isNaN(d3) || !Double.isNaN(d4) ? new CoordPoint.DoubleZM(d, d2, d3, d4) : new CoordPoint.Double(d, d2);
        IfxPoint ifxPoint = new IfxPoint(this.f_srs, double_);
        ifxPoint.checkValid(this.getClass().getName(), "createPoint");
        return ifxPoint;
    }

    public Polygon createPolygon(Envelope envelope) {
        double[] dArray = null;
        double[] dArray2 = null;
        double[] dArray3 = null;
        int[] nArray = null;
        String string = "createPolygon";
        if (envelope != null) {
            if (!envelope.isEmpty()) {
                dArray = new double[10];
                nArray = new int[2];
                dArray[6] = dArray[8] = envelope.getMinX();
                dArray[0] = dArray[8];
                dArray[3] = dArray[9] = envelope.getMinY();
                dArray[1] = dArray[9];
                dArray[2] = dArray[4] = envelope.getMaxX();
                dArray[5] = dArray[7] = envelope.getMaxY();
                nArray[0] = 0;
                nArray[1] = 6;
                if (envelope.hasZ()) {
                    dArray2 = new double[5];
                    dArray2[0] = dArray2[4] = envelope.getMinZ();
                    dArray2[2] = envelope.getMaxZ();
                    dArray2[1] = dArray2[3] = (dArray2[0] + dArray2[2]) / 2.0;
                }
                if (envelope.hasM()) {
                    dArray3 = new double[5];
                    dArray3[0] = envelope.getMinM();
                    dArray3[4] = envelope.getMaxM();
                    dArray3[1] = (3.0 * dArray3[0] + dArray3[4]) / 4.0;
                    dArray3[2] = (dArray3[0] + dArray3[4]) / 2.0;
                    dArray3[3] = (dArray3[0] + 3.0 * dArray3[4]) / 4.0;
                }
            } else {
                if (envelope.hasZ()) {
                    dArray2 = new double[]{};
                }
                if (envelope.hasM()) {
                    dArray3 = new double[]{};
                }
            }
        }
        IfxPolygon ifxPolygon = null;
        try {
            ifxPolygon = (IfxPolygon)this.initGeometry(new IfxPolygon(), dArray, dArray2, dArray3, null, nArray, null, false);
        }
        catch (SpatialException spatialException) {
            // empty catch block
        }
        return ifxPolygon;
    }

    public Geometry createEmptyGeometry(String string, boolean bl, boolean bl2) throws ClassNotFoundException {
        Geometry geometry = null;
        try {
            geometry = this.createGeometry(string, null, (double[])(bl ? IfxGeometry.NULL_DOUBLE_ARRAY : null), (double[])(bl2 ? IfxGeometry.NULL_DOUBLE_ARRAY : null), null, null);
        }
        catch (SpatialException spatialException) {
            // empty catch block
        }
        return geometry;
    }

    public Geometry createGeometry(String string, double[] dArray, double[] dArray2, double[] dArray3, int[] nArray, int[] nArray2) throws ClassNotFoundException, SpatialException {
        IfxGeometry ifxGeometry;
        String string2 = "createGeometry";
        String string3 = "com.ibm.spatial.geom.Ifx" + string;
        try {
            Class<?> clazz = Class.forName(string3);
            ifxGeometry = (IfxGeometry)clazz.newInstance();
        }
        catch (Exception exception) {
            Logger.getInstance().log(1000, 15, exception);
            throw new ClassNotFoundException(string3, exception);
        }
        return this.initGeometry(ifxGeometry, dArray, dArray2, dArray3, nArray, nArray2, null, true);
    }

    public Geometry createGeometryCollection(String string, Geometry[] geometryArray) throws ClassNotFoundException, SpatialException {
        IfxGeometryCollection ifxGeometryCollection;
        String string2 = "createGeometryCollection";
        String string3 = "com.ibm.spatial.geom.Ifx" + string;
        try {
            Class<?> clazz = Class.forName(string3);
            IfxGeometry ifxGeometry = (IfxGeometry)clazz.newInstance();
            if (!(ifxGeometry instanceof IfxGeometryCollection)) {
                throw new ClassNotFoundException();
            }
            ifxGeometryCollection = (IfxGeometryCollection)ifxGeometry;
        }
        catch (Exception exception) {
            Logger.getInstance().log(1000, 15, exception);
            throw new ClassNotFoundException(string3, exception);
        }
        return this.initGeometry(ifxGeometryCollection, geometryArray);
    }

    Geometry initGeometry(IfxGeometry ifxGeometry, double[] dArray, double[] dArray2, double[] dArray3, int[] nArray, int[] nArray2, Envelope envelope, boolean bl) throws SpatialException {
        ifxGeometry.setCoordRef(this.f_srs);
        ifxGeometry.setCoord(dArray, dArray2, dArray3, nArray, nArray2);
        ifxGeometry.setEnvelope(envelope);
        if (bl) {
            ifxGeometry.checkValid(this.getClass().getName(), "initGeometry");
        }
        return ifxGeometry;
    }

    GeometryCollection initGeometry(IfxGeometryCollection ifxGeometryCollection, Geometry[] geometryArray) throws SpatialException {
        ifxGeometryCollection.setCoordRef(this.f_srs);
        ifxGeometryCollection.setCoord(geometryArray);
        ifxGeometryCollection.calcEnvelope();
        return ifxGeometryCollection;
    }
}

