/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.spatial.geom;

import com.ibm.spatial.SpatialException;
import com.ibm.spatial.SpatialManager;
import com.ibm.spatial.geom.CoordPoint;
import com.ibm.spatial.geom.Envelope;
import com.ibm.spatial.geom.Geometry;
import com.ibm.spatial.geom.GeometryFactory;
import com.ibm.spatial.srs.CoordRef;
import com.ibm.spatial.util.Logger;
import java.io.ByteArrayOutputStream;

public abstract class IfxGeometry
implements Geometry,
Cloneable {
    public static final int COORD_XY = 1;
    public static final int COORD_Z = 2;
    public static final int COORD_M = 4;
    protected static final int COORD_MASK = 7;
    protected CoordRef f_srs;
    protected Envelope f_envelope = EMPTY_ENVELOPE;
    protected static final CoordPoint EMPTY_POINT = new CoordPoint.Double();
    protected static final Envelope EMPTY_ENVELOPE = new Envelope.Double();
    private static final int IS_EMPTY = 0x1000000;
    private static final int HAS_Z = 2;
    private static final int HAS_M = 1;
    protected int f_flags = 0x1000000;
    protected static final Object[] NULL_COORDPOINT_ARRAY = new CoordPoint.Double[0];
    protected static final double[] NULL_DOUBLE_ARRAY = new double[0];
    protected static final IfxGeometry[] NULL_GEOMETRY_ARRAY = new IfxGeometry[0];
    protected static final int INVALID_DIMENSION = -2;
    protected static final int EMPTY_DIMENSION = -1;
    protected static String f_sWKTCoordBegin = "(";
    protected static String f_sWKTCoordEnd = ")";
    protected static String f_sWKTCoordSeparator = " ";
    protected static String f_sWKTTupleSeparator = ",";
    protected static String f_sWKTPolyBegin = f_sWKTCoordBegin;
    protected static String f_sWKTPolyEnd = f_sWKTCoordEnd;
    protected static String f_sWKTRingSeparator = ",";
    protected static String f_sWKTMultiGeomBegin = f_sWKTCoordBegin;
    protected static String f_sWKTMultiGeomEnd = f_sWKTCoordEnd;
    protected static String f_sWKTGeomSeparator = ",";

    protected IfxGeometry() {
    }

    protected IfxGeometry(CoordRef coordRef, boolean bl) {
        this.f_srs = coordRef;
        this.f_envelope = bl ? new Envelope.Double() : EMPTY_ENVELOPE;
    }

    void setCoordRef(CoordRef coordRef) {
        this.f_srs = coordRef;
    }

    void setEnvelope(Envelope envelope) {
        if (envelope != null) {
            this.f_envelope = envelope;
        } else {
            this.calcEnvelope();
        }
    }

    void calcEnvelope() {
        this.f_envelope = EMPTY_ENVELOPE;
    }

    void setData(double d, double d2) {
    }

    void setCoord(double[] dArray, double[] dArray2, double[] dArray3, int[] nArray, int[] nArray2) {
    }

    @Override
    public abstract int dimension();

    @Override
    public ByteArrayOutputStream asBinary() {
        SpatialManager.unsupported();
        return null;
    }

    @Override
    public String asText() {
        String string = "asText";
        Logger logger = Logger.getInstance();
        logger.entering(this.getClass().getName(), string);
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append(this.geometryType()).append(' ');
        if (this.is3D()) {
            stringBuffer.append('Z');
            if (this.isMeasured()) {
                stringBuffer.append('M');
            }
            stringBuffer.append(' ');
        } else if (this.isMeasured()) {
            stringBuffer.append("M ");
        }
        if (this.isEmpty()) {
            stringBuffer.append("Empty");
        } else {
            this.coordAsText(stringBuffer);
        }
        String string2 = stringBuffer.toString();
        logger.exiting(this.getClass().getName(), string);
        return string2;
    }

    @Override
    public boolean isSimple() {
        SpatialManager.unsupported();
        return false;
    }

    @Override
    public Geometry envelope() {
        GeometryFactory geometryFactory = GeometryFactory.getInstance(this.f_srs);
        return geometryFactory.createPolygon(this.f_envelope);
    }

    @Override
    public Envelope extent() {
        return (Envelope)this.f_envelope.clone();
    }

    @Override
    public boolean envelopesIntersect(Geometry geometry) {
        return this.f_envelope.intersects(geometry.extent());
    }

    @Override
    public int srid() {
        return this.f_srs.getSrid();
    }

    @Override
    public boolean isEmpty() {
        return (this.f_flags & 0x1000000) != 0;
    }

    @Override
    public abstract int numPoints();

    @Override
    public boolean contains(Geometry geometry) {
        SpatialManager.unsupported();
        return false;
    }

    @Override
    public boolean crosses(Geometry geometry) {
        SpatialManager.unsupported();
        return false;
    }

    @Override
    public boolean disjoint(Geometry geometry) {
        SpatialManager.unsupported();
        return false;
    }

    @Override
    public boolean intersects(Geometry geometry) {
        SpatialManager.unsupported();
        return false;
    }

    @Override
    public boolean overlaps(Geometry geometry) {
        SpatialManager.unsupported();
        return false;
    }

    @Override
    public boolean touches(Geometry geometry) {
        SpatialManager.unsupported();
        return false;
    }

    @Override
    public boolean within(Geometry geometry) {
        SpatialManager.unsupported();
        return false;
    }

    @Override
    public Geometry boundary() {
        SpatialManager.unsupported();
        return null;
    }

    @Override
    public Geometry buffer(double d) {
        SpatialManager.unsupported();
        return null;
    }

    @Override
    public Geometry convexHull() {
        SpatialManager.unsupported();
        return null;
    }

    @Override
    public Geometry difference(Geometry geometry) {
        SpatialManager.unsupported();
        return null;
    }

    @Override
    public double distance(Geometry geometry) {
        SpatialManager.unsupported();
        return Double.NaN;
    }

    @Override
    public Geometry intersection(Geometry geometry) {
        SpatialManager.unsupported();
        return null;
    }

    @Override
    public Geometry symmetricDiff(Geometry geometry) {
        SpatialManager.unsupported();
        return null;
    }

    @Override
    public Geometry union(Geometry geometry) {
        SpatialManager.unsupported();
        return null;
    }

    @Override
    public boolean is3D() {
        return (this.f_flags & 2) != 0;
    }

    @Override
    public boolean isMeasured() {
        return (this.f_flags & 1) != 0;
    }

    @Override
    public boolean isValid() {
        SpatialManager.unsupported();
        return false;
    }

    @Override
    public Geometry exterior() {
        SpatialManager.unsupported();
        return null;
    }

    @Override
    public Geometry interior() {
        SpatialManager.unsupported();
        return null;
    }

    @Override
    public Geometry locateAlong(double d) {
        SpatialManager.unsupported();
        return null;
    }

    @Override
    public Geometry locateBetween(double d, double d2) {
        SpatialManager.unsupported();
        return null;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        IfxGeometry ifxGeometry = (IfxGeometry)object;
        return this.f_envelope.equals(ifxGeometry.f_envelope) && this.srid() == ifxGeometry.srid();
    }

    public int getCoordinateDimension() {
        return this.f_srs.getDimension();
    }

    public int getDimensionality() {
        int n = 2;
        if (this.is3D()) {
            ++n;
        }
        if (this.isMeasured()) {
            ++n;
        }
        return n;
    }

    public String geometryType() {
        return "Geometry";
    }

    public Class getOGCType() {
        try {
            return Class.forName("com.ibm.spatial.geom." + this.geometryType());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new InternalError();
        }
    }

    public CoordPoint getLabelPoint() throws SpatialException {
        CoordPoint.Double double_ = new CoordPoint.Double();
        this.getLabelPoint(double_);
        return double_;
    }

    public void getLabelPoint(CoordPoint coordPoint) throws SpatialException {
        this.f_envelope.getCenter(coordPoint);
    }

    public double area() {
        return 0.0;
    }

    public double perimeter() {
        return 0.0;
    }

    public double length() {
        return 0.0;
    }

    public abstract int numParts();

    public abstract int numSubParts(int var1);

    public abstract int numPoints(int var1, int var2);

    public abstract int toCoordArray(double[] var1, int var2, int var3, int var4, int var5, int var6);

    public abstract int toPointArray(CoordPoint[] var1, int var2, int var3, int var4, int var5);

    public String toString() {
        return this.sridToString() + " " + this.asText();
    }

    public synchronized Object clone() {
        Object object = null;
        try {
            object = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        return object;
    }

    protected String sridToString() {
        if (this.f_srs == null) {
            return "null";
        }
        return Integer.toString(this.f_srs.getSrid());
    }

    protected synchronized void checkValid(String string, String string2) throws SpatialException {
    }

    protected void coordAsText(StringBuffer stringBuffer) {
    }

    protected void setHasZ(boolean bl) {
        this.f_flags = bl ? (this.f_flags |= 2) : (this.f_flags &= 0xFFFFFFFD);
    }

    protected void setHasM(boolean bl) {
        this.f_flags = bl ? (this.f_flags |= 1) : (this.f_flags &= 0xFFFFFFFE);
    }

    protected void setEmpty(boolean bl) {
        this.f_flags = bl ? (this.f_flags |= 0x1000000) : (this.f_flags &= 0xFEFFFFFF);
    }
}

