/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.spatial.geom;

import com.ibm.spatial.SpatialException;
import com.ibm.spatial.SpatialManager;
import com.ibm.spatial.geom.CoordPoint;
import com.ibm.spatial.geom.Envelope;
import com.ibm.spatial.geom.Geometry;
import com.ibm.spatial.geom.GeometryCollection;
import com.ibm.spatial.geom.GeometryFactory;
import com.ibm.spatial.geom.IfxGeometry;
import com.ibm.spatial.geom.IfxMultiCoord;
import com.ibm.spatial.srs.CoordRef;
import com.ibm.spatial.srs.CoordRefManager;
import com.ibm.spatial.util.Logger;

public class IfxGeometryCollection
extends IfxMultiCoord
implements GeometryCollection {
    protected IfxGeometry[] f_geometries = NULL_GEOMETRY_ARRAY;
    protected int f_dimension = -2;
    protected boolean f_hetero = true;

    IfxGeometryCollection() {
        this.f_numPoints = -1;
    }

    IfxGeometryCollection(CoordRef coordRef, boolean bl) {
        super(coordRef, bl);
        this.f_numPoints = -1;
    }

    IfxGeometryCollection(CoordRef coordRef, Geometry[] geometryArray) throws SpatialException {
        super(coordRef, false);
        this.setCoord(geometryArray);
        this.calcEnvelope();
        this.f_numPoints = -1;
    }

    @Override
    void calcEnvelope() {
        if (this.isEmpty()) {
            this.f_envelope = EMPTY_ENVELOPE;
        } else if (this.f_hetero) {
            Envelope.Double double_ = new Envelope.Double();
            for (int i = 0; i < this.f_geometries.length; ++i) {
                double_.add(this.f_geometries[i].f_envelope);
            }
            this.f_envelope = double_;
        } else {
            super.calcEnvelope();
        }
    }

    void setCoord(Geometry[] geometryArray) throws SpatialException {
        String string = "setCoord";
        if (geometryArray != null && geometryArray.length != 0) {
            int n;
            if (!(geometryArray instanceof IfxGeometry[])) {
                SpatialManager.reportError(10, this.getClass().getName(), string);
            }
            int n2 = geometryArray[0].srid();
            boolean bl = geometryArray[0].is3D();
            boolean bl2 = geometryArray[0].isMeasured();
            CoordRef coordRef = CoordRefManager.getInstance().get(n2);
            IfxGeometry[] ifxGeometryArray = new IfxGeometry[geometryArray.length];
            for (n = 0; n < geometryArray.length; ++n) {
                if (geometryArray[n].srid() != n2 || bl && !geometryArray[n].is3D() || !bl && geometryArray[n].is3D() || bl2 && !geometryArray[n].isMeasured() || !bl2 && geometryArray[n].isMeasured()) {
                    if (geometryArray[n].isEmpty()) {
                        try {
                            IfxGeometry ifxGeometry;
                            GeometryFactory geometryFactory = GeometryFactory.getInstance(((IfxGeometry)geometryArray[n]).geometryType(), coordRef);
                            ifxGeometryArray[n] = ifxGeometry = (IfxGeometry)geometryFactory.createEmptyGeometry(((IfxGeometry)geometryArray[n]).geometryType(), geometryArray[n].is3D(), geometryArray[n].isMeasured());
                        }
                        catch (Exception exception) {
                            SpatialManager.reportError(10, this.getClass().getName(), string);
                        }
                    } else {
                        SpatialManager.reportError(10, this.getClass().getName(), string);
                    }
                }
                ifxGeometryArray[n] = (IfxGeometry)geometryArray[n];
            }
            n = 1;
            int n3 = 0;
            while ((n = (int)(ifxGeometryArray[n3++].isEmpty() ? 1 : 0)) != 0) {
            }
            this.setEmpty(n != 0);
            this.setHasZ(ifxGeometryArray[0].is3D());
            this.setHasM(ifxGeometryArray[0].isMeasured());
            if (n == 0) {
                this.f_geometries = ifxGeometryArray;
                this.f_xy = new double[2];
                if (ifxGeometryArray[0].is3D()) {
                    this.f_z = this.f_xy;
                }
                if (ifxGeometryArray[0].isMeasured()) {
                    this.f_m = this.f_xy;
                }
            }
        } else {
            this.setEmpty(true);
        }
    }

    @Override
    public int numGeometries() {
        return this.f_hetero ? this.f_geometries.length : this.numParts();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Geometry geometryN(int n) throws SpatialException {
        IfxGeometry ifxGeometry;
        String string = "geometryN";
        Logger logger = Logger.getInstance();
        logger.entering(this.getClass().getName(), string);
        int n2 = this.numParts();
        IfxGeometry ifxGeometry2 = null;
        if (n < 0 || n >= n2) {
            SpatialManager.indexOutOfRange("index", n, 0, n2 - 1, this.getClass().getName(), string);
        }
        if (this.f_geometries.length == 0) {
            ifxGeometry = this;
            synchronized (ifxGeometry) {
                if (this.f_geometries.length == 0) {
                    this.f_geometries = new IfxGeometry[this.f_numPoints];
                }
            }
        }
        if (this.f_geometries[n] == null) {
            ifxGeometry = this.getGeometryAt(n);
            IfxGeometryCollection ifxGeometryCollection = this;
            synchronized (ifxGeometryCollection) {
                if (this.f_geometries[n] == null) {
                    this.f_geometries[n] = ifxGeometry;
                }
            }
        }
        ifxGeometry2 = this.f_geometries[n];
        logger.exiting(this.getClass().getName(), string);
        return ifxGeometry2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int dimension() {
        if (this.f_dimension == -2) {
            String string = "dimension";
            Logger logger = Logger.getInstance();
            logger.entering(this.getClass().getName(), string);
            int n = this.calcDimension();
            IfxGeometryCollection ifxGeometryCollection = this;
            synchronized (ifxGeometryCollection) {
                if (this.f_dimension == -2) {
                    this.f_dimension = n;
                }
            }
            logger.exiting(this.getClass().getName(), string);
        }
        return this.f_dimension;
    }

    @Override
    public String geometryType() {
        return "GeometryCollection";
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof IfxGeometryCollection)) {
            return false;
        }
        if (!super.equals((IfxGeometry)object)) {
            return false;
        }
        IfxGeometryCollection ifxGeometryCollection = (IfxGeometryCollection)object;
        if (this.f_geometries.length != ifxGeometryCollection.f_geometries.length) {
            return false;
        }
        for (int i = 0; i < this.f_geometries.length; ++i) {
            if (this.f_geometries[i].equals(ifxGeometryCollection.f_geometries[i])) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int numPoints() {
        if (this.f_numPoints == -1) {
            String string = "numPoints";
            Logger logger = Logger.getInstance();
            logger.entering(this.getClass().getName(), string);
            int n = this.calcNumPoints();
            IfxGeometryCollection ifxGeometryCollection = this;
            synchronized (ifxGeometryCollection) {
                if (this.f_numPoints == -1) {
                    this.f_numPoints = n;
                }
            }
            logger.exiting(this.getClass().getName(), string);
        }
        return this.f_numPoints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double area() {
        if (Double.isNaN(this.f_area)) {
            String string = "area";
            Logger logger = Logger.getInstance();
            logger.entering(this.getClass().getName(), string);
            double d = this.calcArea();
            IfxGeometryCollection ifxGeometryCollection = this;
            synchronized (ifxGeometryCollection) {
                if (Double.isNaN(this.f_area)) {
                    this.f_area = d;
                }
            }
            logger.exiting(this.getClass().getName(), string);
        }
        return this.f_area;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Geometry[] toArray() throws SpatialException {
        Geometry[] geometryArray;
        if (!this.isEmpty() && this.f_geometries.length == 0) {
            geometryArray = new IfxGeometry[this.numParts()];
            for (int i = 0; i < geometryArray.length; ++i) {
                geometryArray[i] = this.getGeometryAt(i);
            }
            IfxGeometryCollection ifxGeometryCollection = this;
            synchronized (ifxGeometryCollection) {
                if (this.f_geometries.length == 0) {
                    this.f_geometries = geometryArray;
                }
            }
        }
        geometryArray = new IfxGeometry[this.f_geometries.length];
        System.arraycopy(this.f_geometries, 0, geometryArray, 0, this.f_geometries.length);
        return geometryArray;
    }

    @Override
    public int numParts() {
        return this.f_hetero ? this.f_geometries.length : super.numParts();
    }

    @Override
    public int numSubParts(int n) {
        if (this.f_hetero) {
            if (this.isEmpty()) {
                return 0;
            }
            if (n < 0 || n > this.f_geometries.length - 1) {
                throw new IndexOutOfBoundsException(Integer.toString(n));
            }
            return this.f_geometries[n].numSubParts(0);
        }
        return super.numSubParts(n);
    }

    @Override
    public int numPoints(int n, int n2) {
        if (this.f_hetero) {
            return this.isEmpty() ? 0 : this.f_geometries[n].numPoints(0, n2);
        }
        return super.numPoints(n, n2);
    }

    @Override
    public int toCoordArray(double[] dArray, int n, int n2, int n3, int n4, int n5) {
        if (this.f_hetero) {
            return this.isEmpty() ? 0 : this.f_geometries[n4].toCoordArray(dArray, n, n2, n3, 0, n5);
        }
        return super.toCoordArray(dArray, n, n2, n3, n4, n5);
    }

    @Override
    public int toPointArray(CoordPoint[] coordPointArray, int n, int n2, int n3, int n4) {
        if (this.f_hetero) {
            return this.isEmpty() ? 0 : this.f_geometries[n3].toPointArray(coordPointArray, n, n2, 0, n4);
        }
        return super.toPointArray(coordPointArray, n, n2, n3, n4);
    }

    protected int calcNumPoints() {
        int n = 0;
        if (this.f_hetero) {
            for (int i = 0; i < this.f_geometries.length; ++i) {
                n += this.f_geometries[i].numPoints();
            }
        } else {
            n = this.f_xy.length / 2;
        }
        return n;
    }

    protected double calcArea() {
        double d = 0.0;
        if (this.f_hetero) {
            for (int i = 0; i < this.f_geometries.length; ++i) {
                d += this.f_geometries[i].area();
            }
        } else {
            SpatialManager.unsupported();
        }
        return d;
    }

    @Override
    protected double calcLength() {
        double d = 0.0;
        for (int i = 0; i < this.f_geometries.length; ++i) {
            double d2 = this.f_geometries[i].length();
            if (d2 == 0.0) {
                d2 = this.f_geometries[i].perimeter();
            }
            d += d2;
        }
        return d;
    }

    protected IfxGeometry getGeometryAt(int n) throws SpatialException {
        return this.f_geometries[n];
    }

    protected int calcDimension() {
        int n = -1;
        for (int i = 0; i < this.f_geometries.length; ++i) {
            if (this.f_geometries[i].dimension() > n) {
                n = this.f_geometries[i].dimension();
            }
            if (n == 2) break;
        }
        return n;
    }

    @Override
    protected void coordAsText(StringBuffer stringBuffer) {
        int n;
        stringBuffer.ensureCapacity(8192);
        stringBuffer.append(f_sWKTMultiGeomBegin);
        for (n = 0; n < this.f_geometries.length - 1; ++n) {
            this.f_geometries[n].coordAsText(stringBuffer);
            stringBuffer.append(f_sWKTGeomSeparator);
        }
        if (n == this.f_geometries.length - 1) {
            this.f_geometries[n].coordAsText(stringBuffer);
        }
        stringBuffer.append(f_sWKTMultiGeomEnd);
    }

    @Override
    protected synchronized void checkValid(String string, String string2) throws SpatialException {
        super.checkValid(string, string2);
        SpatialManager.assertSM(this.f_geometries != null && this.f_hetero && (!this.isEmpty() && this.f_geometries.length > 0 || this.isEmpty() && this.f_geometries.length == 0) || !this.f_hetero, string, string2);
    }
}

