/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.spatial.geom;

import com.ibm.spatial.SpatialException;
import com.ibm.spatial.SpatialManager;
import com.ibm.spatial.geom.CoordPoint;
import com.ibm.spatial.geom.GeometryFactory;
import com.ibm.spatial.geom.IfxMultiCoord;
import com.ibm.spatial.geom.IfxPoint;
import com.ibm.spatial.geom.LineString;
import com.ibm.spatial.geom.Point;
import com.ibm.spatial.srs.CoordRef;
import com.ibm.spatial.util.Logger;
import java.util.Iterator;
import java.util.ListIterator;

public class IfxLineString
extends IfxMultiCoord
implements LineString {
    IfxLineString() {
    }

    IfxLineString(CoordRef coordRef, boolean bl) {
        super(coordRef, bl);
    }

    @Override
    public Point pointN(int n) {
        GeometryFactory geometryFactory = GeometryFactory.getInstance(this.f_srs);
        IfxPoint ifxPoint = null;
        try {
            ifxPoint = (IfxPoint)geometryFactory.createPoint(this.getPointAt(n));
        }
        catch (SpatialException spatialException) {
            // empty catch block
        }
        return ifxPoint;
    }

    @Override
    public CoordPoint getPointAt(int n) {
        CoordPoint.Double double_ = this.is3D() || this.isMeasured() ? new CoordPoint.DoubleZM() : new CoordPoint.Double();
        this.getPointAt(double_, n);
        return double_;
    }

    @Override
    public void getPointAt(CoordPoint coordPoint, int n) {
        String string = "getPointAt";
        Logger logger = Logger.getInstance();
        logger.entering(this.getClass().getName(), string);
        if (!(this.isEmpty() || n >= 0 && n < this.f_numPoints)) {
            SpatialManager.indexOutOfRange("index", n, 0, this.f_numPoints - 1, this.getClass().getName(), string);
        }
        if (coordPoint == null) {
            SpatialManager.invalidArg("CoordPoint", "null", this.getClass().getName(), string);
        }
        if (this.isEmpty()) {
            coordPoint.setEmpty();
        } else {
            coordPoint.setCoord(this.f_xy[2 * n], this.f_xy[2 * n + 1]);
            if (this.is3D()) {
                coordPoint.setZ(this.f_z[n]);
            }
            if (this.isMeasured()) {
                coordPoint.setM(this.f_m[n]);
            }
        }
        logger.exiting(this.getClass().getName(), string);
    }

    @Override
    public void startPoint(CoordPoint coordPoint) {
        this.getPointAt(coordPoint, 0);
    }

    @Override
    public void endPoint(CoordPoint coordPoint) {
        this.getPointAt(coordPoint, this.f_numPoints - 1);
    }

    @Override
    public Point startPoint() {
        GeometryFactory geometryFactory = GeometryFactory.getInstance(this.f_srs);
        IfxPoint ifxPoint = null;
        try {
            ifxPoint = (IfxPoint)geometryFactory.createPoint(this.getPointAt(0));
        }
        catch (SpatialException spatialException) {
            // empty catch block
        }
        return ifxPoint;
    }

    @Override
    public Point endPoint() {
        GeometryFactory geometryFactory = GeometryFactory.getInstance(this.f_srs);
        IfxPoint ifxPoint = null;
        try {
            ifxPoint = (IfxPoint)geometryFactory.createPoint(this.getPointAt(this.f_numPoints - 1));
        }
        catch (SpatialException spatialException) {
            // empty catch block
        }
        return ifxPoint;
    }

    @Override
    public boolean isClosed() {
        return this.startPoint().equals(this.endPoint());
    }

    @Override
    public boolean isRing() {
        return this.isClosed() && this.isSimple();
    }

    @Override
    public Point value(double d) {
        CoordPoint coordPoint;
        String string = "value";
        Logger logger = Logger.getInstance();
        logger.entering(this.getClass().getName(), string);
        double d2 = this.length();
        if (d < 0.0 || d > d2) {
            SpatialManager.invalidArg("r", Double.toString(d), this.getClass().getName(), string);
        }
        double d3 = 1.0 / this.f_srs.getXYUnits();
        if (Math.abs(d) < d3) {
            coordPoint = this.getPointAt(0);
        } else if (Math.abs(d - d2) < d3) {
            coordPoint = this.getPointAt(this.f_numPoints - 1);
        } else {
            coordPoint = this.is3D() || this.isMeasured() ? new CoordPoint.DoubleZM() : new CoordPoint.Double();
            if (this.f_segLength == null) {
                this.calcLength();
            }
            for (int i = 0; i < this.f_segLength.length; ++i) {
                if (!((d -= this.f_segLength[i]) <= 0.0)) continue;
                double d4 = d / this.f_segLength[i];
                int n = i * 2;
                coordPoint.setCoord(this.f_xy[n + 2] + d4 * (this.f_xy[n + 2] - this.f_xy[n]), this.f_xy[n + 3] + d4 * (this.f_xy[n + 3] - this.f_xy[n + 1]));
                if (this.is3D()) {
                    coordPoint.setZ(this.f_z[i + 1] + d4 * (this.f_z[i + 1] - this.f_z[i]));
                }
                if (!this.isMeasured()) break;
                coordPoint.setM(this.f_m[i + 1] + d4 * (this.f_m[i + 1] - this.f_m[i]));
                break;
            }
        }
        GeometryFactory geometryFactory = GeometryFactory.getInstance(this.f_srs);
        IfxPoint ifxPoint = null;
        try {
            ifxPoint = (IfxPoint)geometryFactory.createPoint(coordPoint);
        }
        catch (SpatialException spatialException) {
            // empty catch block
        }
        logger.exiting(this.getClass().getName(), string);
        return ifxPoint;
    }

    @Override
    public int dimension() {
        return this.isEmpty() ? -1 : 1;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof IfxLineString)) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public String geometryType() {
        return "LineString";
    }

    @Override
    public double perimeter() {
        return 0.0;
    }

    @Override
    public int numParts() {
        return this.isEmpty() ? 0 : 1;
    }

    @Override
    public int numSubParts(int n) {
        if (this.isEmpty()) {
            return 0;
        }
        if (n != 0) {
            throw new IndexOutOfBoundsException(Integer.toString(n));
        }
        return 1;
    }

    public ListIterator iterator() {
        return this.iterator(0);
    }

    public ListIterator iterator(int n) {
        if (n < 0 || n >= this.f_numPoints - 1) {
            SpatialManager.indexOutOfRange("index", n, 0, this.f_numPoints - 1, this.getClass().getName(), "iterator");
        }
        return new ListItr(n);
    }

    @Override
    protected void calcLabelPoint(CoordPoint coordPoint) {
        double d = this.calcLength();
        int n = this.getLongestSegmentIdx();
        if (n != -1) {
            int n2 = n * 2;
            coordPoint.setCoord((this.f_xy[n2] + this.f_xy[n2 + 2]) / 2.0, (this.f_xy[n2 + 1] + this.f_xy[n2 + 3]) / 2.0);
            if (this.is3D()) {
                coordPoint.setZ((this.f_z[n] + this.f_z[n + 1]) / 2.0);
            }
            if (this.isMeasured()) {
                coordPoint.setM((this.f_m[n] + this.f_m[n + 1]) / 2.0);
            }
        }
    }

    @Override
    protected void coordAsText(StringBuffer stringBuffer) {
        stringBuffer.ensureCapacity(1024);
        this.coordAsText(stringBuffer, 0, 0);
    }

    @Override
    protected double calcLength() {
        return this.calcLength(0, 0);
    }

    private int getLongestSegmentIdx() {
        String string = "getLongestSegmentIdx";
        Logger logger = Logger.getInstance();
        logger.entering(this.getClass().getName(), string);
        int n = -1;
        double d = 0.0;
        for (int i = 0; i < this.f_segLength.length; ++i) {
            if (!(d < this.f_segLength[i])) continue;
            d = this.f_segLength[i];
            n = i;
        }
        logger.exiting(this.getClass().getName(), string);
        return n;
    }

    @Override
    protected int getStartPoint(int n, int n2) {
        return 0;
    }

    @Override
    protected int getEndPoint(int n, int n2) {
        return this.f_numPoints - 1;
    }

    protected class ListItr
    extends Itr
    implements ListIterator {
        ListItr(int n) {
            this.f_cursor = n;
        }

        @Override
        public boolean hasPrevious() {
            return this.f_cursor != 0;
        }

        public Object previous() {
            CoordPoint coordPoint = IfxLineString.this.getPointAt(--this.f_cursor);
            this.f_lastRet = this.f_cursor;
            return coordPoint;
        }

        @Override
        public int nextIndex() {
            return this.f_cursor;
        }

        @Override
        public int previousIndex() {
            return this.f_cursor - 1;
        }

        public void set(Object object) {
            SpatialManager.unsupported();
        }

        public void add(Object object) {
            SpatialManager.unsupported();
        }
    }

    protected class Itr
    implements Iterator {
        int f_cursor = 0;
        int f_lastRet = -1;

        protected Itr() {
        }

        @Override
        public boolean hasNext() {
            return this.f_cursor != IfxLineString.this.numPoints();
        }

        public Object next() {
            CoordPoint coordPoint = IfxLineString.this.getPointAt(this.f_cursor);
            this.f_lastRet = this.f_cursor++;
            return coordPoint;
        }

        @Override
        public void remove() {
            SpatialManager.unsupported();
        }
    }
}

