/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.spatial.geom;

import com.ibm.spatial.SpatialException;
import com.ibm.spatial.SpatialManager;
import com.ibm.spatial.geom.CoordPoint;
import com.ibm.spatial.geom.Envelope;
import com.ibm.spatial.geom.IfxGeometry;
import com.ibm.spatial.srs.CoordRef;
import com.ibm.spatial.util.Logger;

public abstract class IfxMultiCoord
extends IfxGeometry {
    protected double[] f_xy = NULL_DOUBLE_ARRAY;
    protected double[] f_z = NULL_DOUBLE_ARRAY;
    protected double[] f_m = NULL_DOUBLE_ARRAY;
    protected int[] f_partOffsets = null;
    protected int[] f_subPartOffsets = null;
    protected int f_numPoints = 0;
    protected double f_length = Double.NaN;
    protected double f_area = Double.NaN;
    protected double[] f_segLength = null;
    protected CoordPoint.Double f_labelPt = null;

    IfxMultiCoord() {
    }

    IfxMultiCoord(CoordRef coordRef, boolean bl) {
        super(coordRef, bl);
    }

    @Override
    void setCoord(double[] dArray, double[] dArray2, double[] dArray3, int[] nArray, int[] nArray2) {
        if (dArray == null || dArray.length < 2) {
            this.f_m = NULL_DOUBLE_ARRAY;
            this.f_z = NULL_DOUBLE_ARRAY;
            this.f_xy = this.f_z;
            this.f_envelope = EMPTY_ENVELOPE;
            this.f_numPoints = 0;
            this.setEmpty(true);
            this.setHasZ(dArray2 != null);
            this.setHasM(dArray3 != null);
        } else {
            this.f_xy = dArray;
            this.f_z = dArray2 != null ? dArray2 : NULL_DOUBLE_ARRAY;
            this.f_m = dArray3 != null ? dArray3 : NULL_DOUBLE_ARRAY;
            this.f_numPoints = this.f_xy.length / 2;
            this.f_subPartOffsets = nArray2;
            this.f_partOffsets = nArray;
        }
    }

    @Override
    void calcEnvelope() {
        if (this.f_xy == NULL_DOUBLE_ARRAY) {
            this.f_envelope = EMPTY_ENVELOPE;
        } else {
            this.f_envelope = new Envelope.Double();
            this.f_envelope.add(this.f_xy, 0, this.f_numPoints);
            if (this.f_z.length != 0) {
                this.f_envelope.addZ(this.f_z, 0, this.f_z.length);
            }
            if (this.f_m.length != 0) {
                this.f_envelope.addM(this.f_m, 0, this.f_m.length);
            }
        }
    }

    @Override
    void setData(double d, double d2) {
        this.f_length = d;
        this.f_area = d2;
    }

    @Override
    public boolean isEmpty() {
        return this.f_xy.length == 0;
    }

    @Override
    public boolean is3D() {
        return this.isEmpty() ? super.is3D() : this.f_z.length != 0;
    }

    @Override
    public boolean isMeasured() {
        return this.isEmpty() ? super.isMeasured() : this.f_m.length != 0;
    }

    @Override
    public int numPoints() {
        return this.f_numPoints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getLabelPoint(CoordPoint coordPoint) throws SpatialException {
        String string = "getLabelPoint";
        Logger logger = Logger.getInstance();
        logger.entering(this.getClass().getName(), string);
        if (coordPoint == null) {
            SpatialManager.invalidArg("CoordPoint", "null", this.getClass().getName(), string);
        }
        if (this.f_labelPt == null) {
            CoordPoint.Double double_;
            CoordPoint.Double double_2 = double_ = this.is3D() || this.isMeasured() ? new CoordPoint.DoubleZM() : new CoordPoint.Double();
            if (!this.isEmpty()) {
                this.calcLabelPoint(double_);
            }
            IfxMultiCoord ifxMultiCoord = this;
            synchronized (ifxMultiCoord) {
                if (this.f_labelPt == null) {
                    this.f_labelPt = double_;
                }
            }
        }
        coordPoint.setCoord(this.f_labelPt);
        logger.exiting(this.getClass().getName(), string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double length() {
        if (Double.isNaN(this.f_length)) {
            String string = "length";
            Logger logger = Logger.getInstance();
            logger.entering(this.getClass().getName(), string);
            double d = this.isEmpty() ? 0.0 : this.calcLength();
            IfxMultiCoord ifxMultiCoord = this;
            synchronized (ifxMultiCoord) {
                if (Double.isNaN(this.f_length)) {
                    this.f_length = d;
                }
            }
            logger.exiting(this.getClass().getName(), string);
        }
        return this.f_length;
    }

    @Override
    public double perimeter() {
        return this.length();
    }

    @Override
    public boolean equals(Object object) {
        int n;
        if (!super.equals(object)) {
            return false;
        }
        if (!(object instanceof IfxMultiCoord)) {
            return false;
        }
        IfxMultiCoord ifxMultiCoord = (IfxMultiCoord)object;
        if (this.f_xy == ifxMultiCoord.f_xy && this.f_z == ifxMultiCoord.f_z && this.f_m == ifxMultiCoord.f_m) {
            return true;
        }
        if (this.f_numPoints != ifxMultiCoord.f_numPoints) {
            return false;
        }
        double d = 1.0 / this.f_srs.getXYUnits();
        for (int i = 0; i < this.f_numPoints * 2; ++i) {
            if (!(Math.abs(this.f_xy[i] - ifxMultiCoord.f_xy[i]) >= d)) continue;
            return false;
        }
        if (this.f_z.length != ifxMultiCoord.f_z.length) {
            return false;
        }
        double d2 = 1.0 / this.f_srs.getZUnits();
        for (int i = 0; i < this.f_numPoints; ++i) {
            if (!(Math.abs(this.f_z[i] - ifxMultiCoord.f_z[i]) >= d2)) continue;
            return false;
        }
        if (this.f_m.length != ifxMultiCoord.f_m.length) {
            return false;
        }
        double d3 = 1.0 / this.f_srs.getMUnits();
        for (n = 0; n < this.f_numPoints; ++n) {
            if (!(Math.abs(this.f_m[n] - ifxMultiCoord.f_m[n]) >= d3)) continue;
            return false;
        }
        if (this.f_partOffsets.length != ifxMultiCoord.f_partOffsets.length) {
            return false;
        }
        for (n = 0; n < this.f_partOffsets.length; ++n) {
            if (this.f_partOffsets[n] == ifxMultiCoord.f_partOffsets[n]) continue;
            return false;
        }
        if (this.f_subPartOffsets.length != ifxMultiCoord.f_subPartOffsets.length) {
            return false;
        }
        for (n = 0; n < this.f_subPartOffsets.length; ++n) {
            if (this.f_subPartOffsets[n] == ifxMultiCoord.f_subPartOffsets[n]) continue;
            return false;
        }
        return true;
    }

    @Override
    public int numParts() {
        if (this.isEmpty()) {
            return 0;
        }
        return this.f_partOffsets == null ? 1 : this.f_partOffsets.length - 1;
    }

    @Override
    public int numSubParts(int n) {
        if (this.isEmpty()) {
            return 0;
        }
        if (n < 0 || n >= this.numParts()) {
            throw new IndexOutOfBoundsException(Integer.toString(n));
        }
        return this.f_partOffsets == null && n == 0 ? 1 : this.f_partOffsets[n + 1] - this.f_partOffsets[n];
    }

    @Override
    public int numPoints(int n, int n2) {
        if (this.isEmpty()) {
            return 0;
        }
        if (n2 < 0 || n2 >= this.numSubParts(n)) {
            throw new IndexOutOfBoundsException(Integer.toString(n2));
        }
        return this.getEndPoint(n, n2) - this.getStartPoint(n, n2) + 1;
    }

    @Override
    public int toCoordArray(double[] dArray, int n, int n2, int n3, int n4, int n5) {
        int n6;
        int n7 = Integer.MAX_VALUE;
        String string = "toCoordArray";
        Logger logger = Logger.getInstance();
        logger.entering(this.getClass().getName(), string);
        if (dArray == null) {
            SpatialManager.invalidArg("buf", "null", this.getClass().getName(), string);
        }
        if ((n2 & 0xFFFFFFF8) != 0 || n2 == 0) {
            SpatialManager.invalidArg("coordType", n2, this.getClass().getName(), string);
        }
        if (!(this.isEmpty() || n5 >= 0 && n5 < this.numSubParts(n4))) {
            throw new IndexOutOfBoundsException(Integer.toString(n5));
        }
        int n8 = n7;
        int n9 = 0;
        if ((n2 & 1) != 0) {
            n9 += 2;
            n6 = this.f_xy.length / 2;
            if (n8 > n6) {
                n8 = n6;
            }
        }
        if ((n2 & 2) != 0) {
            ++n9;
            if (n8 > this.f_z.length) {
                n8 = this.f_z.length;
            }
        }
        if ((n2 & 4) != 0) {
            ++n9;
            if (n8 > this.f_m.length) {
                n8 = this.f_m.length;
            }
        }
        if (n9 == 0) {
            SpatialManager.invalidArg("coordType", n2, this.getClass().getName(), string);
        }
        n6 = 0;
        int n10 = 0;
        if (n8 > 0) {
            int n11 = (dArray.length - n) / n9;
            if (n8 > n11) {
                n8 = n11;
            }
            n6 = this.getStartPoint(n4, n5);
            n10 = this.getEndPoint(n4, n5);
            n11 = n10 - n6 - n3 + 1;
            if (n8 > n11) {
                n8 = n11;
            }
        }
        if (n8 > 0) {
            double[] dArray2 = null;
            int n12 = n;
            int n13 = n6 + n3;
            if (n2 == 1) {
                dArray2 = this.f_xy;
                n13 *= 2;
            } else if (n2 == 2) {
                dArray2 = this.f_z;
            } else if (n2 == 4) {
                dArray2 = this.f_m;
            }
            if (dArray2 != null) {
                System.arraycopy(dArray2, n13, dArray, n12, n8 * n9);
            } else {
                int n14 = n13 + n8;
                int n15 = n13 * 2;
                if ((n2 & 1) != 0) {
                    if ((n2 & 2) != 0) {
                        if ((n2 & 4) != 0) {
                            while (n13 < n14) {
                                dArray[n12++] = this.f_xy[n15++];
                                dArray[n12++] = this.f_xy[n15++];
                                dArray[n12++] = this.f_z[n13];
                                dArray[n12++] = this.f_m[n13++];
                            }
                        } else {
                            while (n13 < n14) {
                                dArray[n12++] = this.f_xy[n15++];
                                dArray[n12++] = this.f_xy[n15++];
                                dArray[n12++] = this.f_z[n13++];
                            }
                        }
                    } else if ((n2 & 4) != 0) {
                        while (n13 < n14) {
                            dArray[n12++] = this.f_xy[n15++];
                            dArray[n12++] = this.f_xy[n15++];
                            dArray[n12++] = this.f_m[n13++];
                        }
                    }
                } else if ((n2 & 2) != 0 && (n2 & 4) != 0) {
                    while (n13 < n14) {
                        dArray[n12++] = this.f_z[n13];
                        dArray[n12++] = this.f_m[n13++];
                    }
                }
            }
        }
        logger.exiting(this.getClass().getName(), string);
        return n8;
    }

    @Override
    public int toPointArray(CoordPoint[] coordPointArray, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        String string = "toPointArray";
        Logger logger = Logger.getInstance();
        logger.entering(this.getClass().getName(), string);
        if (!(this.isEmpty() || n4 >= 0 && n4 < this.numSubParts(n3))) {
            throw new IndexOutOfBoundsException(Integer.toString(n4));
        }
        int n8 = 0;
        if (!this.isEmpty()) {
            n8 = coordPointArray.length - n;
            n7 = this.getStartPoint(n3, n4);
            n6 = this.getEndPoint(n3, n4);
            n5 = n6 - n7 - n2 + 1;
            if (n8 > n5) {
                n8 = n5;
            }
            n2 += n7;
        }
        if (n8 > 0) {
            n7 = n + n8;
            n6 = n;
            n5 = n2 * 2;
            while (n6 < n7) {
                coordPointArray[n6++].setCoord(this.f_xy[n5++], this.f_xy[n5++]);
            }
            if (this.f_z.length != 0) {
                n6 = n;
                n5 = n2;
                while (n6 < n7) {
                    coordPointArray[n6++].setZ(this.f_z[n5++]);
                }
            }
            if (this.f_m.length != 0) {
                n6 = n;
                n5 = n2;
                while (n6 < n7) {
                    coordPointArray[n6++].setM(this.f_m[n5++]);
                }
            }
        }
        logger.exiting(this.getClass().getName(), string);
        return n8;
    }

    protected void coordAsText(StringBuffer stringBuffer, int n, int n2) {
        int n3;
        if (this.isEmpty()) {
            return;
        }
        boolean bl = this.f_z != null && this.f_z.length > 0;
        boolean bl2 = this.f_m != null && this.f_m.length > 0;
        int n4 = n2;
        if (n2 != -1) {
            stringBuffer.append(f_sWKTCoordBegin);
        } else {
            n4 = 0;
        }
        int n5 = this.getStartPoint(n, n4);
        int n6 = this.getEndPoint(n, n4);
        int n7 = n3 * 2;
        if (bl) {
            if (bl2) {
                for (n3 = n5; n3 < n6; ++n3) {
                    stringBuffer.append(this.f_xy[n7++]).append(f_sWKTCoordSeparator);
                    stringBuffer.append(this.f_xy[n7++]).append(f_sWKTCoordSeparator);
                    stringBuffer.append(this.f_z[n3]).append(f_sWKTCoordSeparator);
                    stringBuffer.append(this.f_m[n3]).append(f_sWKTTupleSeparator);
                }
                if (n3 == n6) {
                    stringBuffer.append(this.f_xy[n7++]).append(f_sWKTCoordSeparator);
                    stringBuffer.append(this.f_xy[n7++]).append(f_sWKTCoordSeparator);
                    stringBuffer.append(this.f_z[n3]).append(f_sWKTCoordSeparator);
                    stringBuffer.append(this.f_m[n3]);
                }
            } else {
                while (n3 < n6) {
                    stringBuffer.append(this.f_xy[n7++]).append(f_sWKTCoordSeparator);
                    stringBuffer.append(this.f_xy[n7++]).append(f_sWKTCoordSeparator);
                    stringBuffer.append(this.f_z[n3]).append(f_sWKTTupleSeparator);
                    ++n3;
                }
                if (n3 == n6) {
                    stringBuffer.append(this.f_xy[n7++]).append(f_sWKTCoordSeparator);
                    stringBuffer.append(this.f_xy[n7++]).append(f_sWKTCoordSeparator);
                    stringBuffer.append(this.f_z[n3]);
                }
            }
        } else if (bl2) {
            while (n3 < n6) {
                stringBuffer.append(this.f_xy[n7++]).append(f_sWKTCoordSeparator);
                stringBuffer.append(this.f_xy[n7++]).append(f_sWKTCoordSeparator);
                stringBuffer.append(this.f_m[n3]).append(f_sWKTTupleSeparator);
                ++n3;
            }
            if (n3 == n6) {
                stringBuffer.append(this.f_xy[n7++]).append(f_sWKTCoordSeparator);
                stringBuffer.append(this.f_xy[n7++]).append(f_sWKTCoordSeparator);
                stringBuffer.append(this.f_m[n3]);
            }
        } else {
            while (n3 < n6) {
                stringBuffer.append(this.f_xy[n7++]).append(f_sWKTCoordSeparator);
                stringBuffer.append(this.f_xy[n7++]).append(f_sWKTTupleSeparator);
                ++n3;
            }
            if (n3 == n6) {
                stringBuffer.append(this.f_xy[n7++]).append(f_sWKTCoordSeparator);
                stringBuffer.append(this.f_xy[n7++]);
            }
        }
        if (n2 != -1) {
            stringBuffer.append(f_sWKTCoordEnd);
        }
    }

    protected abstract double calcLength();

    protected void calcLabelPoint(CoordPoint coordPoint) throws SpatialException {
        this.f_envelope.getCenter(coordPoint);
    }

    protected double calcLength(int n, int n2) {
        double d = 0.0;
        if (this.f_segLength == null) {
            this.f_segLength = new double[this.f_xy.length / 2];
        }
        int n3 = this.getStartPoint(n, n2);
        int n4 = this.getEndPoint(n, n2) - n3;
        int n5 = n3;
        int n6 = 2 * n5;
        while (n5 < n4) {
            double d2 = this.f_xy[n6 + 2] - this.f_xy[n6];
            double d3 = this.f_xy[n6 + 3] - this.f_xy[n6 + 1];
            this.f_segLength[n5] = Math.sqrt(d2 * d2 + d3 * d3);
            d += this.f_segLength[n5];
            ++n5;
            n6 += 2;
        }
        return d;
    }

    protected int getStartPoint(int n, int n2) {
        int n3 = this.f_partOffsets != null ? (this.f_subPartOffsets != null ? this.f_subPartOffsets[this.f_partOffsets[n] + n2] : this.f_partOffsets[n]) : (this.f_subPartOffsets != null ? this.f_subPartOffsets[n2] : 0);
        return n3;
    }

    protected int getEndPoint(int n, int n2) {
        int n3 = this.f_partOffsets != null ? (this.f_subPartOffsets != null ? this.f_subPartOffsets[this.f_partOffsets[n] + n2 + 1] : this.f_partOffsets[n + 1]) : (this.f_subPartOffsets != null ? this.f_subPartOffsets[n2 + 1] : this.f_numPoints);
        return n3 - 1;
    }

    @Override
    protected synchronized void checkValid(String string, String string2) throws SpatialException {
        int n;
        super.checkValid(string, string2);
        int n2 = this.f_xy.length / 2;
        boolean bl = false;
        if (this.f_z.length != 0 && this.f_z.length != n2 || this.f_m.length != 0 && this.f_m.length != n2) {
            bl = true;
        }
        if (this.f_subPartOffsets != null) {
            if (this.f_subPartOffsets.length <= 1) {
                bl = true;
            } else if (this.f_subPartOffsets.length > 1) {
                if (this.f_subPartOffsets[0] < 0 || this.f_subPartOffsets[0] > n2) {
                    bl = true;
                } else {
                    for (n = 1; n < this.f_subPartOffsets.length; ++n) {
                        if (this.f_subPartOffsets[n] > this.f_subPartOffsets[n - 1] && this.f_subPartOffsets[n] <= n2) continue;
                        bl = true;
                        break;
                    }
                }
            }
        }
        if (this.f_partOffsets != null) {
            if (this.f_partOffsets.length <= 1) {
                bl = true;
            } else if (this.f_partOffsets.length > 1) {
                if (this.f_subPartOffsets == null) {
                    if (this.f_partOffsets[0] < 0 || this.f_partOffsets[0] > n2) {
                        bl = true;
                    } else {
                        for (n = 1; n < this.f_partOffsets.length; ++n) {
                            if (this.f_partOffsets[n] > this.f_partOffsets[n - 1] && this.f_partOffsets[n] <= n2) continue;
                            bl = true;
                            break;
                        }
                    }
                } else {
                    n2 = this.f_subPartOffsets.length - 1;
                    if (this.f_partOffsets[0] < 0 || this.f_partOffsets[0] > n2) {
                        bl = true;
                    } else {
                        for (n = 1; n < this.f_partOffsets.length; ++n) {
                            if (this.f_partOffsets[n] > this.f_partOffsets[n - 1] && this.f_partOffsets[n] <= n2) continue;
                            bl = true;
                            break;
                        }
                    }
                }
            }
        }
        if (bl) {
            SpatialManager.reportError(10, string, string2);
        }
    }
}

