/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.spatial.geom;

import com.ibm.spatial.SpatialException;
import com.ibm.spatial.SpatialManager;
import com.ibm.spatial.geom.Geometry;
import com.ibm.spatial.geom.GeometryFactory;
import com.ibm.spatial.geom.IfxGeometry;
import com.ibm.spatial.geom.IfxGeometryCollection;
import com.ibm.spatial.geom.IfxLineString;
import com.ibm.spatial.geom.MultiLineString;
import com.ibm.spatial.srs.CoordRef;
import com.ibm.spatial.util.Logger;

public class IfxMultiLineString
extends IfxGeometryCollection
implements MultiLineString {
    IfxMultiLineString() {
        this.f_hetero = false;
    }

    IfxMultiLineString(CoordRef coordRef, boolean bl) {
        super(coordRef, bl);
        this.f_hetero = false;
    }

    IfxMultiLineString(CoordRef coordRef, Geometry[] geometryArray) throws SpatialException {
        super(coordRef, geometryArray);
        this.f_hetero = false;
    }

    @Override
    void setCoord(Geometry[] geometryArray) throws SpatialException {
        String string = "setCoord";
        double[] dArray = null;
        double[] dArray2 = null;
        double[] dArray3 = null;
        int[] nArray = null;
        if (geometryArray != null && geometryArray.length != 0) {
            try {
                int n;
                int n2 = 0;
                int n3 = geometryArray.length;
                nArray = new int[n3 + 1];
                for (int i = 0; i < n3; ++i) {
                    nArray[i] = n2;
                    n2 += ((IfxGeometry)geometryArray[i]).numPoints();
                }
                nArray[n3] = n2;
                dArray = new double[n2 * 2];
                IfxLineString ifxLineString = (IfxLineString)geometryArray[0];
                dArray2 = ifxLineString.is3D() ? new double[n2] : null;
                dArray3 = ifxLineString.isMeasured() ? new double[n2] : null;
                boolean bl = ifxLineString.isEmpty();
                int n4 = 0;
                for (n = 0; n < geometryArray.length; ++n) {
                    ifxLineString = (IfxLineString)geometryArray[n];
                    n4 += 2 * ifxLineString.toCoordArray(dArray, n4, 1, 0, 0, 0);
                    if (!(ifxLineString.isEmpty() && !bl || !ifxLineString.isEmpty() && bl || ifxLineString.is3D() && dArray2 == null || !ifxLineString.is3D() && dArray2 != null || ifxLineString.isMeasured() && dArray3 == null) && (ifxLineString.isMeasured() || dArray3 == null)) continue;
                    throw new RuntimeException();
                }
                if (dArray2 != null) {
                    n4 = 0;
                    for (n = 0; n < geometryArray.length; ++n) {
                        ifxLineString = (IfxLineString)geometryArray[n];
                        n4 += ifxLineString.toCoordArray(dArray2, n4, 2, 0, 0, 0);
                    }
                }
                if (dArray3 != null) {
                    n4 = 0;
                    for (n = 0; n < geometryArray.length; ++n) {
                        ifxLineString = (IfxLineString)geometryArray[n];
                        n4 += ifxLineString.toCoordArray(dArray3, n4, 4, 0, 0, 0);
                    }
                }
                if (bl) {
                    dArray2 = (double[])(ifxLineString.is3D() ? NULL_DOUBLE_ARRAY : null);
                    dArray3 = (double[])(ifxLineString.isMeasured() ? NULL_DOUBLE_ARRAY : null);
                    geometryArray = null;
                }
            }
            catch (Exception exception) {
                SpatialManager.reportError(10, this.getClass().getName(), string);
            }
        }
        if (geometryArray == null) {
            dArray = null;
            nArray = null;
        }
        super.setCoord(dArray, dArray2, dArray3, nArray, null);
    }

    @Override
    void setData(double d, double d2) {
        this.f_length = d;
        this.f_area = 0.0;
    }

    @Override
    public boolean isClosed() {
        String string = "isClosed";
        Logger logger = Logger.getInstance();
        logger.entering(this.getClass().getName(), string);
        boolean bl = !this.isEmpty();
        for (int i = 0; i < this.f_partOffsets.length - 1 && bl; ++i) {
            double d = this.f_xy[this.f_partOffsets[i]];
            double d2 = this.f_xy[this.f_partOffsets[i] + 1];
            double d3 = this.f_xy[this.f_partOffsets[i + 1] - 2];
            double d4 = this.f_xy[this.f_partOffsets[i + 1] - 1];
            if (d == d3 && d2 == d4) continue;
            bl = false;
        }
        logger.exiting(this.getClass().getName(), string);
        return bl;
    }

    @Override
    public int numGeometries() {
        return this.numParts();
    }

    @Override
    public String geometryType() {
        return "MultiLineString";
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof IfxMultiLineString)) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public double perimeter() {
        return 0.0;
    }

    @Override
    public int numParts() {
        return this.isEmpty() ? 0 : this.f_partOffsets.length - 1;
    }

    @Override
    public int numSubParts(int n) {
        if (this.isEmpty()) {
            return 0;
        }
        if (n < 0 || n >= this.f_partOffsets.length - 1) {
            throw new IndexOutOfBoundsException(Integer.toString(n));
        }
        return 1;
    }

    @Override
    protected double calcArea() {
        return 0.0;
    }

    @Override
    protected double calcLength() {
        int n = this.numParts();
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            d += this.calcLength(i, 0);
        }
        return d;
    }

    @Override
    protected int calcDimension() {
        return this.isEmpty() ? -1 : 1;
    }

    @Override
    protected IfxGeometry getGeometryAt(int n) throws SpatialException {
        int n2 = this.numPoints(n, 0);
        double[] dArray = new double[n2 * 2];
        double[] dArray2 = this.is3D() ? new double[n2] : NULL_DOUBLE_ARRAY;
        double[] dArray3 = this.isMeasured() ? new double[n2] : NULL_DOUBLE_ARRAY;
        this.toCoordArray(dArray, 0, 1, 0, n, 0);
        if (dArray2.length > 0) {
            this.toCoordArray(dArray2, 0, 2, 0, n, 0);
        }
        if (dArray3.length > 0) {
            this.toCoordArray(dArray3, 0, 4, 0, n, 0);
        }
        IfxGeometry ifxGeometry = null;
        try {
            GeometryFactory geometryFactory = GeometryFactory.getInstance(this.f_srs);
            ifxGeometry = (IfxGeometry)geometryFactory.createGeometry("LineString", dArray, dArray2, dArray3, null, null);
        }
        catch (Exception exception) {
            SpatialManager.reportError(exception, this.getClass().getName(), "getGeometryAt");
        }
        return ifxGeometry;
    }

    @Override
    protected void coordAsText(StringBuffer stringBuffer) {
        stringBuffer.ensureCapacity(8192);
        stringBuffer.append(f_sWKTMultiGeomBegin);
        int n = this.numParts() - 1;
        int n2 = 0;
        while (n2 < n) {
            this.coordAsText(stringBuffer, n2++, 0);
            stringBuffer.append(f_sWKTGeomSeparator);
        }
        if (n2 == n) {
            this.coordAsText(stringBuffer, n2, 0);
        }
        stringBuffer.append(f_sWKTMultiGeomEnd);
    }

    @Override
    protected int getStartPoint(int n, int n2) {
        return this.f_partOffsets[n];
    }

    @Override
    protected int getEndPoint(int n, int n2) {
        return this.f_partOffsets[n + 1] - 1;
    }

    @Override
    protected synchronized void checkValid(String string, String string2) throws SpatialException {
        super.checkValid(string, string2);
        SpatialManager.assertSM(!this.f_hetero, string, string2);
    }
}

