/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.spatial.geom;

import com.ibm.spatial.SpatialException;
import com.ibm.spatial.SpatialManager;
import com.ibm.spatial.geom.Geometry;
import com.ibm.spatial.geom.GeometryFactory;
import com.ibm.spatial.geom.IfxGeometry;
import com.ibm.spatial.geom.IfxGeometryCollection;
import com.ibm.spatial.geom.MultiPoint;
import com.ibm.spatial.geom.Point;
import com.ibm.spatial.srs.CoordRef;
import com.ibm.spatial.util.Logger;
import java.util.Vector;

public class IfxMultiPoint
extends IfxGeometryCollection
implements MultiPoint {
    IfxMultiPoint() {
        this.f_hetero = false;
    }

    IfxMultiPoint(CoordRef coordRef, boolean bl) {
        super(coordRef, bl);
        this.f_hetero = false;
    }

    IfxMultiPoint(CoordRef coordRef, Geometry[] geometryArray) throws SpatialException {
        super(coordRef, geometryArray);
        this.f_hetero = false;
    }

    @Override
    void setCoord(Geometry[] geometryArray) throws SpatialException {
        String string = "setCoord";
        double[] dArray = null;
        double[] dArray2 = null;
        double[] dArray3 = null;
        if (geometryArray != null && geometryArray.length != 0) {
            try {
                int n = geometryArray.length;
                dArray = new double[n * 2];
                Point point = (Point)geometryArray[0];
                dArray2 = point.is3D() ? new double[n] : null;
                dArray3 = point.isMeasured() ? new double[n] : null;
                boolean bl = point.isEmpty();
                int n2 = 0;
                for (int i = 0; i < n; ++i) {
                    point = (Point)geometryArray[i];
                    if (point.isEmpty() && !bl || !point.isEmpty() && bl || point.is3D() && dArray2 == null || !point.is3D() && dArray2 != null || point.isMeasured() && dArray3 == null || !point.isMeasured() && dArray3 != null) {
                        throw new RuntimeException();
                    }
                    dArray[n2++] = point.X();
                    dArray[n2++] = point.Y();
                    if (dArray2 != null) {
                        dArray2[i] = point.ordAt(2);
                    }
                    if (dArray3 == null) continue;
                    dArray3[i] = point.ordAt(3);
                }
                if (bl) {
                    dArray2 = (double[])(point.is3D() ? NULL_DOUBLE_ARRAY : null);
                    dArray3 = (double[])(point.isMeasured() ? NULL_DOUBLE_ARRAY : null);
                    geometryArray = null;
                }
            }
            catch (Exception exception) {
                SpatialManager.reportError(10, this.getClass().getName(), string);
            }
        }
        if (geometryArray == null) {
            dArray = null;
        }
        super.setCoord(dArray, dArray2, dArray3, null, null);
    }

    @Override
    void setData(double d, double d2) {
        this.f_length = 0.0;
        this.f_area = 0.0;
    }

    @Override
    public int numGeometries() {
        return this.numPoints();
    }

    @Override
    public String geometryType() {
        return "MultiPoint";
    }

    @Override
    public Geometry locateBetween(double d, double d2) {
        Object object;
        double[] dArray;
        String string = "locateBetween";
        Logger logger = Logger.getInstance();
        logger.entering(this.getClass().getName(), string);
        double[] dArray2 = null;
        double[] dArray3 = (double[])(this.is3D() ? NULL_DOUBLE_ARRAY : null);
        Object object2 = dArray = (Object)(this.isMeasured() ? NULL_DOUBLE_ARRAY : null);
        if (this.isMeasured()) {
            int n;
            int n2;
            object = new Vector(128);
            for (n2 = 0; n2 < this.f_numPoints; ++n2) {
                if (!(this.f_m[n2] >= d) || !(this.f_m[n2] <= d2)) continue;
                ((Vector)object).add(new Integer(n2));
            }
            n2 = ((Vector)object).size();
            dArray2 = new double[n2 * 2];
            dArray = new double[n2];
            int n3 = 0;
            for (n = 0; n < n2; ++n) {
                int n4 = (Integer)((Vector)object).elementAt(n);
                dArray2[n3++] = this.f_xy[n4 * 2];
                dArray2[n3++] = this.f_xy[n4 * 2 + 1];
                dArray[n] = this.f_m[n4];
            }
            if (this.is3D()) {
                dArray3 = new double[n2];
                for (n = 0; n < n2; ++n) {
                    n3 = (Integer)((Vector)object).elementAt(n);
                    dArray3[n] = this.f_z[n3];
                }
            }
        }
        object = GeometryFactory.getInstance(this.f_srs);
        Geometry geometry = null;
        try {
            geometry = ((GeometryFactory)object).initGeometry(new IfxMultiPoint(), dArray2, dArray3, dArray, null, null, null, false);
        }
        catch (SpatialException spatialException) {
            // empty catch block
        }
        logger.exiting(this.getClass().getName(), string);
        return geometry;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof IfxMultiPoint)) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public int numParts() {
        return this.numPoints();
    }

    @Override
    public int numSubParts(int n) {
        if (this.isEmpty()) {
            return 0;
        }
        if (n < 0 || n >= this.numParts()) {
            throw new IndexOutOfBoundsException(Integer.toString(n));
        }
        return 1;
    }

    @Override
    protected double calcArea() {
        return 0.0;
    }

    @Override
    protected double calcLength() {
        return 0.0;
    }

    @Override
    protected int calcDimension() {
        return this.isEmpty() ? -1 : 0;
    }

    @Override
    protected IfxGeometry getGeometryAt(int n) {
        GeometryFactory geometryFactory = GeometryFactory.getInstance(this.f_srs);
        IfxGeometry ifxGeometry = null;
        try {
            ifxGeometry = (IfxGeometry)((Object)geometryFactory.createPoint(this.f_xy[n * 2], this.f_xy[n * 2 + 1], this.f_z.length > n ? this.f_z[n] : Double.NaN, this.f_m.length > n ? this.f_m[n] : Double.NaN));
        }
        catch (SpatialException spatialException) {
            // empty catch block
        }
        return ifxGeometry;
    }

    @Override
    protected void coordAsText(StringBuffer stringBuffer) {
        stringBuffer.ensureCapacity(8192);
        stringBuffer.append(f_sWKTMultiGeomBegin);
        int n = this.numParts() - 1;
        int n2 = 0;
        while (n2 < n) {
            this.coordAsText(stringBuffer, n2++, -1);
            stringBuffer.append(f_sWKTGeomSeparator);
        }
        if (n2 == n) {
            this.coordAsText(stringBuffer, n2, -1);
        }
        stringBuffer.append(f_sWKTMultiGeomEnd);
    }

    @Override
    protected int getStartPoint(int n, int n2) {
        return n;
    }

    @Override
    protected int getEndPoint(int n, int n2) {
        return n;
    }

    @Override
    protected synchronized void checkValid(String string, String string2) throws SpatialException {
        super.checkValid(string, string2);
        SpatialManager.assertSM(!this.f_hetero && this.f_partOffsets == null && this.f_subPartOffsets == null, string, string2);
    }
}

