/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.spatial.geom;

import com.ibm.spatial.SpatialException;
import com.ibm.spatial.SpatialManager;
import com.ibm.spatial.geom.Geometry;
import com.ibm.spatial.geom.GeometryFactory;
import com.ibm.spatial.geom.IfxGeometry;
import com.ibm.spatial.geom.IfxGeometryCollection;
import com.ibm.spatial.geom.IfxPolygon;
import com.ibm.spatial.geom.MultiPolygon;
import com.ibm.spatial.geom.Point;
import com.ibm.spatial.srs.CoordRef;
import com.ibm.spatial.util.Logger;

public class IfxMultiPolygon
extends IfxGeometryCollection
implements MultiPolygon {
    IfxMultiPolygon() {
        this.f_hetero = false;
    }

    IfxMultiPolygon(CoordRef coordRef, boolean bl) {
        super(coordRef, bl);
        this.f_hetero = false;
    }

    IfxMultiPolygon(CoordRef coordRef, Geometry[] geometryArray) throws SpatialException {
        super(coordRef, geometryArray);
        this.f_hetero = false;
    }

    @Override
    void setCoord(Geometry[] geometryArray) throws SpatialException {
        String string = "setCoord";
        double[] dArray = null;
        double[] dArray2 = null;
        double[] dArray3 = null;
        int[] nArray = null;
        int[] nArray2 = null;
        if (geometryArray != null && geometryArray.length != 0) {
            try {
                int n;
                nArray = new int[geometryArray.length + 1];
                int n2 = 0;
                int n3 = 0;
                while (n3 < geometryArray.length) {
                    nArray[n3] = n2;
                    n2 += ((IfxPolygon)geometryArray[n3++]).numSubParts(0);
                }
                nArray[n3] = n2;
                nArray2 = new int[n2 + 1];
                int n4 = 0;
                int n5 = 0;
                for (n3 = 0; n3 < geometryArray.length; ++n3) {
                    int n6 = nArray[n3 + 1] - nArray[n3];
                    n = 0;
                    while (n < n6) {
                        nArray2[n5] = n4;
                        n4 += ((IfxPolygon)geometryArray[n3]).numPoints(0, n);
                        ++n;
                        ++n5;
                    }
                }
                nArray2[n5] = n4;
                dArray = new double[n4 * 2];
                IfxPolygon ifxPolygon = (IfxPolygon)geometryArray[0];
                dArray2 = ifxPolygon.is3D() ? new double[n4] : null;
                dArray3 = ifxPolygon.isMeasured() ? new double[n4] : null;
                n = ifxPolygon.isEmpty() ? 1 : 0;
                int n7 = 0;
                for (n3 = 0; n3 < geometryArray.length; ++n3) {
                    ifxPolygon = (IfxPolygon)geometryArray[n3];
                    n2 = ifxPolygon.numSubParts(0);
                    for (n5 = 0; n5 < n2; ++n5) {
                        n7 += 2 * ifxPolygon.toCoordArray(dArray, n7, 1, 0, 0, n5);
                    }
                    if (!(ifxPolygon.isEmpty() && n == 0 || !ifxPolygon.isEmpty() && n != 0 || ifxPolygon.is3D() && dArray2 == null || !ifxPolygon.is3D() && dArray2 != null || ifxPolygon.isMeasured() && dArray3 == null) && (ifxPolygon.isMeasured() || dArray3 == null)) continue;
                    throw new RuntimeException();
                }
                if (dArray2 != null) {
                    n7 = 0;
                    for (n3 = 0; n3 < geometryArray.length; ++n3) {
                        ifxPolygon = (IfxPolygon)geometryArray[n3];
                        n2 = ifxPolygon.numSubParts(0);
                        for (n5 = 0; n5 < n2; ++n5) {
                            n7 += ifxPolygon.toCoordArray(dArray2, n7, 2, 0, 0, n5);
                        }
                    }
                }
                if (dArray3 != null) {
                    n7 = 0;
                    for (n3 = 0; n3 < geometryArray.length; ++n3) {
                        ifxPolygon = (IfxPolygon)geometryArray[n3];
                        n2 = ifxPolygon.numSubParts(0);
                        for (n5 = 0; n5 < n2; ++n5) {
                            n7 += ifxPolygon.toCoordArray(dArray3, n7, 4, 0, 0, n5);
                        }
                    }
                }
                if (n != 0) {
                    dArray2 = (double[])(ifxPolygon.is3D() ? NULL_DOUBLE_ARRAY : null);
                    dArray3 = (double[])(ifxPolygon.isMeasured() ? NULL_DOUBLE_ARRAY : null);
                    geometryArray = null;
                }
            }
            catch (Exception exception) {
                SpatialManager.reportError(10, this.getClass().getName(), string);
            }
        }
        if (geometryArray == null) {
            dArray = null;
            nArray = null;
            nArray2 = null;
        }
        super.setCoord(dArray, dArray2, dArray3, nArray, nArray2);
    }

    @Override
    void setData(double d, double d2) {
        this.f_length = d;
        this.f_area = d2;
    }

    @Override
    public Point centroid() throws SpatialException {
        String string = "centroid";
        Logger logger = Logger.getInstance();
        logger.entering(this.getClass().getName(), string);
        GeometryFactory geometryFactory = GeometryFactory.getInstance(this.f_srs);
        Point point = geometryFactory.createPoint(this.getLabelPoint());
        logger.exiting(this.getClass().getName(), string);
        return point;
    }

    @Override
    public Point pointOnSurface() throws SpatialException {
        Point point;
        String string = "pointOnSurface";
        Logger logger = Logger.getInstance();
        logger.entering(this.getClass().getName(), string);
        if (!this.isEmpty()) {
            IfxPolygon ifxPolygon = (IfxPolygon)this.geometryN(0);
            point = ifxPolygon.pointOnSurface();
        } else {
            GeometryFactory geometryFactory = GeometryFactory.getInstance(this.f_srs);
            point = geometryFactory.createPoint(null);
        }
        logger.exiting(this.getClass().getName(), string);
        return point;
    }

    @Override
    public String geometryType() {
        return "MultiPolygon";
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof IfxMultiPolygon)) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public double length() {
        return 0.0;
    }

    @Override
    public double perimeter() {
        return super.length();
    }

    @Override
    public int numParts() {
        return this.isEmpty() ? 0 : this.f_partOffsets.length - 1;
    }

    @Override
    public int numSubParts(int n) {
        if (this.isEmpty()) {
            return 0;
        }
        if (n < 0 || n >= this.f_partOffsets.length - 1) {
            throw new IndexOutOfBoundsException(Integer.toString(n));
        }
        return this.f_partOffsets[n + 1] - this.f_partOffsets[n];
    }

    @Override
    protected double calcArea() {
        if (this.isEmpty()) {
            return 0.0;
        }
        SpatialManager.unsupported();
        return Double.NaN;
    }

    @Override
    protected double calcLength() {
        int n = this.numParts();
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            int n2 = this.numSubParts(i);
            int n3 = 0;
            while (i < n2) {
                d += this.calcLength(i, n3);
                ++n3;
            }
        }
        return d;
    }

    @Override
    protected int calcDimension() {
        return this.isEmpty() ? -1 : 2;
    }

    @Override
    protected IfxGeometry getGeometryAt(int n) throws SpatialException {
        int n2 = this.numSubParts(n);
        int[] nArray = new int[n2 + 1];
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            nArray[n4] = n3;
            n3 += this.numPoints(n, n4++);
        }
        nArray[n4] = n3;
        double[] dArray = new double[n3 * 2];
        double[] dArray2 = this.is3D() ? new double[n3] : NULL_DOUBLE_ARRAY;
        double[] dArray3 = this.isMeasured() ? new double[n3] : NULL_DOUBLE_ARRAY;
        int n5 = 0;
        for (n4 = 0; n4 < n2; ++n4) {
            n5 += 2 * this.toCoordArray(dArray, n5, 1, 0, n, n4);
        }
        if (dArray2.length > 0) {
            n5 = 0;
            for (n4 = 0; n4 < n2; ++n4) {
                n5 += this.toCoordArray(dArray2, n5, 2, 0, n, n4);
            }
        }
        if (dArray3.length > 0) {
            n5 = 0;
            for (n4 = 0; n4 < n2; ++n4) {
                n5 += this.toCoordArray(dArray3, n5, 4, 0, n, n4);
            }
        }
        IfxGeometry ifxGeometry = null;
        try {
            GeometryFactory geometryFactory = GeometryFactory.getInstance(this.f_srs);
            ifxGeometry = (IfxGeometry)geometryFactory.createGeometry("Polygon", dArray, dArray2, dArray3, null, nArray);
        }
        catch (Exception exception) {
            SpatialManager.reportError(exception, this.getClass().getName(), "getGeometryAt");
        }
        return ifxGeometry;
    }

    @Override
    protected void coordAsText(StringBuffer stringBuffer) {
        stringBuffer.ensureCapacity(8192);
        stringBuffer.append(f_sWKTMultiGeomBegin);
        int n = this.numParts();
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3 = this.numSubParts(i) - 1;
            stringBuffer.append(f_sWKTPolyBegin);
            for (n2 = 0; n2 < n3; ++n2) {
                this.coordAsText(stringBuffer, i, n2);
                stringBuffer.append(f_sWKTGeomSeparator);
            }
            if (n2 == n3) {
                this.coordAsText(stringBuffer, i, n2);
            }
            stringBuffer.append(f_sWKTPolyEnd);
            if (i >= n - 1) continue;
            stringBuffer.append(f_sWKTGeomSeparator);
        }
        stringBuffer.append(f_sWKTMultiGeomEnd);
    }

    @Override
    protected int getStartPoint(int n, int n2) {
        return this.f_subPartOffsets[this.f_partOffsets[n] + n2];
    }

    @Override
    protected int getEndPoint(int n, int n2) {
        return this.f_subPartOffsets[this.f_partOffsets[n] + n2 + 1] - 1;
    }

    @Override
    protected synchronized void checkValid(String string, String string2) throws SpatialException {
        super.checkValid(string, string2);
        SpatialManager.assertSM(!this.f_hetero, string, string2);
    }
}

