/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.spatial.geom;

import com.ibm.spatial.SpatialException;
import com.ibm.spatial.SpatialManager;
import com.ibm.spatial.geom.CoordPoint;
import com.ibm.spatial.geom.Envelope;
import com.ibm.spatial.geom.IfxGeometry;
import com.ibm.spatial.geom.Point;
import com.ibm.spatial.srs.CoordRef;
import com.ibm.spatial.util.Logger;

public class IfxPoint
extends IfxGeometry
implements Point {
    protected CoordPoint f_pt;

    IfxPoint() {
    }

    IfxPoint(CoordRef coordRef, double d, double d2) {
        super(coordRef, true);
        this.f_envelope.setExtent(d, d2, d, d2);
        this.f_pt = new CoordPoint.Double(d, d2);
    }

    IfxPoint(CoordRef coordRef, double d, double d2, double d3, double d4) {
        super(coordRef, true);
        this.f_envelope.setExtent(d, d2, d, d2);
        this.f_envelope.setExtentZ(d3, d3);
        this.f_envelope.setExtentM(d4, d4);
        this.f_pt = new CoordPoint.DoubleZM(d, d2, d3, d4);
    }

    IfxPoint(CoordRef coordRef, CoordPoint coordPoint) {
        super(coordRef, coordPoint != null);
        if (coordPoint != null) {
            this.f_envelope.add(coordPoint);
            this.f_pt = coordPoint;
        } else {
            this.f_pt = EMPTY_POINT;
        }
    }

    @Override
    void calcEnvelope() {
        if (this.f_pt == EMPTY_POINT || this.f_pt.isEmpty()) {
            this.f_envelope = EMPTY_ENVELOPE;
        } else {
            this.f_envelope = new Envelope.Double();
            this.f_envelope.setExtent(this.f_pt.getX(), this.f_pt.getY(), this.f_pt.getX(), this.f_pt.getY());
            this.f_envelope.setExtentZ(this.f_pt.getZ(), this.f_pt.getZ());
            this.f_envelope.setExtentM(this.f_pt.getM(), this.f_pt.getM());
        }
    }

    @Override
    void setCoord(double[] dArray, double[] dArray2, double[] dArray3, int[] nArray, int[] nArray2) {
        if (dArray == null || dArray.length < 2) {
            this.f_pt = EMPTY_POINT;
            this.f_envelope = EMPTY_ENVELOPE;
            this.setEmpty(true);
            this.setHasZ(dArray2 != null);
            this.setHasM(dArray3 != null);
        } else {
            boolean bl = dArray2 != null && dArray2.length != 0;
            boolean bl2 = dArray3 != null && dArray3.length != 0;
            double d = bl ? dArray2[0] : Double.NaN;
            double d2 = bl2 ? dArray3[0] : Double.NaN;
            this.f_pt = bl || bl2 ? new CoordPoint.DoubleZM(dArray[0], dArray[1], d, d2) : new CoordPoint.Double(dArray[0], dArray[1]);
        }
    }

    @Override
    public double X() {
        return this.f_pt.getX();
    }

    @Override
    public double Y() {
        return this.f_pt.getY();
    }

    @Override
    public double ordAt(int n) {
        return this.f_pt.getCoordAt(n);
    }

    @Override
    public int dimension() {
        return this.isEmpty() ? -1 : 0;
    }

    @Override
    public String geometryType() {
        return "Point";
    }

    @Override
    public boolean isEmpty() {
        return this.f_pt == null || this.f_pt == EMPTY_POINT || this.f_pt.isEmpty();
    }

    @Override
    public boolean is3D() {
        return this.isEmpty() ? super.is3D() : this.f_pt.hasZ();
    }

    @Override
    public boolean isMeasured() {
        return this.isEmpty() ? super.isMeasured() : this.f_pt.hasM();
    }

    @Override
    public boolean isSimple() {
        return true;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof IfxPoint)) {
            return false;
        }
        if (!super.equals((IfxGeometry)object)) {
            return false;
        }
        return this.f_pt.equals(((IfxPoint)object).f_pt, 1.0 / this.f_srs.getXYUnits(), 1.0 / this.f_srs.getZUnits(), 1.0 / this.f_srs.getMUnits());
    }

    @Override
    public int numPoints() {
        return this.isEmpty() ? 0 : 1;
    }

    @Override
    public void getLabelPoint(CoordPoint coordPoint) {
        String string = "getLabelPoint";
        Logger logger = Logger.getInstance();
        logger.entering(this.getClass().getName(), string);
        this.toCoordPoint(coordPoint);
        logger.exiting(this.getClass().getName(), string);
    }

    @Override
    protected void coordAsText(StringBuffer stringBuffer) {
        stringBuffer.append(f_sWKTCoordBegin);
        stringBuffer.append(this.X()).append(f_sWKTCoordSeparator).append(this.Y());
        if (this.is3D()) {
            stringBuffer.append(f_sWKTCoordSeparator).append(this.Z());
        }
        if (this.isMeasured()) {
            stringBuffer.append(f_sWKTCoordSeparator).append(this.M());
        }
        stringBuffer.append(f_sWKTCoordEnd);
    }

    public double M() {
        return this.f_pt.getM();
    }

    public double Z() {
        return this.f_pt.getZ();
    }

    public CoordPoint toCoordPoint() {
        return (CoordPoint)this.f_pt.clone();
    }

    public void toCoordPoint(CoordPoint coordPoint) {
        coordPoint.setCoord(this.f_pt);
    }

    @Override
    public int numParts() {
        return this.isEmpty() ? 0 : 1;
    }

    @Override
    public int numSubParts(int n) {
        if (this.isEmpty()) {
            return 0;
        }
        if (n != 0) {
            throw new IndexOutOfBoundsException(Integer.toString(n));
        }
        return 1;
    }

    @Override
    public int numPoints(int n, int n2) {
        if (this.isEmpty()) {
            return 0;
        }
        if (n != 0 || n2 != 0) {
            throw new IndexOutOfBoundsException(Integer.toString(n != 0 ? n : n2));
        }
        return 1;
    }

    @Override
    public int toCoordArray(double[] dArray, int n, int n2, int n3, int n4, int n5) {
        String string = "toCoordArray";
        Logger logger = Logger.getInstance();
        logger.entering(this.getClass().getName(), string);
        if (dArray == null) {
            SpatialManager.invalidArg("buf", "null", this.getClass().getName(), string);
        }
        if ((n2 & 0xFFFFFFF8) != 0 || n2 == 0) {
            SpatialManager.invalidArg("coordType", n2, this.getClass().getName(), string);
        }
        int n6 = 0;
        if (!this.isEmpty()) {
            if (n4 != 0 || n5 != 0) {
                throw new IndexOutOfBoundsException(Integer.toString(n4 != 0 ? n4 : n5));
            }
            if (n3 == 0) {
                CoordPoint.Double double_ = (CoordPoint.Double)this.f_pt;
                int n7 = n;
                if ((n2 & 1) != 0) {
                    dArray[n7++] = double_.x;
                    dArray[n7++] = double_.y;
                }
                if ((n2 & 2) != 0) {
                    dArray[n7++] = double_.getZ();
                }
                if ((n2 & 4) != 0) {
                    dArray[n7++] = double_.getM();
                }
                n6 = 1;
            }
        }
        logger.exiting(this.getClass().getName(), string);
        return n6;
    }

    @Override
    public int toPointArray(CoordPoint[] coordPointArray, int n, int n2, int n3, int n4) {
        String string = "toPointArray";
        Logger logger = Logger.getInstance();
        logger.entering(this.getClass().getName(), string);
        if (coordPointArray == null) {
            SpatialManager.invalidArg("pointArray", "null", this.getClass().getName(), string);
        }
        int n5 = 0;
        if (!this.isEmpty()) {
            if (n3 != 0 || n4 != 0) {
                throw new IndexOutOfBoundsException(Integer.toString(n3 != 0 ? n3 : n4));
            }
            if (n2 == 0 && coordPointArray.length >= 1) {
                coordPointArray[n].setCoord(this.f_pt);
                n5 = 1;
            }
        }
        logger.exiting(this.getClass().getName(), string);
        return n5;
    }

    @Override
    protected synchronized void checkValid(String string, String string2) throws SpatialException {
        super.checkValid(string, string2);
        SpatialManager.assertSM(this.f_pt != null, string, string2);
        if (Double.isNaN(this.f_pt.getX()) ^ Double.isNaN(this.f_pt.getY())) {
            SpatialManager.reportError(10, this.getClass().getName(), "checkValid");
        }
    }
}

