/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.spatial.geom;

import com.ibm.spatial.SpatialException;
import com.ibm.spatial.SpatialManager;
import com.ibm.spatial.geom.CoordPoint;
import com.ibm.spatial.geom.GeometryFactory;
import com.ibm.spatial.geom.IfxLineString;
import com.ibm.spatial.geom.IfxSurface;
import com.ibm.spatial.geom.LineString;
import com.ibm.spatial.geom.Polygon;
import com.ibm.spatial.srs.CoordRef;
import com.ibm.spatial.util.Logger;

public class IfxPolygon
extends IfxSurface
implements Polygon {
    IfxPolygon() {
        this.f_numPoints = -1;
    }

    IfxPolygon(CoordRef coordRef, boolean bl) {
        super(coordRef, bl);
        this.f_numPoints = -1;
    }

    @Override
    public LineString exteriorRing() {
        String string = "exteriorRing";
        Logger logger = Logger.getInstance();
        logger.entering(this.getClass().getName(), string);
        LineString lineString = this.getRingAt(0, string);
        logger.exiting(this.getClass().getName(), string);
        return lineString;
    }

    @Override
    public LineString interiorRingN(int n) {
        String string = "interiorRingN";
        Logger logger = Logger.getInstance();
        logger.entering(this.getClass().getName(), string);
        LineString lineString = this.getRingAt(n + 1, string);
        logger.exiting(this.getClass().getName(), string);
        return lineString;
    }

    @Override
    public int numInteriorRings() {
        return this.isEmpty() ? 0 : this.numSubParts(0) - 1;
    }

    @Override
    public double area() {
        if (Double.isNaN(this.f_area)) {
            if (this.isEmpty()) {
                this.f_area = 0.0;
            } else {
                SpatialManager.unsupported();
            }
        }
        return this.f_area;
    }

    @Override
    public String geometryType() {
        return "Polygon";
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof IfxPolygon)) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public int numParts() {
        return this.isEmpty() ? 0 : 1;
    }

    @Override
    public int numSubParts(int n) {
        if (this.isEmpty()) {
            return 0;
        }
        if (n != 0) {
            throw new IndexOutOfBoundsException(Integer.toString(n));
        }
        return this.f_subPartOffsets.length - 1;
    }

    @Override
    protected void calcLabelPoint(CoordPoint coordPoint) throws SpatialException {
        double d = (this.f_envelope.getMinX() + this.f_envelope.getMaxX()) / 2.0;
        double d2 = IfxPolygon.calcYPCentroid(d, this.f_xy, 0, this.f_subPartOffsets[1]);
        if (d2 == Double.MAX_VALUE) {
            SpatialManager.reportError(10, this.getClass().getName(), "calcLabelPoint");
        }
        coordPoint.setCoord(d, d2);
    }

    @Override
    protected double calcLength() {
        double d = 0.0;
        int n = this.f_subPartOffsets.length - 1;
        for (int i = 0; i < n; ++i) {
            d += this.calcLength(0, i);
        }
        return d;
    }

    protected static double calcYPCentroid(double d, double[] dArray, int n, int n2) {
        double[] dArray2 = new double[]{Double.MAX_VALUE, Double.MAX_VALUE};
        n2 *= 2;
        int n3 = n *= 2;
        int n4 = n + 2;
        int n5 = n + 1;
        for (int i = n + 3; i < n2; i += 2) {
            if (!(dArray[n3] <= d && dArray[n4] <= d || dArray[n3] > d && dArray[n4] > d)) {
                int n6;
                double d2 = dArray[n4] - dArray[n3];
                double d3 = dArray[i] - dArray[n5];
                double d4 = d - dArray[n3];
                double d5 = dArray[n5] + d4 * d3 / d2;
                int n7 = n6 = dArray2[0] > dArray2[1] ? 0 : 1;
                if (d5 < dArray2[n6]) {
                    dArray2[n6] = d5;
                }
            }
            n3 += 2;
            n5 += 2;
            n4 += 2;
        }
        if (dArray2[0] != Double.MAX_VALUE && dArray2[1] != Double.MAX_VALUE) {
            return (dArray2[0] + dArray2[1]) / 2.0;
        }
        return Double.MAX_VALUE;
    }

    private LineString getRingAt(int n, String string) {
        double[] dArray;
        double[] dArray2;
        double[] dArray3;
        if (this.isEmpty()) {
            dArray3 = null;
            dArray2 = (double[])(this.is3D() ? NULL_DOUBLE_ARRAY : null);
            dArray = (double[])(this.isMeasured() ? NULL_DOUBLE_ARRAY : null);
        } else {
            if (n >= this.f_subPartOffsets.length - 1) {
                SpatialManager.indexOutOfRange("index", n, 0, this.f_subPartOffsets.length - 1, this.getClass().getName(), string);
            }
            int n2 = this.f_subPartOffsets[n + 1] - this.f_subPartOffsets[n];
            int n3 = this.getStartPoint(0, n);
            int n4 = this.getEndPoint(0, n) + 1;
            dArray3 = new double[n2 * 2];
            System.arraycopy(this.f_xy, n3 * 2, dArray3, 0, (n4 - n3) * 2);
            if (this.is3D()) {
                dArray2 = new double[n2];
                System.arraycopy(this.f_z, n3, dArray2, 0, n4 - n3);
            } else {
                dArray2 = null;
            }
            if (this.isMeasured()) {
                dArray = new double[n2];
                System.arraycopy(this.f_m, n3, dArray, 0, n4 - n3);
            } else {
                dArray = null;
            }
        }
        GeometryFactory geometryFactory = GeometryFactory.getInstance(this.f_srs);
        IfxLineString ifxLineString = null;
        try {
            ifxLineString = (IfxLineString)geometryFactory.initGeometry(new IfxLineString(), dArray3, dArray2, dArray, null, null, null, false);
        }
        catch (SpatialException spatialException) {
            // empty catch block
        }
        return ifxLineString;
    }

    @Override
    protected void coordAsText(StringBuffer stringBuffer) {
        stringBuffer.ensureCapacity(8192);
        stringBuffer.append(f_sWKTPolyBegin);
        int n = this.f_subPartOffsets.length - 2;
        int n2 = 0;
        while (n2 < n) {
            this.coordAsText(stringBuffer, 0, n2++);
            stringBuffer.append(f_sWKTRingSeparator);
        }
        if (n2 == n) {
            this.coordAsText(stringBuffer, 0, n2);
        }
        stringBuffer.append(f_sWKTPolyEnd);
    }

    @Override
    protected int getStartPoint(int n, int n2) {
        return this.f_subPartOffsets[n2];
    }

    @Override
    protected int getEndPoint(int n, int n2) {
        return this.f_subPartOffsets[n2 + 1] - 1;
    }

    @Override
    protected synchronized void checkValid(String string, String string2) throws SpatialException {
        super.checkValid(string, string2);
        if (this.f_xy != NULL_DOUBLE_ARRAY && (this.f_partOffsets != null || this.f_subPartOffsets == null || this.f_subPartOffsets.length <= 1)) {
            SpatialManager.reportError(10, string, string2);
        }
    }
}

