/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.spatial.io;

import com.ibm.spatial.SpatialException;
import com.ibm.spatial.SpatialManager;
import com.ibm.spatial.geom.Geometry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

public abstract class GeometryReader {
    protected Object f_input = null;
    protected boolean f_seekForwardOnly = false;
    protected int f_minIndex = 0;
    private boolean f_abort = false;

    protected GeometryReader() {
        this.reset();
    }

    public void reset() {
        this.setInput(null, false);
    }

    public void dispose() {
    }

    public String getFormatName() {
        return "";
    }

    public int getMinIndex() {
        return 0;
    }

    public int getNumGeometries() {
        return 1;
    }

    public boolean isSeekForwardOnly() {
        return this.f_seekForwardOnly;
    }

    public boolean ready() throws IOException {
        return true;
    }

    public Geometry read(int n) throws IOException, SpatialException {
        return this.read(n, null);
    }

    public abstract Geometry read(int var1, Object[] var2) throws IOException, SpatialException;

    public Iterator readAll(Object[] objectArray) throws IOException, SpatialException {
        ArrayList<Geometry> arrayList = new ArrayList<Geometry>();
        int n = this.getMinIndex();
        Geometry geometry = this.read(n, objectArray);
        while (geometry != null) {
            arrayList.add(geometry);
            ++n;
        }
        return arrayList.iterator();
    }

    public void setInput(Object object, boolean bl) {
        if (object != null) {
            boolean bl2 = false;
            if (!bl2) {
                throw new IllegalArgumentException();
            }
            this.f_seekForwardOnly = bl;
            this.f_minIndex = 0;
        }
        this.f_input = object;
    }

    public void setInput(Object object) {
        this.setInput(object, false);
    }

    public Object getInput() {
        return this.f_input;
    }

    public synchronized void abort() {
        this.f_abort = true;
    }

    protected synchronized boolean abortFlag() {
        return this.f_abort;
    }

    protected synchronized void clearAbortFlag() {
        this.f_abort = false;
    }

    protected void unsupported() throws SpatialException {
        if (this.getInput() == null) {
            SpatialManager.reportError(new IllegalStateException(), null, null);
        }
        SpatialManager.unsupported();
    }
}

