/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.spatial.io;

import com.ibm.spatial.SpatialException;
import com.ibm.spatial.SpatialManager;
import com.ibm.spatial.geom.Geometry;
import java.io.IOException;

public abstract class GeometryWriter {
    protected Object f_output = null;
    private boolean f_abort = false;

    protected GeometryWriter() {
        this.reset();
    }

    public void reset() {
        this.setOutput(null);
    }

    public void dispose() {
    }

    public String getFormatName() throws IOException {
        return "";
    }

    public abstract void write(Geometry var1, Object[] var2) throws IOException, SpatialException;

    public void write(Geometry geometry) throws IOException, SpatialException {
        this.write(geometry, null);
    }

    public boolean canInsert(int n) throws IOException {
        if (this.getOutput() == null) {
            throw new IllegalStateException();
        }
        return false;
    }

    public void write(int n, Geometry geometry, Object[] objectArray) throws IOException, SpatialException {
        this.unsupported();
    }

    public void setOutput(Object object) {
        boolean bl;
        if (object != null && !(bl = false)) {
            throw new IllegalArgumentException();
        }
        this.f_output = object;
    }

    public Object getOutput() {
        return this.f_output;
    }

    public synchronized void abort() {
        this.f_abort = true;
    }

    protected synchronized boolean abortFlag() {
        return this.f_abort;
    }

    protected synchronized void clearAbortFlag() {
        this.f_abort = false;
    }

    protected void unsupported() throws SpatialException {
        if (this.getOutput() == null) {
            SpatialManager.reportError(new IllegalStateException(), null, null);
        }
        SpatialManager.unsupported();
    }
}

