/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.spatial.io;

import com.ibm.spatial.SpatialException;
import com.ibm.spatial.SpatialManager;
import com.ibm.spatial.geom.Envelope;
import com.ibm.spatial.geom.Geometry;
import com.ibm.spatial.geom.GeometryFactory;
import com.ibm.spatial.geom.IfxGeometry;
import com.ibm.spatial.geom.IfxPoint;
import com.ibm.spatial.geom.IfxSQLGeometryFactory;
import com.ibm.spatial.io.GeometryReader;
import com.ibm.spatial.io.IfxSQLShape;
import com.ibm.spatial.srs.CoordRef;
import com.ibm.spatial.srs.CoordRefManager;
import com.ibm.spatial.util.Logger;
import com.informix.jdbc.IfmxUDTSQLInput;
import java.io.IOException;
import java.sql.SQLInput;

class IfxSQLGeometryReader
extends GeometryReader {
    @Override
    public String getFormatName() {
        return "IfxSQL";
    }

    @Override
    public void setInput(Object object, boolean bl) {
        if (object != null && !(object instanceof SQLInput) || bl) {
            throw new IllegalArgumentException();
        }
        this.f_seekForwardOnly = bl;
        this.f_minIndex = 0;
        this.f_input = object;
    }

    @Override
    public Geometry read(int n, Object[] objectArray) throws IOException, SpatialException {
        String string = "read";
        Logger logger = Logger.getInstance();
        logger.entering(this.getClass().getName(), string);
        IfxGeometry ifxGeometry = null;
        try {
            Object[] objectArray2;
            IfmxUDTSQLInput ifmxUDTSQLInput = (IfmxUDTSQLInput)this.f_input;
            IfxSQLShape ifxSQLShape = new IfxSQLShape();
            ifxSQLShape.setFlags(ifmxUDTSQLInput.readInt());
            int n2 = ifxSQLShape.getVersion();
            if (n2 != 0) {
                Object[] objectArray3 = new Object[]{this.getFormatName(), new Integer(n2)};
                SpatialManager.reportError(14, objectArray3, this.getClass().getName(), string);
            }
            boolean bl = ifxSQLShape.hasZ();
            boolean bl2 = ifxSQLShape.hasM();
            ifxSQLShape.f_srid = ifmxUDTSQLInput.readInt();
            ifxSQLShape.f_numofpts = ifmxUDTSQLInput.readInt();
            ifxSQLShape.f_numParts = ifmxUDTSQLInput.readInt();
            if (ifxSQLShape.hasArea()) {
                ifxSQLShape.f_area = ifmxUDTSQLInput.readDouble();
            }
            if (ifxSQLShape.hasLength()) {
                ifxSQLShape.f_length = ifmxUDTSQLInput.readDouble();
            }
            if (ifxSQLShape.hasEnvelope()) {
                objectArray2 = new Envelope.Double();
                objectArray2.minX = ifmxUDTSQLInput.readDouble();
                objectArray2.minY = ifmxUDTSQLInput.readDouble();
                objectArray2.maxX = ifmxUDTSQLInput.readDouble();
                objectArray2.maxY = ifmxUDTSQLInput.readDouble();
                if (bl) {
                    objectArray2.minZ = ifmxUDTSQLInput.readDouble();
                    objectArray2.maxZ = ifmxUDTSQLInput.readDouble();
                }
                if (bl2) {
                    objectArray2.minM = ifmxUDTSQLInput.readDouble();
                    objectArray2.maxM = ifmxUDTSQLInput.readDouble();
                }
                ifxSQLShape.f_envelope = objectArray2;
            }
            if (ifxSQLShape.hasSrs()) {
                double d;
                double d2;
                double d3 = ifmxUDTSQLInput.readDouble();
                double d4 = ifmxUDTSQLInput.readDouble();
                double d5 = ifmxUDTSQLInput.readDouble();
                if (bl) {
                    d2 = ifmxUDTSQLInput.readDouble();
                    d = ifmxUDTSQLInput.readDouble();
                }
                if (bl2) {
                    d2 = ifmxUDTSQLInput.readDouble();
                    d = ifmxUDTSQLInput.readDouble();
                }
            }
            if (ifxSQLShape.hasAnnotation() || ifxSQLShape.hasAnnoText()) {
                int n3 = ifmxUDTSQLInput.readInt();
                ifxSQLShape.f_annoText = ifmxUDTSQLInput.readBytes(n3);
            }
            if (ifxSQLShape.isEmpty()) {
                ifxSQLShape.f_numPoints = ifxSQLShape.f_numofpts;
                ifxSQLShape.f_numSubParts = 0;
            } else if (ifxSQLShape.hasSysVals()) {
                if (!ifxSQLShape.hasCompressedVals()) {
                    objectArray2 = new Object[]{this.getFormatName(), new Integer(n2)};
                    SpatialManager.reportError(13, objectArray2, this.getClass().getName(), string);
                }
                objectArray2 = ifmxUDTSQLInput.readBytes(16);
                objectArray2 = ifmxUDTSQLInput.readBytes(ifxSQLShape.decodeSDEBinaryHeader((byte[])objectArray2));
                ifxSQLShape.decodeSDEBinary((byte[])objectArray2);
            } else if (ifxSQLShape.hasWorldVals()) {
                ifxSQLShape.readWorldValues((SQLInput)ifmxUDTSQLInput);
            } else {
                objectArray2 = new Object[]{this.getFormatName(), new Integer(n2)};
                SpatialManager.reportError(13, objectArray2, this.getClass().getName(), string);
            }
            if (ifxSQLShape.hasSysVals()) {
                ifxSQLShape.systemCoordToWorld();
            }
            int n4 = ifxSQLShape.getBaseSQLType();
            CoordRef coordRef = CoordRefManager.getInstance().get(ifxSQLShape.f_srid);
            IfxSQLGeometryFactory ifxSQLGeometryFactory = (IfxSQLGeometryFactory)GeometryFactory.getInstance("IfxSQL", coordRef);
            if (n4 == 4 && !ifxSQLShape.isEmpty()) {
                ifxGeometry = (IfxPoint)ifxSQLGeometryFactory.createPoint(ifxSQLShape.f_point);
            } else {
                String string2 = null;
                switch (n4) {
                    case 4: {
                        string2 = "Point";
                        break;
                    }
                    case 12: {
                        string2 = "LineString";
                        break;
                    }
                    case 16: {
                        string2 = "Polygon";
                        break;
                    }
                    case 8: {
                        string2 = "MultiPoint";
                        break;
                    }
                    case 20: {
                        string2 = "MultiLineString";
                        break;
                    }
                    case 24: {
                        string2 = "MultiPolygon";
                        break;
                    }
                    default: {
                        Object[] objectArray4 = new Object[]{this.getFormatName(), new Integer(n2)};
                        SpatialManager.reportError(13, objectArray4, this.getClass().getName(), string);
                    }
                }
                ifxGeometry = ifxSQLShape.isEmpty() ? (IfxGeometry)ifxSQLGeometryFactory.createEmptyGeometry(string2, ifxSQLShape.hasZ(), ifxSQLShape.hasM()) : (IfxGeometry)ifxSQLGeometryFactory.createGeometry(string2, ifxSQLShape.f_envelope, ifxSQLShape.f_xy, ifxSQLShape.f_z, ifxSQLShape.f_m, ifxSQLShape.f_partOffsets, ifxSQLShape.f_subPartOffsets, ifxSQLShape.f_length, ifxSQLShape.f_area);
            }
        }
        catch (Exception exception) {
            SpatialManager.reportError(exception, this.getClass().getName(), string);
        }
        logger.exiting(this.getClass().getName(), string);
        return ifxGeometry;
    }
}

