/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.spatial.io;

import com.ibm.spatial.SpatialException;
import com.ibm.spatial.SpatialManager;
import com.ibm.spatial.geom.CoordPoint;
import com.ibm.spatial.geom.Envelope;
import com.ibm.spatial.srs.CoordRef;
import com.ibm.spatial.srs.CoordRefManager;
import java.sql.SQLException;
import java.sql.SQLInput;

class IfxSQLShape {
    private int f_flags = 0;
    double f_area = Double.NaN;
    double f_length = Double.NaN;
    int f_srid = -1;
    int f_numofpts = -1;
    int f_numPoints = -1;
    int f_numParts = -1;
    int f_numSubParts = -1;
    boolean f_hasZ;
    boolean f_hasM;
    byte[] f_annoText = null;
    private static final String f__FILE__ = "com.ibm.spatial.io.IfxSQLShape";
    private static final int SG_NIL_SHAPE = 0;
    private static final int SG_POINT_SHAPE = 1;
    private static final int SG_LINE_SHAPE = 2;
    private static final int SG_SIMPLE_LINE_SHAPE = 4;
    private static final int SG_AREA_SHAPE = 8;
    private static final int SG_SHAPE_CLASS_MASK = 255;
    private static final int SG_SHAPE_MULTI_PART_MASK = 256;
    private static final int SG_MULTI_POINT_SHAPE = 257;
    private static final int SG_MULTI_LINE_SHAPE = 258;
    private static final int SG_MULTI_SIMPLE_LINE_SHAPE = 260;
    private static final int SG_MULTI_AREA_SHAPE = 264;
    private static final int FEATURE_3D_MASK = 1;
    private static final int FEATURE_MEASURE_MASK = 2;
    private static final int FEATURE_ANNO_MASK = 4;
    private static final int FEATURE_CAD_MASK = 8;
    int f_entity = 0;
    int f_ftrEflag = 0;
    int f_annoEflag = 0;
    byte[] f_annoCad = null;
    Envelope.Long f_sysEnvelope = null;
    CoordPoint.Long f_sysPoint = null;
    long[] f_sysxy = NULL_LONG_ARRAY;
    long[] f_sysz = NULL_LONG_ARRAY;
    long[] f_sysm = NULL_LONG_ARRAY;
    Envelope.Double f_envelope = null;
    CoordPoint.Double f_point = null;
    double[] f_xy = NULL_DOUBLE_ARRAY;
    double[] f_z = NULL_DOUBLE_ARRAY;
    double[] f_m = NULL_DOUBLE_ARRAY;
    int[] f_partOffsets = null;
    int[] f_subPartOffsets = null;
    static final int POINT_TYPE = 4;
    static final int MULTIPOINT_TYPE = 8;
    static final int LINESTRING_TYPE = 12;
    static final int POLYGON_TYPE = 16;
    static final int MULTILINESTRING_TYPE = 20;
    static final int MULTIPOLYGON_TYPE = 24;
    protected static final double[] NULL_DOUBLE_ARRAY = new double[0];
    protected static final long[] NULL_LONG_ARRAY = new long[0];
    private static final int SHAPEC_TYPE_MASK = 65535;
    private static final int BASE_TYPE_MASK = 4092;
    private static final int SHAPEC_AUX_MASK = 1105199104;
    private static final int SHAPEC_VERSION_MASK = 196608;
    static final int SHAPEC_VERSION_0 = 0;
    private static final int SHAPEC_ENVELOPE = 0x4000000;
    private static final int SHAPEC_AREA = 0x8000000;
    private static final int SHAPEC_LENGTH = 0x10000000;
    private static final int SHAPEC_SRS = Integer.MIN_VALUE;
    private static final int SHAPEC_WORLDVALS = 0x20000000;
    private static final int SHAPEC_COMPRESSED = 0x40000000;
    private static final int SHAPEC_DATA_MASK = 0x60000000;
    private static final int SQLSDE_HAS_ANNO_TEXT = 0x200000;
    private static final int SQLSDE_HAS_ANNOTATION = 0x400000;
    private static final int SQLSDE_HAS_CAD = 0x800000;
    private static final int SQLSDE_IS_EMPTY = 0x1000000;
    private static byte SIGN_MASK = (byte)64;
    private static int CONTINUE_MASK = 128;
    private static byte LOW6_BITS_MASK = (byte)63;
    private static byte LOW7_BITS_MASK = (byte)127;

    IfxSQLShape() {
    }

    IfxSQLShape(int n) {
        this.setFlags(n);
    }

    void setFlags(int n) {
        this.f_flags = n;
        this.f_hasZ = (this.f_flags & 2) != 0;
        this.f_hasM = (this.f_flags & 1) != 0;
    }

    int getBaseSQLType() {
        return this.f_flags & 0xFFC;
    }

    boolean hasZ() {
        return this.f_hasZ;
    }

    boolean hasM() {
        return this.f_hasM;
    }

    boolean isPoint() {
        return (this.f_flags & 0xFC) == 4;
    }

    boolean isMultiPoint() {
        return (this.f_flags & 0xFC) == 8;
    }

    boolean isLineString() {
        return (this.f_flags & 0xFC) == 12;
    }

    boolean isMultiLineString() {
        return (this.f_flags & 0xFC) == 20;
    }

    boolean isPolygon() {
        return (this.f_flags & 0xFC) == 16;
    }

    boolean isMultiPolygon() {
        return (this.f_flags & 0xFC) == 24;
    }

    boolean isGeomCollection() {
        int n = this.f_flags & 0xFC;
        return n == 8 || n == 20 || n == 24;
    }

    int getVersion() {
        return (this.f_flags & 0x30000) >> 16;
    }

    void setVersion(int n) {
        this.f_flags = this.f_flags & 0xFFFCFFFF | (n & 3) << 16;
    }

    boolean hasSrs() {
        return (this.f_flags & Integer.MIN_VALUE) != 0;
    }

    final boolean hasArea() {
        return (this.f_flags & 0x8000000) != 0;
    }

    final boolean hasLength() {
        return (this.f_flags & 0x10000000) != 0;
    }

    final boolean hasEnvelope() {
        return (this.f_flags & 0x4000000) != 0;
    }

    boolean hasSysVals() {
        return (this.f_flags & 0x20000000) == 0;
    }

    boolean hasCompressedVals() {
        return (this.f_flags & 0x40000000) != 0;
    }

    boolean hasWorldVals() {
        return (this.f_flags & 0x40000000) == 0 && (this.f_flags & 0x20000000) != 0;
    }

    boolean hasAnnotation() {
        return (this.f_flags & 0x400000) != 0;
    }

    boolean hasAnnoText() {
        return (this.f_flags & 0x200000) != 0;
    }

    boolean isEmpty() {
        return (this.f_flags & 0x1000000) != 0;
    }

    private void setEmpty() {
        this.f_flags |= 0x1000000;
        this.f_numPoints = 0;
        this.f_numParts = 1;
        this.f_numSubParts = 0;
        this.f_area = 0.0;
        this.f_length = 0.0;
        this.f_point = null;
        this.f_envelope = null;
        this.f_sysPoint = null;
        this.f_sysEnvelope = null;
    }

    void readWorldValues(SQLInput sQLInput) throws SpatialException {
        String string = "readWorldValues";
        if (this.f_numPoints == -1) {
            this.f_numPoints = this.f_numofpts;
        }
        try {
            if (this.isEmpty()) {
                this.setEmpty();
            } else if (this.isPoint()) {
                this.f_point = this.f_hasZ || this.f_hasM ? new CoordPoint.DoubleZM() : new CoordPoint.Double();
                this.f_point.x = sQLInput.readDouble();
                this.f_point.y = sQLInput.readDouble();
                if (this.f_hasZ) {
                    this.f_point.setZ(sQLInput.readDouble());
                }
                if (this.f_hasM) {
                    this.f_point.setM(sQLInput.readDouble());
                }
            } else {
                if (this.isMultiLineString()) {
                    this.f_partOffsets = new int[2];
                    this.f_partOffsets[0] = 0;
                    this.f_partOffsets[1] = this.f_numPoints;
                }
                this.f_xy = new double[this.f_numPoints * 2];
                int n = 0;
                while (n < this.f_xy.length) {
                    this.f_xy[n++] = sQLInput.readDouble();
                    this.f_xy[n++] = sQLInput.readDouble();
                }
                if (this.f_hasZ) {
                    this.f_z = new double[this.f_numPoints];
                    n = 0;
                    while (n < this.f_numPoints) {
                        this.f_z[n++] = sQLInput.readDouble();
                    }
                }
                if (this.f_hasM) {
                    this.f_m = new double[this.f_numPoints];
                    n = 0;
                    while (n < this.f_numPoints) {
                        this.f_m[n++] = sQLInput.readDouble();
                    }
                }
            }
        }
        catch (SQLException sQLException) {
            SpatialManager.reportError(sQLException, this.getClass().getName(), string);
        }
    }

    void calcEnvelope() {
        int n;
        double d = Double.MAX_VALUE;
        double d2 = Double.MAX_VALUE;
        double d3 = Double.MAX_VALUE;
        double d4 = Double.MAX_VALUE;
        double d5 = Double.MIN_VALUE;
        double d6 = Double.MIN_VALUE;
        double d7 = Double.MIN_VALUE;
        double d8 = Double.MIN_VALUE;
        for (n = 0; n < this.f_xy.length; ++n) {
            if (d4 > this.f_xy[n]) {
                d4 = this.f_xy[n];
            }
            if (d8 < this.f_xy[n]) {
                d8 = this.f_xy[n];
            }
            if (d3 > this.f_xy[++n]) {
                d3 = this.f_xy[n];
            }
            if (!(d7 < this.f_xy[n])) continue;
            d7 = this.f_xy[n];
        }
        for (n = 0; n < this.f_z.length; ++n) {
            if (d2 > this.f_z[n]) {
                d2 = this.f_z[n];
            }
            if (!(d6 < this.f_z[n])) continue;
            d6 = this.f_z[n];
        }
        for (n = 0; n < this.f_m.length; ++n) {
            if (d > this.f_m[n]) {
                d = this.f_m[n];
            }
            if (!(d5 < this.f_m[n])) continue;
            d5 = this.f_m[n];
        }
        this.f_envelope = new Envelope.Double(d4, d3, d8, d7);
        this.f_envelope.setExtentZ(d2, d6);
        this.f_envelope.setExtentM(d, d5);
    }

    void calcSysEnvelope() {
        int n;
        long l = Long.MAX_VALUE;
        long l2 = Long.MAX_VALUE;
        long l3 = Long.MAX_VALUE;
        long l4 = Long.MAX_VALUE;
        long l5 = Long.MIN_VALUE;
        long l6 = Long.MIN_VALUE;
        long l7 = Long.MIN_VALUE;
        long l8 = Long.MIN_VALUE;
        for (n = 0; n < this.f_sysxy.length; ++n) {
            if (l4 > this.f_sysxy[n]) {
                l4 = this.f_sysxy[n];
            }
            if (l8 < this.f_sysxy[n]) {
                l8 = this.f_sysxy[n];
            }
            if (l3 > this.f_sysxy[++n]) {
                l3 = this.f_sysxy[n];
            }
            if (l7 >= this.f_sysxy[n]) continue;
            l7 = this.f_sysxy[n];
        }
        for (n = 0; n < this.f_sysz.length; ++n) {
            if (l2 > this.f_sysz[n]) {
                l2 = this.f_sysz[n];
            }
            if (l6 >= this.f_sysz[n]) continue;
            l6 = this.f_sysz[n];
        }
        for (n = 0; n < this.f_sysm.length; ++n) {
            if (l > this.f_sysm[n]) {
                l = this.f_sysm[n];
            }
            if (l5 >= this.f_sysm[n]) continue;
            l5 = this.f_sysm[n];
        }
        this.f_sysEnvelope = new Envelope.Long(l4, l3, l8, l7);
        this.f_sysEnvelope.setExtentZ(l2, l6);
        this.f_sysEnvelope.setExtentM(l, l5);
    }

    void systemCoordToWorld() throws SpatialException {
        CoordRefManager coordRefManager = CoordRefManager.getInstance();
        CoordRef coordRef = coordRefManager.get(this.f_srid);
        if (this.f_sysPoint != null) {
            if (this.f_sysPoint.isEmpty()) {
                this.f_point = new CoordPoint.Double();
            } else {
                double d = coordRef.convertXValueToWorld(this.f_sysPoint.x);
                double d2 = coordRef.convertYValueToWorld(this.f_sysPoint.y);
                double d3 = this.f_sysPoint.hasZ() ? coordRef.convertZValueToWorld((int)this.f_sysPoint.getZ()) : Double.NaN;
                double d4 = this.f_sysPoint.hasM() ? coordRef.convertMValueToWorld((int)this.f_sysPoint.getM()) : Double.NaN;
                this.f_point = !Double.isNaN(d3) || !Double.isNaN(d4) ? new CoordPoint.DoubleZM(d, d2, d3, d4) : new CoordPoint.Double(d, d2);
            }
        }
        this.f_xy = coordRef.convertXYValuesToWorld(this.f_sysxy);
        this.f_z = coordRef.convertZValuesToWorld(this.f_sysz);
        this.f_m = coordRef.convertMValuesToWorld(this.f_sysm);
        if (this.f_envelope == null) {
            this.systemEnvelopeToWorld(coordRef);
        }
    }

    void systemEnvelopeToWorld() throws SpatialException {
        CoordRefManager coordRefManager = CoordRefManager.getInstance();
        CoordRef coordRef = coordRefManager.get(this.f_srid);
        if (this.f_sysEnvelope != null) {
            this.f_envelope = new Envelope.Double();
            if (!this.f_sysEnvelope.isEmpty()) {
                this.f_envelope.minX = coordRef.convertXValueToWorld(this.f_sysEnvelope.minX);
                this.f_envelope.maxX = coordRef.convertXValueToWorld(this.f_sysEnvelope.maxX);
                this.f_envelope.minY = coordRef.convertYValueToWorld(this.f_sysEnvelope.minY);
                this.f_envelope.maxY = coordRef.convertYValueToWorld(this.f_sysEnvelope.maxY);
                if (this.f_hasZ) {
                    this.f_envelope.minZ = coordRef.convertZValueToWorld(this.f_sysEnvelope.minZ);
                    this.f_envelope.maxZ = coordRef.convertZValueToWorld(this.f_sysEnvelope.maxZ);
                }
                if (this.f_hasM) {
                    this.f_envelope.minM = coordRef.convertMValueToWorld(this.f_sysEnvelope.minM);
                    this.f_envelope.maxM = coordRef.convertMValueToWorld(this.f_sysEnvelope.maxM);
                }
            }
        }
    }

    private void systemEnvelopeToWorld(CoordRef coordRef) {
        if (this.f_sysEnvelope != null) {
            this.f_envelope = new Envelope.Double();
            if (!this.f_sysEnvelope.isEmpty()) {
                this.f_envelope.minX = coordRef.convertXValueToWorld(this.f_sysEnvelope.minX);
                this.f_envelope.maxX = coordRef.convertXValueToWorld(this.f_sysEnvelope.maxX);
                this.f_envelope.minY = coordRef.convertYValueToWorld(this.f_sysEnvelope.minY);
                this.f_envelope.maxY = coordRef.convertYValueToWorld(this.f_sysEnvelope.maxY);
                if (this.f_hasZ) {
                    this.f_envelope.minZ = coordRef.convertZValueToWorld(this.f_sysEnvelope.minZ);
                    this.f_envelope.maxZ = coordRef.convertZValueToWorld(this.f_sysEnvelope.maxZ);
                }
                if (this.f_hasM) {
                    this.f_envelope.minM = coordRef.convertMValueToWorld(this.f_sysEnvelope.minM);
                    this.f_envelope.maxM = coordRef.convertMValueToWorld(this.f_sysEnvelope.maxM);
                }
            }
        }
    }

    int decodeSDEBinaryHeader(byte[] byArray) throws SpatialException {
        String string = "decodeSDEBinaryHeader";
        int[] nArray = new int[]{0};
        int n = this.decodeVarLONG(byArray, nArray);
        this.f_entity = this.decodeVarLONG(byArray, nArray);
        this.f_numofpts = n;
        nArray[0] = 8;
        int n2 = this.decodeVarLONG(byArray, nArray);
        nArray[0] = 13;
        this.f_ftrEflag = this.decodeVarLONG(byArray, nArray);
        nArray[0] = 14;
        this.f_annoEflag = this.decodeVarLONG(byArray, nArray);
        if (0 == this.f_entity) {
            this.setEmpty();
        }
        return n2;
    }

    void decodeSDEBinary(byte[] byArray) throws SpatialException {
        String string = "decodeSDEBinary";
        int[] nArray = new int[]{0};
        long[] lArray = this.uncompress(byArray, nArray, byArray.length, this.f_numofpts);
        if (0 != this.f_entity) {
            int n;
            this.f_numPoints = n = IfxSQLShape.calcNumPoints(this.f_entity, lArray, this.f_numofpts, 0, 0);
            int[] nArray2 = new int[]{0};
            int[] nArray3 = new int[]{0};
            IfxSQLShape.calcNumParts(this.f_entity, lArray, this.f_numofpts, nArray2, nArray3);
            this.f_numParts = nArray2[0];
            this.f_numSubParts = nArray3[0];
            if (this.f_entity == 1) {
                int n2 = 0;
                if (this.f_hasM || this.f_hasZ) {
                    this.f_sysPoint = new CoordPoint.LongZM(lArray[n2++], lArray[n2++]);
                    if (this.f_hasZ) {
                        this.f_sysPoint.setZ(lArray[n2++]);
                    }
                    if (this.f_hasM) {
                        this.f_sysPoint.setM(lArray[n2]);
                    }
                } else {
                    this.f_sysPoint = new CoordPoint.Long(lArray[0], lArray[1]);
                }
            } else {
                this.getAllPoints(lArray, this.f_numofpts);
                if (this.f_sysEnvelope == null) {
                    this.calcSysEnvelope();
                }
            }
        }
    }

    private long[] uncompress(byte[] byArray, int[] nArray, int n, int n2) {
        int n3;
        int n4 = nArray[0];
        String string = "uncompress";
        long[] lArray = null;
        if (n2 > 0) {
            long l;
            n3 = 2 * n2;
            if ((this.f_ftrEflag & 1) != 0) {
                n3 += n2;
            }
            if ((this.f_ftrEflag & 2) != 0) {
                n3 += n2;
            }
            lArray = new long[n3];
            int n5 = 0;
            int n6 = n2 * 2;
            while (n5 < n6) {
                lArray[n5++] = this.decodeVarINT64(byArray, nArray);
                lArray[n5++] = this.decodeVarINT64(byArray, nArray);
            }
            for (n5 = 2; n5 < n6; ++n5) {
                int n7 = n5;
                lArray[n7] = lArray[n7] + lArray[n5 - 2];
            }
            if ((1 & this.f_ftrEflag) != 0) {
                n6 += n2;
                int n8 = n5++;
                long l2 = this.decodeVarINT64(byArray, nArray);
                lArray[n8] = l2;
                l = l2;
                while (n5 < n6) {
                    int n9 = n5++;
                    long l3 = this.decodeVarINT64(byArray, nArray) + l;
                    lArray[n9] = l3;
                    l = l3;
                }
            }
            if ((2 & this.f_ftrEflag) != 0) {
                n6 += n2;
                int n10 = n5++;
                long l4 = this.decodeVarINT64(byArray, nArray);
                lArray[n10] = l4;
                l = l4;
                while (n5 < n6) {
                    int n11 = n5++;
                    long l5 = this.decodeVarINT64(byArray, nArray) + l;
                    lArray[n11] = l5;
                    l = l5;
                }
            }
        }
        this.f_annoCad = null;
        if (((this.f_ftrEflag & 8) != 0 || (this.f_ftrEflag & 4) != 0) && (n3 = n - (nArray[0] - n4)) > 0) {
            this.f_annoCad = new byte[n3];
            System.arraycopy(byArray, nArray[0], this.f_annoCad, 0, n3);
        }
        nArray[0] = n4 + n;
        return lArray;
    }

    private void getAllPoints(long[] lArray, int n) throws SpatialException {
        if (0 == this.f_entity) {
            return;
        }
        String string = "getAllPoints";
        this.initOffsets();
        this.f_sysxy = new long[this.f_numPoints * 2];
        this.f_sysz = this.f_hasZ ? new long[this.f_numPoints] : NULL_LONG_ARRAY;
        long[] lArray2 = this.f_sysm = this.f_hasM ? new long[this.f_numPoints] : NULL_LONG_ARRAY;
        if ((1 & this.f_entity) != 0) {
            int n2;
            if (this.f_subPartOffsets != null) {
                if (this.f_partOffsets != null) {
                    for (n2 = 0; n2 < n; ++n2) {
                        this.f_partOffsets[n2] = this.f_subPartOffsets[n2] = n2;
                    }
                } else {
                    for (n2 = 0; n2 < n; ++n2) {
                        this.f_subPartOffsets[n2] = n2;
                    }
                }
            } else if (this.f_partOffsets != null) {
                for (n2 = 0; n2 < n; ++n2) {
                    this.f_partOffsets[n2] = n2;
                }
            }
            System.arraycopy(lArray, 0, this.f_sysxy, 0, this.f_numPoints * 2);
            n2 = this.f_numPoints * 2;
            if (this.f_hasZ) {
                System.arraycopy(lArray, n2, this.f_sysz, 0, this.f_numPoints);
                n2 += this.f_numPoints;
            }
            if (this.f_hasM) {
                System.arraycopy(lArray, n2, this.f_sysm, 0, this.f_numPoints);
            }
        } else if ((8 & this.f_entity) == 0 || null == this.f_subPartOffsets) {
            int n3 = 0;
            int n4 = 0;
            int n5 = n * 2;
            int n6 = 0;
            while (n4 < n5) {
                int n7;
                if (this.f_subPartOffsets != null) {
                    this.f_subPartOffsets[n6] = n3 / 2;
                    if (this.f_partOffsets != null) {
                        this.f_partOffsets[n6] = n6;
                    }
                } else if (this.f_partOffsets != null) {
                    this.f_partOffsets[n6] = n3 / 2;
                }
                if ((n7 = 2 * IfxSQLShape.calcPartSize(this.f_entity, lArray, n, n4)) <= 0) {
                    SpatialManager.reportError(22, this.getClass().getName(), string);
                }
                System.arraycopy(lArray, n4, this.f_sysxy, n3, n7);
                int n8 = n5 + n4 / 2;
                if (this.f_hasZ) {
                    System.arraycopy(lArray, n8, this.f_sysz, n3 / 2, n7 / 2);
                    n8 += n;
                }
                if (this.f_hasM) {
                    System.arraycopy(lArray, n8, this.f_sysm, n3 / 2, n7 / 2);
                }
                n3 += n7;
                n4 += n7 + 2;
                ++n6;
            }
            if (this.f_subPartOffsets != null) {
                this.f_subPartOffsets[n6] = n3 / 2;
                if (this.f_partOffsets != null) {
                    this.f_partOffsets[n6] = n6;
                }
            } else if (this.f_partOffsets != null) {
                this.f_partOffsets[n6] = n3 / 2;
            }
        } else {
            int n9 = 0;
            int n10 = 0;
            int n11 = 0;
            int n12 = n * 2;
            int n13 = 0;
            int n14 = 0;
            while (n10 < n12) {
                int n15;
                if (null != this.f_partOffsets) {
                    this.f_partOffsets[n13] = null != this.f_subPartOffsets ? n14 : n9 / 2;
                }
                if ((n15 = 2 * IfxSQLShape.calcPartSize(this.f_entity, lArray, n, n10)) <= 0) {
                    SpatialManager.reportError(22, this.getClass().getName(), string);
                }
                int n16 = n10 + n15 - 2;
                n11 = n10;
                while (n11 <= n16) {
                    int n17 = 2 * IfxSQLShape.calcSubPartSize(lArray, n, n11, n16);
                    if (n17 <= 0) {
                        SpatialManager.reportError(22, this.getClass().getName(), string);
                    }
                    if (this.f_subPartOffsets != null) {
                        this.f_subPartOffsets[n14] = n9 / 2;
                    }
                    System.arraycopy(lArray, n11, this.f_sysxy, n9, n17);
                    int n18 = n12 + n11 / 2;
                    if (this.f_hasZ) {
                        System.arraycopy(lArray, n18, this.f_sysz, n9 / 2, n17 / 2);
                        n18 += n;
                    }
                    if (this.f_hasM) {
                        System.arraycopy(lArray, n18, this.f_sysm, n9 / 2, n17 / 2);
                    }
                    n9 += n17;
                    n11 += n17;
                    ++n14;
                }
                if (this.f_subPartOffsets != null) {
                    this.f_subPartOffsets[n14] = n9 / 2;
                }
                n10 = n16 + 4;
                ++n13;
            }
            if (null != this.f_partOffsets) {
                this.f_partOffsets[n13] = null != this.f_subPartOffsets ? n14 : n9 / 2;
            }
        }
    }

    private static boolean isSeparator(long[] lArray, int n) {
        return lArray[n] == -1L && lArray[n + 1] == 0L;
    }

    private static void makeSeparator(long[] lArray, int n) {
        lArray[n] = -1L;
        lArray[n + 1] = 0L;
    }

    private static boolean isSubpartSeparator(long[] lArray, int n) {
        return lArray[n] == -1L && lArray[n + 1] == -1L;
    }

    private static void makeSubpartSeparator(long[] lArray, int n) {
        lArray[n] = -1L;
        lArray[n + 1] = -1L;
    }

    private void initOffsets() throws SpatialException {
        if (this.f_numParts < 1) {
            SpatialManager.reportError(22, this.getClass().getName(), "initOffsets");
        }
        this.f_subPartOffsets = null;
        this.f_partOffsets = null;
        if ((this.isMultiLineString() || this.isMultiPolygon()) && this.f_numParts > 0) {
            this.f_partOffsets = new int[this.f_numParts + 1];
        }
        if (this.f_numSubParts > 0 && (this.isPolygon() || this.isMultiPolygon())) {
            this.f_subPartOffsets = new int[this.f_numSubParts + 1];
        }
    }

    private static void calcNumParts(int n, long[] lArray, int n2, int[] nArray, int[] nArray2) {
        if ((8 & n) != 0 && null != nArray2) {
            IfxSQLShape.calcPartCounts(n, lArray, n2, nArray, nArray2);
        } else {
            nArray[0] = IfxSQLShape.calcPartCount(n, lArray, n2);
            if (null != nArray2) {
                nArray2[0] = nArray[0];
            }
        }
    }

    private static int calcPartCount(int n, long[] lArray, int n2) {
        int n3 = 1;
        if (0 == n) {
            n3 = 0;
        } else if ((1 & n) != 0) {
            n3 = n2;
        } else {
            int n4 = n2 * 2;
            for (int i = 0; i < n4; i += 2) {
                if (!IfxSQLShape.isSeparator(lArray, i)) continue;
                ++n3;
            }
        }
        return n3;
    }

    private static void calcPartCounts(int n, long[] lArray, int n2, int[] nArray, int[] nArray2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = n2 * 2;
        nArray[0] = 0;
        if (nArray2 != null) {
            nArray2[0] = 0;
        }
        if ((8 & n) != 0 && null != nArray2) {
            int n6 = 0;
            while (n6 < n5) {
                ++n3;
                int n7 = n6 + 2 * (IfxSQLShape.calcPartSize(n, lArray, n2, n6) - 1);
                if (n7 <= n6) {
                    return;
                }
                int n8 = IfxSQLShape.calcSubPartCount(lArray, n2, n6, n7);
                if (n8 <= 0) {
                    return;
                }
                n4 += n8;
                n6 = n7 + 4;
            }
        } else {
            n4 = n3 = IfxSQLShape.calcPartCount(n, lArray, n2);
        }
        nArray[0] = n3;
        if (nArray2 != null) {
            nArray2[0] = n4;
        }
    }

    private static int calcPartSize(int n, long[] lArray, int n2, int n3) {
        int n4 = 0;
        int n5 = n2 * 2;
        if ((1 & n) != 0) {
            if (n3 < n5 && n3 >= 0) {
                n4 = 1;
            } else {
                SpatialManager.indexOutOfRange("iOffset", n3, 0, lArray.length, f__FILE__, "calcPartSize");
            }
        } else if (0 != n) {
            int n6;
            for (n6 = n3; n6 < n5 && !IfxSQLShape.isSeparator(lArray, n6); n6 += 2) {
            }
            n4 = (n6 - n3) / 2;
        }
        return n4;
    }

    private static int calcSubPartCount(long[] lArray, int n, int n2, int n3) {
        int n4 = 0;
        int n5 = n2;
        while (n5 < n3) {
            int n6 = n3;
            while (lArray[n5] != lArray[n6] || lArray[n5 + 1] != lArray[n6 + 1]) {
                n6 -= 2;
            }
            if (n6 <= n5) {
                return 0;
            }
            ++n4;
            n5 = n6 + 2;
        }
        return n4;
    }

    private static int calcSubPartSize(long[] lArray, int n, int n2, int n3) {
        int n4 = n3;
        while (lArray[n2] != lArray[n4] || lArray[n2 + 1] != lArray[n4 + 1]) {
            n4 -= 2;
        }
        return n4 <= n2 ? 0 : (n4 - n2) / 2 + 1;
    }

    private static int calcSubPartOffset(int n, long[] lArray, int n2, int n3, int n4, int n5) {
        int n6 = n3;
        for (int i = 1; n6 < n4 && i != n5; ++i) {
            int n7 = n4;
            while (lArray[n6] != lArray[n7] || lArray[n6 + 1] != lArray[n7 + 1]) {
                n7 -= 2;
            }
            if (n7 <= n6) {
                return -1;
            }
            n6 = n7 + 2;
        }
        if (n6 >= n4) {
            return -1;
        }
        return n6;
    }

    private int decodeVarLONG(byte[] byArray, int[] nArray) {
        int n = 6;
        int n2 = nArray[0];
        nArray[0] = n2 + 1;
        byte by = byArray[n2];
        int n3 = by & LOW6_BITS_MASK;
        byte by2 = by;
        while ((by2 & CONTINUE_MASK) != 0) {
            int n4 = nArray[0];
            nArray[0] = n4 + 1;
            by2 = byArray[n4];
            int n5 = by2 & LOW7_BITS_MASK;
            n3 += (n5 <<= (n += 7));
        }
        if ((by & SIGN_MASK) != 0) {
            n3 = -n3;
        }
        return n3;
    }

    private void encodeVarLONG(byte[] byArray, int n, int[] nArray) {
        byte by = 0;
        if (n < 0) {
            by = SIGN_MASK;
            n = -n;
        }
        if (n > 63) {
            by = (byte)(by | CONTINUE_MASK);
        }
        by = (byte)(by | n & LOW6_BITS_MASK);
        int n2 = nArray[0];
        nArray[0] = n2 + 1;
        byArray[n2] = by;
        n >>= 6;
        while (n != 0) {
            if (n > 127) {
                by = (byte)CONTINUE_MASK;
                by = (byte)(by | n & LOW7_BITS_MASK);
            } else {
                by = (byte)n;
            }
            int n3 = nArray[0];
            nArray[0] = n3 + 1;
            byArray[n3] = by;
            n >>= 7;
        }
    }

    private long decodeVarINT64(byte[] byArray, int[] nArray) {
        int n = 6;
        int n2 = nArray[0];
        nArray[0] = n2 + 1;
        byte by = byArray[n2];
        long l = by & LOW6_BITS_MASK;
        byte by2 = by;
        while ((by2 & CONTINUE_MASK) != 0) {
            int n3 = nArray[0];
            nArray[0] = n3 + 1;
            by2 = byArray[n3];
            long l2 = by2 & LOW7_BITS_MASK;
            l += (l2 <<= (n += 7));
        }
        if ((by & SIGN_MASK) != 0) {
            l = -l;
        }
        return l;
    }

    private void encodeVarINT64(byte[] byArray, long l, int[] nArray) {
        byte by = 0;
        if (l < 0L) {
            by = SIGN_MASK;
            l = -l;
        }
        if (l > 63L) {
            by = (byte)(by | CONTINUE_MASK);
        }
        by = (byte)((long)by | l & (long)LOW6_BITS_MASK);
        int n = nArray[0];
        nArray[0] = n + 1;
        byArray[n] = by;
        l >>= 6;
        while (l != 0L) {
            if (l > 127L) {
                by = (byte)CONTINUE_MASK;
                by = (byte)((long)by | l & (long)LOW7_BITS_MASK);
            } else {
                by = (byte)l;
            }
            int n2 = nArray[0];
            nArray[0] = n2 + 1;
            byArray[n2] = by;
            l >>= 7;
        }
    }

    private static int calcNumSubParts(int n, long[] lArray, int n2, int n3) throws SpatialException {
        int n4 = 0;
        String string = "calcNumSubParts";
        if (0 != n && n3 == 0) {
            int[] nArray = new int[]{0};
            int[] nArray2 = new int[]{0};
            IfxSQLShape.calcPartCounts(n, lArray, n2, nArray, nArray2);
            if (nArray2[0] < 1) {
                SpatialManager.reportError(22, f__FILE__, string);
            } else {
                int n5 = IfxSQLShape.calcPartOffset(n, lArray, n2, n3);
                if (n5 < 0) {
                    SpatialManager.reportError(22, f__FILE__, string);
                }
                if ((8 & n) == 0) {
                    n4 = 1;
                } else {
                    int n6 = n5 + 2 * (IfxSQLShape.calcPartSize(n, lArray, n2, n5) - 1);
                    if (n6 <= n5) {
                        SpatialManager.reportError(22, f__FILE__, string);
                    }
                    if ((n4 = IfxSQLShape.calcSubPartCount(lArray, n2, n5, n6)) <= 0) {
                        SpatialManager.reportError(22, f__FILE__, string);
                    }
                }
            }
        }
        return n4;
    }

    private static int calcPartOffset(int n, long[] lArray, int n2, int n3) {
        int n4;
        if (n3 < 1 || 0 == n) {
            n4 = -1;
        } else if ((1 & n) != 0) {
            n4 = n3 > n2 ? -1 : (n3 - 1) * 2;
        } else {
            int n5 = n2 * 2;
            int n6 = 1;
            for (n4 = 0; n6 < n3 && n4 < n5; n4 += 2) {
                if (!IfxSQLShape.isSeparator(lArray, n4)) continue;
                ++n6;
            }
            if (n4 >= n5) {
                n4 = -1;
            }
        }
        return n4;
    }

    private static int calcNumPoints(int n, long[] lArray, int n2, int n3, int n4) {
        String string = "calcNumPoints";
        String string2 = "part";
        String string3 = "subPart";
        int n5 = 0;
        if (n3 < 0 || n4 < 0) {
            SpatialManager.invalidArg(n3 < 0 ? string2 : string3, n3 < 0 ? n3 : n4, f__FILE__, string);
        }
        if (n3 == 0) {
            if (0 == n) {
                n5 = 0;
            } else if ((n & 0x100) == 0 || (n & 1) != 0) {
                n5 = n2;
            } else {
                int n6 = IfxSQLShape.calcPartCount(n, lArray, n2);
                n5 = n2 - (n6 - 1);
            }
        } else if (0 == n) {
            SpatialManager.invalidArg(string2, n3, f__FILE__, string);
        } else if ((1 & n) != 0) {
            if (n3 > n2) {
                SpatialManager.invalidArg(string2, n3, f__FILE__, string);
            } else {
                n5 = 1;
            }
        } else {
            int n7 = IfxSQLShape.calcPartOffset(n, lArray, n2, n3);
            if (n7 < 0) {
                SpatialManager.invalidArg(string2, n3, f__FILE__, string);
            } else {
                int n8 = IfxSQLShape.calcPartSize(n, lArray, n2, n7);
                if ((8 & n) != 0 && n4 > 0) {
                    int n9 = n7 + 2 * (n8 - 1);
                    int n10 = IfxSQLShape.calcSubPartOffset(n, lArray, n2, n7, n9, n4);
                    if (n10 < 0) {
                        SpatialManager.invalidArg(string3, n4, f__FILE__, string);
                    }
                    if ((n5 = IfxSQLShape.calcSubPartSize(lArray, n2, n10, n9)) <= 0) {
                        SpatialManager.invalidArg(string3, n4, f__FILE__, string);
                    }
                } else {
                    n5 = n8;
                }
            }
        }
        return n5;
    }
}

