/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.spatial.srs;

import com.ibm.spatial.SpatialException;
import com.ibm.spatial.SpatialManager;
import com.ibm.spatial.geom.Envelope;
import java.io.Serializable;

public class CoordRef
implements Cloneable,
Serializable {
    protected double f_falseX;
    protected double f_falseY;
    protected double f_xyUnits;
    protected double f_xyCRound;
    protected double f_xyHalfSU;
    protected double f_falseZ;
    protected double f_zUnits;
    protected double f_zCRound;
    protected double f_zHalfSU;
    protected double f_falseM;
    protected double f_mUnits;
    protected double f_mCRound;
    protected double f_mHalfSU;
    protected int f_dimension = 3;
    protected int f_srid;
    protected String f_authName;
    protected Integer f_authSrid;
    protected String f_srtext;
    protected String f_description;
    private static final long i_SULIMIT = 0x20000000000000L;
    private static final double f_SULIMIT = 9.007199254740992E15;
    private static final double f_EPSILON = 2.3283064376228985E-10;
    private static final double f_LOG_10 = Math.log(10.0);
    private static final String f_EMPTY_STRING = "";
    private static final int UNSET_SRID = Integer.MIN_VALUE;
    public static final int SRTEXT = 1;
    public static final int AUTH = 2;
    public static final int DESC = 4;
    public static final int EXTENT = 8;
    public static final int ALL = 15;

    public CoordRef() {
        this.f_falseX = -180.0;
        this.f_falseY = -90.0;
        this.f_xyUnits = 1000000.0;
        this.f_xyCRound = 1.0;
        this.f_xyHalfSU = 0.5;
        this.f_falseZ = 0.0;
        this.f_zUnits = 1.0;
        this.f_zCRound = 1.0;
        this.f_zHalfSU = 0.5;
        this.f_falseM = 0.0;
        this.f_mUnits = 1.0;
        this.f_mCRound = 1.0;
        this.f_mHalfSU = 0.5;
        this.f_srtext = f_EMPTY_STRING;
        this.f_authName = null;
        this.f_authSrid = null;
        this.f_description = null;
        this.f_dimension = 3;
        this.f_srid = Integer.MIN_VALUE;
    }

    public CoordRef(CoordRef coordRef) {
        this.f_falseX = coordRef.f_falseX;
        this.f_falseY = coordRef.f_falseY;
        this.f_xyUnits = coordRef.f_xyUnits;
        this.f_xyCRound = coordRef.f_xyCRound;
        this.f_xyHalfSU = coordRef.f_xyHalfSU;
        this.f_falseZ = coordRef.f_falseZ;
        this.f_zUnits = coordRef.f_zUnits;
        this.f_zCRound = coordRef.f_zCRound;
        this.f_zHalfSU = coordRef.f_zHalfSU;
        this.f_falseM = coordRef.f_falseM;
        this.f_mUnits = coordRef.f_mUnits;
        this.f_mCRound = coordRef.f_mCRound;
        this.f_mHalfSU = coordRef.f_mHalfSU;
        this.f_srtext = coordRef.f_srtext;
        this.f_authName = coordRef.f_authName;
        this.f_authSrid = coordRef.f_authSrid;
        this.f_description = coordRef.f_description;
        this.f_dimension = coordRef.f_dimension;
        this.f_srid = coordRef.f_srid;
    }

    public double getFalseX() {
        return this.f_falseX;
    }

    public double getFalseY() {
        return this.f_falseY;
    }

    public double getXYUnits() {
        return this.f_xyUnits;
    }

    public double getFalseZ() {
        return this.f_falseZ;
    }

    public double getZUnits() {
        return this.f_zUnits;
    }

    public double getFalseM() {
        return this.f_falseM;
    }

    public double getMUnits() {
        return this.f_mUnits;
    }

    public Envelope getExtent() {
        Envelope.Double double_ = new Envelope.Double();
        ((Envelope)double_).setExtent(this.f_falseX, this.f_falseY, CoordRef.systemToPlanar(0x20000000000000L, this.f_falseX, this.f_xyUnits), CoordRef.systemToPlanar(0x20000000000000L, this.f_falseY, this.f_xyUnits));
        ((Envelope)double_).setExtentZ(this.f_falseZ, CoordRef.systemToPlanar(0x20000000000000L, this.f_falseZ, this.f_zUnits));
        ((Envelope)double_).setExtentM(this.f_falseM, CoordRef.systemToPlanar(0x20000000000000L, this.f_falseM, this.f_mUnits));
        return double_;
    }

    public int getDimension() {
        return this.f_dimension;
    }

    public String getSrtext() {
        return this.f_srtext;
    }

    public String getAuthName() {
        return this.f_authName;
    }

    public Integer getAuthSrid() {
        return this.f_authSrid;
    }

    public String getDescription() {
        return this.f_description;
    }

    public int getSrid() {
        return this.f_srid;
    }

    public void setDimension(int n) {
        if (n < 2 || n > 3) {
            SpatialManager.invalidArg("dimension", n, this.getClass().getName(), "setDimension");
        }
        this.f_dimension = n;
    }

    public void setSrtext(String string) {
        this.f_srtext = string != null ? string.trim() : f_EMPTY_STRING;
    }

    public void setAuthName(String string) {
        this.f_authName = string != null ? string.trim() : string;
    }

    public void setAuthSrid(Integer n) {
        this.f_authSrid = n;
    }

    public void setDescription(String string) {
        this.f_description = string != null ? string.trim() : string;
    }

    public void setSrid(int n) {
        this.f_srid = n;
    }

    public void unsetSrid() {
        this.f_srid = Integer.MIN_VALUE;
    }

    public void setExtent(Envelope envelope) {
        double d;
        double d2;
        double d3;
        String string = "setByExtent";
        if (envelope == null) {
            SpatialManager.invalidArg("env", "null", this.getClass().getName(), string);
        }
        double d4 = envelope.getMaxX() - envelope.getMinX();
        double d5 = envelope.getMaxY() - envelope.getMinY();
        if (d4 <= 0.0 || d5 <= 0.0) {
            SpatialManager.invalidArg("env", envelope.toString(), this.getClass().getName(), string);
        } else {
            this.f_xyUnits = 9.007199254740992E15 / Math.max(d4, d5);
            this.f_falseX = CoordRef.calcFalseOrigin(envelope.getMinX(), this.f_xyUnits);
            this.f_falseY = CoordRef.calcFalseOrigin(envelope.getMinY(), this.f_xyUnits);
            this.f_xyCRound = CoordRef.calcCRound(this.f_xyUnits);
            this.f_xyHalfSU = CoordRef.calcHalfSU(this.f_xyCRound);
        }
        if (envelope.hasZ() && (d3 = envelope.getMaxZ() - envelope.getMinZ()) > 0.0) {
            d2 = 9.007199254740992E15 / d3;
            d = CoordRef.calcFalseOrigin(envelope.getMinZ(), d2);
            this.setM(d, d2);
        }
        if (envelope.hasM() && (d3 = envelope.getMaxM() - envelope.getMinM()) > 0.0) {
            d2 = 9.007199254740992E15 / d3;
            d = CoordRef.calcFalseOrigin(envelope.getMinM(), d2);
            this.setM(d, d2);
        }
    }

    public void setXY(double d, double d2, double d3) {
        if (d3 < 1.0) {
            SpatialManager.invalidArg("xyUnits", Double.toString(d3), this.getClass().getName(), "setXY");
        } else {
            this.f_falseX = d;
            this.f_falseY = d2;
            this.f_xyUnits = d3;
            this.f_xyCRound = CoordRef.calcCRound(this.f_xyUnits);
            this.f_xyHalfSU = CoordRef.calcHalfSU(this.f_xyCRound);
        }
    }

    public void setZ(double d, double d2) {
        if (d2 < 1.0) {
            SpatialManager.invalidArg("zUnits", Double.toString(d2), this.getClass().getName(), "setZ");
        } else {
            this.f_falseZ = d;
            this.f_zUnits = d2;
            this.f_zCRound = CoordRef.calcCRound(this.f_zUnits);
            this.f_zHalfSU = CoordRef.calcHalfSU(this.f_zCRound);
        }
    }

    public void setM(double d, double d2) {
        if (d2 < 1.0) {
            SpatialManager.invalidArg("mUnits", Double.toString(d2), this.getClass().getName(), "setM");
        } else {
            this.f_falseM = d;
            this.f_mUnits = d2;
            this.f_mCRound = CoordRef.calcCRound(this.f_mUnits);
            this.f_mHalfSU = CoordRef.calcHalfSU(this.f_mCRound);
        }
    }

    public long convertXValueToSystem(double d) throws SpatialException {
        return CoordRef.planarToSystem(d, this.f_falseX, this.f_xyUnits);
    }

    public long convertYValueToSystem(double d) throws SpatialException {
        return CoordRef.planarToSystem(d, this.f_falseY, this.f_xyUnits);
    }

    public long convertZValueToSystem(double d) throws SpatialException {
        return CoordRef.planarToSystem(d, this.f_falseZ, this.f_zUnits);
    }

    public long convertMValueToSystem(double d) throws SpatialException {
        return CoordRef.planarToSystem(d, this.f_falseM, this.f_mUnits);
    }

    public double convertXValueToWorld(long l) {
        return CoordRef.systemToPlanar(l, this.f_falseX, this.f_xyUnits);
    }

    public double[] convertXYValuesToWorld(long[] lArray) {
        double[] dArray = new double[lArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            dArray[i] = CoordRef.systemToPlanar(lArray[i], this.f_falseX, this.f_xyUnits);
            dArray[++i] = CoordRef.systemToPlanar(lArray[i], this.f_falseY, this.f_xyUnits);
        }
        return dArray;
    }

    public double[] convertZValuesToWorld(long[] lArray) {
        double[] dArray = new double[lArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            dArray[i] = CoordRef.systemToPlanar(lArray[i], this.f_falseZ, this.f_zUnits);
        }
        return dArray;
    }

    public double[] convertMValuesToWorld(long[] lArray) {
        double[] dArray = new double[lArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            dArray[i] = CoordRef.systemToPlanar(lArray[i], this.f_falseM, this.f_mUnits);
        }
        return dArray;
    }

    public double convertYValueToWorld(long l) {
        return CoordRef.systemToPlanar(l, this.f_falseY, this.f_xyUnits);
    }

    public double convertZValueToWorld(long l) {
        return CoordRef.systemToPlanar(l, this.f_falseZ, this.f_zUnits);
    }

    public double convertMValueToWorld(long l) {
        return CoordRef.systemToPlanar(l, this.f_falseM, this.f_mUnits);
    }

    public CoordRef duplicate() {
        return (CoordRef)this.clone();
    }

    public boolean sameAs(CoordRef coordRef, int n) {
        if ((n & 0xFFFFFFF0) != 0 || n == 0) {
            SpatialManager.invalidArg("flags", n, this.getClass().getName(), "sameAs");
        }
        if ((n & 8) != 0) {
            double d;
            double d2 = Math.min(this.f_xyUnits, coordRef.f_xyUnits);
            if (this.f_xyUnits != coordRef.f_xyUnits && (d = Math.abs(this.f_xyUnits - coordRef.f_xyUnits)) * d2 > 2.3283064376228985E-10) {
                return false;
            }
            if (this.f_falseX != coordRef.f_falseX && (d = Math.abs(this.f_falseX - coordRef.f_falseX)) * d2 > 0.5) {
                return false;
            }
            if (this.f_falseY != coordRef.f_falseY && (d = Math.abs(this.f_falseY - coordRef.f_falseY)) * d2 > 0.5) {
                return false;
            }
            d2 = Math.min(this.f_zUnits, coordRef.f_zUnits);
            if (this.f_zUnits != coordRef.f_zUnits && (d = Math.abs(this.f_zUnits - coordRef.f_zUnits)) * d2 > 2.3283064376228985E-10) {
                return false;
            }
            if (this.f_falseZ != coordRef.f_falseZ && (d = Math.abs(this.f_falseZ - coordRef.f_falseZ)) * d2 > 0.5) {
                return false;
            }
            d2 = Math.min(this.f_mUnits, coordRef.f_mUnits);
            if (this.f_mUnits != coordRef.f_mUnits && (d = Math.abs(this.f_mUnits - coordRef.f_mUnits)) * d2 > 2.3283064376228985E-10) {
                return false;
            }
            if (this.f_falseM != coordRef.f_falseM && (d = Math.abs(this.f_falseM - coordRef.f_falseM)) * d2 > 0.5) {
                return false;
            }
        }
        if ((n & 2) != 0) {
            if (this.f_authName == null ? coordRef.f_authName != null : !this.f_authName.equals(coordRef.f_authName)) {
                return false;
            }
            if (this.f_authSrid == null ? coordRef.f_authSrid != null : !this.f_authSrid.equals(coordRef.f_authSrid)) {
                return false;
            }
        }
        if (!((n & 1) == 0 || this.f_srtext == coordRef.f_srtext || this.f_srtext != null && this.f_srtext.equals(coordRef.f_srtext))) {
            return false;
        }
        return (n & 4) == 0 || !(this.f_description == null ? coordRef.f_description != null : !this.f_description.equals(coordRef.f_description));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CoordRef)) {
            return false;
        }
        CoordRef coordRef = (CoordRef)object;
        if (this.f_srid != coordRef.f_srid) {
            return false;
        }
        if (Double.doubleToLongBits(this.f_falseX) != Double.doubleToLongBits(coordRef.f_falseX) || Double.doubleToLongBits(this.f_falseY) != Double.doubleToLongBits(coordRef.f_falseY) || Double.doubleToLongBits(this.f_xyUnits) != Double.doubleToLongBits(coordRef.f_xyUnits) || Double.doubleToLongBits(this.f_falseZ) != Double.doubleToLongBits(coordRef.f_falseZ) || Double.doubleToLongBits(this.f_zUnits) != Double.doubleToLongBits(coordRef.f_zUnits) || Double.doubleToLongBits(this.f_falseM) != Double.doubleToLongBits(coordRef.f_falseM) || Double.doubleToLongBits(this.f_mUnits) != Double.doubleToLongBits(coordRef.f_mUnits) || this.f_dimension != coordRef.f_dimension) {
            return false;
        }
        return this.sameAs(coordRef, 7);
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.f_falseX) ^ Double.doubleToLongBits(this.f_falseY) ^ Double.doubleToLongBits(this.f_xyUnits) ^ Double.doubleToLongBits(this.f_falseZ) ^ Double.doubleToLongBits(this.f_zUnits) ^ Double.doubleToLongBits(this.f_falseM) ^ Double.doubleToLongBits(this.f_mUnits);
        int n = (int)l ^ this.f_dimension ^ this.f_srid ^ this.f_srtext.hashCode();
        if (this.f_description != null) {
            n ^= this.f_description.hashCode();
        }
        if (this.f_authName != null) {
            n ^= this.f_authName.hashCode();
        }
        if (this.f_authSrid != null) {
            n ^= this.f_authSrid.hashCode();
        }
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(512);
        stringBuffer.append("(").append(this.getClass().getName()).append(": ");
        stringBuffer.append("srid=").append(this.f_srid);
        stringBuffer.append(",authName=").append(this.f_authName);
        stringBuffer.append(",authSrid=").append(this.f_authSrid);
        stringBuffer.append(",description=").append(this.f_description);
        stringBuffer.append(",falsex=").append(this.f_falseX);
        stringBuffer.append(",falsey=").append(this.f_falseY);
        stringBuffer.append(",xyunits=").append(this.f_xyUnits);
        stringBuffer.append(",falsez=").append(this.f_falseZ);
        stringBuffer.append(",zunits=").append(this.f_zUnits);
        stringBuffer.append(",falsem=").append(this.f_falseM);
        stringBuffer.append(",munits=").append(this.f_mUnits);
        stringBuffer.append(",srtext=").append(this.f_srtext).append(")");
        return stringBuffer.toString();
    }

    public Object clone() {
        Object object = null;
        try {
            object = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return object;
    }

    void setFalseX(double d) {
        this.f_falseX = d;
    }

    void setFalseY(double d) {
        this.f_falseY = d;
    }

    void setXYUnits(double d) {
        this.f_xyUnits = d;
    }

    void setFalseZ(double d) {
        this.f_falseZ = d;
    }

    void setZUnits(double d) {
        this.f_zUnits = d;
    }

    void setFalseM(double d) {
        this.f_falseM = d;
    }

    void setMUnits(double d) {
        this.f_mUnits = d;
    }

    boolean isSridUnset() {
        return this.f_srid == Integer.MIN_VALUE;
    }

    private static long planarToSystem(double d, double d2, double d3) throws SpatialException {
        if (!Double.isNaN(d)) {
            double d4 = (d - d2) * d3 + 0.5;
            if (d4 <= 0.0 && d4 > 9.007199254740992E15) {
                Object[] objectArray = new Object[]{new Double(d4)};
                SpatialManager.reportError(2, objectArray, "CoordRef", "planarToSystem");
            }
            return (int)d4;
        }
        return -1L;
    }

    private static double systemToPlanar(long l, double d, double d2) {
        if (l == -1L) {
            return Double.NaN;
        }
        return (double)l / d2 + d;
    }

    private static double calcCRound(double d) {
        double d2 = d == 1.0 ? 1.0 : Math.pow(10.0, -((Math.log(d - 1.0) + 1.0) / f_LOG_10));
        return d2;
    }

    private static double calcHalfSU(double d) {
        return d / 2.0;
    }

    private static double calcFalseOrigin(double d, double d2) {
        return d - 1.0 / d2;
    }
}

