/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.spatial.srs;

import com.ibm.spatial.SpatialException;
import com.ibm.spatial.SpatialManager;
import com.ibm.spatial.geom.Envelope;
import com.ibm.spatial.srs.CoordRef;
import com.ibm.spatial.util.Logger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;

public class CoordRefManager {
    private static final CoordRefManager INSTANCE = new CoordRefManager();
    private Connection f_conn = null;
    private Hashtable f_srsTable = new Hashtable(32);
    private static final EmptyEnumerator f_EMPTY_ENUM = new EmptyEnumerator();
    private static final Vector f_EMPTY_VECTOR = new Vector();
    private static final String f_updateColumns = "auth_name, auth_srid, description, falsex, falsey, xyunits, falsez, zunits, falsem, munits, srtext";
    private static final String f_allColumns = "srid, auth_name, auth_srid, description, falsex, falsey, xyunits, falsez, zunits, falsem, munits, srtext";
    private static final boolean f_ignoreNullConnection = false;

    CoordRefManager() {
    }

    public void setConnection(Connection connection) {
        this.f_conn = connection;
    }

    public Connection getConnection() {
        return this.f_conn;
    }

    public static CoordRefManager getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CoordRef get(int n) throws SpatialException {
        String string = "get";
        Logger logger = Logger.getInstance();
        logger.entering(this.getClass().getName(), string);
        CoordRefImmutable coordRefImmutable = null;
        coordRefImmutable = (CoordRefImmutable)this.f_srsTable.get(new Integer(n));
        if (coordRefImmutable == null && this.verifyConnection(string)) {
            CoordRefManager coordRefManager = this;
            synchronized (coordRefManager) {
                coordRefImmutable = (CoordRefImmutable)this.f_srsTable.get(new Integer(n));
                if (coordRefImmutable == null && this.f_conn != null && (coordRefImmutable = this.findInDb(n)) != null) {
                    this.f_srsTable.put(new Integer(n), coordRefImmutable);
                }
            }
        }
        logger.exiting(this.getClass().getName(), string);
        return coordRefImmutable;
    }

    public synchronized Enumeration findByAuth(String string, Integer n) throws SpatialException {
        String string2 = "findByAuth";
        Logger logger = Logger.getInstance();
        logger.entering(this.getClass().getName(), string2);
        CoordRef coordRef = new CoordRef();
        coordRef.setAuthName(string);
        coordRef.setAuthSrid(n);
        Enumeration enumeration = this.doFind(coordRef, 2);
        logger.exiting(this.getClass().getName(), string2);
        return enumeration;
    }

    public synchronized Enumeration findBySrtext(String string) throws SpatialException {
        String string2 = "findBySrtext";
        Logger logger = Logger.getInstance();
        logger.entering(this.getClass().getName(), string2);
        CoordRef coordRef = new CoordRef();
        coordRef.setSrtext(string);
        Enumeration enumeration = this.doFind(coordRef, 1);
        logger.exiting(this.getClass().getName(), string2);
        return enumeration;
    }

    public synchronized Enumeration findByDesc(String string) throws SpatialException {
        String string2 = "findByDesc";
        Logger logger = Logger.getInstance();
        logger.entering(this.getClass().getName(), string2);
        CoordRef coordRef = new CoordRef();
        coordRef.setDescription(string);
        Enumeration enumeration = this.doFind(coordRef, 4);
        logger.exiting(this.getClass().getName(), string2);
        return enumeration;
    }

    public synchronized Enumeration find(CoordRef coordRef, int n) throws SpatialException {
        String string = "find";
        Logger logger = Logger.getInstance();
        logger.entering(this.getClass().getName(), string);
        Enumeration enumeration = this.doFind(coordRef, n);
        logger.exiting(this.getClass().getName(), string);
        return enumeration;
    }

    public Enumeration getAll() {
        return this.f_srsTable.elements();
    }

    public Enumeration getAllSrids() {
        return this.f_srsTable.keys();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized CoordRef put(CoordRef coordRef) throws SpatialException {
        String string = "put";
        Logger logger = Logger.getInstance();
        logger.entering(this.getClass().getName(), string);
        this.verifyNotNull("cr", coordRef, string);
        CoordRefImmutable coordRefImmutable = null;
        if (this.verifyConnection(string)) {
            boolean bl = true;
            try {
                coordRefImmutable = (CoordRefImmutable)this.get(coordRef.getSrid());
                if (coordRefImmutable != null) {
                    coordRefImmutable.update(coordRef);
                    coordRefImmutable.store();
                } else {
                    if (coordRef.isSridUnset()) {
                        Enumeration enumeration = this.find(coordRef, 15);
                        if (enumeration.hasMoreElements()) {
                            coordRefImmutable = (CoordRefImmutable)enumeration.nextElement();
                        } else {
                            coordRef.setSrid(this.reserveNextAvailablePk());
                            coordRefImmutable = new CoordRefImmutable(coordRef);
                            coordRefImmutable.store();
                        }
                    } else {
                        coordRefImmutable = new CoordRefImmutable(coordRef);
                        if (coordRefImmutable.isStored()) {
                            coordRefImmutable.store();
                            Object[] objectArray = new Object[]{new Integer(coordRefImmutable.getSrid())};
                            Logger.getInstance().log(900, this.getClass().getName(), string, 23, objectArray);
                        } else {
                            coordRefImmutable.create();
                        }
                    }
                    this.f_srsTable.put(new Integer(coordRefImmutable.getSrid()), coordRefImmutable);
                }
                bl = false;
            }
            finally {
                if (bl) {
                    this.refresh();
                }
            }
        }
        logger.exiting(this.getClass().getName(), string);
        return coordRefImmutable;
    }

    public void remove(int n) throws SpatialException {
        String string = "remove";
        Logger logger = Logger.getInstance();
        logger.entering(this.getClass().getName(), string);
        this.doRemove(n, true);
        logger.exiting(this.getClass().getName(), string);
    }

    public void removeFromCache(int n) throws SpatialException {
        String string = "removeFromCache";
        Logger logger = Logger.getInstance();
        logger.entering(this.getClass().getName(), string);
        this.doRemove(n, false);
        logger.exiting(this.getClass().getName(), string);
    }

    public synchronized void refresh() throws SpatialException {
        String string = "read";
        Logger logger = Logger.getInstance();
        logger.entering(this.getClass().getName(), string);
        if (this.verifyConnection(string)) {
            Enumeration enumeration = this.f_srsTable.elements();
            while (enumeration.hasMoreElements()) {
                CoordRefImmutable coordRefImmutable = (CoordRefImmutable)enumeration.nextElement();
                if (coordRefImmutable.load()) continue;
                this.f_srsTable.remove(new Integer(coordRefImmutable.getSrid()));
            }
        }
        logger.exiting(this.getClass().getName(), string);
    }

    public synchronized int size() {
        return this.f_srsTable.size();
    }

    private Enumeration doFind(CoordRef coordRef, int n) throws SpatialException {
        if (coordRef == null) {
            return f_EMPTY_ENUM;
        }
        Vector<CoordRef> vector = this.findInCache(coordRef, n);
        if (this.verifyConnection("doFind")) {
            Vector vector2 = this.findInDb(coordRef, n, vector);
            int n2 = vector2.size();
            if (n2 > 0 && vector == f_EMPTY_VECTOR) {
                vector = new Vector<CoordRef>();
            }
            for (int i = 0; i < n2; ++i) {
                CoordRef coordRef2 = (CoordRef)vector2.get(i);
                vector.add(coordRef2);
            }
        }
        return vector.elements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoordRefImmutable findInDb(int n) throws SpatialException {
        String string = "findInDb";
        Logger logger = Logger.getInstance();
        logger.entering(this.getClass().getName(), string);
        CoordRefImmutable coordRefImmutable = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = this.f_conn.createStatement();
            String string2 = "SELECT srid, auth_name, auth_srid, description, falsex, falsey, xyunits, falsez, zunits, falsem, munits, srtext FROM SDE.SPATIAL_REFERENCES WHERE srid=" + n;
            resultSet = statement.executeQuery(string2);
            while (resultSet.next()) {
                coordRefImmutable = new CoordRefImmutable(resultSet);
            }
        }
        catch (SQLException sQLException) {
            this.processSQLException(sQLException, string);
        }
        finally {
            this.closeStatement(statement, string);
        }
        logger.exiting(this.getClass().getName(), string);
        return coordRefImmutable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector findInDb(CoordRef coordRef, int n, Vector vector) throws SpatialException {
        Object object;
        boolean bl;
        String string = "findInDb";
        Logger logger = Logger.getInstance();
        logger.entering(this.getClass().getName(), string);
        String string2 = "SELECT srid, auth_name, auth_srid, description, falsex, falsey, xyunits, falsez, zunits, falsem, munits, srtext FROM SDE.SPATIAL_REFERENCES";
        boolean bl2 = (n & 2) != 0;
        boolean bl3 = bl = vector != null && vector.size() > 0;
        if (bl2 || bl) {
            string2 = string2 + " WHERE ";
        }
        if (bl2) {
            String string3 = "auth_name " + (coordRef.getAuthName() != null ? "= '" + coordRef.getAuthName() + "'" : "IS NULL") + " AND auth_srid " + (coordRef.getAuthSrid() != null ? "= " + coordRef.getAuthSrid() : "IS NULL");
            string2 = string2 + string3;
        }
        if (bl) {
            int n2 = vector.size() - 1;
            object = new StringBuffer(256);
            if (bl2) {
                ((StringBuffer)object).append(" AND");
            }
            ((StringBuffer)object).append(" srid NOT IN (");
            int n3 = 0;
            while (n3 < n2) {
                ((StringBuffer)object).append(((CoordRef)vector.get(n3++)).getSrid());
                ((StringBuffer)object).append(" ,");
            }
            if (n3 == n2) {
                ((StringBuffer)object).append(((CoordRef)vector.get(n3)).getSrid());
            }
            ((StringBuffer)object).append(')');
            string2 = string2 + object;
        }
        boolean bl4 = (n & 0xF) == 0;
        object = null;
        Vector<CoordRefImmutable> vector2 = f_EMPTY_VECTOR;
        try {
            object = this.f_conn.prepareStatement(string2);
            ResultSet resultSet = object.executeQuery();
            while (resultSet.next()) {
                CoordRefImmutable coordRefImmutable = new CoordRefImmutable(resultSet);
                if (!bl4 && !coordRefImmutable.sameAs(coordRef, n)) continue;
                if (vector2 == f_EMPTY_VECTOR) {
                    vector2 = new Vector<CoordRefImmutable>();
                }
                vector2.add(coordRefImmutable);
            }
        }
        catch (SQLException sQLException) {
            this.processSQLException(sQLException, string);
        }
        finally {
            this.closeStatement((Statement)object, string);
        }
        logger.exiting(this.getClass().getName(), string);
        return vector2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized CoordRefImmutable doRemove(int n, boolean bl) throws SpatialException {
        CoordRefImmutable coordRefImmutable = null;
        if (this.verifyConnection("doRemove")) {
            boolean bl2 = true;
            try {
                block10: {
                    coordRefImmutable = (CoordRefImmutable)this.f_srsTable.remove(new Integer(n));
                    if (bl) {
                        try {
                            if (coordRefImmutable == null) {
                                coordRefImmutable = this.findInDb(n);
                            }
                            if (coordRefImmutable != null) {
                                coordRefImmutable.remove();
                            }
                        }
                        catch (SpatialException spatialException) {
                            if (spatialException.getErrorCode() == 7) break block10;
                            throw spatialException;
                        }
                    }
                }
                bl2 = false;
            }
            finally {
                if (bl2) {
                    this.refresh();
                }
            }
        }
        return coordRefImmutable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int reserveNextAvailablePk() throws SpatialException {
        String string = "reserveNextAvailablePk";
        Logger logger = Logger.getInstance();
        logger.entering(this.getClass().getName(), string);
        Statement statement = null;
        int n = Integer.MIN_VALUE;
        CoordRefManager coordRefManager = this;
        synchronized (coordRefManager) {
            try {
                statement = this.f_conn.createStatement();
                String string2 = "SELECT max(srid) FROM SDE.SPATIAL_REFERENCES";
                ResultSet resultSet = statement.executeQuery(string2);
                n = resultSet.next() ? resultSet.getInt(1) + 1 : 1;
                string2 = "INSERT INTO SDE.SPATIAL_REFERENCES VALUES(" + n + ",NULL,NULL,NULL,0.0,-1000.0,1000," + "-1000.0,1000,-1000.0,1000,'UNKNOWN')";
                statement.executeUpdate(string2);
            }
            catch (SQLException sQLException) {
                this.processSQLException(sQLException, string);
            }
            finally {
                this.closeStatement(statement, string);
            }
        }
        logger.exiting(this.getClass().getName(), string);
        return n;
    }

    private Vector findInCache(CoordRef coordRef, int n) {
        boolean bl;
        Enumeration enumeration = this.f_srsTable.elements();
        Vector<CoordRef> vector = f_EMPTY_VECTOR;
        boolean bl2 = bl = (n & 0xF) == 0;
        while (enumeration.hasMoreElements()) {
            CoordRef coordRef2 = (CoordRef)enumeration.nextElement();
            if (!bl && !coordRef2.sameAs(coordRef, n)) continue;
            if (vector == f_EMPTY_VECTOR) {
                vector = new Vector<CoordRef>();
            }
            vector.add(coordRef2);
        }
        return vector;
    }

    private boolean verifyConnection(String string) throws SpatialException {
        if (this.f_conn != null) {
            return true;
        }
        SpatialManager.reportError(8, this.getClass().getName(), string);
        return false;
    }

    private void verifyNotNull(String string, Object object, String string2) throws SpatialException {
        if (object == null) {
            Object[] objectArray = new Object[]{string, object};
            SpatialManager.reportError(16, objectArray, this.getClass().getName(), string2);
        }
    }

    private void processSQLException(SQLException sQLException, String string) throws SpatialException {
        SQLException sQLException2 = sQLException;
        do {
            Object[] objectArray = new Object[]{sQLException.getSQLState(), new Integer(sQLException.getErrorCode()), sQLException.getMessage()};
            Logger.getInstance().log(1000, this.getClass().getName(), string, 7, objectArray);
        } while ((sQLException = sQLException.getNextException()) != null);
        SpatialManager.reportError(sQLException2, this.getClass().getName(), string);
    }

    private void closeStatement(Statement statement, String string) {
        try {
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException sQLException) {
            Object[] objectArray = new Object[]{sQLException.getSQLState(), new Integer(sQLException.getErrorCode()), sQLException.getMessage()};
            Logger.getInstance().log(900, this.getClass().getName(), string, 7, objectArray);
        }
    }

    private static class EmptyEnumerator
    implements Enumeration {
        EmptyEnumerator() {
        }

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() {
            throw new NoSuchElementException("CoordRefManager Enumerator");
        }
    }

    private class CoordRefImmutable
    extends CoordRef {
        private static final String f_className = "CoordRefImmutable";

        CoordRefImmutable() {
        }

        CoordRefImmutable(CoordRef coordRef) {
            this.update(coordRef);
        }

        CoordRefImmutable(ResultSet resultSet) throws SQLException {
            this.update(resultSet);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void create() throws SpatialException {
            Logger logger;
            String string;
            PreparedStatement preparedStatement;
            block10: {
                preparedStatement = null;
                string = "create";
                logger = Logger.getInstance();
                logger.entering(this.getClass().getName(), string);
                try {
                    String string2 = "INSERT INTO sde.spatial_references (srid, auth_name, auth_srid, description, falsex, falsey, xyunits, falsez, zunits, falsem, munits, srtext) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                    preparedStatement = CoordRefManager.this.f_conn.prepareStatement(string2);
                    preparedStatement.setInt(1, this.f_srid);
                    if (this.f_authName != null) {
                        preparedStatement.setString(2, this.f_authName);
                    } else {
                        preparedStatement.setNull(2, 12);
                    }
                    if (this.f_authSrid != null) {
                        preparedStatement.setInt(3, this.f_authSrid);
                    } else {
                        preparedStatement.setNull(3, 4);
                    }
                    if (this.f_description != null) {
                        preparedStatement.setString(4, this.f_description);
                    } else {
                        preparedStatement.setNull(4, 12);
                    }
                    preparedStatement.setDouble(5, this.f_falseX);
                    preparedStatement.setDouble(6, this.f_falseY);
                    preparedStatement.setDouble(7, this.f_xyUnits);
                    preparedStatement.setDouble(8, this.f_falseZ);
                    preparedStatement.setDouble(9, this.f_zUnits);
                    preparedStatement.setDouble(10, this.f_falseM);
                    preparedStatement.setDouble(11, this.f_mUnits);
                    preparedStatement.setString(12, this.f_srtext);
                    if (preparedStatement.executeUpdate() == 1) break block10;
                    Object[] objectArray = new Object[]{new Integer(this.f_srid)};
                    SpatialManager.reportError(3, objectArray, this.getClass().getName(), string);
                }
                catch (SQLException sQLException) {
                    try {
                        CoordRefManager.this.processSQLException(sQLException, string);
                    }
                    catch (Throwable throwable) {
                        CoordRefManager.this.closeStatement(preparedStatement, string);
                        throw throwable;
                    }
                    CoordRefManager.this.closeStatement(preparedStatement, string);
                }
            }
            CoordRefManager.this.closeStatement(preparedStatement, string);
            logger.exiting(this.getClass().getName(), string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void store() throws SpatialException {
            PreparedStatement preparedStatement = null;
            String string = "store";
            Logger logger = Logger.getInstance();
            logger.entering(this.getClass().getName(), string);
            try {
                preparedStatement = CoordRefManager.this.f_conn.prepareStatement("UPDATE sde.spatial_references SET (auth_name, auth_srid, description, falsex, falsey, xyunits, falsez, zunits, falsem, munits, srtext) = (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?) WHERE srid = ?");
                if (this.f_authName != null) {
                    preparedStatement.setString(1, this.f_authName);
                } else {
                    preparedStatement.setNull(1, 12);
                }
                if (this.f_authSrid != null) {
                    preparedStatement.setInt(2, this.f_authSrid);
                } else {
                    preparedStatement.setNull(2, 4);
                }
                if (this.f_description != null) {
                    preparedStatement.setString(3, this.f_description);
                } else {
                    preparedStatement.setNull(3, 12);
                }
                preparedStatement.setDouble(4, this.f_falseX);
                preparedStatement.setDouble(5, this.f_falseY);
                preparedStatement.setDouble(6, this.f_xyUnits);
                preparedStatement.setDouble(7, this.f_falseZ);
                preparedStatement.setDouble(8, this.f_zUnits);
                preparedStatement.setDouble(9, this.f_falseM);
                preparedStatement.setDouble(10, this.f_mUnits);
                preparedStatement.setString(11, this.f_srtext);
                preparedStatement.setInt(12, this.f_srid);
                if (preparedStatement.executeUpdate() != 1) {
                    Object[] objectArray = new Object[]{new Integer(this.f_srid)};
                    SpatialManager.reportError(5, objectArray, this.getClass().getName(), string);
                }
            }
            catch (SQLException sQLException) {
                CoordRefManager.this.processSQLException(sQLException, string);
            }
            finally {
                CoordRefManager.this.closeStatement(preparedStatement, string);
            }
            logger.exiting(this.getClass().getName(), string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove() throws SpatialException {
            Statement statement = null;
            String string = "remove";
            Logger logger = Logger.getInstance();
            logger.entering(this.getClass().getName(), string);
            try {
                statement = CoordRefManager.this.f_conn.createStatement();
                String string2 = "DELETE FROM sde.spatial_references WHERE srid =" + this.f_srid;
                if (statement.executeUpdate(string2) != 1) {
                    Object[] objectArray = new Object[]{new Integer(this.f_srid)};
                    SpatialManager.reportError(6, objectArray, this.getClass().getName(), string);
                }
            }
            catch (SQLException sQLException) {
                CoordRefManager.this.processSQLException(sQLException, string);
            }
            finally {
                CoordRefManager.this.closeStatement(statement, string);
            }
            logger.exiting(this.getClass().getName(), string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean load() throws SpatialException {
            String string = "load";
            boolean bl = true;
            Logger logger = Logger.getInstance();
            logger.entering(this.getClass().getName(), string);
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                statement = CoordRefManager.this.f_conn.createStatement();
                String string2 = "SELECT srid, auth_name, auth_srid, description, falsex, falsey, xyunits, falsez, zunits, falsem, munits, srtext FROM SDE.SPATIAL_REFERENCES WHERE srid=" + this.f_srid;
                resultSet = statement.executeQuery(string2);
                if (resultSet.next()) {
                    this.update(resultSet);
                } else {
                    bl = false;
                }
                if (resultSet.next()) {
                    Object[] objectArray = new Object[]{new Integer(this.f_srid)};
                    SpatialManager.reportError(4, objectArray, this.getClass().getName(), string);
                }
            }
            catch (SQLException sQLException) {
                CoordRefManager.this.processSQLException(sQLException, string);
            }
            finally {
                CoordRefManager.this.closeStatement(statement, string);
            }
            logger.exiting(this.getClass().getName(), string);
            return bl;
        }

        private synchronized void update(ResultSet resultSet) throws SQLException {
            this.f_dimension = 3;
            this.f_srid = resultSet.getInt(1);
            this.f_authName = resultSet.getString(2);
            Object var2_2 = null;
            String string = resultSet.getString(3);
            this.f_authSrid = string != null ? new Integer(string) : null;
            this.f_description = resultSet.getString(4);
            super.setXY(resultSet.getFloat(5), resultSet.getFloat(6), resultSet.getFloat(7));
            super.setZ(resultSet.getFloat(8), resultSet.getFloat(9));
            super.setM(resultSet.getFloat(10), resultSet.getFloat(11));
            this.f_srtext = resultSet.getString(12);
            if (this.f_authName != null) {
                this.f_authName = this.f_authName.trim();
            }
            if (this.f_description != null) {
                this.f_description = this.f_description.trim();
            }
            if (this.f_srtext != null) {
                this.f_srtext = this.f_srtext.trim();
            }
        }

        private synchronized void update(CoordRef coordRef) {
            this.f_dimension = coordRef.getDimension();
            this.f_srid = coordRef.getSrid();
            this.f_authName = coordRef.getAuthName();
            this.f_authSrid = coordRef.getAuthSrid();
            this.f_description = coordRef.getDescription();
            super.setXY(coordRef.getFalseX(), coordRef.getFalseY(), coordRef.getXYUnits());
            super.setZ(coordRef.getFalseZ(), coordRef.getZUnits());
            super.setM(coordRef.getFalseM(), coordRef.getMUnits());
            this.f_srtext = coordRef.getSrtext();
            if (this.f_authName != null) {
                this.f_authName = this.f_authName.trim();
            }
            if (this.f_description != null) {
                this.f_description = this.f_description.trim();
            }
            if (this.f_srtext != null) {
                this.f_srtext = this.f_srtext.trim();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isStored() throws SpatialException {
            String string = "isStored";
            Logger logger = Logger.getInstance();
            logger.entering(f_className, string);
            Statement statement = null;
            ResultSet resultSet = null;
            boolean bl = false;
            try {
                statement = CoordRefManager.this.f_conn.createStatement();
                String string2 = "SELECT count(*) FROM SDE.SPATIAL_REFERENCES WHERE srid=" + this.f_srid;
                resultSet = statement.executeQuery(string2);
                if (resultSet.next()) {
                    bl = resultSet.getInt(1) != 0;
                } else {
                    Object[] objectArray = new Object[]{new Integer(this.f_srid)};
                    SpatialManager.reportError(4, objectArray, f_className, string);
                }
            }
            catch (SQLException sQLException) {
                CoordRefManager.this.processSQLException(sQLException, string);
            }
            finally {
                CoordRefManager.this.closeStatement(statement, string);
            }
            logger.exiting(f_className, string);
            return bl;
        }

        @Override
        public void setSrid(int n) {
            SpatialManager.unsupported();
        }

        @Override
        public void unsetSrid() {
            SpatialManager.unsupported();
        }

        @Override
        public void setFalseX(double d) {
            SpatialManager.unsupported();
        }

        @Override
        public void setFalseY(double d) {
            SpatialManager.unsupported();
        }

        @Override
        public void setXY(double d, double d2, double d3) {
            SpatialManager.unsupported();
        }

        @Override
        public void setExtent(Envelope envelope) {
            SpatialManager.unsupported();
        }

        @Override
        public void setXYUnits(double d) {
            SpatialManager.unsupported();
        }

        @Override
        public void setFalseZ(double d) {
            SpatialManager.unsupported();
        }

        @Override
        public void setZ(double d, double d2) {
            SpatialManager.unsupported();
        }

        @Override
        public void setZUnits(double d) {
            SpatialManager.unsupported();
        }

        @Override
        public void setFalseM(double d) {
            SpatialManager.unsupported();
        }

        @Override
        public void setM(double d, double d2) {
            SpatialManager.unsupported();
        }

        @Override
        public void setMUnits(double d) {
            SpatialManager.unsupported();
        }

        @Override
        public void setSrtext(String string) {
            SpatialManager.unsupported();
        }

        @Override
        public void setAuthName(String string) {
            SpatialManager.unsupported();
        }

        @Override
        public void setAuthSrid(Integer n) {
            SpatialManager.unsupported();
        }

        @Override
        public void setDescription(String string) {
            SpatialManager.unsupported();
        }

        @Override
        public void setDimension(int n) {
            SpatialManager.unsupported();
        }
    }
}

