/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.spatial.util;

import com.ibm.spatial.ErrorHandler;
import com.ibm.spatial.EventLocation;
import com.ibm.spatial.SpatialException;
import com.ibm.spatial.util.HandlerImpl;
import com.ibm.spatial.util.ImplementationMessages;
import com.ibm.spatial.util.MessageProvider;
import com.ibm.spatial.util.Messages;

public class ErrorReporter {
    public static final int ERROR = 0;
    public static final int RECOVERABLE_ERROR = 1;
    public static final int WARNING = 2;
    public static final int RUNTIME = 3;
    public static final int EXCEPTION = 4;
    private ErrorHandler f_errorHandler;
    private MessageProvider f_messages;
    private MessageProvider f_implementationMessages;
    private boolean f_writeClassInfo = true;
    private boolean f_continueAfterFatalError = false;

    public ErrorReporter() {
        this.setHandler(new HandlerImpl());
        this.f_messages = new Messages();
        this.f_implementationMessages = new ImplementationMessages();
    }

    public ErrorReporter(ErrorHandler errorHandler, MessageProvider messageProvider, MessageProvider messageProvider2) {
        this.setHandler(errorHandler);
        this.f_messages = messageProvider;
        this.f_implementationMessages = messageProvider2;
    }

    public void setHandler(ErrorHandler errorHandler) {
        this.f_errorHandler = errorHandler;
    }

    public ErrorHandler getHandler() {
        return this.f_errorHandler;
    }

    public void setWriteClassInfo(boolean bl) {
        this.f_writeClassInfo = bl;
    }

    public boolean getWriteClassInfo() {
        return this.f_writeClassInfo;
    }

    public synchronized void reportError(int n, int n2, Object[] objectArray, EventLocation eventLocation) throws SpatialException {
        Object[] objectArray2;
        SpatialException spatialException;
        IllegalArgumentException illegalArgumentException = null;
        if (n == 4) {
            spatialException = new SpatialException(n2, eventLocation, (Exception)objectArray[0]);
        } else {
            objectArray2 = ErrorReporter.formatMessage(n2, this.f_messages, objectArray, eventLocation, this.f_writeClassInfo);
            spatialException = new SpatialException(n2, (String)objectArray2, eventLocation);
        }
        if (this.f_errorHandler == null) {
            if (!(n != 0 && n != 4 || this.f_continueAfterFatalError)) {
                throw spatialException;
            }
        } else {
            switch (n) {
                case 2: {
                    spatialException = (SpatialException)this.f_errorHandler.warning(spatialException);
                    break;
                }
                case 1: {
                    spatialException = (SpatialException)this.f_errorHandler.recoverableError(spatialException);
                    break;
                }
                case 0: 
                case 4: {
                    this.f_errorHandler.fatalError(spatialException);
                    break;
                }
                default: {
                    objectArray2 = new Object[]{new Integer(n)};
                    illegalArgumentException = new IllegalArgumentException(this.f_implementationMessages.getMessage(3, objectArray2));
                }
            }
        }
        if (illegalArgumentException != null) {
            throw illegalArgumentException;
        }
        if (spatialException != null) {
            throw spatialException;
        }
    }

    public synchronized void reportRuntimeError(int n, int n2, Object[] objectArray, EventLocation eventLocation) {
        Object[] objectArray2;
        RuntimeException runtimeException;
        String string = ErrorReporter.formatMessage(n2, this.f_messages, objectArray, eventLocation, this.f_writeClassInfo);
        switch (n2) {
            case 16: {
                runtimeException = new IllegalArgumentException(string);
                break;
            }
            case 17: {
                runtimeException = new IndexOutOfBoundsException(string);
                break;
            }
            case 19: 
            case 20: {
                runtimeException = new RuntimeException(string);
                break;
            }
            case 18: {
                runtimeException = new UnsupportedOperationException(string);
                break;
            }
            default: {
                objectArray2 = new Object[]{new Integer(n2)};
                runtimeException = new IllegalArgumentException(this.f_implementationMessages.getMessage(4, objectArray2));
            }
        }
        if (this.f_errorHandler == null) {
            if (!(n != 0 && n != 4 || this.f_continueAfterFatalError)) {
                throw runtimeException;
            }
        } else {
            switch (n) {
                case 2: {
                    runtimeException = (RuntimeException)this.f_errorHandler.warning(runtimeException);
                    break;
                }
                case 1: {
                    runtimeException = (RuntimeException)this.f_errorHandler.recoverableError(runtimeException);
                    break;
                }
                case 0: 
                case 4: {
                    this.f_errorHandler.fatalError(runtimeException);
                    break;
                }
                default: {
                    objectArray2 = new Object[]{new Integer(n)};
                    runtimeException = new IllegalArgumentException(this.f_implementationMessages.getMessage(3, objectArray2));
                }
            }
        }
        if (runtimeException != null) {
            throw runtimeException;
        }
    }

    public static String formatMessage(int n, MessageProvider messageProvider, Object[] objectArray, EventLocation eventLocation, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(512);
        stringBuffer = ErrorReporter.formatEventLocation(stringBuffer, eventLocation, bl);
        stringBuffer.append(messageProvider.getMessage(n, objectArray));
        return stringBuffer.toString();
    }

    public static StringBuffer formatEventLocation(StringBuffer stringBuffer, EventLocation eventLocation, boolean bl) {
        if (eventLocation != null) {
            if (eventLocation.getColumnNumber() == -2) {
                if (bl) {
                    stringBuffer.append(eventLocation.getEntityId()).append('(').append(eventLocation.getSubEntityId()).append("): ");
                }
            } else if (eventLocation.getEntityId() != null) {
                stringBuffer.append(eventLocation.getEntityId());
                if (eventLocation.getSubEntityId() != null) {
                    stringBuffer.append('.').append(eventLocation.getSubEntityId());
                }
                if (eventLocation.getLineNumber() >= 0) {
                    stringBuffer.append('(').append(eventLocation.getLineNumber());
                    if (eventLocation.getColumnNumber() >= 0) {
                        stringBuffer.append(':').append(eventLocation.getColumnNumber());
                    }
                    stringBuffer.append(')');
                }
                stringBuffer.append(": ");
            }
        }
        return stringBuffer;
    }
}

