/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.spatial.util;

import com.ibm.spatial.ErrorHandler;
import com.ibm.spatial.SpatialManager;
import com.ibm.spatial.util.LogHandler;
import com.ibm.spatial.util.LogRecord;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Date;

public class HandlerImpl
implements ErrorHandler,
LogHandler {
    private static final String f_timeFormat = "{0,date} {0,time}";
    private MessageFormat f_formatter;
    private Date f_date;
    private Object[] f_args;
    private StringBuffer f_text;
    private StringBuffer f_logBuffer;
    private Writer f_logWriter;
    private String f_lineSeparator;

    public HandlerImpl() {
        this.f_args = new Object[]{this.f_date};
        this.setWriter(new OutputStreamWriter(System.err));
    }

    @Override
    public Exception recoverableError(Exception exception) {
        return exception;
    }

    @Override
    public void fatalError(Exception exception) {
    }

    @Override
    public Exception warning(Exception exception) {
        return exception;
    }

    @Override
    public synchronized void write(LogRecord logRecord) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer(1024);
        if (this.f_lineSeparator == null) {
            try {
                this.f_lineSeparator = System.getProperty("line.separator");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (this.f_lineSeparator == null) {
                this.f_lineSeparator = "\n";
            }
        }
        if (this.f_date == null) {
            this.f_date = new Date();
        }
        if (this.f_args[0] == null) {
            this.f_args[0] = this.f_date;
        }
        if (this.f_formatter == null) {
            this.f_formatter = new MessageFormat(f_timeFormat);
        }
        if (this.f_text == null) {
            this.f_text = new StringBuffer(128);
        }
        this.f_text.setLength(0);
        if (stringBuffer == null) {
            stringBuffer = new StringBuffer(1024);
        }
        stringBuffer.setLength(0);
        this.f_date.setTime(logRecord.getTime());
        this.f_formatter.format(this.f_args, this.f_text, (FieldPosition)null);
        stringBuffer.append(this.f_text).append(' ');
        stringBuffer.append(logRecord.getThreadID()).append(' ');
        if (logRecord.getClassName() != null) {
            stringBuffer.append(logRecord.getClassName());
        }
        if (logRecord.getMethodName() != null) {
            stringBuffer.append(".");
            stringBuffer.append(logRecord.getMethodName());
        }
        stringBuffer.append(this.f_lineSeparator);
        String string = logRecord.getMessageProvider().getMessage(logRecord.getMessageCode(), logRecord.getParams());
        stringBuffer.append(HandlerImpl.getLogLevelName(logRecord));
        stringBuffer.append(": ");
        stringBuffer.append(string);
        stringBuffer.append(this.f_lineSeparator);
        if (logRecord.getThrown() != null) {
            try {
                object = new StringWriter();
                PrintWriter printWriter = new PrintWriter((Writer)object);
                logRecord.getThrown().printStackTrace(printWriter);
                printWriter.close();
                stringBuffer.append(((StringWriter)object).toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        object = new char[stringBuffer.length()];
        stringBuffer.getChars(0, stringBuffer.length(), (char[])object, 0);
        try {
            this.f_logWriter.write((char[])object, 0, stringBuffer.length());
            this.f_logWriter.flush();
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[]{exception.toString()};
            SpatialManager.getErrorReporter().reportRuntimeError(2, 29, objectArray, null);
        }
    }

    @Override
    public void flush() {
        try {
            this.f_logWriter.flush();
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[]{exception.toString()};
            SpatialManager.getErrorReporter().reportRuntimeError(2, 29, objectArray, null);
        }
    }

    @Override
    public void close() {
        try {
            if (this.f_logWriter instanceof FileWriter) {
                this.f_logWriter.close();
            } else {
                this.f_logWriter.flush();
            }
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[]{exception.toString()};
            SpatialManager.getErrorReporter().reportRuntimeError(2, 29, objectArray, null);
        }
    }

    public void setWriter(Writer writer) {
        if (writer == null) {
            writer = new BufferedWriter(new OutputStreamWriter(System.err));
        }
        this.f_logWriter = writer;
    }

    public Writer getWriter() {
        return this.f_logWriter;
    }

    private static String getLogLevelName(LogRecord logRecord) {
        int n = -1;
        switch (logRecord.getLevel()) {
            case 1000: {
                n = 26;
                break;
            }
            case 900: {
                n = 27;
                break;
            }
            case 800: {
                n = 28;
                break;
            }
            default: {
                SpatialManager.invalidArg("logRecord level", logRecord.getLevel(), "HandlerImpl", "getLogLevelName");
            }
        }
        return SpatialManager.getMessageProvider().getMessage(n, null);
    }
}

