/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.spatial.util;

import com.ibm.spatial.SpatialManager;
import com.ibm.spatial.util.LogHandler;
import com.ibm.spatial.util.LogRecord;
import com.ibm.spatial.util.MessageProvider;

public class Logger {
    public static final int OFF = Integer.MAX_VALUE;
    public static final int SEVERE = 1000;
    public static final int WARNING = 900;
    public static final int INFO = 800;
    public static final int ALL = Integer.MIN_VALUE;
    private static final int f_offValue = Integer.MAX_VALUE;
    private volatile int f_levelValue = Integer.MAX_VALUE;
    private LogHandler f_handler = null;
    private MessageProvider f_messages = null;

    public static synchronized Logger getInstance() {
        Logger logger = SpatialManager.getLogger();
        if (logger == null) {
            logger = new Logger();
            logger.setLogHandler(SpatialManager.getLogHandler());
            logger.setMessageProvider(SpatialManager.getMessageProvider());
            SpatialManager.setLogger(logger);
            logger = SpatialManager.getLogger();
        }
        return logger;
    }

    public void setLevel(int n) {
        this.f_levelValue = n;
    }

    public int getLevel() {
        return this.f_levelValue;
    }

    public boolean isLoggable(int n) {
        return n >= this.f_levelValue && this.f_levelValue != Integer.MAX_VALUE;
    }

    public void setMessageProvider(MessageProvider messageProvider) {
        this.f_messages = messageProvider;
    }

    public MessageProvider getMessageProvider() {
        return this.f_messages;
    }

    public void log(int n, int n2) {
        if (n < this.f_levelValue || this.f_levelValue == Integer.MAX_VALUE) {
            return;
        }
        this.doLog(n, n2, null, null, null, null);
    }

    public void log(int n, int n2, Object object) {
        if (n < this.f_levelValue || this.f_levelValue == Integer.MAX_VALUE) {
            return;
        }
        Object[] objectArray = new Object[]{object};
        this.doLog(n, n2, objectArray, null, null, null);
    }

    public void log(int n, int n2, Object[] objectArray) {
        if (n < this.f_levelValue || this.f_levelValue == Integer.MAX_VALUE) {
            return;
        }
        this.doLog(n, n2, objectArray, null, null, null);
    }

    public void log(int n, int n2, Throwable throwable) {
        if (n < this.f_levelValue || this.f_levelValue == Integer.MAX_VALUE) {
            return;
        }
        this.doLog(n, n2, null, null, null, throwable);
    }

    public void log(int n, String string, String string2, int n2) {
        if (n < this.f_levelValue || this.f_levelValue == Integer.MAX_VALUE) {
            return;
        }
        this.doLog(n, n2, null, string, string2, null);
    }

    public void log(int n, String string, String string2, int n2, Object[] objectArray) {
        if (n < this.f_levelValue || this.f_levelValue == Integer.MAX_VALUE) {
            return;
        }
        this.doLog(n, n2, objectArray, string, string2, null);
    }

    public void log(int n, String string, String string2, int n2, Object[] objectArray, Throwable throwable) {
        if (n < this.f_levelValue || this.f_levelValue == Integer.MAX_VALUE) {
            return;
        }
        this.doLog(n, n2, objectArray, string, string2, throwable);
    }

    public void entering(String string, String string2) {
        if (800 < this.f_levelValue) {
            return;
        }
        this.log(800, string, string2, 24);
    }

    public void exiting(String string, String string2) {
        if (800 < this.f_levelValue) {
            return;
        }
        this.log(800, string, string2, 25);
    }

    private void setLogHandler(LogHandler logHandler) {
        this.f_handler = logHandler;
    }

    private LogHandler getLogHandler() {
        return this.f_handler;
    }

    private void doLog(int n, int n2, Object[] objectArray, String string, String string2, Throwable throwable) {
        LogRecord logRecord = new LogRecord(n, string, string2, n2, objectArray, throwable, this.f_messages);
        if (this.f_handler != null) {
            this.f_handler.write(logRecord);
        }
    }
}

