/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbcx;

import com.informix.jdbcx.IfxXAReusableConnection;
import com.informix.jdbcx.IfxXASqli;
import com.informix.util.Trace;
import com.informix.util.TraceFlag;
import java.sql.SQLException;
import java.util.Vector;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class IfxXAResource
implements XAResource {
    private static final Object logger = Trace.getLoggerForClass(IfxXAResource.class);
    private IfxXAReusableConnection conn = null;
    private int rmid = 1;
    private Trace trace = null;
    private IfxXASqli proto = null;
    private int XAError = 0;
    protected Vector<Xid> xidList = null;

    IfxXAResource(IfxXAReusableConnection connection) {
        this.conn = connection;
        this.trace = this.conn.getTrace();
        this.proto = (IfxXASqli)this.conn.getProto();
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        int flag = 0;
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxXAResource: commit() called");
        }
        this.XAError = 0;
        this.proto.clearWarnings();
        if (onePhase) {
            flag = 0x40000000;
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 3, "  commit() setting TMONEPHASE");
            }
        }
        try {
            this.XAError = this.proto.executeXACommand((short)67, xid, this.rmid, flag);
            this.errClose(this.XAError, 0);
        }
        catch (Exception e) {
            throw new XAException(e.toString());
        }
        if (this.XAError != 0) {
            throw new XAException(this.XAError);
        }
        this.removeFromXidList(xid);
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxXAResource: commit() exited");
        }
    }

    @Override
    public void end(Xid xid, int flags) throws XAException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxXAResource: end() called");
        }
        this.XAError = 0;
        this.proto.clearWarnings();
        if ((flags & 0x26000000) == 0) {
            throw new XAException(-5);
        }
        try {
            this.XAError = this.proto.executeXACommand((short)68, xid, this.rmid, flags);
        }
        catch (Exception e) {
            this.removeFromXidList(xid);
            throw new XAException(e.toString());
        }
        this.conn.startXA = false;
        this.conn.currentXid = null;
        if (this.XAError != 0) {
            this.removeFromXidList(xid);
            throw new XAException(this.XAError);
        }
        if (flags == 0x2000000) {
            this.removeFromXidList(xid);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxXAResource: end() exited");
        }
    }

    @Override
    public void forget(Xid xid) throws XAException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxXAResource: forget() called");
        }
        this.XAError = 0;
        this.proto.clearWarnings();
        try {
            this.XAError = this.proto.executeXACommand((short)69, xid, this.rmid, 0);
        }
        catch (Exception e) {
            this.conn.startXA = false;
            this.conn.currentXid = null;
            this.removeFromXidList(xid);
            throw new XAException(e.toString());
        }
        this.errClose(this.XAError, 0);
        if (this.XAError != 0) {
            this.conn.startXA = false;
            this.conn.currentXid = null;
            this.removeFromXidList(xid);
            throw new XAException(this.XAError);
        }
        this.removeFromXidList(xid);
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxXAResource: forget() exited");
        }
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxXAResource: getTransactionTimeout() called");
        }
        return 0;
    }

    @Override
    public boolean isSameRM(XAResource xares) throws XAException {
        boolean isSame = false;
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxXAResource: isSameRM() called");
        }
        if (xares instanceof IfxXAResource && this.conn.getServerName().equals(((IfxXAResource)xares).conn.getServerName())) {
            isSame = true;
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxXAResource: isSameRM() exited");
        }
        return isSame;
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxXAResource: prepare() called");
        }
        this.XAError = 0;
        this.proto.clearWarnings();
        try {
            this.XAError = this.proto.executeXACommand((short)70, xid, this.rmid, 0);
        }
        catch (Exception e) {
            throw new XAException(e.toString());
        }
        this.errClose(this.XAError, 0);
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxXAResource: prepare() exited");
        }
        if (this.XAError >= 100 && this.XAError <= 107 || this.XAError == 3) {
            this.removeFromXidList(xid);
            this.conn.startXA = false;
            this.conn.currentXid = null;
        }
        if (this.XAError < 0) {
            this.removeFromXidList(xid);
            throw new XAException(this.XAError);
        }
        return this.XAError;
    }

    @Override
    public Xid[] recover(int flag) throws XAException {
        int count = 10;
        String sqlcodeException = null;
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxXAResource: recover() called");
        }
        this.XAError = 0;
        this.proto.clearWarnings();
        if (flag != 0 && flag != 0x1000000 && flag != 0x800000 && flag != 0x1800000) {
            throw new XAException(-5);
        }
        try {
            this.XAError = this.proto.executeXARecover(count, this.rmid, flag);
        }
        catch (Exception e) {
            sqlcodeException = e.toString();
        }
        int sqlCode = this.proto.getSQLCode();
        if (sqlCode == -457 || sqlCode == -408) {
            this.removeXidList();
            throw new XAException(-7);
        }
        if (sqlCode != 0) {
            this.removeXidList();
            throw new XAException(sqlcodeException);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxXAResource: recover() exited");
        }
        if (this.XAError < 0) {
            this.removeXidList();
            throw new XAException(this.XAError);
        }
        return (Xid[])this.proto.getXidArray();
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        int sqlCode = 0;
        String sqlcodeException = null;
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxXAResource: rollback() called");
        }
        this.XAError = 0;
        this.proto.clearWarnings();
        try {
            this.XAError = this.proto.executeXACommand((short)65, xid, this.rmid, 0);
        }
        catch (Exception e) {
            sqlcodeException = e.toString();
        }
        sqlCode = this.proto.getSQLCode();
        if (sqlCode == -457 || sqlCode == -408) {
            this.removeFromXidList(xid);
            throw new XAException(-7);
        }
        if (this.XAError < 0 && this.XAError != -3) {
            this.removeFromXidList(xid);
            throw new XAException(this.XAError);
        }
        this.errClose(this.XAError, 0);
        if (this.XAError != 0) {
            throw new XAException(this.XAError);
        }
        this.removeFromXidList(xid);
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxXAResource: rollback() exited");
        }
    }

    @Override
    public boolean setTransactionTimeout(int t) throws XAException {
        return false;
    }

    @Override
    public void start(Xid xid, int flags) throws XAException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxXAResource: start() called");
        }
        if (this.conn.isInUserTransaction()) {
            throw new XAException(-9);
        }
        this.XAError = 0;
        this.proto.clearWarnings();
        if (flags != 0 && (flags & 0x8200000) == 0) {
            throw new XAException(-5);
        }
        try {
            this.XAError = this.proto.executeXACommand((short)72, xid, this.rmid, flags);
        }
        catch (SQLException e) {
            this.removeXidList();
            throw new XAException(-7);
        }
        if (this.XAError != 0) {
            throw new XAException(this.XAError);
        }
        this.conn.startXA = true;
        this.conn.currentXid = xid;
        this.conn.inXATXN = true;
        if (flags == 0) {
            this.addToXidList(xid);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxXAResource: start() exited");
        }
    }

    private void errClose(int errCode, int flags) {
        String dbName = null;
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxXAResource: errClose() called");
        }
        if (errCode == -7) {
            try {
                dbName = this.conn.getDbName();
                this.conn.startXA = false;
                this.conn.currentXid = null;
                this.removeXidList();
                this.proto.executeXAClose(dbName, this.rmid, flags);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxXAResource: errClose() exited");
        }
    }

    protected void removeFromXidList(Xid xid) {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxXAResource:removeFromXidList called");
        }
        if (this.xidList == null) {
            this.conn.inXATXN = false;
        }
        if (xid == null) {
            return;
        }
        if (this.xidList != null && this.xidList.size() > 0) {
            boolean ret_status = this.xidList.removeElement(xid);
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 1, "xid removed(status=" + ret_status + "):" + xid);
            }
            if (this.xidList.size() == 0) {
                this.conn.inXATXN = false;
            }
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxXAResource:removeFromXidList exited");
        }
    }

    protected void addToXidList(Xid xid) {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxXAResource:addToXidList called");
        }
        if (this.xidList == null) {
            this.xidList = new Vector(20);
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 1, "xidList is created");
            }
        }
        if (xid != null && !this.xidList.contains(xid)) {
            this.xidList.addElement(xid);
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 1, "added xid to xidList:" + xid);
            }
        }
    }

    protected void removeXidList() {
        if (this.xidList != null) {
            this.xidList.removeAllElements();
            this.xidList = null;
            this.conn.inXATXN = false;
        }
    }

    private Xid findInXidList(Xid xid) {
        if (this.xidList != null && this.xidList.contains(xid)) {
            return xid;
        }
        return null;
    }

    private int noOfElementsInxidList() {
        if (this.xidList != null) {
            return this.xidList.size();
        }
        return 0;
    }

    private void cleanAllTransactions() {
        Xid[] x = null;
        try {
            x = this.recover(0x1000000);
            System.out.println("x is : " + x);
        }
        catch (XAException xe) {
            System.err.println("Exception: " + xe.toString());
        }
        if (x != null && x.length > 0) {
            for (int i = 0; i < x.length; ++i) {
                System.out.println("Recovered Xid: " + x[i]);
                try {
                    this.rollback(x[i]);
                    continue;
                }
                catch (XAException xe) {
                    try {
                        this.forget(x[i]);
                        continue;
                    }
                    catch (XAException xae) {
                        System.err.println("Exception: " + xae.toString());
                    }
                }
            }
        }
    }
}

