/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jns;

import com.informix.jns.FileSqlhosts;
import com.informix.jns.IfxJNSException;
import com.informix.jns.ServerGroup;
import com.informix.jns.ServerInfo;
import com.informix.util.IfxErrMsg;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;

public class LdapSqlhosts {
    static String NSNETTYPE = "dsf1_nettype";
    static String NSHOSTNAME = "dsf1_hostname";
    static String NSSERVICE = "dsf1_service";
    static String NSOPTIONS = "dsf1_options";
    static String LDAP_VERSION = "3";
    static String LDAP_INITCTX = "com.sun.jndi.ldap.LdapCtxFactory";
    static String LDAP_FILTER = "objectclass=*";
    static String LDAP_DEF_AUTH = "none";
    static String LDAP_DEF_URL = "ldap://localhost:389";
    static String LDAP_DEF_IFXBASE = "cn=Informix,cn=Software,o=Informix,c=US";
    static String LDAP_AUTH_SIMPLE = "simple";
    static String LDAP_SQHRDN = "cn=sqlhosts";
    static int LDAP_SCOPE0 = 0;
    static int LDAP_SCOPE1 = 1;
    static int LDAP_SCOPE2 = 2;
    private DirContext sqhctx;
    private String ldap_ifxDn;
    private String ldap_sqhDn;
    private String ldap_sqhrdn;
    private String ldap_sqhName;
    private String ClientLocale = null;
    private Properties sqhEnv;

    public LdapSqlhosts(Properties sqhenv) throws IfxJNSException {
        this.sqhEnv = sqhenv;
        this.ClientLocale = sqhenv.getProperty("CLIENT_LOCALE");
        String ldap_url = sqhenv.getProperty("LDAP_URL");
        if (ldap_url == null) {
            ldap_url = LDAP_DEF_URL;
        }
        if ((this.ldap_ifxDn = sqhenv.getProperty("LDAP_IFXBASE")) == null) {
            this.ldap_ifxDn = LDAP_DEF_IFXBASE;
        }
        if ((this.ldap_sqhrdn = sqhenv.getProperty("LDAP_SQHRDN")) == null) {
            this.ldap_sqhrdn = LDAP_SQHRDN;
        }
        String ldap_auth = LDAP_DEF_AUTH;
        String ldap_user = sqhenv.getProperty("LDAP_USER");
        if (ldap_user != null) {
            ldap_auth = LDAP_AUTH_SIMPLE;
        }
        String ldap_passwd = sqhenv.getProperty("LDAP_PASSWD");
        Properties ldapenv = new Properties();
        ldapenv.put("java.naming.factory.initial", LDAP_INITCTX);
        ldapenv.put("java.naming.ldap.version", LDAP_VERSION);
        ldapenv.put("java.naming.provider.url", ldap_url);
        ldapenv.put("java.naming.security.authentication", ldap_auth);
        if (ldap_auth.equalsIgnoreCase(LDAP_AUTH_SIMPLE)) {
            ldapenv.put("java.naming.security.principal", ldap_user);
            ldapenv.put("java.naming.security.credentials", ldap_passwd);
        }
        this.ldap_sqhDn = this.ldap_sqhrdn + "," + this.ldap_ifxDn;
        this.ldap_sqhName = this.ldap_sqhrdn.substring(this.ldap_sqhrdn.indexOf(61) + 1);
        try {
            this.sqhctx = new InitialDirContext(ldapenv);
        }
        catch (NamingException e) {
            throw IfxErrMsg.getLocIfxJNSException(-80282, this.ClientLocale);
        }
    }

    public ServerInfo getServer(String sname) throws IfxJNSException {
        String nsNettype = "default_nettype";
        String nsHostname = "default_hostname";
        String nsService = "default_service";
        String nsOptions = "default_options";
        try {
            SearchControls constraints = new SearchControls();
            constraints.setSearchScope(LDAP_SCOPE0);
            String lbase = "cn=" + sname + "," + this.ldap_sqhDn;
            NamingEnumeration<SearchResult> results = this.sqhctx.search(lbase, LDAP_FILTER, constraints);
            if (results != null && results.hasMore()) {
                SearchResult si = results.next();
                Attributes attrs = si.getAttributes();
                NamingEnumeration<? extends Attribute> ae = attrs.getAll();
                while (ae.hasMoreElements()) {
                    Attribute attr = ae.next();
                    String attrId = attr.getID();
                    NamingEnumeration<?> vals = attr.getAll();
                    if (attrId.compareTo(NSNETTYPE) == 0) {
                        nsNettype = (String)vals.nextElement();
                        continue;
                    }
                    if (attrId.compareTo(NSHOSTNAME) == 0) {
                        nsHostname = (String)vals.nextElement();
                        continue;
                    }
                    if (attrId.compareTo(NSSERVICE) == 0) {
                        nsService = (String)vals.nextElement();
                        continue;
                    }
                    if (attrId.compareTo(NSOPTIONS) != 0) continue;
                    nsOptions = (String)vals.nextElement();
                }
                return new ServerInfo(sname, nsNettype, nsHostname, nsService, nsOptions);
            }
        }
        catch (NamingException e) {
            throw IfxErrMsg.getLocIfxJNSException(-25555, this.ClientLocale);
        }
        throw IfxErrMsg.getLocIfxJNSException(-80283, this.ClientLocale);
    }

    public ServerGroup getServerGroup(String sname) throws IfxJNSException {
        Vector<String> myvect = new Vector<String>();
        try {
            SearchControls constraints = new SearchControls();
            constraints.setSearchScope(LDAP_SCOPE1);
            String lbase = sname.length() == 0 ? this.ldap_sqhDn : "cn=" + sname + "," + this.ldap_sqhDn;
            NamingEnumeration<SearchResult> results = this.sqhctx.search(lbase, LDAP_FILTER, constraints);
            while (results != null && results.hasMore()) {
                SearchResult si = results.next();
                String gname = si.getName();
                myvect.addElement(gname.substring(3));
            }
        }
        catch (NamingException e) {
            throw IfxErrMsg.getLocIfxJNSException(-25555, this.ClientLocale);
        }
        return new ServerGroup(myvect);
    }

    public ServerGroup listServers() throws IfxJNSException {
        return this.getServerGroup("");
    }

    void addServer(ServerInfo server) throws IfxJNSException {
        String sname = server.getSname();
        String nettype = server.getNettype();
        String hostname = server.getHostname();
        String service = server.getService();
        String options = server.getOptfield();
        BasicAttribute doclass = new BasicAttribute("objectclass", "extensibleobject");
        BasicAttribute dcn = new BasicAttribute("cn", sname);
        BasicAttribute dnettype = new BasicAttribute(NSNETTYPE, nettype);
        BasicAttribute dhostname = new BasicAttribute(NSHOSTNAME, hostname);
        BasicAttribute dservice = new BasicAttribute(NSSERVICE, service);
        BasicAttribute doptions = new BasicAttribute(NSOPTIONS, options);
        String dname = "cn=" + sname;
        BasicAttributes entryAttrs = new BasicAttributes();
        entryAttrs.put(doclass);
        entryAttrs.put(dcn);
        entryAttrs.put(dnettype);
        entryAttrs.put(dhostname);
        entryAttrs.put(dservice);
        entryAttrs.put(doptions);
        String fulldn = dname + "," + this.ldap_sqhDn;
        try {
            System.out.println(IfxErrMsg.getMinorMsg(-80251, (String)null) + fulldn);
            this.sqhctx.createSubcontext(fulldn, (Attributes)entryAttrs);
        }
        catch (NameAlreadyBoundException e) {
            System.out.println(IfxErrMsg.getMinorMsg(-80253, (String)null));
        }
        catch (NamingException e) {
            throw IfxErrMsg.getLocIfxJNSException(-80284, this.ClientLocale);
        }
    }

    void addEntry(String name, Properties attrs) throws IfxJNSException {
        String fulldn = name + "," + this.ldap_sqhDn;
        BasicAttributes entryAttrs = new BasicAttributes();
        entryAttrs.put(new BasicAttribute("objectclass", "extensibleobject"));
        Enumeration<Object> attrKeys = attrs.keys();
        while (attrKeys.hasMoreElements()) {
            String akey = (String)attrKeys.nextElement();
            String aval = (String)attrs.get(akey);
            entryAttrs.put(new BasicAttribute(akey, aval));
        }
        try {
            System.out.println(IfxErrMsg.getMinorMsg(-80251, (String)null) + fulldn);
            this.sqhctx.createSubcontext(fulldn, (Attributes)entryAttrs);
        }
        catch (NameAlreadyBoundException e) {
            System.out.println(IfxErrMsg.getMinorMsg(-80253, (String)null));
        }
        catch (NamingException e) {
            throw IfxErrMsg.getLocIfxJNSException(-80284, this.ClientLocale);
        }
    }

    void delServer(String name) throws IfxJNSException {
        String dnameSfix = "," + this.ldap_sqhDn;
        try {
            String fulldn;
            ServerInfo tsrvr = this.getServer(name);
            if (tsrvr.isGroupEntry()) {
                ServerGroup tgroup = this.getServerGroup(name);
                while (tgroup.hasMoreElements()) {
                    String gsrvr = (String)tgroup.nextElement();
                    fulldn = "cn=" + gsrvr + "," + "cn=" + name + dnameSfix;
                    System.out.println(IfxErrMsg.getMinorMsg(-80252, (String)null) + fulldn);
                    this.sqhctx.destroySubcontext(fulldn);
                }
            }
            fulldn = "cn=" + name + dnameSfix;
            System.out.println(IfxErrMsg.getMinorMsg(-80252, (String)null) + fulldn);
            this.sqhctx.destroySubcontext(fulldn);
        }
        catch (NamingException e) {
            throw IfxErrMsg.getLocIfxJNSException(-80284, this.ClientLocale);
        }
    }

    public void destroySqlhosts() throws IfxJNSException {
        try {
            ServerGroup tgroup = this.listServers();
            while (tgroup.hasMoreElements()) {
                String gsrvr = (String)tgroup.nextElement();
                this.delServer(gsrvr);
            }
            System.out.println(IfxErrMsg.getMinorMsg(-80252, (String)null) + this.ldap_sqhDn);
            this.sqhctx.destroySubcontext(this.ldap_sqhDn);
        }
        catch (Exception e) {
            throw IfxErrMsg.getLocIfxJNSException(-80284, this.ClientLocale);
        }
    }

    public void uploadSqlhosts(String sqhFilename) throws IfxJNSException {
        BasicAttributes entryAttrs = new BasicAttributes();
        entryAttrs.put(new BasicAttribute("objectclass", "extensibleobject"));
        entryAttrs.put("cn", this.ldap_sqhName);
        entryAttrs.put("desc", "Sql Hosts");
        try {
            System.out.println(IfxErrMsg.getMinorMsg(-80251, (String)null) + this.ldap_sqhDn);
            this.sqhctx.createSubcontext(this.ldap_sqhDn, (Attributes)entryAttrs);
        }
        catch (NameAlreadyBoundException e) {
            System.out.println(IfxErrMsg.getMinorMsg(-80253, (String)null));
        }
        catch (NamingException e) {
            throw IfxErrMsg.getLocIfxJNSException(-80284, this.ClientLocale);
        }
        try {
            this.sqhEnv.put("SQLH_FILE", sqhFilename);
            FileSqlhosts sqhf = new FileSqlhosts(this.sqhEnv);
            sqhf.uploadToLdap(this);
        }
        catch (Exception e) {
            throw IfxErrMsg.getLocIfxJNSException(-80284, this.ClientLocale);
        }
    }
}

