/*
 * Decompiled with CFR 0.152.
 */
package UtilXML;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.sql.SQLException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;

public class UtilXML {
    private static final boolean Debug = false;

    public static String XMLtoString(String file, String handler, boolean validating, boolean nsa) throws SQLException {
        try {
            InputStream is = UtilXML.XMLtoInputStream(file, handler, validating, nsa);
            int size = is.available();
            if (size <= 0) {
                return null;
            }
            StringBuffer sb = new StringBuffer(size);
            byte[] ba = new byte[size];
            while (size > 0) {
                size = is.read(ba);
                if (size <= 0) continue;
                sb.append(new String(ba, 0, size));
            }
            return sb.toString();
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            SQLException ee = new SQLException(e.toString());
            throw ee;
        }
    }

    public static String XMLtoString(String file, String handler) throws SQLException {
        return UtilXML.XMLtoString(file, handler, false, false);
    }

    public static String XMLtoString(String file) throws SQLException {
        return UtilXML.XMLtoString(file, null, false, false);
    }

    public static InputStream XMLtoInputStream(String file, String handler, boolean validating, boolean nsa) throws SQLException {
        try {
            UtilXML.validateXML(file, handler, validating, nsa);
            FileInputStream fis = null;
            File f = new File(file);
            if (!f.isFile()) {
                if (file.substring(0, 4).equals("file")) {
                    int index = file.indexOf(":");
                    if (index > 0) {
                        String path = file.substring(index + 1, file.length());
                        fis = new FileInputStream(new File(path));
                        return fis;
                    }
                    throw new SQLException("File '" + file + "' not found.");
                }
                if (file.substring(0, 4).equals("http")) {
                    URL url = new URL(file);
                    url.openConnection();
                    InputStream is = url.openStream();
                    return is;
                }
                fis = new FileInputStream(f);
                return fis;
            }
            fis = new FileInputStream(f);
            return fis;
        }
        catch (Exception e) {
            SQLException ee = new SQLException(e.getMessage());
            throw ee;
        }
    }

    public static InputStream XMLtoInputStream(String file, String handler) throws SQLException {
        return UtilXML.XMLtoInputStream(file, handler, false, false);
    }

    public static InputStream XMLtoInputStream(String file) throws SQLException {
        return UtilXML.XMLtoInputStream(file, null, false, false);
    }

    public static InputSource getInputSource(String s) throws SQLException {
        if (s == null || s.length() == 0) {
            return null;
        }
        byte[] b = s.getBytes();
        ByteArrayInputStream bais = new ByteArrayInputStream(b);
        return UtilXML.getInputSource(bais);
    }

    public static InputSource getInputSource(InputStream is) throws SQLException {
        InputSource input = new InputSource(new BufferedReader(new InputStreamReader(is)));
        return input;
    }

    public static Document InputStreamtoDOM(InputStream is, String eHandler, boolean validating, boolean nsa) throws SQLException {
        Class<?> hcls = null;
        Document document = null;
        try {
            if (eHandler != null) {
                hcls = Class.forName(eHandler);
            }
        }
        catch (ClassNotFoundException e) {
            SQLException ee = new SQLException(e.toString());
            throw ee;
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(true);
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            if (hcls != null) {
                builder.setErrorHandler((ErrorHandler)hcls.newInstance());
            }
            InputSource inpsrc = UtilXML.getInputSource(is);
            document = builder.parse(inpsrc);
        }
        catch (Exception e) {
            SQLException ee = new SQLException(e.toString());
            throw ee;
        }
        return document;
    }

    public static Document InputStreamtoDOM(InputStream is, String eHandler) throws SQLException {
        return UtilXML.InputStreamtoDOM(is, eHandler, false, false);
    }

    public static Document InputStreamtoDOM(InputStream is) throws SQLException {
        return UtilXML.InputStreamtoDOM(is, null, false, false);
    }

    public static Document StringtoDOM(String s, String eHandler, boolean validating, boolean nsa) throws SQLException {
        if (s == null || s.length() == 0) {
            return UtilXML.InputStreamtoDOM(null, eHandler, validating, nsa);
        }
        byte[] b = s.getBytes();
        ByteArrayInputStream is = new ByteArrayInputStream(b);
        return UtilXML.InputStreamtoDOM(is, eHandler, validating, nsa);
    }

    public static Document StringtoDOM(String s, String eHandler) throws SQLException {
        return UtilXML.StringtoDOM(s, eHandler, false, false);
    }

    public static Document StringtoDOM(String s) throws SQLException {
        return UtilXML.StringtoDOM(s, null, false, false);
    }

    private static void validateXML(String file, String handler, boolean validating, boolean nsa) throws SQLException {
        SAXParser parser;
        String handlerName = null;
        Class<?> hcls = null;
        try {
            handlerName = handler == null ? "UtilXML.IfxHandler" : handler;
            hcls = Class.forName(handlerName);
        }
        catch (Exception e) {
            SQLException ee = new SQLException(e.toString());
            throw ee;
        }
        if (file == null) {
            throw new SQLException("Target '" + file + "' is null.");
        }
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            factory.setValidating(validating);
            factory.setNamespaceAware(nsa);
            parser = factory.newSAXParser();
        }
        catch (Exception e) {
            SQLException ee = new SQLException(e.toString());
            throw ee;
        }
        try {
            File f = new File(file);
            if (f.exists()) {
                parser.parse(f, (HandlerBase)hcls.newInstance());
            } else {
                parser.parse(file, (HandlerBase)hcls.newInstance());
            }
        }
        catch (Exception e) {
            SQLException ee = new SQLException(e.toString());
            throw ee;
        }
    }
}

