/*
 * Decompiled with CFR 0.152.
 */
package udtudrmgr;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Vector;

public class CodeGenUtil {
    public static final short GETSQL = 0;
    public static final short READ = 1;
    public static final short WRITE = 2;
    public static final String CRLF = "\n";
    public static final String TAB = "    ";
    public static final String BASE = "B";
    public static final String COLLECTION = "C";
    public static final String DISTINCT = "D";
    public static final String NAMEDROW = "R";
    public static final String BUILTIN = " ";
    boolean importYM = false;
    boolean importDF = false;

    String toStringType(int dataType, short length) {
        switch (dataType) {
            case 0: {
                return "String";
            }
            case 1: {
                return "short";
            }
            case 2: {
                return "int";
            }
            case 3: {
                return "double";
            }
            case 4: {
                return "float";
            }
            case 5: {
                return "BigDecimal";
            }
            case 7: {
                return "Date";
            }
            case 8: {
                return "BigDecimal";
            }
            case 10: {
                return this.getTimeType(length);
            }
            case 14: {
                return this.getIntervalType(length);
            }
            case 15: {
                return "String";
            }
            case 17: {
                return "long";
            }
            case 6: {
                return "int";
            }
            case 18: {
                return "long";
            }
            case 45: {
                return "boolean";
            }
            case 101: {
                return "java.sql.Clob";
            }
            case 102: {
                return "java.sql.Blob";
            }
        }
        return null;
    }

    String getTimeType(short length) {
        byte startCode = (byte)(length >> 4 & 0xF);
        if (startCode < 6) {
            return "Timestamp";
        }
        return "Time";
    }

    String getIntervalType(short length) {
        byte startCode = (byte)(length >> 4 & 0xF);
        if (startCode < 4) {
            this.importYM = true;
            return "IfxIntervalYM";
        }
        this.importDF = true;
        return "IfxIntervalDF";
    }

    public static String getReadProcName(String type, int len) {
        if (type.startsWith("IfxInterval")) {
            return "new " + type + "(stream.readString())";
        }
        if (type.startsWith("String")) {
            return "readString(" + len + ")";
        }
        if (type.equalsIgnoreCase("struct")) {
            return "(Struct)stream.readObject()";
        }
        StringBuffer sbuf = new StringBuffer(type);
        sbuf.setCharAt(0, Character.toUpperCase(sbuf.charAt(0)));
        return "read" + sbuf + "()";
    }

    public static String getWriteProcName(String type, String name, int len) {
        if (type.startsWith("IfxInterval")) {
            return "stream.writeString(" + name + ".toString())";
        }
        if (type.startsWith("String")) {
            return "writeString(" + name + ", " + len + ")";
        }
        StringBuffer sbuf = new StringBuffer(type);
        sbuf.setCharAt(0, Character.toUpperCase(sbuf.charAt(0)));
        return "write" + sbuf + "(" + name + ")";
    }

    String generateFile(String udtname, String className, Vector fields) {
        String fileName = className + ".java";
        try {
            RandomAccessFile file = new RandomAccessFile(fileName, "rw");
            this.generateImportAndFields(className, file, fields);
            this.generateCode(file, 0, fields, udtname);
            this.generateCode(file, 1, fields, udtname);
            this.generateCode(file, 2, fields, udtname);
            this.generateCode(file, "\n}\n");
            file.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return fileName;
    }

    private void generateImportAndFields(String className, RandomAccessFile file, Vector fields) throws IOException {
        this.generateCode(file, "import java.sql.*;\n");
        this.generateCode(file, "import com.informix.jdbc.IfmxUDTSQLInput;\n");
        this.generateCode(file, "import com.informix.jdbc.IfmxUDTSQLOutput;\n");
        this.generateCode(file, "import java.math.*;\n\n");
        if (this.importDF) {
            this.generateCode(file, "import com.informix.jdbc.IfxIntervalDF;\n");
        }
        if (this.importYM) {
            this.generateCode(file, "import com.informix.jdbc.IfxIntervalYM;\n");
        }
        this.generateCode(file, "public class " + className + " implements SQLData " + CRLF + "{ " + CRLF);
        for (int i = 0; i < fields.size(); ++i) {
            this.generateCode(file, "    public " + ((Field)fields.elementAt((int)i)).datatype + BUILTIN + ((Field)fields.elementAt((int)i)).name + ";" + CRLF);
        }
    }

    void generateCode(RandomAccessFile file, String text) throws IOException {
        file.writeBytes(text);
    }

    void generateCode(RandomAccessFile file, int code, Vector fields, String dataTypeName) throws IOException {
        if (file == null) {
            throw new IOException("File Not found");
        }
        switch (code) {
            case 0: {
                String text = "    private String sql_type =  \"" + dataTypeName + "\"" + ";" + CRLF + CRLF + TAB + "public String getSQLTypeName() { return sql_type" + "; }" + CRLF;
                this.generateCode(file, text);
                break;
            }
            case 1: {
                String text = "\n    public void readSQL(SQLInput stream, String type) throws SQLException\n    {\n";
                text = text + TAB + TAB + "IfmxUDTSQLInput in = (IfmxUDTSQLInput) stream; " + CRLF;
                for (int i = 0; i < fields.size(); ++i) {
                    String text1 = "        " + ((Field)fields.elementAt((int)i)).name + " = in." + ((Field)fields.elementAt((int)i)).readProcName + ";" + CRLF;
                    text = text + text1;
                }
                text = text + TAB + "}" + CRLF;
                this.generateCode(file, text);
                break;
            }
            case 2: {
                String text = "\n    public void writeSQL(SQLOutput stream) throws SQLException\n    { \n";
                text = text + TAB + TAB + "IfmxUDTSQLOutput out = (IfmxUDTSQLOutput) stream; " + CRLF;
                for (int i = 0; i < fields.size(); ++i) {
                    String text1 = "        out." + ((Field)fields.elementAt((int)i)).writeProcName + ";" + CRLF;
                    text = text + text1;
                }
                text = text + TAB + "}" + CRLF;
                this.generateCode(file, text);
            }
        }
    }

    class Field {
        String name;
        String datatype;
        String readProcName;
        String writeProcName;

        public Field(String name, String datatype, String readProcName, String writeProcName) {
            this.name = name;
            this.datatype = datatype;
            this.readProcName = readProcName;
            this.writeProcName = writeProcName;
        }
    }
}

