/*
 * Decompiled with CFR 0.152.
 */
package udtudrmgr;

import com.informix.jdbc.IfmxCallableStatement;
import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxInteger;
import com.informix.jdbc.IfxLvarchar;
import com.informix.jdbc.IfxSqli;
import com.informix.jdbc.IfxSqliConnect;
import com.informix.util.IfxErrMsg;
import com.informix.util.Trace;
import com.informix.util.TraceFlag;
import java.io.File;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import udtudrmgr.UDRMetaData;

public class UDRManager {
    private static final Object logger = Trace.getLoggerForClass(UDRManager.class);
    private IfxConnection conn = null;
    private String jarTmpPath = null;
    private Locale locale = Locale.getDefault();
    private Trace trace = null;
    private boolean isInUserTx = false;
    static Hashtable JavaToIfxNameTable;
    static final String IFX_FILE_TO_FILE = "function informix.ifx_file_to_file(lvarchar,int,lvarchar,int)";
    static final int LO_SERVER_FILE = 0x10000000;
    static final int LO_CLIENT_FILE = 0x20000000;

    public UDRManager(Connection conn) throws SQLException {
        if (conn == null) {
            throw IfxErrMsg.getSQLException((int)-79708, (String)"", (Locale)this.locale);
        }
        this.conn = (IfxConnection)conn;
        this.jarTmpPath = UDRManager.isNTServer(this.conn) ? "c:\\Temp\\" : "/tmp/";
        if (TraceFlag.isTraceEnabled()) {
            this.trace = this.conn.getTrace();
            if (this.trace == null) {
                System.out.println("UDRManager: Trace is NULL");
            } else {
                this.trace.writeTrace(logger, 1, "UDRManager: constructor exited");
            }
        }
    }

    public void createUDRs(UDRMetaData mdata, String jarfile, String classname, int deploy) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "UDRManager:createUDRs() entered");
        }
        if (mdata == null) {
            throw IfxErrMsg.getSQLException((int)-79708, (String)"", (Locale)this.locale);
        }
        if (classname == null) {
            throw IfxErrMsg.getSQLException((int)-79708, (String)"", (Locale)this.locale);
        }
        UDRManager.checkJarFile(jarfile, this.locale);
        int dbtype = this.conn.getDatabaseType();
        if (dbtype == 0) {
            throw IfxErrMsg.getSQLException((int)-79844, (String)"", (Locale)this.locale);
        }
        Hashtable udrs = mdata.udrs;
        if (udrs == null || udrs.size() == 0) {
            throw IfxErrMsg.getSQLException((int)-79842, (String)"", (Locale)this.locale);
        }
        String jarFileSQLName = mdata.jarFileSQLName;
        if (jarFileSQLName == null) {
            throw IfxErrMsg.getSQLException((int)-79843, (String)"", (Locale)this.locale);
        }
        UDRManager.checkJarInSysCatalog(jarFileSQLName, this.conn, this.locale);
        String jarFileInServer = UDRManager.transportJarToServer(jarfile, this.jarTmpPath, this.conn, this.locale);
        if (dbtype == 1 || dbtype == 2) {
            if (((IfxSqliConnect)this.conn).isInUserTransaction()) {
                this.isInUserTx = true;
            } else {
                this.conn.setAutoCommit(false);
            }
        }
        try {
            UDRManager.installJarNow(jarFileSQLName, jarFileInServer, deploy, this.conn);
            UDRManager.registerUDRs(mdata, classname, null, this.conn, this.locale);
        }
        catch (SQLException e) {
            if (!this.isInUserTx) {
                this.conn.rollback();
                throw e;
            }
            throw e;
        }
        if (!(dbtype != 1 && dbtype != 2 || this.isInUserTx)) {
            this.conn.commit();
            this.conn.setAutoCommit(true);
        }
        UDRManager.removeFileInServer(jarFileInServer, this.conn);
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "UDRManager:createUDRs() exited");
        }
    }

    public void removeUDR(String sqlname) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "UDRManager:removeUDR(String) entered");
        }
        if (sqlname == null) {
            throw IfxErrMsg.getSQLException((int)-79708, (String)"", (Locale)this.locale);
        }
        String sql = "DROP ROUTINE " + sqlname;
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 3, "sql = " + sql);
        }
        Statement stmt = this.conn.createStatement();
        stmt.executeUpdate(sql);
        stmt.close();
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "UDRManager:removeUDR(String) exited");
        }
    }

    public void removeUDR(String sqlname, Class[] methodparams) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "UDRManager:removeUDR(String, Class[]) entered");
        }
        if (sqlname == null) {
            throw IfxErrMsg.getSQLException((int)-79708, (String)"", (Locale)this.locale);
        }
        String sqlparams = "";
        if (methodparams != null) {
            sqlparams = UDRManager.fromClassesToIfxNames(methodparams, null, null, this.trace, this.locale);
        }
        String sql = "DROP ROUTINE " + sqlname + "(" + sqlparams + ")";
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 3, "sql = " + sql);
        }
        Statement stmt = this.conn.createStatement();
        stmt.executeUpdate(sql);
        stmt.close();
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "UDRManager:removeUDR(String, Class[]) exited");
        }
    }

    public void removeJar(String jarfilesqlname, int undeploy) throws SQLException {
        UDRManager.removeJarNow(jarfilesqlname, undeploy, this.conn, this.locale);
    }

    public void setJarTmpPath(String path) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "UDRManager:setJarTmpPath() entered");
        }
        this.jarTmpPath = UDRManager.getJarTmpPathNow(this.conn, path, this.locale);
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 3, "jarTmpPath = " + this.jarTmpPath);
            this.trace.writeTrace(logger, 1, "UDRManager:setJarTmpPath() exited");
        }
    }

    static boolean isNTServer(IfxConnection conn) throws SQLException {
        boolean NTserver = false;
        int points = 0;
        if (conn == null) {
            return false;
        }
        String dbversion = conn.getDbVersion();
        for (int i = 0; !NTserver && i < dbversion.length(); ++i) {
            if (dbversion.charAt(i) != '.' || ++points != 2 || dbversion.charAt(i + 1) != 'T') continue;
            NTserver = true;
        }
        return NTserver;
    }

    static String getJarTmpPathNow(IfxConnection conn, String path, Locale locale) throws SQLException {
        if (path == null) {
            throw IfxErrMsg.getSQLException((int)-79708, (String)"", (Locale)locale);
        }
        if (UDRManager.isNTServer(conn)) {
            return path + "\\";
        }
        return path + "/";
    }

    static void checkJarFile(String jarfile, Locale locale) throws SQLException {
        if (jarfile == null) {
            throw IfxErrMsg.getSQLException((int)-79708, (String)"", (Locale)locale);
        }
        File jarFileObj = new File(jarfile);
        if (!jarFileObj.exists() || !jarFileObj.canRead()) {
            throw IfxErrMsg.getSQLException((int)-79845, (String)"", (Locale)locale);
        }
    }

    static void checkJarInSysCatalog(String jarfilesqlname, IfxConnection conn, Locale locale) throws SQLException {
        Trace trace = null;
        if (TraceFlag.isTraceEnabled()) {
            trace = conn.getTrace();
            trace.writeTrace(logger, 1, "UDRManager:checkJarInSysCatalog() entered");
        }
        String sql = "select tabname from informix.systables where tabname = 'retained_jars' and owner = 'sqlj'";
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery(sql);
        boolean tabExists = rs.next();
        rs.close();
        if (!tabExists) {
            stmt.close();
            if (TraceFlag.isTraceEnabled()) {
                trace.writeTrace(logger, 3, "sql = " + sql);
                trace.writeTrace(logger, 1, "UDRManager:checkJarInSysCatalog() exited");
            }
            return;
        }
        String jarfullname = conn.getDbName() + "." + conn.getUserName() + "." + jarfilesqlname;
        sql = "select jarname from 'sqlj'.retained_jars where jarname = '" + jarfullname + "'";
        rs = stmt.executeQuery(sql);
        boolean jarExists = rs.next();
        rs.close();
        stmt.close();
        if (jarExists) {
            throw IfxErrMsg.getSQLException((int)-79839, (String)"", (Locale)locale);
        }
        if (TraceFlag.isTraceEnabled()) {
            trace.writeTrace(logger, 3, "sql = " + sql);
            trace.writeTrace(logger, 1, "UDRManager:checkJarInSysCatalog() exited");
        }
    }

    static String transportJarToServer(String jarfile, String jarTmpPath, IfxConnection conn, Locale locale) throws SQLException {
        int idx;
        String jarnameDotJar;
        Trace trace = null;
        if (TraceFlag.isTraceEnabled()) {
            trace = conn.getTrace();
            trace.writeTrace(logger, 1, "UDRManager:transportJarToServer() entered");
            trace.writeTrace(logger, 3, "jarfile = '" + jarfile + "'");
            trace.writeTrace(logger, 3, "jarTmpPath = '" + jarTmpPath + "'");
        }
        String fsep = System.getProperty("file.separator");
        if (TraceFlag.isTraceEnabled()) {
            trace.writeTrace(logger, 3, "fsep = '" + fsep + "'");
        }
        if (!(jarnameDotJar = jarfile.substring((idx = jarfile.lastIndexOf(fsep)) + 1)).endsWith(".jar")) {
            throw IfxErrMsg.getSQLException((int)-79846, (String)"", (Locale)locale);
        }
        if (TraceFlag.isTraceEnabled()) {
            trace.writeTrace(logger, 3, "jarnameDotJar = '" + jarnameDotJar + "'");
        }
        String jarFileInServer = jarTmpPath + jarnameDotJar;
        IfxLvarchar ip1 = new IfxLvarchar(jarfile);
        ip1.setConnection(conn);
        ip1.setExtendedTypeName("lvarchar");
        IfxInteger ip2 = new IfxInteger(0x20000000);
        IfxLvarchar ip3 = new IfxLvarchar(jarFileInServer);
        ip3.setConnection(conn);
        ip3.setExtendedTypeName("lvarchar");
        IfxInteger ip4 = new IfxInteger(0x10000000);
        Vector<Object> inVec = new Vector<Object>();
        inVec.addElement(ip1);
        inVec.addElement(ip2);
        inVec.addElement(ip3);
        inVec.addElement(ip4);
        IfxSqli prot = null;
        try {
            prot = new IfxSqli((IfxSqliConnect)conn);
        }
        catch (Exception e) {
            if (TraceFlag.isTraceEnabled()) {
                trace.writeTrace(logger, 3, "exception occurs: " + e.toString());
            }
            throw IfxErrMsg.getSQLException((int)-79735, (String)"", (Locale)locale);
        }
        if (TraceFlag.isTraceEnabled()) {
            trace.writeTrace(logger, 3, "UDRManager.transportJarToServer():");
            trace.writeTrace(logger, 3, "Transport from: '" + jarfile + "'");
            trace.writeTrace(logger, 3, "            to: '" + jarFileInServer + "'");
        }
        Vector outVec = prot.executeFastPath(IFX_FILE_TO_FILE, inVec, false);
        prot.clear();
        prot = null;
        if (!UDRManager.isNTServer(conn)) {
            UDRManager.changeFilePermissionInServer(jarFileInServer, conn);
        }
        UDRManager.changeFilePermissionInClient(jarfile, conn, locale);
        if (TraceFlag.isTraceEnabled()) {
            trace.writeTrace(logger, 1, "UDRManager:transportJarToServer() exited");
        }
        return jarFileInServer;
    }

    static void changeFilePermissionInClient(String jarfile, IfxConnection conn, Locale locale) throws SQLException {
        Trace trace = null;
        if (TraceFlag.isTraceEnabled()) {
            trace = conn.getTrace();
            trace.writeTrace(logger, 1, "UDRManager:changeFilePermissionInClient() entered");
        }
        String cmd = null;
        cmd = System.getProperty("file.separator").equals("/") ? "chmod a+w " + jarfile : "attrib -r " + jarfile;
        if (TraceFlag.isTraceEnabled()) {
            trace.writeTrace(logger, 3, "cmd is '" + cmd + "'");
        }
        try {
            Process child = Runtime.getRuntime().exec(cmd);
            if (child.waitFor() != 0) {
                throw IfxErrMsg.getSQLException((int)-79838, (String)"", (Locale)locale);
            }
        }
        catch (Exception e) {
            if (TraceFlag.isTraceEnabled()) {
                trace.writeTrace(logger, 3, "exception occurs: " + e.toString());
            }
            throw IfxErrMsg.getSQLException((int)-79838, (String)"", (Locale)locale);
        }
        if (TraceFlag.isTraceEnabled()) {
            trace.writeTrace(logger, 1, "UDRManager:changeFilePermissionInClient() exited");
        }
    }

    static void changeFilePermissionInServer(String jarfile, IfxConnection conn) throws SQLException {
        Trace trace = null;
        if (TraceFlag.isTraceEnabled()) {
            trace = conn.getTrace();
            trace.writeTrace(logger, 1, "UDRManager:changeFilePermissionInServer() entered");
        }
        Statement stmt = conn.createStatement();
        String sql = null;
        sql = UDRManager.isNTServer(conn) ? "CREATE PROCEDURE udtudrmgr_chperm (fname varchar(80)) \nsystem 'cmd /C attrib -r ' || fname; \nEND PROCEDURE" : "CREATE PROCEDURE udtudrmgr_chperm (fname varchar(80)) \nsystem 'chmod 666 ' || fname; \nEND PROCEDURE";
        if (TraceFlag.isTraceEnabled()) {
            trace.writeTrace(logger, 3, "UDRManager: sql = " + sql);
        }
        stmt.execute(sql);
        sql = "EXECUTE PROCEDURE udtudrmgr_chperm ('" + jarfile + "')";
        if (TraceFlag.isTraceEnabled()) {
            trace.writeTrace(logger, 3, "UDRManager: sql = " + sql);
        }
        stmt.execute(sql);
        sql = "DROP PROCEDURE udtudrmgr_chperm (varchar)";
        if (TraceFlag.isTraceEnabled()) {
            trace.writeTrace(logger, 3, "UDRManager: sql = " + sql);
        }
        stmt.execute(sql);
        stmt.close();
        if (TraceFlag.isTraceEnabled()) {
            trace.writeTrace(logger, 1, "UDRManager:changeFilePermissionInServer() exited");
        }
    }

    static void removeFileInServer(String jarfile, IfxConnection conn) throws SQLException {
        Trace trace = null;
        if (TraceFlag.isTraceEnabled()) {
            trace = conn.getTrace();
            trace.writeTrace(logger, 1, "UDRManager:removeFileInServer() entered");
        }
        Statement stmt = conn.createStatement();
        String sql = null;
        sql = UDRManager.isNTServer(conn) ? "CREATE PROCEDURE udtudrmgr_rmfile (fname varchar(80)) \nsystem 'cmd /C del ' || fname; \nEND PROCEDURE" : "CREATE PROCEDURE udtudrmgr_rmfile (fname varchar(80)) \nsystem 'rm ' || fname; \nEND PROCEDURE";
        if (TraceFlag.isTraceEnabled()) {
            trace.writeTrace(logger, 3, "UDRManager: sql = " + sql);
        }
        stmt.execute(sql);
        sql = "EXECUTE PROCEDURE udtudrmgr_rmfile ('" + jarfile + "')";
        if (TraceFlag.isTraceEnabled()) {
            trace.writeTrace(logger, 3, "UDRManager: sql = " + sql);
        }
        stmt.execute(sql);
        sql = "DROP PROCEDURE udtudrmgr_rmfile (varchar)";
        if (TraceFlag.isTraceEnabled()) {
            trace.writeTrace(logger, 3, "UDRManager: sql = " + sql);
        }
        stmt.execute(sql);
        stmt.close();
        if (TraceFlag.isTraceEnabled()) {
            trace.writeTrace(logger, 1, "UDRManager:removeFileInServer() exited");
        }
    }

    static void installJarNow(String jarFileSQLName, String jarFileInServer, int deploy, IfxConnection conn) throws SQLException {
        Trace trace = null;
        if (TraceFlag.isTraceEnabled()) {
            trace = conn.getTrace();
            trace.writeTrace(logger, 1, "UDRManager:installJarNow() entered");
        }
        String jarURLOnServer = "file:" + jarFileInServer;
        if (TraceFlag.isTraceEnabled()) {
            trace.writeTrace(logger, 3, "sql = execute procedure sqlj.install_jar('" + jarURLOnServer + "', '" + jarFileSQLName + "', " + deploy + ")");
        }
        IfmxCallableStatement cstmt = (IfmxCallableStatement)conn.prepareCall("{ call sqlj.install_jar(?,?,?) }");
        cstmt.setString(1, jarURLOnServer);
        cstmt.setString(2, jarFileSQLName);
        cstmt.setInt(3, deploy);
        cstmt.executeUpdate();
        cstmt.close();
        if (TraceFlag.isTraceEnabled()) {
            trace.writeTrace(logger, 1, "UDRManager:installJarNow() exited");
        }
    }

    static void removeJarNow(String jarfilesqlname, int undeploy, IfxConnection conn, Locale locale) throws SQLException {
        Trace trace = null;
        if (TraceFlag.isTraceEnabled()) {
            trace = conn.getTrace();
            trace.writeTrace(logger, 1, "UDRManager:removeJarNow() entered");
        }
        if (jarfilesqlname == null) {
            throw IfxErrMsg.getSQLException((int)-79708, (String)"", (Locale)locale);
        }
        if (TraceFlag.isTraceEnabled()) {
            trace.writeTrace(logger, 3, "sql = execute procedure sqlj.remove_jar('" + jarfilesqlname + "', " + undeploy + ")");
        }
        IfmxCallableStatement cstmt = (IfmxCallableStatement)conn.prepareCall("{ call sqlj.remove_jar(?,?) }");
        cstmt.setString(1, jarfilesqlname);
        cstmt.setInt(2, undeploy);
        cstmt.executeUpdate();
        if (TraceFlag.isTraceEnabled()) {
            trace.writeTrace(logger, 1, "UDRManager:removeJarNow() exited");
        }
    }

    static void registerUDRs(UDRMetaData mdata, String classname, String udtsqlname, IfxConnection conn, Locale locale) throws SQLException {
        Trace trace = null;
        if (TraceFlag.isTraceEnabled()) {
            trace = conn.getTrace();
            trace.writeTrace(logger, 1, "UDRManager:registerUDRs() entered");
        }
        Method m = null;
        String mName = null;
        String mSQLName = null;
        String mSQLParams = null;
        String mJavaParams = null;
        String mSQLReturn = null;
        String sql = null;
        Hashtable udrs = mdata.udrs;
        if (udrs == null || udrs.size() == 0) {
            if (TraceFlag.isTraceEnabled()) {
                trace.writeTrace(logger, 1, "UDRManager:registerUDRs() exited");
            }
            return;
        }
        String jarFileSQLName = mdata.jarFileSQLName;
        Statement stmt = conn.createStatement();
        Enumeration keys = udrs.keys();
        while (keys.hasMoreElements()) {
            m = (Method)keys.nextElement();
            if (TraceFlag.isTraceEnabled()) {
                trace.writeTrace(logger, 3, "m = " + m.toString());
            }
            mName = m.getName();
            UDRMetaData.udrinfo udr = (UDRMetaData.udrinfo)udrs.get(m);
            mSQLName = udr.sqlname;
            mSQLParams = UDRManager.fromClassesToIfxNames(m.getParameterTypes(), classname, udtsqlname, trace, locale);
            mJavaParams = UDRManager.fromClassesToJavaNames(m.getParameterTypes(), trace);
            mSQLReturn = UDRManager.fromClassesToIfxNames(new Class[]{m.getReturnType()}, classname, udtsqlname, trace, locale);
            sql = mSQLReturn.equals("void") ? "CREATE PROCEDURE " + mSQLName + " (" + mSQLParams + ") " + "EXTERNAL NAME '" + jarFileSQLName + ":" + classname + "." + mName + "(" + mJavaParams + ")' " + "LANGUAGE JAVA NOT VARIANT END PROCEDURE" : "CREATE FUNCTION " + mSQLName + " (" + mSQLParams + ") " + "RETURNS " + mSQLReturn + " " + "EXTERNAL NAME '" + jarFileSQLName + ":" + classname + "." + mName + "(" + mJavaParams + ")' " + "LANGUAGE JAVA NOT VARIANT END FUNCTION";
            if (TraceFlag.isTraceEnabled()) {
                trace.writeTrace(logger, 3, "sql = " + sql);
            }
            stmt.executeUpdate(sql);
        }
        stmt.close();
        if (TraceFlag.isTraceEnabled()) {
            trace.writeTrace(logger, 1, "UDRManager:registerUDRs() exited");
        }
    }

    static String fromClassesToJavaNames(Class[] classes, Trace trace) {
        int numclass;
        if (TraceFlag.isTraceEnabled()) {
            trace.writeTrace(logger, 1, "UDRManager:fromClassesToJavaNames() entered");
        }
        if ((numclass = classes.length) == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < numclass; ++i) {
            if (i != numclass - 1) {
                buf.append(classes[i].getName() + ", ");
                continue;
            }
            buf.append(classes[i].getName());
        }
        if (TraceFlag.isTraceEnabled()) {
            trace.writeTrace(logger, 3, "buf = '" + buf.toString() + "'");
            trace.writeTrace(logger, 1, "UDRManager:fromClassesToJavaNames() exited");
        }
        return buf.toString();
    }

    static String fromClassesToIfxNames(Class[] classes, String classname, String udtsqlname, Trace trace, Locale locale) throws SQLException {
        int numclass;
        if (TraceFlag.isTraceEnabled()) {
            trace.writeTrace(logger, 1, "UDRManager:fromClassesToIfxNames() entered");
        }
        if ((numclass = classes.length) == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < numclass; ++i) {
            int ifxtype = -1;
            String ifxname = null;
            String javatypename = classes[i].getName();
            if (TraceFlag.isTraceEnabled()) {
                trace.writeTrace(logger, 3, "javatypename = " + javatypename);
            }
            if (javatypename.equals(classname)) {
                if (udtsqlname != null) {
                    ifxname = udtsqlname;
                }
            } else {
                if (javatypename.equals("java.lang.Object") || javatypename.equals("java.sql.SQLData")) {
                    throw IfxErrMsg.getSQLException((int)-79860, (String)"", (Locale)locale);
                }
                ifxname = UDRManager.JavaToIfxName(javatypename);
                if (ifxname.equals("unknown")) {
                    throw IfxErrMsg.getSQLException((int)-79714, (String)"", (Locale)locale);
                }
            }
            if (i != numclass - 1) {
                buf.append(ifxname + ", ");
                continue;
            }
            buf.append(ifxname);
        }
        if (TraceFlag.isTraceEnabled()) {
            trace.writeTrace(logger, 3, "buf = '" + buf.toString() + "'");
            trace.writeTrace(logger, 1, "UDRManager:fromClassesToIfxNames() exited");
        }
        return buf.toString();
    }

    private static String JavaToIfxName(String javatypename) {
        String name = (String)JavaToIfxNameTable.get(javatypename);
        if (name == null) {
            return "unknown";
        }
        return name;
    }

    static {
        if (JavaToIfxNameTable == null) {
            JavaToIfxNameTable = new Hashtable(30);
            JavaToIfxNameTable.put(new String("boolean"), new String("boolean"));
            JavaToIfxNameTable.put(new String("char"), new String("char(1)"));
            JavaToIfxNameTable.put(new String("byte"), new String("char(1)"));
            JavaToIfxNameTable.put(new String("short"), new String("smallint"));
            JavaToIfxNameTable.put(new String("int"), new String("int"));
            JavaToIfxNameTable.put(new String("long"), new String("int8"));
            JavaToIfxNameTable.put(new String("float"), new String("smallfloat"));
            JavaToIfxNameTable.put(new String("double"), new String("float"));
            JavaToIfxNameTable.put(new String("java.lang.String"), new String("lvarchar"));
            JavaToIfxNameTable.put(new String("java.math.BigDecimal"), new String("decimal"));
            JavaToIfxNameTable.put(new String("java.lang.Boolean"), new String("boolean"));
            JavaToIfxNameTable.put(new String("java.lang.Integer"), new String("int"));
            JavaToIfxNameTable.put(new String("java.lang.Short"), new String("smallint"));
            JavaToIfxNameTable.put(new String("java.lang.Long"), new String("int8"));
            JavaToIfxNameTable.put(new String("java.lang.Float"), new String("smallfloat"));
            JavaToIfxNameTable.put(new String("java.lang.Double"), new String("float"));
            JavaToIfxNameTable.put(new String("java.sql.Date"), new String("date"));
            JavaToIfxNameTable.put(new String("java.sql.Time"), new String("datetime hour to second"));
            JavaToIfxNameTable.put(new String("java.sql.Timestamp"), new String("datetime year to fraction(5)"));
            JavaToIfxNameTable.put(new String("com.informix.lang.IntervalYM"), new String("interval year to month"));
            JavaToIfxNameTable.put(new String("com.informix.lang.IntervalDF"), new String("interval day to fraction(5)"));
            JavaToIfxNameTable.put(new String("java.sql.Blob"), new String("blob"));
            JavaToIfxNameTable.put(new String("java.sql.Clob"), new String("clob"));
        }
    }
}

