/*
 * Decompiled with CFR 0.152.
 */
package udtudrmgr;

import com.informix.util.IfxErrMsg;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;

public class UDRMetaData {
    protected Locale locale = Locale.getDefault();
    protected Hashtable udrs = null;
    protected String jarFileSQLName = null;

    public void setUDR(Method method, String sqlname) throws SQLException {
        udrinfo udr;
        if (method == null) {
            throw IfxErrMsg.getSQLException((int)-79708, (String)"", (Locale)this.locale);
        }
        if (sqlname == null) {
            throw IfxErrMsg.getSQLException((int)-79708, (String)"", (Locale)this.locale);
        }
        if (this.udrs == null) {
            this.udrs = new Hashtable(10);
        }
        if (!this.udrs.contains(udr = new udrinfo(method, sqlname))) {
            this.udrs.put(method, udr);
        }
    }

    public Method[] getUDRs() {
        Method[] methods = null;
        int numUdrs = 0;
        if (this.udrs == null) {
            return null;
        }
        numUdrs = this.udrs.size();
        if (numUdrs == 0) {
            return null;
        }
        methods = new Method[numUdrs];
        int i = 0;
        Enumeration keys = this.udrs.keys();
        while (keys.hasMoreElements()) {
            methods[i] = (Method)keys.nextElement();
            ++i;
        }
        return methods;
    }

    public String getUDRSQLName(Method method) throws SQLException {
        if (method == null) {
            throw IfxErrMsg.getSQLException((int)-79708, (String)"", (Locale)this.locale);
        }
        if (this.udrs == null) {
            return null;
        }
        udrinfo udr = (udrinfo)this.udrs.get(method);
        return udr == null ? null : udr.sqlname;
    }

    public void setJarFileSQLName(String name) throws SQLException {
        if (name == null) {
            throw IfxErrMsg.getSQLException((int)-79708, (String)"", (Locale)this.locale);
        }
        this.jarFileSQLName = name;
    }

    public String getJarFileSQLName() {
        return this.jarFileSQLName;
    }

    class udrinfo {
        Method method = null;
        String sqlname = null;

        udrinfo(Method method, String sqlname) {
            this.method = method;
            this.sqlname = sqlname;
        }
    }
}

